/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway.auth;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\t\u001a\u00020\u00052\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000bH\u0000\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\f\u0010\u0010\u001a\u00020\u0005*\u00020\u0002H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"OAUTH_SYMBOLS", "", "", "URL_ALPHABET", "doURLEncode", "", "value", "spaceToPlus", "", "formDataString", "data", "", "hexDigitToChar", "", "digit", "", "percentEncode", "intellij.space.gateway"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/intellij/space/gateway/auth/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1549#2:57\n1620#2,3:58\n1549#2:61\n1620#2,3:62\n*S KotlinDebug\n*F\n+ 1 util.kt\ncom/intellij/space/gateway/auth/UtilKt\n*L\n5#1:57\n5#1:58,3\n7#1:61\n7#1:62,3\n*E\n"})
public final class UtilKt {
    @NotNull
    private static final List<Byte> URL_ALPHABET;
    @NotNull
    private static final List<Byte> OAUTH_SYMBOLS;

    @NotNull
    public static final String formDataString(@NotNull Map<String, String> data2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        StringBuilder $this$formDataString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Map.Entry<String, String> entry : data2.entrySet()) {
            String key2 = entry.getKey();
            String value2 = entry.getValue();
            if (((CharSequence)$this$formDataString_u24lambda_u242).length() > 0) {
                $this$formDataString_u24lambda_u242.append("&");
            }
            if (value2 == null) {
                $this$formDataString_u24lambda_u242.append(UtilKt.doURLEncode(key2, true));
                continue;
            }
            $this$formDataString_u24lambda_u242.append(UtilKt.doURLEncode(key2, true));
            $this$formDataString_u24lambda_u242.append("=");
            $this$formDataString_u24lambda_u242.append(UtilKt.doURLEncode(value2, true));
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    public static final String doURLEncode(@NotNull String value2, boolean spaceToPlus) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        try {
            StringBuilder stringBuilder;
            ByteBuffer bytes = Charsets.UTF_8.newEncoder().encode(CharBuffer.wrap(value2));
            StringBuilder $this$doURLEncode_u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl = false;
            while (bytes.hasRemaining()) {
                byte by = bytes.get();
                if (URL_ALPHABET.contains(by) || OAUTH_SYMBOLS.contains(by)) {
                    $this$doURLEncode_u24lambda_u243.append((char)by);
                    continue;
                }
                if (spaceToPlus && by == 32) {
                    $this$doURLEncode_u24lambda_u243.append('+');
                    continue;
                }
                $this$doURLEncode_u24lambda_u243.append(UtilKt.percentEncode(by));
            }
            String string3 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
            string2 = string3;
        }
        catch (Exception e) {
            string2 = value2;
        }
        return string2;
    }

    public static /* synthetic */ String doURLEncode$default(String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UtilKt.doURLEncode(string2, bl);
    }

    private static final String percentEncode(byte $this$percentEncode) {
        StringBuilder stringBuilder;
        int n = 3;
        StringBuilder $this$percentEncode_u24lambda_u244 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        int code = $this$percentEncode & 0xFF;
        $this$percentEncode_u24lambda_u244.append('%');
        $this$percentEncode_u24lambda_u244.append(UtilKt.hexDigitToChar(code >> 4));
        $this$percentEncode_u24lambda_u244.append(UtilKt.hexDigitToChar(code & 0xF));
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string2;
    }

    private static final char hexDigitToChar(int digit) {
        int n = digit;
        return (0 <= n ? n < 10 : false) ? (char)(48 + digit) : (char)((char)(65 + digit) - 10);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        char it;
        Collection collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv = (Object[])CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('A', 'Z'))), (Iterable)((Iterable)new CharRange('0', '9')));
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            char c = ((Character)item$iv$iv).charValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)it);
        }
        URL_ALPHABET = (List)destination$iv$iv;
        $this$map$iv = new Character[]{Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('~')};
        $this$map$iv = CollectionsKt.listOf((Object[])$this$map$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = ((Character)item$iv$iv).charValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)it);
        }
        OAUTH_SYMBOLS = (List)var3_3;
    }
}

