/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway.connection;

import circlet.rd.api.RdWorkspaceState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remoteDev.util.LifetimeExKt;
import com.intellij.space.gateway.SpaceKt;
import com.intellij.space.gateway.client.data.RdGatewayConnectionInfo;
import com.intellij.space.gateway.client.data.RdWorkspace;
import com.intellij.space.gateway.client.data.RdWorkspaceKt;
import com.intellij.space.gateway.connection.GatewayRelayConnection;
import com.intellij.space.gateway.connection.GatewaySocketChannel;
import com.intellij.space.gateway.connection.GatewaySocketOpener;
import com.intellij.space.gateway.connection.RelayStableConnection;
import com.intellij.space.gateway.connection.ThinClientConnection;
import com.intellij.space.gateway.utils.UtilsKt;
import com.intellij.util.UriUtilKt;
import com.jetbrains.gateway.thinClientLink.LinkedClientManager;
import com.jetbrains.gateway.thinClientLink.ThinClientHandle;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u0000 72\u00020\u0001:\u00056789:B[\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011\u00a2\u0006\u0002\u0010\u0014J\u0011\u0010\u001e\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ'\u0010 \u001a\u0004\u0018\u00010!2\n\u0010\"\u001a\u00060#j\u0002`$2\u0006\u0010\b\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J\u0006\u0010&\u001a\u00020\u0013J\u0019\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020#H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J%\u0010*\u001a\u00020+2\n\u0010\"\u001a\u00060#j\u0002`$2\u0006\u0010\b\u001a\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J\b\u0010,\u001a\u00020\u0013H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0002J\u0010\u0010/\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J\u001d\u00100\u001a\u00020\u0013*\u00020!2\u0006\u00101\u001a\u00020+H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J\u001d\u00103\u001a\u00020\u0013*\u00020+2\u0006\u00104\u001a\u00020!H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u000f0\u000f0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006;"}, d2={"Lcom/intellij/space/gateway/connection/RelayStableConnection;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Lcom/intellij/space/gateway/RdLifetime;", "devEnv", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/space/gateway/client/data/RdWorkspace;", "connectionInfo", "Lcom/intellij/space/gateway/client/data/RdGatewayConnectionInfo;", "openedClient", "Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle;", "gatewaySocket", "Lcom/intellij/space/gateway/connection/GatewaySocketChannel;", "initialOriginalLink", "", "onError", "Lkotlin/Function1;", "", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlinx/coroutines/flow/StateFlow;Lkotlinx/coroutines/flow/StateFlow;Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle;Lcom/intellij/space/gateway/connection/GatewaySocketChannel;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "_connectionStatus", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/space/gateway/connection/RelayStableConnection$RelayConnectionStatus;", "connectionState", "getConnectionState", "()Lkotlinx/coroutines/flow/StateFlow;", "currentOriginalLink", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "awaitConnectionInfo", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitThinClientConnectionToGW", "Lcom/intellij/space/gateway/connection/ThinClientConnection;", "connectionLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "Lcom/intellij/space/gateway/RdLifetimeSource;", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lcom/intellij/space/gateway/client/data/RdGatewayConnectionInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "closeClient", "connect", "", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connectToRelay", "Lcom/intellij/space/gateway/connection/GatewayRelayConnection;", "establishConnection", "getOriginalLinkFingerprint", "originalLink", "updateJoinLinkIfChanged", "moveDataFromClientToRelay", "relay", "(Lcom/intellij/space/gateway/connection/ThinClientConnection;Lcom/intellij/space/gateway/connection/GatewayRelayConnection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "moveDataFromRelayToClient", "client", "(Lcom/intellij/space/gateway/connection/GatewayRelayConnection;Lcom/intellij/space/gateway/connection/ThinClientConnection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ClientConnectionStatus", "Companion", "GwRelayConnectionStatus", "RelayConnectionStatus", "ThinClientConnectionException", "intellij.space.gateway"})
@SourceDebugExtension(value={"SMAP\nRelayStableConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelayStableConnection.kt\ncom/intellij/space/gateway/connection/RelayStableConnection\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,384:1\n230#2,5:385\n230#2,5:390\n230#2,5:395\n230#2,5:400\n230#2,5:405\n230#2,5:410\n10#3:415\n*S KotlinDebug\n*F\n+ 1 RelayStableConnection.kt\ncom/intellij/space/gateway/connection/RelayStableConnection\n*L\n209#1:385,5\n241#1:390,5\n271#1:395,5\n289#1:400,5\n328#1:405,5\n359#1:410,5\n36#1:415\n*E\n"})
public final class RelayStableConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final com.jetbrains.rd.util.lifetime.Lifetime lifetime;
    @NotNull
    private final StateFlow<RdWorkspace> devEnv;
    @NotNull
    private final StateFlow<RdGatewayConnectionInfo> connectionInfo;
    @NotNull
    private final ThinClientHandle openedClient;
    @NotNull
    private final GatewaySocketChannel gatewaySocket;
    @NotNull
    private Function1<? super Throwable, Unit> onError;
    @NotNull
    private final AtomicReference<String> currentOriginalLink;
    @NotNull
    private final MutableStateFlow<RelayConnectionStatus> _connectionStatus;
    @NotNull
    private final StateFlow<RelayConnectionStatus> connectionState;
    @NotNull
    private static final Logger LOG;

    public RelayStableConnection(@NotNull com.jetbrains.rd.util.lifetime.Lifetime lifetime, @NotNull StateFlow<RdWorkspace> devEnv2, @NotNull StateFlow<RdGatewayConnectionInfo> connectionInfo2, @NotNull ThinClientHandle openedClient, @NotNull GatewaySocketChannel gatewaySocket, @NotNull String initialOriginalLink, @NotNull Function1<? super Throwable, Unit> onError2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(devEnv2, (String)"devEnv");
        Intrinsics.checkNotNullParameter(connectionInfo2, (String)"connectionInfo");
        Intrinsics.checkNotNullParameter((Object)openedClient, (String)"openedClient");
        Intrinsics.checkNotNullParameter((Object)gatewaySocket, (String)"gatewaySocket");
        Intrinsics.checkNotNullParameter((Object)initialOriginalLink, (String)"initialOriginalLink");
        Intrinsics.checkNotNullParameter(onError2, (String)"onError");
        this.lifetime = lifetime;
        this.devEnv = devEnv2;
        this.connectionInfo = connectionInfo2;
        this.openedClient = openedClient;
        this.gatewaySocket = gatewaySocket;
        this.onError = onError2;
        this.currentOriginalLink = new AtomicReference<String>(initialOriginalLink);
        this._connectionStatus = StateFlowKt.MutableStateFlow((Object)new RelayConnectionStatus(ClientConnectionStatus.AWAIT_DEV_ENV, GwRelayConnectionStatus.AWAIT_DEV_ENV));
        this.connectionState = FlowKt.asStateFlow(this._connectionStatus);
        this.lifetime.onTermination((Function0)1.INSTANCE);
    }

    @NotNull
    public final StateFlow<RelayConnectionStatus> getConnectionState() {
        return this.connectionState;
    }

    private final void establishConnection() {
        SpaceKt.launchBackground$default(SpaceKt.spaceLifetime(this.lifetime), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ RelayStableConnection this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        connectionLifetimes = new SequentialLifetimes(RelayStableConnection.access$getLifetime$p(this.this$0));
                        RelayStableConnection.access$getLOG$cp().info("Connecting...");
lbl7:
                        // 2 sources

                        while (RLifetimeKt.isAlive((com.jetbrains.rd.util.lifetime.Lifetime)RelayStableConnection.access$getLifetime$p(this.this$0))) {
                            this.L$0 = connectionLifetimes;
                            this.label = 1;
                            v0 = RelayStableConnection.access$connect(this.this$0, connectionLifetimes.next(), (Continuation)this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl19
                        }
                        ** GOTO lbl22
                    }
                    case 1: {
                        connectionLifetimes = (SequentialLifetimes)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) ** GOTO lbl22
                        RelayStableConnection.access$getLOG$cp().info("Reconnecting...");
                        ** GOTO lbl7
lbl22:
                        // 2 sources

                        if (RLifetimeKt.isAlive((com.jetbrains.rd.util.lifetime.Lifetime)RelayStableConnection.access$getLifetime$p(this.this$0))) {
                            connectionLifetimes.terminateCurrent();
                        }
                        RelayStableConnection.access$getLOG$cp().info("Disconnected");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final Object connect(LifetimeDefinition connectionLifetime, Continuation<? super Boolean> $completion) {
        CompletableDeferred canReconnect = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        LifetimeExKt.onTerminationOrNow((com.jetbrains.rd.util.lifetime.Lifetime)((com.jetbrains.rd.util.lifetime.Lifetime)connectionLifetime), (Function0)((Function0)new Function0<Unit>((CompletableDeferred<Boolean>)canReconnect){
            final /* synthetic */ CompletableDeferred<Boolean> $canReconnect;
            {
                this.$canReconnect = $canReconnect;
                super(0);
            }

            public final void invoke() {
                RelayStableConnection.access$getLOG$cp().info("Connection lifetime terminated");
                this.$canReconnect.complete((Object)true);
            }
        }));
        SpaceKt.launchBackground$default(SpaceKt.spaceLifetime((com.jetbrains.rd.util.lifetime.Lifetime)connectionLifetime), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, connectionLifetime, (CompletableDeferred<Boolean>)canReconnect, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ RelayStableConnection this$0;
            final /* synthetic */ LifetimeDefinition $connectionLifetime;
            final /* synthetic */ CompletableDeferred<Boolean> $canReconnect;
            {
                this.this$0 = $receiver;
                this.$connectionLifetime = $connectionLifetime;
                this.$canReconnect = $canReconnect;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launchBackground = (CoroutineScope)this.L$0;
                        $this$update$iv = RelayStableConnection.access$get_connectionStatus$p(this.this$0);
                        $i$f$update = false;
                        do {
                            prevValue$iv = $this$update$iv.getValue();
                            (RelayConnectionStatus)prevValue$iv;
                            $i$a$-update-RelayStableConnection$connect$3$1 = false;
                        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = new RelayConnectionStatus(ClientConnectionStatus.AWAIT_DEV_ENV, GwRelayConnectionStatus.AWAIT_DEV_ENV))));
                        this.L$0 = $this$launchBackground;
                        this.label = 1;
                        v0 = RelayStableConnection.access$awaitConnectionInfo(this.this$0, (Continuation)this);
                        ** if (v0 != var10_2) goto lbl23
lbl22:
                        // 1 sources

                        return var10_2;
lbl23:
                        // 1 sources

                        ** GOTO lbl30
                    }
                    case 1: {
                        $this$launchBackground = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl30:
                        // 2 sources

                        currentConnectionInfo = (RdGatewayConnectionInfo)v0;
                        this.L$0 = $this$launchBackground;
                        this.L$1 = currentConnectionInfo;
                        this.label = 2;
                        v1 = RelayStableConnection.access$awaitThinClientConnectionToGW(this.this$0, this.$connectionLifetime, currentConnectionInfo, (Continuation)this);
                        ** if (v1 != var10_2) goto lbl37
lbl36:
                        // 1 sources

                        return var10_2;
lbl37:
                        // 1 sources

                        ** GOTO lbl45
                    }
                    case 2: {
                        currentConnectionInfo = (RdGatewayConnectionInfo)this.L$1;
                        $this$launchBackground = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl45:
                        // 2 sources

                        v2 = (ThinClientConnection)v1;
                        if (v2 == null) {
                            var6_9 = $this$launchBackground;
                            var7_11 = this.this$0;
                            var8_12 = this.$canReconnect;
                            $i$a$-run-RelayStableConnection$connect$3$thinClientConnection$1 = false;
                            RelayStableConnection.access$getOnError$p(var7_11).invoke((Object)new ThinClientConnectionException("Can't establish connection with Thin Client", null, 2, null));
                            var8_12.complete((Object)Boxing.boxBoolean((boolean)false));
                            return Unit.INSTANCE;
                        }
                        thinClientConnection = v2;
                        this.L$0 = currentConnectionInfo;
                        this.L$1 = thinClientConnection;
                        this.label = 3;
                        v3 = RelayStableConnection.access$connectToRelay(this.this$0, this.$connectionLifetime, currentConnectionInfo, (Continuation)this);
                        ** if (v3 != var10_2) goto lbl63
lbl62:
                        // 1 sources

                        return var10_2;
lbl63:
                        // 1 sources

                        ** GOTO lbl71
                    }
                    case 3: {
                        thinClientConnection = (ThinClientConnection)this.L$1;
                        currentConnectionInfo = (RdGatewayConnectionInfo)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl71:
                        // 2 sources

                        relay = (GatewayRelayConnection)v3;
                        SpaceKt.launchBackground$default(SpaceKt.spaceLifetime((com.jetbrains.rd.util.lifetime.Lifetime)this.$connectionLifetime), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, thinClientConnection, relay, null){
                            int label;
                            final /* synthetic */ RelayStableConnection this$0;
                            final /* synthetic */ ThinClientConnection $thinClientConnection;
                            final /* synthetic */ GatewayRelayConnection $relay;
                            {
                                this.this$0 = $receiver;
                                this.$thinClientConnection = $thinClientConnection;
                                this.$relay = $relay;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = RelayStableConnection.access$moveDataFromClientToRelay(this.this$0, this.$thinClientConnection, this.$relay, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 3, null);
                        SpaceKt.launchBackground$default(SpaceKt.spaceLifetime((com.jetbrains.rd.util.lifetime.Lifetime)this.$connectionLifetime), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, relay, thinClientConnection, null){
                            int label;
                            final /* synthetic */ RelayStableConnection this$0;
                            final /* synthetic */ GatewayRelayConnection $relay;
                            final /* synthetic */ ThinClientConnection $thinClientConnection;
                            {
                                this.this$0 = $receiver;
                                this.$relay = $relay;
                                this.$thinClientConnection = $thinClientConnection;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = RelayStableConnection.access$moveDataFromRelayToClient(this.this$0, this.$relay, this.$thinClientConnection, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 3, null);
                        this.L$0 = null;
                        this.L$1 = null;
                        this.label = 4;
                        v4 = RelayStableConnection.access$getConnectionInfo$p(this.this$0).collect(new FlowCollector(currentConnectionInfo, this.this$0, this.$canReconnect){
                            final /* synthetic */ RdGatewayConnectionInfo $currentConnectionInfo;
                            final /* synthetic */ RelayStableConnection this$0;
                            final /* synthetic */ CompletableDeferred<Boolean> $canReconnect;
                            {
                                this.$currentConnectionInfo = $currentConnectionInfo;
                                this.this$0 = $receiver;
                                this.$canReconnect = $canReconnect;
                            }

                            @Nullable
                            public final Object emit(@Nullable RdGatewayConnectionInfo newConnectionInfo, @NotNull Continuation<? super Unit> $completion) {
                                if (!Intrinsics.areEqual((Object)newConnectionInfo, (Object)this.$currentConnectionInfo)) {
                                    String newFp;
                                    String oldFp = RelayStableConnection.access$getOriginalLinkFingerprint(this.this$0, this.$currentConnectionInfo.getOriginalLink());
                                    Object object = newConnectionInfo;
                                    if (object != null && (object = ((RdGatewayConnectionInfo)object).getOriginalLink()) != null) {
                                        Object object2 = object;
                                        RelayStableConnection relayStableConnection = this.this$0;
                                        Object it = object2;
                                        boolean bl = false;
                                        v1 = RelayStableConnection.access$getOriginalLinkFingerprint(relayStableConnection, (String)it);
                                    } else {
                                        v1 = newFp = null;
                                    }
                                    if (!Intrinsics.areEqual((Object)oldFp, newFp)) {
                                        RdGatewayConnectionInfo rdGatewayConnectionInfo2 = newConnectionInfo;
                                        RelayStableConnection.access$getLOG$cp().info("Dev env connection info was changed (fingerprint was changed): " + this.$currentConnectionInfo.getOriginalLink() + " -> " + (rdGatewayConnectionInfo2 != null ? rdGatewayConnectionInfo2.getOriginalLink() : null));
                                        this.$canReconnect.complete((Object)Boxing.boxBoolean((boolean)true));
                                    } else {
                                        RdGatewayConnectionInfo rdGatewayConnectionInfo3 = newConnectionInfo;
                                        RelayStableConnection.access$getLOG$cp().warn("Dev env connection info was changed (fingerprint wasn't changed): " + this.$currentConnectionInfo.getOriginalLink() + " -> " + (rdGatewayConnectionInfo3 != null ? rdGatewayConnectionInfo3.getOriginalLink() : null));
                                    }
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        ** if (v4 != var10_2) goto lbl82
lbl81:
                        // 1 sources

                        return var10_2;
lbl82:
                        // 1 sources

                        ** GOTO lbl88
                    }
                    case 4: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl88:
                            // 2 sources

                            throw new KotlinNothingValueException();
                        }
                        catch (Throwable e) {
                            if (RLifetimeKt.isAlive((com.jetbrains.rd.util.lifetime.Lifetime)((com.jetbrains.rd.util.lifetime.Lifetime)this.$connectionLifetime))) {
                                RelayStableConnection.access$getLOG$cp().info("Connection failed with error", e);
                            } else {
                                RelayStableConnection.access$getLOG$cp().debug("Connection failed with error", e);
                            }
                            this.$canReconnect.complete((Object)Boxing.boxBoolean((boolean)true));
                            return Unit.INSTANCE;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        return canReconnect.await($completion);
    }

    public final void closeClient() {
        LOG.debug("closeClient");
        if (this.openedClient.getClientPresent() && !this.openedClient.getRestartNeeded()) {
            this.openedClient.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object awaitThinClientConnectionToGW(LifetimeDefinition var1_1, RdGatewayConnectionInfo var2_2, Continuation<? super ThinClientConnection> var3_3) {
        if (!(var3_3 instanceof awaitThinClientConnectionToGW.1)) ** GOTO lbl-1000
        var17_4 = var3_3;
        if ((var17_4.label & -2147483648) != 0) {
            var17_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                long J$0;
                long J$1;
                /* synthetic */ Object result;
                final /* synthetic */ RelayStableConnection this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RelayStableConnection.access$awaitThinClientConnectionToGW(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$update$iv = this._connectionStatus;
                $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    status = (RelayConnectionStatus)prevValue$iv;
                    $i$a$-update-RelayStableConnection$awaitThinClientConnectionToGW$2 = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = RelayConnectionStatus.copy$default(status, ClientConnectionStatus.CONNECTING, null, 2, null))));
                this.updateJoinLinkIfChanged((RdGatewayConnectionInfo)connectionInfo);
                try {
                    var7_13 = Registry.intValue((String)"gateway.spaceport.client.connection.timeoutSeconds");
                }
                catch (Throwable $i$a$-update-RelayStableConnection$awaitThinClientConnectionToGW$2) {
                    var7_13 = 20;
                }
                timeout = DurationKt.toDuration((int)var7_13, (DurationUnit)DurationUnit.SECONDS);
                RelayStableConnection.LOG.info("Thin Client connection to Gateway awaiting with timeout " + Duration.toString-impl((long)timeout));
                awaitConnectionStart = System.currentTimeMillis();
                $continuation.L$0 = this;
                $continuation.J$0 = timeout;
                $continuation.J$1 = awaitConnectionStart;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)timeout, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ThinClientConnection>, Object>((LifetimeDefinition)connectionLifetime, this, null){
                    int label;
                    final /* synthetic */ LifetimeDefinition $connectionLifetime;
                    final /* synthetic */ RelayStableConnection this$0;
                    {
                        this.$connectionLifetime = $connectionLifetime;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = ThinClientConnection.Companion.awaitConnection(this.$connectionLifetime, RelayStableConnection.access$getGatewaySocket$p(this.this$0).getServerSocket(), (Continuation<? super ThinClientConnection>)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ThinClientConnection> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var18_6) {
                    return var18_6;
                }
                ** GOTO lbl46
            }
            case 1: {
                awaitConnectionStart = $continuation.J$1;
                timeout = $continuation.J$0;
                this = (RelayStableConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl46:
                // 2 sources

                if ((thinClientConnection = (ThinClientConnection)v0) == null) {
                    RelayStableConnection.LOG.error("Thin Client connection to Gateway failed to be established in " + Duration.toString-impl((long)timeout));
                    return null;
                }
                timeToConnect = System.currentTimeMillis() - awaitConnectionStart;
                if (timeToConnect > 10000L) {
                    RelayStableConnection.LOG.warn("Thin Client connection to Gateway awaited more than 10s");
                }
                RelayStableConnection.LOG.info("Thin Client connected to Gateway in " + timeToConnect + "ms");
                $this$update$iv = this._connectionStatus;
                $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    status = (RelayConnectionStatus)prevValue$iv;
                    $i$a$-update-RelayStableConnection$awaitThinClientConnectionToGW$3 = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = RelayConnectionStatus.copy$default(status, ClientConnectionStatus.CONNECTED, null, 2, null))));
                return thinClientConnection;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void updateJoinLinkIfChanged(RdGatewayConnectionInfo connectionInfo2) {
        String current2 = this.currentOriginalLink.get();
        if (Intrinsics.areEqual((Object)current2, (Object)connectionInfo2.getOriginalLink())) {
            LOG.info("Join link is not changed");
            return;
        }
        if (this.currentOriginalLink.compareAndSet(current2, connectionInfo2.getOriginalLink())) {
            LOG.info("Updating Thin Client join link");
            URI newJoinLink = connectionInfo2.thinClientJoinLink(this.gatewaySocket.getPort());
            this.openedClient.updateJoinLink(newJoinLink, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object connectToRelay(LifetimeDefinition var1_1, RdGatewayConnectionInfo var2_2, Continuation<? super GatewayRelayConnection> var3_3) {
        if (!(var3_3 instanceof connectToRelay.1)) ** GOTO lbl-1000
        var12_4 = var3_3;
        if ((var12_4.label & -2147483648) != 0) {
            var12_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RelayStableConnection this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RelayStableConnection.access$connectToRelay(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$update$iv = this._connectionStatus;
                $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    status = (RelayConnectionStatus)prevValue$iv;
                    $i$a$-update-RelayStableConnection$connectToRelay$2 = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = RelayConnectionStatus.copy$default(status, null, GwRelayConnectionStatus.CONNECTING, 1, null))));
                relayConnectUri = new URI(connectionInfo.getRelayLink() + "/" + RelayStableConnection.connectToRelay$generateUserId());
                RelayStableConnection.LOG.info("Connect to relay " + relayConnectUri);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = GatewayRelayConnection.Companion.connectToRelay(var1_1, relayConnectUri, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)connectionInfo.getRelayAuthData())), (Continuation<? super GatewayRelayConnection>)$continuation);
                if (v0 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl33
            }
            case 1: {
                this = (RelayStableConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                relay = (GatewayRelayConnection)v0;
                RelayStableConnection.LOG.info("Connected to relay");
                $this$update$iv = this._connectionStatus;
                $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    status = (RelayConnectionStatus)prevValue$iv;
                    $i$a$-update-RelayStableConnection$connectToRelay$3 = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = RelayConnectionStatus.copy$default(status, null, GwRelayConnectionStatus.CONNECTED, 1, null))));
                return relay;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object moveDataFromClientToRelay(ThinClientConnection var1_1, GatewayRelayConnection var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof moveDataFromClientToRelay.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ RelayStableConnection this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RelayStableConnection.access$moveDataFromClientToRelay(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                RelayStableConnection.LOG.info("Thin Client -> Relay: start moving data");
                counter = new AtomicInteger();
                $continuation.label = 1;
                v0 = $this$moveDataFromClientToRelay.readDataFromClientLoop((Function2<? super ByteBuffer, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ByteBuffer, Continuation<? super Unit>, Object>(counter, (GatewayRelayConnection)relay, null){
                    int I$0;
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ AtomicInteger $counter;
                    final /* synthetic */ GatewayRelayConnection $relay;
                    {
                        this.$counter = $counter;
                        this.$relay = $relay;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                clientData = (ByteBuffer)this.L$0;
                                currentCounter = this.$counter.incrementAndGet();
                                clientData.flip();
                                if (currentCounter == 1) {
                                    RelayStableConnection.access$getLOG$cp().info("Thin Client -> Relay: read first packet");
                                }
                                this.I$0 = currentCounter;
                                this.label = 1;
                                v0 = this.$relay.write(clientData, (Continuation<? super Unit>)((Continuation)this));
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl21
                            }
                            case 1: {
                                currentCounter = this.I$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl21:
                                // 2 sources

                                if (currentCounter == 1) {
                                    RelayStableConnection.access$getLOG$cp().info("Thin Client -> Relay: wrote first packet");
                                }
                                if (currentCounter % 1000 == 0) {
                                    RelayStableConnection.access$getLOG$cp().info("Thin Client -> Relay: 1000 packets sent");
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull ByteBuffer p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super Unit>)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                RelayStableConnection.LOG.info("Thin Client -> Relay: end moving data");
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object moveDataFromRelayToClient(GatewayRelayConnection var1_1, ThinClientConnection var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof moveDataFromRelayToClient.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ RelayStableConnection this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RelayStableConnection.access$moveDataFromRelayToClient(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                RelayStableConnection.LOG.info("Relay -> Thin Client: start moving data");
                counter = new AtomicInteger();
                var5_8 = $this$moveDataFromRelayToClient.getRelayOutputChannel().iterator();
lbl15:
                // 3 sources

                while (true) {
                    $continuation.L$0 = client;
                    $continuation.L$1 = counter;
                    $continuation.L$2 = var5_8;
                    $continuation.label = 1;
                    v0 = var5_8.hasNext((Continuation)$continuation);
                    if (v0 == var10_6) {
                        return var10_6;
                    }
                    ** GOTO lbl30
                    break;
                }
            }
            case 1: {
                var5_8 = (ChannelIterator)$continuation.L$2;
                counter = (AtomicInteger)$continuation.L$1;
                client = (ThinClientConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) break;
                relayData = (ByteBuffer)var5_8.next();
                currentCounter = counter.incrementAndGet();
                if (currentCounter == 1) {
                    RelayStableConnection.LOG.info("Relay -> Thin Client: read first packet");
                }
                $continuation.L$0 = client;
                $continuation.L$1 = counter;
                $continuation.L$2 = var5_8;
                $continuation.I$0 = currentCounter;
                $continuation.label = 2;
                v1 = client.writeDataFromClient(relayData, (Continuation<? super Unit>)$continuation);
                if (v1 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl51
            }
            case 2: {
                currentCounter = $continuation.I$0;
                var5_8 = (ChannelIterator)$continuation.L$2;
                counter = (AtomicInteger)$continuation.L$1;
                client = (ThinClientConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl51:
                // 2 sources

                if (currentCounter == 1) {
                    RelayStableConnection.LOG.info("Relay -> Thin Client: wrote first packet");
                }
                if (currentCounter % 1000 != 0) ** GOTO lbl15
                RelayStableConnection.LOG.info("Relay -> Thin Client: 1000 packets sent");
                ** continue;
            }
        }
        RelayStableConnection.LOG.info("Relay -> Thin Client: end moving data");
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String getOriginalLinkFingerprint(String originalLink) {
        return (String)UriUtilKt.getFragmentParameters((URI)new URI(originalLink)).get("fp");
    }

    /*
     * Unable to fully structure code
     */
    private final Object awaitConnectionInfo(Continuation<? super RdGatewayConnectionInfo> var1_1) {
        if (!(var1_1 instanceof awaitConnectionInfo.1)) ** GOTO lbl-1000
        var10_2 = var1_1;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RelayStableConnection this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RelayStableConnection.access$awaitConnectionInfo(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                RelayStableConnection.LOG.info("Ensure dev env connection info is ready");
                $this$update$iv = this._connectionStatus;
                $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    (RelayConnectionStatus)prevValue$iv;
                    $i$a$-update-RelayStableConnection$awaitConnectionInfo$2 = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = new RelayConnectionStatus(ClientConnectionStatus.AWAIT_DEV_ENV, GwRelayConnectionStatus.AWAIT_DEV_ENV))));
                afterRestart = this.openedClient.getRestartNeeded();
                isFirstCheck = new Ref.BooleanRef();
                isFirstCheck.element = true;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = FlowKt.first((Flow)FlowKt.combine((Flow)((Flow)this.devEnv), (Flow)((Flow)this.connectionInfo), (Function3)((Function3)new Function3<RdWorkspace, RdGatewayConnectionInfo, Continuation<? super Pair<? extends RdWorkspace, ? extends RdGatewayConnectionInfo>>, Object>(null){
                    int label;
                    /* synthetic */ Object L$0;
                    /* synthetic */ Object L$1;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                RdWorkspace devEnvVal = (RdWorkspace)this.L$0;
                                RdGatewayConnectionInfo connectionInfoVal = (RdGatewayConnectionInfo)this.L$1;
                                return TuplesKt.to((Object)devEnvVal, (Object)connectionInfoVal);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull RdWorkspace p1, @Nullable RdGatewayConnectionInfo p2, @Nullable Continuation<? super Pair<RdWorkspace, RdGatewayConnectionInfo>> p3) {
                        var var4_4 = new /* invalid duplicate definition of identical inner class */;
                        var4_4.L$0 = p1;
                        var4_4.L$1 = p2;
                        return var4_4.invokeSuspend(Unit.INSTANCE);
                    }
                })), (Function2)((Function2)new Function2<Pair<? extends RdWorkspace, ? extends RdGatewayConnectionInfo>, Continuation<? super Boolean>, Object>(this, afterRestart != false, isFirstCheck, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ RelayStableConnection this$0;
                    final /* synthetic */ boolean $afterRestart;
                    final /* synthetic */ Ref.BooleanRef $isFirstCheck;
                    {
                        this.this$0 = $receiver;
                        this.$afterRestart = $afterRestart;
                        this.$isFirstCheck = $isFirstCheck;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                var2_2 = (Pair)this.L$0;
                                devEnvVal = (RdWorkspace)var2_2.component1();
                                newConnection = (RdGatewayConnectionInfo)var2_2.component2();
                                v0 = newConnection;
                                RelayStableConnection.access$getLOG$cp().debug("Dev env (" + devEnvVal.getState() + ") join link: " + (v0 != null ? v0.thinClientJoinLink(RelayStableConnection.access$getGatewaySocket$p(this.this$0).getPort()) : null));
                                if (RdWorkspaceKt.getStatus(devEnvVal) != RdWorkspaceState.Active) ** GOTO lbl31
                                if (!this.$afterRestart) ** GOTO lbl30
                                v1 = RelayStableConnection.access$getCurrentOriginalLink$p(this.this$0).get();
                                Intrinsics.checkNotNullExpressionValue(v1, (String)"get(...)");
                                fpOld = RelayStableConnection.access$getOriginalLinkFingerprint(this.this$0, (String)v1);
                                v2 = newConnection;
                                if (v2 == null || (v2 = v2.getOriginalLink()) == null) ** GOTO lbl26
                                var7_6 = v2;
                                var8_7 = this.this$0;
                                it = var7_6;
                                $i$a$-let-RelayStableConnection$awaitConnectionInfo$4$fpNew$1 = false;
                                v3 = RelayStableConnection.access$getOriginalLinkFingerprint(var8_7, (String)it);
                                v2 = v3;
                                if (v3 != null) ** GOTO lbl27
lbl26:
                                // 2 sources

                                v2 = fpOld;
lbl27:
                                // 2 sources

                                fpNew = v2;
                                RelayStableConnection.access$getLOG$cp().debug("Waiting for new fp after restart");
                                return Boxing.boxBoolean((boolean)(Intrinsics.areEqual((Object)fpOld, (Object)fpNew) == false));
lbl30:
                                // 1 sources

                                return Boxing.boxBoolean((boolean)true);
lbl31:
                                // 1 sources

                                if (this.$isFirstCheck.element) {
                                    this.$isFirstCheck.element = false;
                                    RelayStableConnection.access$getLOG$cp().info("Putting Thin Client to reconnect mode");
                                    RelayStableConnection.access$getOpenedClient$p(this.this$0).notifyReconnect();
                                }
                                return Boxing.boxBoolean((boolean)false);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull Pair<RdWorkspace, RdGatewayConnectionInfo> p1, @Nullable Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl36
            }
            case 1: {
                this = (RelayStableConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl36:
                // 2 sources

                RelayStableConnection.LOG.info("Dev env is active");
                $this$update$iv = this._connectionStatus;
                $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    (RelayConnectionStatus)prevValue$iv;
                    $i$a$-update-RelayStableConnection$awaitConnectionInfo$5 = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = new RelayConnectionStatus(ClientConnectionStatus.DISCONNECTED, GwRelayConnectionStatus.AWAIT_CONNECT_INFO))));
                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = UtilsKt.firstNotNull((Flow)this.connectionInfo, $continuation);
                if (v1 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl56
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl56:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final String connectToRelay$generateUserId() {
        SecureRandom random = new SecureRandom();
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        byte[] buffer2 = new byte[16];
        random.nextBytes(buffer2);
        String string2 = encoder.encodeToString(buffer2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    public static final /* synthetic */ void access$establishConnection(RelayStableConnection $this) {
        $this.establishConnection();
    }

    public static final /* synthetic */ com.jetbrains.rd.util.lifetime.Lifetime access$getLifetime$p(RelayStableConnection $this) {
        return $this.lifetime;
    }

    public static final /* synthetic */ Object access$connect(RelayStableConnection $this, LifetimeDefinition connectionLifetime, Continuation $completion) {
        return $this.connect(connectionLifetime, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ MutableStateFlow access$get_connectionStatus$p(RelayStableConnection $this) {
        return $this._connectionStatus;
    }

    public static final /* synthetic */ Object access$awaitConnectionInfo(RelayStableConnection $this, Continuation $completion) {
        return $this.awaitConnectionInfo((Continuation<? super RdGatewayConnectionInfo>)$completion);
    }

    public static final /* synthetic */ Object access$awaitThinClientConnectionToGW(RelayStableConnection $this, LifetimeDefinition connectionLifetime, RdGatewayConnectionInfo connectionInfo2, Continuation $completion) {
        return $this.awaitThinClientConnectionToGW(connectionLifetime, connectionInfo2, (Continuation<? super ThinClientConnection>)$completion);
    }

    public static final /* synthetic */ Object access$connectToRelay(RelayStableConnection $this, LifetimeDefinition connectionLifetime, RdGatewayConnectionInfo connectionInfo2, Continuation $completion) {
        return $this.connectToRelay(connectionLifetime, connectionInfo2, (Continuation<? super GatewayRelayConnection>)$completion);
    }

    public static final /* synthetic */ Object access$moveDataFromClientToRelay(RelayStableConnection $this, ThinClientConnection $receiver, GatewayRelayConnection relay, Continuation $completion) {
        return $this.moveDataFromClientToRelay($receiver, relay, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$moveDataFromRelayToClient(RelayStableConnection $this, GatewayRelayConnection $receiver, ThinClientConnection client2, Continuation $completion) {
        return $this.moveDataFromRelayToClient($receiver, client2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ StateFlow access$getConnectionInfo$p(RelayStableConnection $this) {
        return $this.connectionInfo;
    }

    public static final /* synthetic */ String access$getOriginalLinkFingerprint(RelayStableConnection $this, String originalLink) {
        return $this.getOriginalLinkFingerprint(originalLink);
    }

    public static final /* synthetic */ Function1 access$getOnError$p(RelayStableConnection $this) {
        return $this.onError;
    }

    public static final /* synthetic */ GatewaySocketChannel access$getGatewaySocket$p(RelayStableConnection $this) {
        return $this.gatewaySocket;
    }

    public static final /* synthetic */ AtomicReference access$getCurrentOriginalLink$p(RelayStableConnection $this) {
        return $this.currentOriginalLink;
    }

    public static final /* synthetic */ ThinClientHandle access$getOpenedClient$p(RelayStableConnection $this) {
        return $this.openedClient;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(RelayStableConnection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/space/gateway/connection/RelayStableConnection$ClientConnectionStatus;", "", "(Ljava/lang/String;I)V", "AWAIT_DEV_ENV", "DISCONNECTED", "CONNECTING", "CONNECTED", "intellij.space.gateway"})
    public static final class ClientConnectionStatus
    extends Enum<ClientConnectionStatus> {
        public static final /* enum */ ClientConnectionStatus AWAIT_DEV_ENV = new ClientConnectionStatus();
        public static final /* enum */ ClientConnectionStatus DISCONNECTED = new ClientConnectionStatus();
        public static final /* enum */ ClientConnectionStatus CONNECTING = new ClientConnectionStatus();
        public static final /* enum */ ClientConnectionStatus CONNECTED = new ClientConnectionStatus();
        private static final /* synthetic */ ClientConnectionStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ClientConnectionStatus[] values() {
            return (ClientConnectionStatus[])$VALUES.clone();
        }

        public static ClientConnectionStatus valueOf(String value2) {
            return Enum.valueOf(ClientConnectionStatus.class, value2);
        }

        @NotNull
        public static EnumEntries<ClientConnectionStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = clientConnectionStatusArray = new ClientConnectionStatus[]{ClientConnectionStatus.AWAIT_DEV_ENV, ClientConnectionStatus.DISCONNECTED, ClientConnectionStatus.CONNECTING, ClientConnectionStatus.CONNECTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jg\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100\u0013H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lcom/intellij/space/gateway/connection/RelayStableConnection$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createConnection", "Lcom/intellij/space/gateway/connection/RelayStableConnection;", "lt", "Llibraries/coroutines/extra/Lifetime;", "devEnv", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/intellij/space/gateway/client/data/RdWorkspace;", "connectionInfo", "Lcom/intellij/space/gateway/client/data/RdGatewayConnectionInfo;", "onClientStarted", "Lkotlin/Function0;", "", "onClientClose", "onError", "Lkotlin/Function1;", "", "(Llibraries/coroutines/extra/Lifetime;Lkotlinx/coroutines/flow/StateFlow;Lkotlinx/coroutines/flow/StateFlow;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.space.gateway"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Object createConnection(@NotNull Lifetime var1_1, @NotNull StateFlow<RdWorkspace> var2_2, @NotNull StateFlow<RdGatewayConnectionInfo> var3_3, @NotNull Function0<Unit> var4_4, @NotNull Function0<Unit> var5_5, @NotNull Function1<? super Throwable, Unit> var6_6, @NotNull Continuation<? super RelayStableConnection> var7_7) {
            if (!(var7_7 instanceof createConnection.1)) ** GOTO lbl-1000
            var17_8 = var7_7;
            if ((var17_8.label & -2147483648) != 0) {
                var17_8.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var7_7){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.createConnection(null, null, null, null, null, null, (Continuation<? super RelayStableConnection>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var18_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    rdLifetime = SpaceKt.rdLifetime((Lifetime)lt);
                    RelayStableConnection.access$getLOG$cp().info("Gateway: Open port");
                    $continuation.L$0 = devEnv;
                    $continuation.L$1 = connectionInfo;
                    $continuation.L$2 = onClientStarted;
                    $continuation.L$3 = onClientClose;
                    $continuation.L$4 = onError;
                    $continuation.L$5 = rdLifetime;
                    $continuation.label = 1;
                    v0 = GatewaySocketOpener.INSTANCE.occupyPort(rdLifetime, (Continuation<? super GatewaySocketChannel>)$continuation);
                    if (v0 == var18_10) {
                        return var18_10;
                    }
                    ** GOTO lbl34
                }
                case 1: {
                    rdLifetime = (com.jetbrains.rd.util.lifetime.Lifetime)$continuation.L$5;
                    onError = (Function1)$continuation.L$4;
                    onClientClose = (Function0)$continuation.L$3;
                    onClientStarted = (Function0)$continuation.L$2;
                    connectionInfo = (StateFlow)$continuation.L$1;
                    devEnv = (StateFlow)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl34:
                    // 2 sources

                    gatewaySocket = (GatewaySocketChannel)v0;
                    RelayStableConnection.access$getLOG$cp().info("Gateway: Opened port " + gatewaySocket.getPort());
                    RelayStableConnection.access$getLOG$cp().info("Await for dev env connection info");
                    $continuation.L$0 = devEnv;
                    $continuation.L$1 = connectionInfo;
                    $continuation.L$2 = onClientStarted;
                    $continuation.L$3 = onClientClose;
                    $continuation.L$4 = onError;
                    $continuation.L$5 = rdLifetime;
                    $continuation.L$6 = gatewaySocket;
                    $continuation.label = 2;
                    v1 = UtilsKt.firstNotNull((Flow)connectionInfo, $continuation);
                    if (v1 == var18_10) {
                        return var18_10;
                    }
                    ** GOTO lbl59
                }
                case 2: {
                    gatewaySocket = (GatewaySocketChannel)$continuation.L$6;
                    rdLifetime = (com.jetbrains.rd.util.lifetime.Lifetime)$continuation.L$5;
                    onError = (Function1)$continuation.L$4;
                    onClientClose = (Function0)$continuation.L$3;
                    onClientStarted = (Function0)$continuation.L$2;
                    connectionInfo = (StateFlow)$continuation.L$1;
                    devEnv = (StateFlow)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl59:
                    // 2 sources

                    connectionInfoVal = (RdGatewayConnectionInfo)v1;
                    initialJoinLink = connectionInfoVal.thinClientJoinLink(gatewaySocket.getPort());
                    RelayStableConnection.access$getLOG$cp().info("Start Thin Client with join link " + initialJoinLink);
                    thinClient = LinkedClientManager.Companion.getInstance().startNewClient(rdLifetime, initialJoinLink, null, onClientStarted);
                    closeHandled = new Ref.BooleanRef();
                    onClientCloseHandler = (Function0)new Function0<Unit>(closeHandled, (Function0<Unit>)onClientClose){
                        final /* synthetic */ Ref.BooleanRef $closeHandled;
                        final /* synthetic */ Function0<Unit> $onClientClose;
                        {
                            this.$closeHandled = $closeHandled;
                            this.$onClientClose = $onClientClose;
                            super(0);
                        }

                        public final void invoke() {
                            if (!this.$closeHandled.element) {
                                this.$closeHandled.element = true;
                                RelayStableConnection.access$getLOG$cp().info("Thin Client: handle close");
                                this.$onClientClose.invoke();
                            }
                        }
                    };
                    thinClient.getClientClosed().advise(rdLifetime, (Function1)new Function1<Unit, Unit>((Function0<Unit>)onClientCloseHandler){
                        final /* synthetic */ Function0<Unit> $onClientCloseHandler;
                        {
                            this.$onClientCloseHandler = $onClientCloseHandler;
                            super(1);
                        }

                        public final void invoke(@NotNull Unit it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            RelayStableConnection.access$getLOG$cp().info("Thin Client: closed");
                            this.$onClientCloseHandler.invoke();
                        }
                    });
                    thinClient.getLifetime().onTermination((Function0)new Function0<Unit>((Function0<Unit>)onClientCloseHandler){
                        final /* synthetic */ Function0<Unit> $onClientCloseHandler;
                        {
                            this.$onClientCloseHandler = $onClientCloseHandler;
                            super(0);
                        }

                        public final void invoke() {
                            RelayStableConnection.access$getLOG$cp().info("Thin Client: lifetime terminated");
                            this.$onClientCloseHandler.invoke();
                        }
                    });
                    RelayStableConnection.access$getLOG$cp().info("Connect Thin Client to relay");
                    connection = new RelayStableConnection(rdLifetime, (StateFlow<RdWorkspace>)devEnv, (StateFlow<RdGatewayConnectionInfo>)connectionInfo, thinClient, gatewaySocket, connectionInfoVal.getOriginalLink(), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>((Function1<? super Throwable, Unit>)onError, thinClient){
                        final /* synthetic */ Function1<Throwable, Unit> $onError;
                        final /* synthetic */ ThinClientHandle $thinClient;
                        {
                            this.$onError = $onError;
                            this.$thinClient = $thinClient;
                            super(1);
                        }

                        public final void invoke(@NotNull Throwable it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            RelayStableConnection.access$getLOG$cp().error("Thin Client error", it);
                            this.$onError.invoke((Object)it);
                            this.$thinClient.close();
                        }
                    }));
                    RelayStableConnection.access$establishConnection(connection);
                    return connection;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/space/gateway/connection/RelayStableConnection$GwRelayConnectionStatus;", "", "(Ljava/lang/String;I)V", "AWAIT_DEV_ENV", "AWAIT_CONNECT_INFO", "CONNECTING", "CONNECTED", "intellij.space.gateway"})
    public static final class GwRelayConnectionStatus
    extends Enum<GwRelayConnectionStatus> {
        public static final /* enum */ GwRelayConnectionStatus AWAIT_DEV_ENV = new GwRelayConnectionStatus();
        public static final /* enum */ GwRelayConnectionStatus AWAIT_CONNECT_INFO = new GwRelayConnectionStatus();
        public static final /* enum */ GwRelayConnectionStatus CONNECTING = new GwRelayConnectionStatus();
        public static final /* enum */ GwRelayConnectionStatus CONNECTED = new GwRelayConnectionStatus();
        private static final /* synthetic */ GwRelayConnectionStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static GwRelayConnectionStatus[] values() {
            return (GwRelayConnectionStatus[])$VALUES.clone();
        }

        public static GwRelayConnectionStatus valueOf(String value2) {
            return Enum.valueOf(GwRelayConnectionStatus.class, value2);
        }

        @NotNull
        public static EnumEntries<GwRelayConnectionStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = gwRelayConnectionStatusArray = new GwRelayConnectionStatus[]{GwRelayConnectionStatus.AWAIT_DEV_ENV, GwRelayConnectionStatus.AWAIT_CONNECT_INFO, GwRelayConnectionStatus.CONNECTING, GwRelayConnectionStatus.CONNECTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/space/gateway/connection/RelayStableConnection$RelayConnectionStatus;", "", "clientStatus", "Lcom/intellij/space/gateway/connection/RelayStableConnection$ClientConnectionStatus;", "gwRelayStatus", "Lcom/intellij/space/gateway/connection/RelayStableConnection$GwRelayConnectionStatus;", "(Lcom/intellij/space/gateway/connection/RelayStableConnection$ClientConnectionStatus;Lcom/intellij/space/gateway/connection/RelayStableConnection$GwRelayConnectionStatus;)V", "getClientStatus", "()Lcom/intellij/space/gateway/connection/RelayStableConnection$ClientConnectionStatus;", "getGwRelayStatus", "()Lcom/intellij/space/gateway/connection/RelayStableConnection$GwRelayConnectionStatus;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.space.gateway"})
    public static final class RelayConnectionStatus {
        @NotNull
        private final ClientConnectionStatus clientStatus;
        @NotNull
        private final GwRelayConnectionStatus gwRelayStatus;

        public RelayConnectionStatus(@NotNull ClientConnectionStatus clientStatus, @NotNull GwRelayConnectionStatus gwRelayStatus) {
            Intrinsics.checkNotNullParameter((Object)((Object)clientStatus), (String)"clientStatus");
            Intrinsics.checkNotNullParameter((Object)((Object)gwRelayStatus), (String)"gwRelayStatus");
            this.clientStatus = clientStatus;
            this.gwRelayStatus = gwRelayStatus;
        }

        @NotNull
        public final ClientConnectionStatus getClientStatus() {
            return this.clientStatus;
        }

        @NotNull
        public final GwRelayConnectionStatus getGwRelayStatus() {
            return this.gwRelayStatus;
        }

        @NotNull
        public final ClientConnectionStatus component1() {
            return this.clientStatus;
        }

        @NotNull
        public final GwRelayConnectionStatus component2() {
            return this.gwRelayStatus;
        }

        @NotNull
        public final RelayConnectionStatus copy(@NotNull ClientConnectionStatus clientStatus, @NotNull GwRelayConnectionStatus gwRelayStatus) {
            Intrinsics.checkNotNullParameter((Object)((Object)clientStatus), (String)"clientStatus");
            Intrinsics.checkNotNullParameter((Object)((Object)gwRelayStatus), (String)"gwRelayStatus");
            return new RelayConnectionStatus(clientStatus, gwRelayStatus);
        }

        public static /* synthetic */ RelayConnectionStatus copy$default(RelayConnectionStatus relayConnectionStatus, ClientConnectionStatus clientConnectionStatus, GwRelayConnectionStatus gwRelayConnectionStatus, int n, Object object) {
            if ((n & 1) != 0) {
                clientConnectionStatus = relayConnectionStatus.clientStatus;
            }
            if ((n & 2) != 0) {
                gwRelayConnectionStatus = relayConnectionStatus.gwRelayStatus;
            }
            return relayConnectionStatus.copy(clientConnectionStatus, gwRelayConnectionStatus);
        }

        @NotNull
        public String toString() {
            return "RelayConnectionStatus(clientStatus=" + this.clientStatus + ", gwRelayStatus=" + this.gwRelayStatus + ")";
        }

        public int hashCode() {
            int result2 = this.clientStatus.hashCode();
            result2 = result2 * 31 + this.gwRelayStatus.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RelayConnectionStatus)) {
                return false;
            }
            RelayConnectionStatus relayConnectionStatus = (RelayConnectionStatus)other;
            if (this.clientStatus != relayConnectionStatus.clientStatus) {
                return false;
            }
            return this.gwRelayStatus == relayConnectionStatus.gwRelayStatus;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/space/gateway/connection/RelayStableConnection$ThinClientConnectionException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "intellij.space.gateway"})
    public static final class ThinClientConnectionException
    extends Exception {
        public ThinClientConnectionException(@NotNull String message2, @Nullable Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(message2, cause);
        }

        public /* synthetic */ ThinClientConnectionException(String string2, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string2, throwable);
        }
    }
}

