/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway.web.flow.v2;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.space.gateway.SpaceKt;
import com.intellij.space.gateway.messages.SpaceGatewayBundle;
import com.intellij.space.gateway.web.flow.v2.CallbackAction;
import com.intellij.space.gateway.web.flow.v2.ConnectionStage;
import com.intellij.space.gateway.web.flow.v2.SpaceOpenInIdeConnectionHandle;
import com.intellij.ui.AppUIUtilKt;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ToolbarService;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.gateway.api.CustomConnectionFrameContext;
import com.jetbrains.gateway.connection.GatewayConnectionFrameManager;
import com.jetbrains.gateway.connectionFrame.ConnectionFrameManagerImpl;
import com.jetbrains.rd.framework.util.LifetimeCoroutineUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import libraries.klogging.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\bH\u0002J\b\u0010\r\u001a\u00020\bH\u0002J\b\u0010\u000e\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0002R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/space/gateway/web/flow/v2/SpaceConnectionFrame;", "Lcom/intellij/openapi/Disposable;", "handle", "Lcom/intellij/space/gateway/web/flow/v2/SpaceOpenInIdeConnectionHandle;", "(Lcom/intellij/space/gateway/web/flow/v2/SpaceOpenInIdeConnectionHandle;)V", "dialog", "Lcom/intellij/space/gateway/web/flow/v2/SpaceConnectionFrame$SpaceConnectionDialog;", "disconnect", "", "dispose", "hasOtherConnections", "", "minimize", "onDialogClose", "openGateway", "quitApp", "shouldQuitApp", "Companion", "SpaceConnectionDialog", "intellij.space.gateway"})
@SourceDebugExtension(value={"SMAP\nSpaceConnectionFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceConnectionFrame.kt\ncom/intellij/space/gateway/web/flow/v2/SpaceConnectionFrame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n1774#2,4:210\n*S KotlinDebug\n*F\n+ 1 SpaceConnectionFrame.kt\ncom/intellij/space/gateway/web/flow/v2/SpaceConnectionFrame\n*L\n89#1:210,4\n*E\n"})
public final class SpaceConnectionFrame
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SpaceOpenInIdeConnectionHandle handle;
    @NotNull
    private final SpaceConnectionDialog dialog;

    public SpaceConnectionFrame(@NotNull SpaceOpenInIdeConnectionHandle handle) {
        Intrinsics.checkNotNullParameter((Object)((Object)handle), (String)"handle");
        this.handle = handle;
        this.dialog = new SpaceConnectionDialog();
        this.handle.getLifetime().onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                if (this.hasOtherConnections()) {
                    this.openGateway();
                } else {
                    Thread.sleep(1000L);
                    this.quitApp();
                }
            }
        });
    }

    private final void onDialogClose() {
        if (this.shouldQuitApp()) {
            this.quitApp();
        } else {
            this.minimize();
        }
    }

    private final void disconnect() {
        this.handle.terminate();
    }

    public void dispose() {
        this.dialog.dispose();
    }

    private final void openGateway() {
        Disposer.dispose((Disposable)this);
        WelcomeFrame.Companion.showNow();
    }

    private final boolean shouldQuitApp() {
        return this.handle.isFailed() && !this.hasOtherConnections();
    }

    private final void quitApp() {
        ApplicationKt.getApplication().exit(true, true, false, 0);
    }

    private final void minimize() {
        LifetimeCoroutineUtilKt.launch$default((Lifetime)((Lifetime)this.dialog.getLifetime()), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpaceConnectionFrame this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        SpaceConnectionFrame.access$getDialog$p(this.this$0).setExtendedState(1);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final boolean hasOtherConnections() {
        int n;
        ConnectionFrameManagerImpl connections2;
        GatewayConnectionFrameManager gatewayConnectionFrameManager = GatewayConnectionFrameManager.Companion.getInstance();
        ConnectionFrameManagerImpl connectionFrameManagerImpl = connections2 = gatewayConnectionFrameManager instanceof ConnectionFrameManagerImpl ? (ConnectionFrameManagerImpl)gatewayConnectionFrameManager : null;
        List list2 = connectionFrameManagerImpl != null ? connectionFrameManagerImpl.get() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable $this$count$iv = list2;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Disposable it = (Disposable)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)this)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n > 0;
    }

    public static final /* synthetic */ SpaceConnectionDialog access$getDialog$p(SpaceConnectionFrame $this) {
        return $this.dialog;
    }

    public static final /* synthetic */ void access$onDialogClose(SpaceConnectionFrame $this) {
        $this.onDialogClose();
    }

    public static final /* synthetic */ void access$disconnect(SpaceConnectionFrame $this) {
        $this.disconnect();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/space/gateway/web/flow/v2/SpaceConnectionFrame$Companion;", "Llibraries/klogging/KLogging;", "()V", "intellij.space.gateway"})
    public static final class Companion
    extends KLogging {
        private Companion() {
            super(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0015\u0010\u001d\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020!H\u0016J\b\u0010\u0013\u001a\u00020!H\u0016J\b\u0010%\u001a\u00020!H\u0002J\u000e\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(R\u001f\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\u00020\u0007*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lcom/intellij/space/gateway/web/flow/v2/SpaceConnectionFrame$SpaceConnectionDialog;", "Ljavax/swing/JFrame;", "Lcom/jetbrains/gateway/api/CustomConnectionFrameContext;", "(Lcom/intellij/space/gateway/web/flow/v2/SpaceConnectionFrame;)V", "buttons", "", "Lcom/intellij/space/gateway/web/flow/v2/CallbackAction;", "Ljavax/swing/JButton;", "Lorg/jetbrains/annotations/NotNull;", "disconnectAction", "hideToTrayAction", "hideToTrayPossibility", "Lcom/jetbrains/gateway/api/CustomConnectionFrameContext$HideToTrayPossibility$Impossible;", "getHideToTrayPossibility", "()Lcom/jetbrains/gateway/api/CustomConnectionFrameContext$HideToTrayPossibility$Impossible;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "openGateway", "retry", "button", "getButton", "(Lcom/intellij/space/gateway/web/flow/v2/CallbackAction;)Ljavax/swing/JButton;", "createButtonsPanel", "Ljavax/swing/JPanel;", "", "createCenterPanel", "Ljavax/swing/JComponent;", "createJButtonForAction", "action", "Ljavax/swing/Action;", "dispose", "", "getPreferredSize", "Ljava/awt/Dimension;", "hideToTray", "setupUI", "updateButtons", "stage", "Lcom/intellij/space/gateway/web/flow/v2/ConnectionStage;", "intellij.space.gateway"})
    @SourceDebugExtension(value={"SMAP\nSpaceConnectionFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceConnectionFrame.kt\ncom/intellij/space/gateway/web/flow/v2/SpaceConnectionFrame$SpaceConnectionDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,209:1\n1271#2,2:210\n1285#2,4:212\n*S KotlinDebug\n*F\n+ 1 SpaceConnectionFrame.kt\ncom/intellij/space/gateway/web/flow/v2/SpaceConnectionFrame$SpaceConnectionDialog\n*L\n109#1:210,2\n109#1:212,4\n*E\n"})
    private final class SpaceConnectionDialog
    extends JFrame
    implements CustomConnectionFrameContext {
        @NotNull
        private final LifetimeDefinition lifetime;
        @NotNull
        private final CustomConnectionFrameContext.HideToTrayPossibility.Impossible hideToTrayPossibility;
        @NotNull
        private final CallbackAction disconnectAction;
        @NotNull
        private final CallbackAction hideToTrayAction;
        @NotNull
        private final CallbackAction openGateway;
        @NotNull
        private final CallbackAction retry;
        @NotNull
        private final Map<CallbackAction, JButton> buttons;

        /*
         * WARNING - void declaration
         */
        public SpaceConnectionDialog() {
            void $this$associateWith$iv;
            this.lifetime = SpaceConnectionFrame.this.handle.getLifetime().createNested();
            this.hideToTrayPossibility = CustomConnectionFrameContext.HideToTrayPossibility.Impossible.INSTANCE;
            this.disconnectAction = new CallbackAction(SpaceGatewayBundle.INSTANCE.message("open.in.ide.connection.dialog.exit.disconnect.and.close", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>((Object)SpaceConnectionFrame.this){

                public final void invoke() {
                    SpaceConnectionFrame.access$disconnect((SpaceConnectionFrame)this.receiver);
                }
            }));
            this.hideToTrayAction = new CallbackAction(SpaceGatewayBundle.INSTANCE.message("open.in.ide.connection.dialog.hide", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>((Object)SpaceConnectionFrame.this){

                public final void invoke() {
                    SpaceConnectionFrame.access$minimize((SpaceConnectionFrame)this.receiver);
                }
            }));
            this.openGateway = new CallbackAction(SpaceGatewayBundle.INSTANCE.message("open.in.ide.connection.dialog.open.gateway", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>((Object)SpaceConnectionFrame.this){

                public final void invoke() {
                    SpaceConnectionFrame.access$openGateway((SpaceConnectionFrame)this.receiver);
                }
            }));
            this.retry = new CallbackAction(SpaceGatewayBundle.INSTANCE.message("open.in.ide.connection.dialog.retry", new Object[0]), (Function0<Unit>)((Function0)new Function0<Unit>((Object)SpaceConnectionFrame.this.handle){

                public final void invoke() {
                    ((SpaceOpenInIdeConnectionHandle)((Object)this.receiver)).retry();
                }
            }));
            Object object = new CallbackAction[]{this.disconnectAction, this.hideToTrayAction, this.openGateway, this.retry};
            object = CollectionsKt.listOf((Object[])object);
            SpaceConnectionDialog spaceConnectionDialog = this;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                CallbackAction callbackAction = (CallbackAction)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                JButton jButton = this.createJButtonForAction((Action)it);
                map2.put(t, jButton);
            }
            spaceConnectionDialog.buttons = result$iv;
            this.setupUI();
            SpaceConnectionFrame.this.handle.stageUpdates(SpaceKt.spaceLifetime((Lifetime)this.lifetime), (Function1<? super ConnectionStage, Unit>)((Function1)new Function1<ConnectionStage, Unit>((Object)this){

                public final void invoke(@NotNull ConnectionStage p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((SpaceConnectionDialog)this.receiver).updateButtons(p0);
                }
            }));
        }

        @NotNull
        public final LifetimeDefinition getLifetime() {
            return this.lifetime;
        }

        @NotNull
        public CustomConnectionFrameContext.HideToTrayPossibility.Impossible getHideToTrayPossibility() {
            return this.hideToTrayPossibility;
        }

        private final JButton getButton(CallbackAction $this$button) {
            JButton jButton = this.buttons.get($this$button);
            Intrinsics.checkNotNull((Object)jButton);
            return jButton;
        }

        public void openGateway() {
            SpaceConnectionFrame.this.openGateway();
        }

        public void hideToTray() {
            SpaceConnectionFrame.this.minimize();
        }

        @Override
        public void dispose() {
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetime, (boolean)false, (int)1, null);
            super.dispose();
        }

        public final void updateButtons(@NotNull ConnectionStage stage) {
            Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
            boolean isFailed = stage instanceof ConnectionStage.Failed;
            boolean isConnected = stage instanceof ConnectionStage.Connected;
            if (isFailed) {
                this.getButton(this.disconnectAction).setVisible(false);
                this.getButton(this.hideToTrayAction).setVisible(false);
                this.getButton(this.openGateway).setVisible(true);
                this.getButton(this.retry).setVisible(SpaceConnectionFrame.this.handle.isRetryAvailable());
                this.rootPane.setDefaultButton(SpaceConnectionFrame.this.handle.isRetryAvailable() ? this.getButton(this.retry) : this.getButton(this.openGateway));
            } else if (isConnected) {
                this.getButton(this.disconnectAction).setVisible(true);
                this.getButton(this.hideToTrayAction).setVisible(false);
                this.getButton(this.openGateway).setVisible(true);
                this.getButton(this.retry).setVisible(false);
                this.rootPane.setDefaultButton(this.getButton(this.openGateway));
            } else {
                this.getButton(this.disconnectAction).setVisible(true);
                this.getButton(this.hideToTrayAction).setVisible(true);
                this.getButton(this.openGateway).setVisible(false);
                this.getButton(this.retry).setVisible(false);
            }
            this.setResizable(true);
            LifetimeCoroutineUtilKt.launch$default((Lifetime)((Lifetime)this.lifetime), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ SpaceConnectionDialog this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.this$0.pack();
                            this.this$0.setResizable(false);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void setupUI() {
            void $this$setupUI_u24lambda_u243_u24lambda_u242;
            JComponent $this$setupUI_u24lambda_u243_u24lambda_u241;
            JComponent jComponent;
            Container container2;
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(SpaceConnectionFrame.this){
                final /* synthetic */ SpaceConnectionFrame this$0;
                {
                    this.this$0 = $receiver;
                }

                public void windowClosing(@NotNull WindowEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SpaceConnectionFrame.access$onDialogClose(this.this$0);
                }
            });
            Container $this$setupUI_u24lambda_u243 = container2 = this.getContentPane();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$setupUI_u24lambda_u243, (String)"null cannot be cast to non-null type javax.swing.JPanel");
            JPanel cfr_ignored_0 = (JPanel)$this$setupUI_u24lambda_u243;
            ((JPanel)$this$setupUI_u24lambda_u243).setBorder(JBUI.Borders.empty((int)8));
            $this$setupUI_u24lambda_u243.setLayout(new BoxLayout($this$setupUI_u24lambda_u243, 1));
            JComponent jComponent2 = jComponent = this.createCenterPanel();
            Container container3 = $this$setupUI_u24lambda_u243;
            boolean bl2 = false;
            $this$setupUI_u24lambda_u243_u24lambda_u241.setAlignmentX(1.0f);
            container3.add(jComponent);
            $this$setupUI_u24lambda_u243_u24lambda_u241 = jComponent = this.createButtonsPanel(CollectionsKt.toList((Iterable)this.buttons.values()));
            container3 = $this$setupUI_u24lambda_u243;
            boolean bl3 = false;
            $this$setupUI_u24lambda_u243_u24lambda_u242.setBorder((Border)JBUI.Borders.empty((int)8, (int)0, (int)4, (int)0));
            $this$setupUI_u24lambda_u243_u24lambda_u242.setAlignmentX(1.0f);
            container3.add(jComponent);
            this.getButton(this.openGateway).setVisible(false);
            this.getButton(this.retry).setVisible(false);
            this.setResizable(false);
            AppUIUtilKt.updateAppWindowIcon((Window)this);
            ComponentUtil.decorateWindowHeader((JRootPane)this.rootPane);
            UIUtil.setAutoRequestFocus((Window)this, (boolean)true);
            this.setLocationRelativeTo(null);
            ToolbarService toolbarService = ToolbarService.Companion.getInstance();
            Window window2 = this;
            JRootPane jRootPane = this.rootPane;
            Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"rootPane");
            toolbarService.setTransparentTitleBar(window2, jRootPane, (Function1)new Function1<Runnable, Unit>(this){
                final /* synthetic */ SpaceConnectionDialog this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Runnable runnable) {
                    Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
                    this.this$0.getLifetime().onTermination((Function0)new Function0<Unit>(runnable){
                        final /* synthetic */ Runnable $runnable;
                        {
                            this.$runnable = $runnable;
                            super(0);
                        }

                        public final void invoke() {
                            this.$runnable.run();
                        }
                    });
                }
            });
            this.pack();
            Rectangle screenBounds = ScreenUtil.getScreenRectangle((Point)new Point(0, 0));
            this.setLocation(new Point(screenBounds.x + (screenBounds.width - this.getWidth()) / 2, screenBounds.y + (screenBounds.height - this.getHeight()) / 2));
            this.setVisible(true);
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Dimension it = super.getPreferredSize();
            boolean bl = false;
            return new Dimension(Math.max(it.width, 450), it.height);
        }

        private final JComponent createCenterPanel() {
            return SpaceConnectionFrame.this.handle.customComponentProvider((Lifetime)this.lifetime).createComponent((CustomConnectionFrameContext)this);
        }

        private final JPanel createButtonsPanel(List<? extends JButton> buttons2) {
            NonOpaquePanel buttonsPanel = new NonOpaquePanel();
            buttonsPanel.setLayout((LayoutManager)new BoxLayout((Container)buttonsPanel, 0));
            for (JButton jButton : buttons2) {
                buttonsPanel.add((Component)jButton);
            }
            return (JPanel)buttonsPanel;
        }

        private final JButton createJButtonForAction(Action action2) {
            JButton jButton = DialogWrapper.createJButtonForAction((Action)action2, (JRootPane)this.getRootPane());
            Intrinsics.checkNotNullExpressionValue((Object)jButton, (String)"createJButtonForAction(...)");
            return jButton;
        }
    }
}

