/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.promo;

import com.intellij.ui.icons.HiDPIImage;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/intellij/space/promo/ImageLoader;", "", "()V", "loadImage", "Ljava/awt/Image;", "path", "", "width", "", "height", "intellij.space"})
@SourceDebugExtension(value={"SMAP\npromo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 promo.kt\ncom/intellij/space/promo/ImageLoader\n+ 2 KLoggers.kt\nlibraries/klogging/KLoggersKt\n+ 3 KLogger.kt\nlibraries/klogging/KLogger\n*L\n1#1,158:1\n18#2:159\n35#3,5:160\n*S KotlinDebug\n*F\n+ 1 promo.kt\ncom/intellij/space/promo/ImageLoader\n*L\n118#1:159\n118#1:160,5\n*E\n"})
final class ImageLoader {
    @NotNull
    public static final ImageLoader INSTANCE = new ImageLoader();

    private ImageLoader() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Image loadImage(@NotNull String path2, int width, int height) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResourceAsStream(path2));
            Intrinsics.checkNotNull((Object)img);
            image = (Image)new HiDPIImage((Image)img, width, height, img.getType());
        }
        catch (Exception e) {
            void this_$iv;
            Object $this$logger$iv = this;
            boolean $i$f$logger = false;
            $this$logger$iv = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(ImageLoader.class));
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                String msgStr$iv = "Image " + path2 + " is not loaded";
                this_$iv.error(msgStr$iv);
            }
            image = null;
        }
        return image;
    }
}

