/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.space.vcs.SpaceOpenInBrowserActionGroup;
import com.intellij.space.vcs.SpaceProjectContext;
import com.intellij.space.vcs.SpaceProjectInfo;
import com.intellij.space.vcs.SpaceRepoInfo;
import com.intellij.space.vcs.UrlData;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/space/vcs/SpaceUrlBasedActionGroup;", "Lcom/intellij/space/vcs/SpaceOpenInBrowserActionGroup;", "Lcom/intellij/space/vcs/UrlData;", "groupName", "", "description", "(Ljava/lang/String;Ljava/lang/String;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getData", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getDataFromHistory", "project", "Lcom/intellij/openapi/project/Project;", "getDataFromLog", "getDataFromVirtualFile", "intellij.space.vcs"})
@SourceDebugExtension(value={"SMAP\nSpaceOpenInBrowserAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceOpenInBrowserAction.kt\ncom/intellij/space/vcs/SpaceUrlBasedActionGroup\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,281:1\n125#2:282\n152#2,3:283\n125#2:286\n152#2,3:287\n125#2:290\n152#2,3:291\n*S KotlinDebug\n*F\n+ 1 SpaceOpenInBrowserAction.kt\ncom/intellij/space/vcs/SpaceUrlBasedActionGroup\n*L\n164#1:282\n164#1:283,3\n174#1:286\n174#1:287,3\n183#1:290\n183#1:291,3\n*E\n"})
public abstract class SpaceUrlBasedActionGroup
extends SpaceOpenInBrowserActionGroup<UrlData> {
    public SpaceUrlBasedActionGroup(@NlsActions.ActionText @NotNull String groupName, @NlsActions.ActionDescription @NotNull String description2) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        super(groupName, description2);
    }

    @Override
    @Nullable
    public List<UrlData> getData(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project2 = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        List<UrlData> list2 = this.getDataFromHistory(dataContext, project3);
        if (list2 == null && (list2 = this.getDataFromLog(dataContext, project3)) == null) {
            list2 = this.getDataFromVirtualFile(dataContext, project3);
        }
        return list2;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UrlData> getDataFromVirtualFile(DataContext dataContext, Project project2) {
        void $this$mapTo$iv$iv;
        VirtualFile virtualFile = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Repository repository = VcsRepositoryManager.getInstance((Project)project2).getRepositoryForFileQuick(virtualFile2);
        if (repository == null) {
            return null;
        }
        Repository gitRepository = repository;
        if (!(gitRepository instanceof GitRepository)) {
            return null;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        if (changeListManager2.isUnversioned(virtualFile2)) {
            return null;
        }
        if (changeListManager2.isIgnoredFile(virtualFile2)) {
            return null;
        }
        Change change2 = changeListManager2.getChange(virtualFile2);
        if (change2 != null && change2.getType() == Change.Type.NEW) {
            return null;
        }
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        Integer line2 = editor != null && editor.getDocument().getLineCount() >= 1 ? Integer.valueOf(editor.getCaretModel().getCurrentCaret().getLogicalPosition().line) : null;
        Map<SpaceRepoInfo, SpaceProjectInfo> $this$map$iv = SpaceProjectContext.Companion.findProjectMappings(project2, (GitRepository)gitRepository);
        boolean $i$f$map = false;
        Map<SpaceRepoInfo, SpaceProjectInfo> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SpaceRepoInfo repo = (SpaceRepoInfo)entry.getKey();
            SpaceProjectInfo pr = (SpaceProjectInfo)entry.getValue();
            collection.add(new UrlData.File(project2, pr, repo.getName(), virtualFile2, line2, (GitRepository)gitRepository));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UrlData> getDataFromHistory(DataContext dataContext, Project project2) {
        void $this$mapTo$iv$iv;
        FilePath filePath = (FilePath)dataContext.getData(VcsDataKeys.FILE_PATH);
        if (filePath == null) {
            return null;
        }
        FilePath filePath2 = filePath;
        VcsFileRevision vcsFileRevision = (VcsFileRevision)dataContext.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (vcsFileRevision == null) {
            return null;
        }
        VcsFileRevision fileRevision = vcsFileRevision;
        if (!(fileRevision instanceof VcsFileRevisionEx)) {
            return null;
        }
        GitRepository gitRepository = (GitRepository)GitUtil.getRepositoryManager((Project)project2).getRepositoryForFileQuick(filePath2);
        if (gitRepository == null) {
            return null;
        }
        GitRepository gitRepository2 = gitRepository;
        Map<SpaceRepoInfo, SpaceProjectInfo> $this$map$iv = SpaceProjectContext.Companion.findProjectMappings(project2, gitRepository2);
        boolean $i$f$map = false;
        Map<SpaceRepoInfo, SpaceProjectInfo> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SpaceRepoInfo repo = (SpaceRepoInfo)entry.getKey();
            SpaceProjectInfo pr = (SpaceProjectInfo)entry.getValue();
            collection.add(new UrlData.FileRevision(project2, pr, repo.getName(), (VcsFileRevisionEx)fileRevision));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<UrlData> getDataFromLog(DataContext dataContext, Project project2) {
        void $this$mapTo$iv$iv;
        VcsLogCommitSelection vcsLogCommitSelection = (VcsLogCommitSelection)dataContext.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (vcsLogCommitSelection == null) {
            return null;
        }
        VcsLogCommitSelection selection2 = vcsLogCommitSelection;
        CommitId commitId = (CommitId)CollectionsKt.firstOrNull((List)selection2.getCommits());
        if (commitId == null) {
            return null;
        }
        CommitId selectedCommit2 = commitId;
        GitRepository gitRepository = (GitRepository)GitUtil.getRepositoryManager((Project)project2).getRepositoryForFileQuick(selectedCommit2.getRoot());
        if (gitRepository == null) {
            return null;
        }
        GitRepository gitRepository2 = gitRepository;
        Map<SpaceRepoInfo, SpaceProjectInfo> $this$map$iv = SpaceProjectContext.Companion.findProjectMappings(project2, gitRepository2);
        boolean $i$f$map = false;
        Map<SpaceRepoInfo, SpaceProjectInfo> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SpaceRepoInfo repo = (SpaceRepoInfo)entry.getKey();
            SpaceProjectInfo pr = (SpaceProjectInfo)entry.getValue();
            collection.add(new UrlData.Commit(project2, pr, repo.getName(), selectedCommit2));
        }
        return (List)destination$iv$iv;
    }
}

