/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.actions;

import circlet.client.api.ProjectKey;
import circlet.client.api.TeamDirectoryKt;
import circlet.platform.client.ConnectionStatus;
import circlet.workspaces.Workspace;
import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.space.actions.SpaceLoginPromoPanelKt;
import com.intellij.space.components.SpaceConnectionStatusService;
import com.intellij.space.components.SpaceUserAvatarProvider;
import com.intellij.space.components.SpaceWorkspaceComponent;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.promo.SpaceExplorePlace;
import com.intellij.space.settings.SpaceLoginState;
import com.intellij.space.settings.SpaceSettings;
import com.intellij.space.settings.SpaceSettingsPanel;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.ui.LoginComponents;
import com.intellij.space.ui.UtilitiesKt;
import com.intellij.space.ui.icons.SpaceMeIcon;
import com.intellij.space.utils.SpaceUrls;
import com.intellij.space.vcs.Context;
import com.intellij.space.vcs.SpaceProjectContext;
import com.intellij.space.vcs.SpaceProjectInfo;
import com.intellij.space.vcs.actions.SpaceMainToolBarAction;
import com.intellij.space.vcs.clone.SpaceCloneAction;
import com.intellij.space.vcs.messages.SpaceVcsBundle;
import com.intellij.space.vcs.review.SpaceShowReviewsAction;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.cloneDialog.AccountMenuItem;
import com.intellij.util.ui.cloneDialog.AccountMenuPopupStep;
import com.intellij.util.ui.cloneDialog.AccountsMenuListPopup;
import com.intellij.util.ui.cloneDialog.VcsCloneDialogPopupMenuKt;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.Source;
import runtime.reactive.SourceKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/space/vcs/actions/SpaceMainToolBarAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/RightAlignedToolbarAction;", "()V", "settings", "Lcom/intellij/space/settings/SpaceSettings;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "buildMenu", "Lcom/intellij/util/ui/cloneDialog/AccountsMenuListPopup;", "workspace", "Lcirclet/workspaces/Workspace;", "icon", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "createView", "Ljavax/swing/JComponent;", "st", "Lcom/intellij/space/settings/SpaceLoginState;", "component", "Ljava/awt/Component;", "packPopup", "Lkotlin/Function0;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.space.vcs"})
@SourceDebugExtension(value={"SMAP\nSpaceMainToolBarAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceMainToolBarAction.kt\ncom/intellij/space/vcs/actions/SpaceMainToolBarAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1549#2:179\n1620#2,3:180\n1549#2:183\n1620#2,3:184\n1549#2:187\n1620#2,3:188\n*S KotlinDebug\n*F\n+ 1 SpaceMainToolBarAction.kt\ncom/intellij/space/vcs/actions/SpaceMainToolBarAction\n*L\n145#1:179\n145#1:180,3\n150#1:183\n150#1:184,3\n155#1:187\n155#1:188,3\n*E\n"})
public final class SpaceMainToolBarAction
extends DumbAwareAction
implements RightAlignedToolbarAction {
    @NotNull
    private final SpaceSettings settings = SpaceSettings.Companion.getInstance();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean isOnNavBar = Intrinsics.areEqual((Object)e.getPlace(), (Object)"NavBarToolbar");
        boolean isOnMainBar = Intrinsics.areEqual((Object)e.getPlace(), (Object)"MainToolbar");
        if (!isOnNavBar && !isOnMainBar) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
        SpaceWorkspaceComponent space = SpaceWorkspaceComponent.Companion.getInstance();
        SpaceMeIcon avatars2 = (SpaceMeIcon)SpaceUserAvatarProvider.Companion.getInstance().getAvatarStateFlow().getValue();
        boolean isOnline = SpaceConnectionStatusService.Companion.getInstance().getConnectionStatus().getValue() instanceof ConnectionStatus.Connected;
        boolean isConnecting = space.getAuthorizationState().getValue() instanceof SpaceLoginState.Connecting;
        e.getPresentation().setIcon(isOnline ? avatars2.getOnline() : (isConnecting ? (Icon)AnimatedIcon.Default.INSTANCE : avatars2.getOffline()));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        InputEvent inputEvent = e.getInputEvent();
        Intrinsics.checkNotNull((Object)inputEvent);
        Component component2 = inputEvent.getComponent();
        SpaceWorkspaceComponent space = SpaceWorkspaceComponent.Companion.getInstance();
        Workspace workspace2 = space.getWorkspace().getValue();
        SpaceStatsCounterCollector.OPEN_MAIN_TOOLBAR_POPUP.log((Object)SpaceStatsCounterCollector.LoginState.Companion.convert((SpaceLoginState)space.getAuthorizationState().getValue()));
        if (workspace2 != null) {
            Icon icon2 = SpaceUserAvatarProvider.Companion.getInstance().getAvatars().getValue().getCircle();
            Project project2 = e.getProject();
            Intrinsics.checkNotNull((Object)project2);
            AccountsMenuListPopup accountsMenuListPopup = this.buildMenu(workspace2, icon2, project2);
            Intrinsics.checkNotNull((Object)component2);
            accountsMenuListPopup.showUnderneathOf(component2);
        } else {
            Wrapper wrapper2 = new Wrapper();
            JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)wrapper2, (JComponent)wrapper2).setRequestFocus(true).setFocusable(true).setBorderColor(JBColor.border()).createPopup();
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
            JBPopup popup2 = jBPopup;
            SourceKt.view((Source)space.getLoginState(), space.getLifetime(), (Function2)new Function2<Lifetime, SpaceLoginState, Unit>(this, component2, popup2, wrapper2){
                final /* synthetic */ SpaceMainToolBarAction this$0;
                final /* synthetic */ Component $component;
                final /* synthetic */ JBPopup $popup;
                final /* synthetic */ Wrapper $wrapper;
                {
                    this.this$0 = $receiver;
                    this.$component = $component;
                    this.$popup = $popup;
                    this.$wrapper = $wrapper;
                    super(2);
                }

                public final void invoke(@NotNull Lifetime lifetime, @NotNull SpaceLoginState st) {
                    Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)st, (String)"st");
                    Component component2 = this.$component;
                    Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"$component");
                    JComponent view2 = SpaceMainToolBarAction.access$createView(this.this$0, st, component2, (Function0)new Function0<Unit>(this.$popup){
                        final /* synthetic */ JBPopup $popup;
                        {
                            this.$popup = $popup;
                            super(0);
                        }

                        public final void invoke() {
                            this.$popup.pack(true, true);
                        }
                    });
                    if (view2 == null) {
                        this.$popup.cancel();
                        return;
                    }
                    this.$wrapper.setContent(view2);
                    this.$wrapper.repaint();
                    if (st instanceof SpaceLoginState.Disconnected) {
                        this.$popup.pack(true, true);
                    }
                }
            });
            popup2.show(new RelativePoint(component2, new Point(-wrapper2.getPreferredSize().width + component2.getWidth(), component2.getHeight())));
        }
    }

    private final JComponent createView(SpaceLoginState st, Component component2, Function0<Unit> packPopup) {
        JComponent jComponent;
        SpaceLoginState spaceLoginState = st;
        if (spaceLoginState instanceof SpaceLoginState.Connected) {
            jComponent = null;
        } else if (spaceLoginState instanceof SpaceLoginState.Connecting) {
            jComponent = (JComponent)LoginComponents.INSTANCE.buildConnectingPanel((SpaceLoginState.Connecting)st, SpaceStatsCounterCollector.LoginPlace.MAIN_TOOLBAR, (Border)SpaceLoginPromoPanelKt.prettyBorder(), (Function0<Unit>)((Function0)new Function0<Unit>(st){
                final /* synthetic */ SpaceLoginState $st;
                {
                    this.$st = $st;
                    super(0);
                }

                public final void invoke() {
                    ((SpaceLoginState.Connecting)this.$st).cancel();
                }
            }));
        } else if (spaceLoginState instanceof SpaceLoginState.Disconnected) {
            jComponent = SpaceLoginPromoPanelKt.buildLoginPanelWithPromo((SpaceLoginState.Disconnected)st, SpaceExplorePlace.MAIN_TOOLBAR, SpaceStatsCounterCollector.LoginPlace.MAIN_TOOLBAR, packPopup, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(component2){
                final /* synthetic */ Component $component;
                {
                    this.$component = $component;
                    super(1);
                }

                public final void invoke(@NotNull String serverName) {
                    Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
                    SpaceWorkspaceComponent space = SpaceWorkspaceComponent.Companion.getInstance();
                    space.signInManually(serverName, space.getLifetime(), this.$component);
                }
            }));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jComponent;
    }

    private final AccountsMenuListPopup buildMenu(Workspace workspace2, Icon icon2, Project project2) {
        String host = this.settings.getServerSettings().getServer();
        String serverUrl = CollaborationToolsUIUtil.INSTANCE.cleanupUrl(host);
        List menuItems = new ArrayList();
        Collection collection = menuItems;
        String string2 = TeamDirectoryKt.englishFullName(workspace2.getMe().getValue());
        Icon icon3 = UtilitiesKt.resizeIcon(icon2, 40);
        Object object = new Object[]{serverUrl};
        String string3 = SpaceBundle.message("main.toolbar.open.server", (Object[])object);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        collection.add(new AccountMenuItem.Account(string2, serverUrl, icon3, CollectionsKt.listOf((Object)VcsCloneDialogPopupMenuKt.browseAction((String)string3, (String)host, (boolean)true)), false, 16, null));
        collection = menuItems;
        String string4 = SpaceVcsBundle.message("action.com.intellij.space.vcs.clone.SpaceCloneAction.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        collection.add(new AccountMenuItem.Action(string4, (Function0)new Function0<Unit>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                SpaceCloneAction.Handler.INSTANCE.runClone(this.$project);
            }
        }, null, true, 4, null));
        SpaceProjectContext projectContext2 = SpaceProjectContext.Companion.getInstance(project2);
        Context context2 = projectContext2.getCurrentContext();
        if (context2.isAssociatedWithSpaceRepository()) {
            Collection<SpaceProjectInfo> descriptions = context2.getRepoToProject().values();
            Collection collection2 = menuItems;
            String string5 = SpaceVcsBundle.message("action.SpaceShowReviewsAction.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            collection2.add(new AccountMenuItem.Action(string5, (Function0)new Function0<Unit>(project2){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(0);
                }

                public final void invoke() {
                    SpaceShowReviewsAction.Handler.INSTANCE.showCodeReviews$intellij_space_vcs(this.$project);
                }
            }, null, false, 12, null));
            if (descriptions.size() > 1) {
                String issuesUrl;
                Object[] objectArray;
                SpaceProjectInfo it;
                Collection collection3;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                collection2 = menuItems;
                String string6 = SpaceBundle.message("open.in.browser.group.documents", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
                Iterable iterable = descriptions;
                String string7 = string6;
                boolean $i$f$map = false;
                void var13_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    SpaceProjectInfo spaceProjectInfo = (SpaceProjectInfo)item$iv$iv;
                    collection3 = destination$iv$iv;
                    boolean bl = false;
                    String url2 = SpaceUrls.INSTANCE.documents(it.getKey());
                    objectArray = new Object[]{it.getProject().getName()};
                    String string8 = SpaceBundle.message("open.in.browser.open.for.project.action", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
                    collection3.add(VcsCloneDialogPopupMenuKt.browseAction$default((String)string8, (String)url2, (boolean)false, (int)4, null));
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 4;
                boolean bl = false;
                List list2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                String string9 = string7;
                collection2.add(new AccountMenuItem.Group(string9, list2, bl, n, defaultConstructorMarker));
                collection2 = menuItems;
                String string10 = SpaceBundle.message("open.in.browser.group.issues", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"message(...)");
                $this$map$iv = descriptions;
                string7 = string10;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (SpaceProjectInfo)item$iv$iv;
                    collection3 = destination$iv$iv;
                    boolean bl2 = false;
                    issuesUrl = SpaceUrls.INSTANCE.issues(it.getKey());
                    objectArray = new Object[]{it.getProject().getName()};
                    String string11 = SpaceBundle.message("open.in.browser.open.for.project.action", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"message(...)");
                    collection3.add(VcsCloneDialogPopupMenuKt.browseAction$default((String)string11, (String)issuesUrl, (boolean)false, (int)4, null));
                }
                DefaultConstructorMarker defaultConstructorMarker2 = null;
                int n2 = 4;
                boolean bl3 = false;
                List list3 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                String string12 = string7;
                collection2.add(new AccountMenuItem.Group(string12, list3, bl3, n2, defaultConstructorMarker2));
                collection2 = menuItems;
                String string13 = SpaceBundle.message("open.in.browser.group.packages", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"message(...)");
                $this$map$iv = descriptions;
                string7 = string13;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (SpaceProjectInfo)item$iv$iv;
                    collection3 = destination$iv$iv;
                    boolean bl4 = false;
                    issuesUrl = SpaceUrls.INSTANCE.packages(it.getKey());
                    objectArray = new Object[]{it.getProject().getName()};
                    String string14 = SpaceBundle.message("open.in.browser.open.for.project.action", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"message(...)");
                    collection3.add(VcsCloneDialogPopupMenuKt.browseAction$default((String)string14, (String)issuesUrl, (boolean)false, (int)4, null));
                }
                DefaultConstructorMarker defaultConstructorMarker3 = null;
                int n3 = 4;
                boolean bl5 = false;
                List list4 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                String string15 = string7;
                collection2.add(new AccountMenuItem.Group(string15, list4, bl5, n3, defaultConstructorMarker3));
            } else if (!descriptions.isEmpty()) {
                ProjectKey projectKey = ((SpaceProjectInfo)CollectionsKt.first((Iterable)descriptions)).getKey();
                Collection collection4 = menuItems;
                String string16 = SpaceBundle.message("main.toolbar.documents.action", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"message(...)");
                collection4.add(VcsCloneDialogPopupMenuKt.browseAction$default((String)string16, (String)SpaceUrls.INSTANCE.documents(projectKey), (boolean)false, (int)4, null));
                collection4 = menuItems;
                String string17 = SpaceBundle.message("main.toolbar.issues.action", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"message(...)");
                collection4.add(VcsCloneDialogPopupMenuKt.browseAction$default((String)string17, (String)SpaceUrls.INSTANCE.issues(projectKey), (boolean)false, (int)4, null));
                collection4 = menuItems;
                String string18 = SpaceBundle.message("main.toolbar.packages.action", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"message(...)");
                collection4.add(VcsCloneDialogPopupMenuKt.browseAction$default((String)string18, (String)SpaceUrls.INSTANCE.packages(projectKey), (boolean)false, (int)4, null));
            }
        }
        object = menuItems;
        String string19 = SpaceBundle.message("main.toolbar.settings.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string19, (String)"message(...)");
        object.add(new AccountMenuItem.Action(string19, (Function0)new Function0<Unit>(project2){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            public final void invoke() {
                SpaceSettingsPanel.Companion.openSettings(this.$project);
            }
        }, null, true, 4, null));
        object = menuItems;
        String string20 = SpaceBundle.message("main.toolbar.log.out.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string20, (String)"message(...)");
        object.add(new AccountMenuItem.Action(string20, (Function0)buildMenu.7.INSTANCE, null, false, 12, null));
        return new AccountsMenuListPopup(project2, new AccountMenuPopupStep(menuItems), null, null, 12, null);
    }

    public static final /* synthetic */ JComponent access$createView(SpaceMainToolBarAction $this, SpaceLoginState st, Component component2, Function0 packPopup) {
        return $this.createView(st, component2, (Function0<Unit>)packPopup);
    }
}

