/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.changes;

import com.intellij.diff.editor.DiffEditorTabFilesManager;
import com.intellij.diff.editor.DiffVirtualFileBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.EditorTabPreviewBase;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.vcs.changes.SpaceDiffFileProvider;
import com.intellij.space.vcs.review.details.diff.SpaceReviewOpenDiffActionProvider;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/space/vcs/changes/SpaceEditorDiffPreview;", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "spaceDiffFileProvider", "Lcom/intellij/space/vcs/changes/SpaceDiffFileProvider;", "diffPlace", "Lcom/intellij/space/stats/SpaceStatsCounterCollector$DiffPlace;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Lcom/intellij/space/vcs/changes/SpaceDiffFileProvider;Lcom/intellij/space/stats/SpaceStatsCounterCollector$DiffPlace;)V", "escapeHandler", "Ljava/lang/Runnable;", "spaceDiffFile", "Lcom/intellij/diff/editor/DiffVirtualFileBase;", "getSpaceDiffFile", "()Lcom/intellij/diff/editor/DiffVirtualFileBase;", "closePreview", "", "openPreview", "", "requestFocus", "updateDiffAction", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.space.vcs"})
public final class SpaceEditorDiffPreview
implements DiffPreview {
    @NotNull
    private final Project project;
    @NotNull
    private final ChangesTree tree;
    @NotNull
    private final SpaceDiffFileProvider spaceDiffFileProvider;
    @NotNull
    private final SpaceStatsCounterCollector.DiffPlace diffPlace;
    @NotNull
    private final Runnable escapeHandler;

    public SpaceEditorDiffPreview(@NotNull Project project2, @NotNull ChangesTree tree2, @NotNull SpaceDiffFileProvider spaceDiffFileProvider, @NotNull SpaceStatsCounterCollector.DiffPlace diffPlace) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)spaceDiffFileProvider, (String)"spaceDiffFileProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)diffPlace), (String)"diffPlace");
        this.project = project2;
        this.tree = tree2;
        this.spaceDiffFileProvider = spaceDiffFileProvider;
        this.diffPlace = diffPlace;
        this.escapeHandler = () -> SpaceEditorDiffPreview.escapeHandler$lambda$1(this);
    }

    public void updateDiffAction(@NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        SpaceReviewOpenDiffActionProvider.Companion.updateAvailability(event2);
    }

    private final DiffVirtualFileBase getSpaceDiffFile() {
        return this.spaceDiffFileProvider.getSpaceDiffFile();
    }

    public boolean openPreview(boolean requestFocus) {
        SpaceStatsCounterCollector.OPEN_DIFF.log((Object)SpaceStatsCounterCollector.DiffType.PREVIEW, (Object)this.diffPlace);
        DiffVirtualFileBase diffFile = this.getSpaceDiffFile();
        EditorTabPreviewBase.Companion.registerEscapeHandler((VirtualFile)diffFile, this.escapeHandler);
        DiffEditorTabFilesManager.Companion.getInstance(this.project).showDiffFile((VirtualFile)diffFile, requestFocus);
        return true;
    }

    public void closePreview() {
        DiffPreview.Companion.closePreviewFile(this.project, (VirtualFile)this.getSpaceDiffFile());
    }

    private static final void escapeHandler$lambda$1$lambda$0(SpaceEditorDiffPreview this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        IdeFocusManager.getInstance((Project)this$0.project).requestFocus((Component)this$0.tree.getPreferredFocusedComponent(), true);
    }

    private static final void escapeHandler$lambda$1(SpaceEditorDiffPreview this$0) {
        block0: {
            ToolWindow toolWindow;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.closePreview();
            ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance(this$0.project).getToolWindow("Space Code Reviews");
            if (toolWindow2 == null) break block0;
            toolWindow2.activate(() -> SpaceEditorDiffPreview.escapeHandler$lambda$1$lambda$0(this$0), false);
        }
    }
}

