/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.chat.editor;

import com.intellij.diff.editor.DiffVirtualFileBase;
import com.intellij.ide.actions.SplitAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.space.vcs.chat.editor.SpaceChatFileType;
import com.intellij.space.vcs.chat.model.api.SpaceChatCreationDetails;
import com.intellij.space.vcs.chat.ui.SpaceChatUiDetails;
import com.intellij.space.vcs.editor.SpaceChatComplexPathVirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002BM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0001\u0010\b\u001a\u00020\u0004\u0012\b\b\u0001\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0013\u0010\u0019\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020\u0004H\u0016J\b\u0010 \u001a\u00020!H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/intellij/space/vcs/chat/editor/SpaceChatFile;", "Lcom/intellij/testFramework/LightVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "sessionId", "", "projectHash", "id", "path", "displayName", "tabTooltip", "chatCreationDetails", "Lcom/intellij/space/vcs/chat/model/api/SpaceChatCreationDetails;", "chatUiDetails", "Lcom/intellij/space/vcs/chat/ui/SpaceChatUiDetails;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/space/vcs/chat/model/api/SpaceChatCreationDetails;Lcom/intellij/space/vcs/chat/ui/SpaceChatUiDetails;)V", "getChatCreationDetails", "()Lcom/intellij/space/vcs/chat/model/api/SpaceChatCreationDetails;", "getChatUiDetails", "()Lcom/intellij/space/vcs/chat/ui/SpaceChatUiDetails;", "getDisplayName", "()Ljava/lang/String;", "getId", "getTabTooltip", "enforcePresentableName", "", "equals", "other", "", "getFileSystem", "Lcom/intellij/space/vcs/editor/SpaceChatComplexPathVirtualFileSystem;", "getPath", "getPresentablePath", "hashCode", "", "intellij.space.vcs"})
public final class SpaceChatFile
extends LightVirtualFile
implements VirtualFilePathWrapper {
    @NotNull
    private final String sessionId;
    @NotNull
    private final String projectHash;
    @NotNull
    private final String id;
    @NotNull
    private final String displayName;
    @NotNull
    private final String tabTooltip;
    @NotNull
    private final SpaceChatCreationDetails chatCreationDetails;
    @NotNull
    private final SpaceChatUiDetails chatUiDetails;

    public SpaceChatFile(@NotNull String sessionId, @NotNull String projectHash, @NlsSafe @NotNull String id2, @NlsSafe @NotNull String path2, @NlsContexts.TabTitle @NotNull String displayName, @NlsContexts.Tooltip @NotNull String tabTooltip, @NotNull SpaceChatCreationDetails chatCreationDetails2, @NotNull SpaceChatUiDetails chatUiDetails) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)projectHash, (String)"projectHash");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)tabTooltip, (String)"tabTooltip");
        Intrinsics.checkNotNullParameter((Object)chatCreationDetails2, (String)"chatCreationDetails");
        Intrinsics.checkNotNullParameter((Object)chatUiDetails, (String)"chatUiDetails");
        super(path2, (FileType)SpaceChatFileType.Companion.getInstance(), (CharSequence)"");
        this.sessionId = sessionId;
        this.projectHash = projectHash;
        this.id = id2;
        this.displayName = displayName;
        this.tabTooltip = tabTooltip;
        this.chatCreationDetails = chatCreationDetails2;
        this.chatUiDetails = chatUiDetails;
        this.putUserData(SplitAction.FORBID_TAB_SPLIT, true);
        DiffVirtualFileBase.Companion.turnOffReopeningWindow((VirtualFile)this);
        this.setWritable(false);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final String getTabTooltip() {
        return this.tabTooltip;
    }

    @NotNull
    public final SpaceChatCreationDetails getChatCreationDetails() {
        return this.chatCreationDetails;
    }

    @NotNull
    public final SpaceChatUiDetails getChatUiDetails() {
        return this.chatUiDetails;
    }

    @NotNull
    public SpaceChatComplexPathVirtualFileSystem getFileSystem() {
        return SpaceChatComplexPathVirtualFileSystem.Companion.getInstance();
    }

    @NotNull
    public String getPath() {
        String string2;
        try {
            string2 = this.getFileSystem().getPath(this.sessionId, this.projectHash, this.id);
        }
        catch (Exception e) {
            String string3 = this.getName();
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        }
        return string2;
    }

    public boolean enforcePresentableName() {
        return true;
    }

    @NotNull
    public String getPresentablePath() {
        String string2 = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return string2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.space.vcs.chat.editor.SpaceChatFile");
        SpaceChatFile cfr_ignored_0 = (SpaceChatFile)((Object)other);
        return Intrinsics.areEqual((Object)this.id, (Object)((SpaceChatFile)((Object)other)).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

