/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.clone;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.dvcs.ui.CloneDvcsValidationUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.checkout.GitCheckoutListener;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.commands.Git;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"doCloneSpaceRepo", "", "project", "Lcom/intellij/openapi/project/Project;", "cloneUrl", "", "directory", "checkoutListener", "Lgit4idea/checkout/GitCheckoutListener;", "intellij.space.vcs"})
public final class SpaceCloneComponentKt {
    public static final void doCloneSpaceRepo(@NotNull Project project2, @NotNull String cloneUrl, @NotNull String directory, @NotNull GitCheckoutListener checkoutListener) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cloneUrl, (String)"cloneUrl");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)checkoutListener, (String)"checkoutListener");
        ValidationInfo createDirectoryError = CloneDvcsValidationUtils.createDestination((String)directory);
        if (createDirectoryError != null) {
            VcsNotifier.getInstance((Project)project2).notifyImportantWarning("space.git.repo.foldernotfound", CollaborationToolsBundle.message((String)"clone.dialog.clone.failed", (Object[])new Object[0]), CollaborationToolsBundle.message((String)"clone.dialog.error.unable.to.find.destination.directory", (Object[])new Object[0]));
            return;
        }
        Path parent = Paths.get(directory, new String[0]).toAbsolutePath().getParent();
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem lfs = localFileSystem;
        VirtualFile virtualFile = lfs.findFileByIoFile(parent.toFile());
        if (virtualFile == null && (virtualFile = lfs.refreshAndFindFileByIoFile(parent.toFile())) == null) {
            return;
        }
        VirtualFile destinationParent = virtualFile;
        String directoryName = ((Object)Paths.get(directory, new String[0]).getFileName()).toString();
        String parentDirectory = ((Object)parent.toAbsolutePath()).toString();
        GitCheckoutProvider.clone((Project)project2, (Git)Git.getInstance(), (CheckoutProvider.Listener)((CheckoutProvider.Listener)checkoutListener), (VirtualFile)destinationParent, (String)cloneUrl, (String)directoryName, (String)parentDirectory);
    }
}

