/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.diff;

import com.intellij.diff.tools.combined.CombinedDiffVirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.vcs.editor.SpaceDiffComplexPathVirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0001\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/space/vcs/diff/SpaceDiffPreviewFile;", "Lcom/intellij/diff/tools/combined/CombinedDiffVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "sourceId", "", "sessionId", "projectHash", "fileId", "fileName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFileId", "()Ljava/lang/String;", "enforcePresentableName", "", "equals", "other", "", "getFileSystem", "Lcom/intellij/space/vcs/editor/SpaceDiffComplexPathVirtualFileSystem;", "getPath", "getPresentablePath", "hashCode", "", "intellij.space.vcs"})
public final class SpaceDiffPreviewFile
extends CombinedDiffVirtualFile
implements VirtualFilePathWrapper {
    @NotNull
    private final String sessionId;
    @NotNull
    private final String projectHash;
    @NotNull
    private final String fileId;

    public SpaceDiffPreviewFile(@NotNull String sourceId, @NotNull String sessionId, @NotNull String projectHash, @NotNull String fileId, @Nls @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)projectHash, (String)"projectHash");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Object[] objectArray = new Object[]{fileName};
        String string2 = SpaceBundle.message("review.diff.tab.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        super(sourceId, string2, null, 4, null);
        this.sessionId = sessionId;
        this.projectHash = projectHash;
        this.fileId = fileId;
    }

    @NotNull
    public final String getFileId() {
        return this.fileId;
    }

    @NotNull
    public SpaceDiffComplexPathVirtualFileSystem getFileSystem() {
        return SpaceDiffComplexPathVirtualFileSystem.Companion.getInstance();
    }

    @NotNull
    public String getPath() {
        String string2;
        try {
            string2 = this.getFileSystem().getPath(this.sessionId, this.projectHash, this.fileId);
        }
        catch (Exception e) {
            String string3 = this.getName();
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        }
        return string2;
    }

    public boolean enforcePresentableName() {
        return true;
    }

    @NotNull
    public String getPresentablePath() {
        String string2 = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return string2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.space.vcs.diff.SpaceDiffPreviewFile");
        SpaceDiffPreviewFile cfr_ignored_0 = (SpaceDiffPreviewFile)((Object)other);
        return Intrinsics.areEqual((Object)this.fileId, (Object)((SpaceDiffPreviewFile)((Object)other)).fileId);
    }

    public int hashCode() {
        return this.fileId.hashCode();
    }
}

