/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.review.create;

import circlet.platform.client.KCircletClient;
import com.intellij.collaboration.ui.toolwindow.ReviewToolwindowDataKeys;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.stats.SpaceClientStats;
import com.intellij.space.stats.SpaceClientStatsKt;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.vcs.SpaceProjectContext;
import com.intellij.space.vcs.SpaceProjectContextKt;
import com.intellij.space.vcs.SpaceProjectInfo;
import com.intellij.space.vcs.SpaceRepoInfo;
import com.intellij.space.vcs.review.create.BranchData;
import com.intellij.space.vcs.review.create.CommitsData;
import com.intellij.space.vcs.review.toolwindow.SpaceReviewToolWindowProjectViewModel;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.GitBranch;
import git4idea.GitRemoteBranch;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001b\u0010\u0000\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002\u001a*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0000\u001a\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u001f"}, d2={"allRemoteBranches", "", "", "Lorg/jetbrains/annotations/NotNull;", "repository", "Lgit4idea/repo/GitRepository;", "collectStatistics", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "projectVm", "Lcom/intellij/space/vcs/review/toolwindow/SpaceReviewToolWindowProjectViewModel;", "type", "Lcom/intellij/space/stats/SpaceStatsCounterCollector$CreateReviewType;", "createCommitSetReview", "project", "Lcom/intellij/openapi/project/Project;", "createMergeRequestAction", "findBranch", "Lcom/intellij/space/vcs/review/create/BranchData;", "findCommits", "Lcom/intellij/space/vcs/review/create/CommitsData;", "projectInfo", "Lcom/intellij/space/vcs/SpaceProjectInfo;", "searchBranchesQuickly", "", "getReviewToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getReviewToolWindowProjectVm", "toolWindow", "isCommitsSuitableForCodeReview", "intellij.space.vcs"})
@SourceDebugExtension(value={"SMAP\nSpaceCreateReviewActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceCreateReviewActions.kt\ncom/intellij/space/vcs/review/create/SpaceCreateReviewActionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,236:1\n288#2,2:237\n1549#2:239\n1620#2,3:240\n1726#2,3:250\n1549#2:253\n1620#2,3:254\n1549#2:257\n1620#2,3:258\n526#3:243\n511#3,6:244\n*S KotlinDebug\n*F\n+ 1 SpaceCreateReviewActions.kt\ncom/intellij/space/vcs/review/create/SpaceCreateReviewActionsKt\n*L\n180#1:237,2\n204#1:239\n204#1:240,3\n211#1:250,3\n222#1:253\n222#1:254,3\n236#1:257\n236#1:258,3\n207#1:243\n207#1:244,6\n*E\n"})
public final class SpaceCreateReviewActionsKt {
    private static final void createMergeRequestAction(Project project2, AnActionEvent e, SpaceReviewToolWindowProjectViewModel projectVm2) {
        SpaceCreateReviewActionsKt.collectStatistics(e, projectVm2, SpaceStatsCounterCollector.CreateReviewType.MERGE_REQUEST);
        BranchData branchData = SpaceCreateReviewActionsKt.findBranch(project2, e);
        if (branchData instanceof BranchData.Branch) {
            projectVm2.createMergeRequest(((BranchData.Branch)branchData).getGitBranch());
        } else {
            SpaceReviewToolWindowProjectViewModel.createMergeRequest$default(projectVm2, null, 1, null);
        }
    }

    private static final void createCommitSetReview(Project project2, AnActionEvent e, SpaceReviewToolWindowProjectViewModel projectVm2) {
        SpaceCreateReviewActionsKt.collectStatistics(e, projectVm2, SpaceStatsCounterCollector.CreateReviewType.CODE_REVIEW);
        CommitsData commitsData = SpaceCreateReviewActionsKt.findCommits$default(project2, e, projectVm2.getProjectInfo().getSpaceProject(), false, 8, null);
        if (Intrinsics.areEqual((Object)commitsData, (Object)CommitsData.Empty.INSTANCE)) {
            SpaceReviewToolWindowProjectViewModel.createCodeReview$default(projectVm2, null, null, 3, null);
        } else if (commitsData instanceof CommitsData.RepoAndCommits) {
            projectVm2.createCodeReview(((CommitsData.RepoAndCommits)commitsData).getCommits(), ((CommitsData.RepoAndCommits)commitsData).getSpaceRepoInfo());
        }
    }

    private static final void collectStatistics(AnActionEvent e, SpaceReviewToolWindowProjectViewModel projectVm2, SpaceStatsCounterCollector.CreateReviewType type2) {
        String projectId2 = projectVm2.getProjectInfo().getSpaceProject().getProject().getId();
        KCircletClient kCircletClient = SpaceClientStatsKt.getStats(projectVm2.getWorkspace().getClient());
        String string2 = e.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPlace(...)");
        SpaceClientStats.reportOpenCreateReview-impl(kCircletClient, projectId2, type2, string2);
    }

    @Nullable
    public static final SpaceReviewToolWindowProjectViewModel getReviewToolWindowProjectVm(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Object object = toolWindow.getContentManager().getSelectedContent();
        if (object == null || (object = object.getComponent()) == null) {
            return null;
        }
        Object selectedContentComponent = object;
        Object object2 = DataManager.getInstance().getDataContext((Component)selectedContentComponent).getData(ReviewToolwindowDataKeys.getREVIEW_TOOLWINDOW_PROJECT_VM());
        return object2 instanceof SpaceReviewToolWindowProjectViewModel ? (SpaceReviewToolWindowProjectViewModel)object2 : null;
    }

    @Nullable
    public static final SpaceReviewToolWindowProjectViewModel getReviewToolWindowProjectVm(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project3).getToolWindow("Space Code Reviews");
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        return SpaceCreateReviewActionsKt.getReviewToolWindowProjectVm(toolWindow2);
    }

    @Nullable
    public static final ToolWindow getReviewToolWindow(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return ToolWindowManager.Companion.getInstance(project2).getToolWindow("Space Code Reviews");
    }

    private static final BranchData findBranch(Project project2, AnActionEvent e) {
        GitBranch branch2;
        Object v4;
        block6: {
            int selectedCommits2;
            VcsLogCommitSelection vcsLogCommitSelection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
            int n = selectedCommits2 = vcsLogCommitSelection != null ? vcsLogCommitSelection.getSize() : 0;
            if (selectedCommits2 > 1) {
                String string2 = SpaceBundle.message("review.create.merge.request.action.description.error.multiple.selection", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                return new BranchData.ErrorDescription(string2);
            }
            List list2 = (List)e.getData(VcsLogDataKeys.VCS_LOG_BRANCHES);
            if (list2 == null) {
                return new BranchData.ErrorDescription("");
            }
            List vcsRefs = list2;
            Iterable $this$firstOrNull$iv = vcsRefs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VcsRef it = (VcsRef)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)"HEAD"))) continue;
                v4 = element$iv;
                break block6;
            }
            v4 = null;
        }
        VcsRef vcsRef = v4;
        if (vcsRef != null) {
            VcsRef it = vcsRef;
            boolean bl = false;
            GitRepository repository = (GitRepository)GitRepositoryManager.getInstance((Project)project2).getRepositoryForRootQuick(it.getRoot());
            GitRepository gitRepository = repository;
            v7 = gitRepository != null && (gitRepository = gitRepository.getBranches()) != null ? gitRepository.findBranchByName(it.getName()) : null;
        } else {
            v7 = branch2 = null;
        }
        if (branch2 != null) {
            return new BranchData.Branch(branch2);
        }
        String string3 = SpaceBundle.message("review.create.merge.request.action.description.error", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        return new BranchData.ErrorDescription(string3);
    }

    private static final boolean isCommitsSuitableForCodeReview(AnActionEvent e, SpaceProjectInfo projectInfo2) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return false;
        }
        Project project3 = project2;
        return SpaceCreateReviewActionsKt.findCommits(project3, e, projectInfo2, true) instanceof CommitsData.RepoAndCommits;
    }

    /*
     * WARNING - void declaration
     */
    private static final CommitsData findCommits(Project project2, AnActionEvent e, SpaceProjectInfo projectInfo2, boolean searchBranchesQuickly) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean allCommitsOnRemote;
        Iterable $this$all$iv;
        Map.Entry<SpaceRepoInfo, SpaceProjectInfo> spaceRepoInfo;
        Object destination$iv$iv;
        List commits2;
        block15: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object item$iv$iv2;
            void $this$mapTo$iv$iv2;
            VcsLogCommitSelection vcsLogCommitSelection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
            if (vcsLogCommitSelection == null) {
                return CommitsData.Empty.INSTANCE;
            }
            VcsLogCommitSelection selection2 = vcsLogCommitSelection;
            Object object = e.getData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
            VcsLogData vcsLogData = object instanceof VcsLogData ? (VcsLogData)object : null;
            if (vcsLogData == null) {
                return CommitsData.Empty.INSTANCE;
            }
            VcsLogData logDataProvider = vcsLogData;
            commits2 = selection2.getCachedMetadata();
            GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"getInstance(...)");
            GitRepositoryManager repositoryManager = gitRepositoryManager;
            Iterable $this$map$iv2 = commits2;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv2;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it.getRoot());
            }
            VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv2)));
            if (virtualFile == null) {
                return CommitsData.Empty.INSTANCE;
            }
            VirtualFile root2 = virtualFile;
            GitRepository gitRepository = (GitRepository)repositoryManager.getRepositoryForRootQuick(root2);
            if (gitRepository == null) {
                return CommitsData.Empty.INSTANCE;
            }
            GitRepository repository = gitRepository;
            Map<SpaceRepoInfo, SpaceProjectInfo> $i$f$map22 = SpaceProjectContext.Companion.findProjectMappings(project2, repository);
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            item$iv$iv2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (item$iv$iv2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = (Map.Entry)item$iv$iv2.next();
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getValue(), (Object)projectInfo2)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map.Entry<SpaceRepoInfo, SpaceProjectInfo> entry = SpaceProjectContextKt.firstMappingOrNull((Map<SpaceRepoInfo, SpaceProjectInfo>)destination$iv$iv);
            if (entry == null || (entry = entry.getKey()) == null) {
                return CommitsData.Empty.INSTANCE;
            }
            spaceRepoInfo = entry;
            Set<String> remoteBranches = SpaceCreateReviewActionsKt.allRemoteBranches(repository);
            $this$all$iv = commits2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v6 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Set commitBranches;
                    List list2;
                    VcsCommitMetadata commitData = (VcsCommitMetadata)element$iv;
                    boolean bl = false;
                    if (searchBranchesQuickly) {
                        Object object2 = commitData.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getId(...)");
                        list2 = GitCommitEditingActionBase.Companion.findContainingBranchesQuickly(logDataProvider, root2, (Hash)object2);
                        if (list2 == null) {
                            list2 = CollectionsKt.emptyList();
                        }
                    } else {
                        Object object3 = commitData.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getId(...)");
                        list2 = GitCommitEditingActionBase.Companion.findContainingBranches(logDataProvider, root2, (Hash)object3);
                    }
                    if (!((Collection)CollectionsKt.intersect((Iterable)(commitBranches = CollectionsKt.toSet((Iterable)list2)), (Iterable)remoteBranches)).isEmpty()) continue;
                    v6 = false;
                    break block15;
                }
                v6 = allCommitsOnRemote = true;
            }
        }
        if (!allCommitsOnRemote) {
            return CommitsData.Empty.INSTANCE;
        }
        $this$all$iv = commits2;
        Map.Entry<SpaceRepoInfo, SpaceProjectInfo> entry = spaceRepoInfo;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsCommitMetadata bl = (VcsCommitMetadata)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl2 = false;
            String string2 = ((Hash)it.getId()).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            collection.add(string2);
        }
        List list3 = (List)destination$iv$iv3;
        Map.Entry<SpaceRepoInfo, SpaceProjectInfo> entry2 = entry;
        return new CommitsData.RepoAndCommits((SpaceRepoInfo)((Object)entry2), list3);
    }

    static /* synthetic */ CommitsData findCommits$default(Project project2, AnActionEvent anActionEvent, SpaceProjectInfo spaceProjectInfo, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return SpaceCreateReviewActionsKt.findCommits(project2, anActionEvent, spaceProjectInfo, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> allRemoteBranches(GitRepository repository) {
        void $this$mapTo$iv$iv;
        Collection collection = repository.getBranches().getRemoteBranches();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRemoteBranches(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GitRemoteBranch gitRemoteBranch = (GitRemoteBranch)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getNameForLocalOperations());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public static final /* synthetic */ BranchData access$findBranch(Project project2, AnActionEvent e) {
        return SpaceCreateReviewActionsKt.findBranch(project2, e);
    }

    public static final /* synthetic */ void access$createMergeRequestAction(Project project2, AnActionEvent e, SpaceReviewToolWindowProjectViewModel projectVm2) {
        SpaceCreateReviewActionsKt.createMergeRequestAction(project2, e, projectVm2);
    }

    public static final /* synthetic */ boolean access$isCommitsSuitableForCodeReview(AnActionEvent e, SpaceProjectInfo projectInfo2) {
        return SpaceCreateReviewActionsKt.isCommitsSuitableForCodeReview(e, projectInfo2);
    }

    public static final /* synthetic */ void access$createCommitSetReview(Project project2, AnActionEvent e, SpaceReviewToolWindowProjectViewModel projectVm2) {
        SpaceCreateReviewActionsKt.createCommitSetReview(project2, e, projectVm2);
    }
}

