/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.share;

import circlet.client.api.PR_RepositoryInfo;
import circlet.client.api.RepoDetails;
import circlet.platform.client.KCircletClient;
import circlet.workspaces.Workspace;
import com.intellij.CommonBundle;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.space.actions.SpaceActionUtils;
import com.intellij.space.components.SpaceWorkspaceComponent;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.settings.CloneType;
import com.intellij.space.settings.SpaceLoginState;
import com.intellij.space.settings.SpaceSettings;
import com.intellij.space.stats.SpaceClientStats;
import com.intellij.space.stats.SpaceClientStatsKt;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.utils.SpaceUrls;
import com.intellij.space.vcs.SpaceProjectContext;
import com.intellij.space.vcs.share.SpaceShareProjectActionKt;
import com.intellij.space.vcs.share.SpaceShareProjectDialog;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import libraries.klogging.BaseLogger;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J4\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u001d\u001a\u00020\tH\u0002J8\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0002J@\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J:\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170&2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170*H\u0002J\"\u0010+\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010,\u001a\u0004\u0018\u00010\u00172\u0006\u0010-\u001a\u00020.H\u0002J \u0010/\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\t2\u0006\u00100\u001a\u00020\tH\u0002J\u0010\u00101\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u00062"}, d2={"Lcom/intellij/space/vcs/share/SpaceShareProjectAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "addRemoteUrl", "Lkotlin/Pair;", "", "repoDetails", "Lcirclet/client/api/RepoDetails;", "git", "Lgit4idea/commands/Git;", "gitRepo", "Lgit4idea/repo/GitRepository;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createEmptyGitRepository", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "createSpaceProject", "Lcom/intellij/space/vcs/share/SpaceShareProjectDialog$Result;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "notifyError", "message", "performFirstCommitIfRequired", "repository", "name", "url", "pushCurrentBranch", "remoteName", "remoteUrl", "selectFilesToCommit", "", "allFiles", "", "preselectedFiles", "", "shareProjectOnSpace", "file", "details", "Lcom/intellij/space/vcs/share/SpaceShareProjectDialog$Result$ProjectCreated;", "showInitialPushNotPerformedNotification", "repoName", "update", "intellij.space.vcs"})
@SourceDebugExtension(value={"SMAP\nSpaceShareProjectAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceShareProjectAction.kt\ncom/intellij/space/vcs/share/SpaceShareProjectAction\n+ 2 KLogger.kt\nlibraries/klogging/KLogger\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,349:1\n21#2,5:350\n35#2,5:355\n1603#3,9:360\n1855#3:369\n1856#3:371\n1612#3:372\n766#3:373\n857#3,2:374\n1#4:370\n*S KotlinDebug\n*F\n+ 1 SpaceShareProjectAction.kt\ncom/intellij/space/vcs/share/SpaceShareProjectAction\n*L\n198#1:350,5\n219#1:355,5\n244#1:360,9\n244#1:369\n244#1:371\n244#1:372\n245#1:373\n245#1:374,2\n244#1:370\n*E\n"})
final class SpaceShareProjectAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        SpaceActionUtils.INSTANCE.setSpaceIconIfNeeded(e);
        Project project2 = e.getProject();
        if (project2 == null || project2.isDefault() || !TrustedProjects.isTrusted((Project)project2)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        SpaceProjectContext context2 = SpaceProjectContext.Companion.getInstance(project2);
        if (context2.getCurrentContext().isAssociatedWithSpaceRepository()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRequiredData(...)");
        Project project2 = (Project)object;
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        SpaceWorkspaceComponent workspaceComponent = SpaceWorkspaceComponent.Companion.getInstance();
        SpaceStatsCounterCollector.LoginState loginState2 = SpaceStatsCounterCollector.LoginState.Companion.convert((SpaceLoginState)workspaceComponent.getAuthorizationState().getValue());
        Object object2 = (Workspace)workspaceComponent.getWorkspaceStateFlow().getValue();
        if (object2 != null && (object2 = object2.getClient()) != null) {
            SpaceClientStats.reportOpenShareProject-impl(SpaceClientStatsKt.getStats((KCircletClient)object2), loginState2);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        SpaceShareProjectDialog.Result creationResult = this.createSpaceProject(project2);
        if (creationResult instanceof SpaceShareProjectDialog.Result.ProjectCreated) {
            this.shareProjectOnSpace(project2, file2, (SpaceShareProjectDialog.Result.ProjectCreated)creationResult);
        } else if (Intrinsics.areEqual((Object)creationResult, (Object)SpaceShareProjectDialog.Result.NotCreated.INSTANCE)) {
            String string2 = SpaceBundle.message("share.project.error.notification.repository.not.created", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.notifyError(project2, string2);
        }
    }

    private final void shareProjectOnSpace(Project project2, VirtualFile file2, SpaceShareProjectDialog.Result.ProjectCreated details) {
        PR_RepositoryInfo repoInfo = details.component1();
        RepoDetails repoDetails = details.component2();
        String url2 = details.component3();
        String string2 = SpaceBundle.message("share.project.action.progress.title.sharing.title", new Object[0]);
        new Task.Backgroundable(project2, file2, this, repoDetails, repoInfo, url2, string2){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ SpaceShareProjectAction this$0;
            final /* synthetic */ RepoDetails $repoDetails;
            final /* synthetic */ PR_RepositoryInfo $repoInfo;
            final /* synthetic */ String $url;
            {
                this.$project = $project;
                this.$file = $file;
                this.this$0 = $receiver;
                this.$repoDetails = $repoDetails;
                this.$repoInfo = $repoInfo;
                this.$url = $url;
                super($project, $super_call_param$1);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText(SpaceBundle.message("share.project.action.progress.title.searching.repository.title", new Object[0]));
                Repository repository = this.$file != null ? VcsRepositoryManager.getInstance((Project)this.$project).getRepositoryForFile(this.$file, false) : VcsRepositoryManager.getInstance((Project)this.$project).getRepositoryForFile(this.$project.getBaseDir(), false);
                SpaceShareProjectActionKt.access$getLOG$p().info("Found repository: " + repository);
                Repository repository2 = repository;
                if ((repository2 == null || (repository2 = repository2.getRoot()) == null) && (repository2 = ProjectUtil.guessProjectDir((Project)this.$project)) == null) {
                    return;
                }
                Repository root2 = repository2;
                SpaceShareProjectActionKt.access$getLOG$p().info("Found project root: " + (VirtualFile)root2);
                if (repository == null) {
                    KLogger this_$iv = SpaceShareProjectActionKt.access$getLOG$p();
                    boolean $i$f$info = false;
                    if (this_$iv.isInfoEnabled()) {
                        boolean bl = false;
                        String msgStr$iv = "No git repo detected, creating empty git repository";
                        this_$iv.info(msgStr$iv);
                    }
                    if (!SpaceShareProjectAction.access$createEmptyGitRepository(this.this$0, this.$project, (VirtualFile)root2, indicator)) {
                        SpaceShareProjectActionKt.access$getLOG$p().error("Unable to init git repository");
                        return;
                    }
                }
                GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"getRepositoryManager(...)");
                GitRepositoryManager gitRepoManager = gitRepositoryManager;
                GitRepository gitRepository = (GitRepository)gitRepoManager.getRepositoryForRoot((VirtualFile)root2);
                if (gitRepository == null) {
                    throw new Exception("Can't find Git repository");
                }
                GitRepository gitRepo = gitRepository;
                Git git = Git.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)git, (String)"getInstance(...)");
                Git git2 = git;
                Pair pair = SpaceShareProjectAction.access$addRemoteUrl(this.this$0, this.$repoDetails, git2, gitRepo, indicator);
                String remoteUrl = (String)pair.component1();
                String remoteName = (String)pair.component2();
                String repoName = this.$repoInfo.getName();
                if (!SpaceShareProjectAction.access$performFirstCommitIfRequired(this.this$0, this.$project, (VirtualFile)root2, gitRepo, indicator, repoName, this.$url)) {
                    SpaceShareProjectActionKt.access$getLOG$p().info("Commit not finished");
                    return;
                }
                if (!SpaceShareProjectAction.access$pushCurrentBranch(this.this$0, this.$project, gitRepo, remoteName, remoteUrl, repoName, this.$url, indicator)) {
                    SpaceShareProjectActionKt.access$getLOG$p().info("Push not finished");
                    return;
                }
                VcsNotifier.getInstance((Project)this.$project).notifySuccess("space.project.shared.successfully", SpaceBundle.message("share.project.success.notification.title", new Object[0]), XmlStringUtil.formatLink((String)this.$url, (String)repoName), NotificationListener.URL_OPENING_LISTENER);
            }
        }.queue();
    }

    private final void showInitialPushNotPerformedNotification(Project project2, String url2, String repoName) {
        String string2 = SpaceBundle.message("share.project.error.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Object[] objectArray = new Object[]{XmlStringUtil.formatLink((String)url2, (String)repoName)};
        String string3 = SpaceBundle.message("share.project.error.notification.not.pushed.git.access", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(string2, string3, NotificationType.ERROR).setListener(NotificationListener.URL_OPENING_LISTENER).setDisplayId("space.sharing.not.finished");
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setDisplayId(...)");
        Notification notification2 = notification;
        Workspace workspace2 = SpaceWorkspaceComponent.Companion.getInstance().getWorkspace().getValue();
        if (workspace2 != null) {
            notification2.addAction((AnAction)NotificationAction.create((String)SpaceBundle.message("share.project.error.notification.action.configure.text", new Object[0]), arg_0 -> SpaceShareProjectAction.showInitialPushNotPerformedNotification$lambda$0(workspace2, arg_0)));
        }
        VcsNotifier.getInstance((Project)project2).notify(notification2);
    }

    private final SpaceShareProjectDialog.Result createSpaceProject(Project project2) {
        SpaceShareProjectActionKt.access$getLOG$p().info("Creating repository on Space");
        SpaceShareProjectDialog shareProjectDialog = new SpaceShareProjectDialog(project2);
        if (shareProjectDialog.showAndGet()) {
            SpaceShareProjectDialog.Result result2 = shareProjectDialog.getResult$intellij_space_vcs();
            if (result2 == null) {
                SpaceShareProjectActionKt.access$getLOG$p().info("Repository not created");
                return SpaceShareProjectDialog.Result.NotCreated.INSTANCE;
            }
            SpaceShareProjectActionKt.access$getLOG$p().info("Repository created successfully: " + result2);
            return result2;
        }
        return SpaceShareProjectDialog.Result.Canceled.INSTANCE;
    }

    private final boolean createEmptyGitRepository(Project project2, VirtualFile root2, ProgressIndicator indicator) {
        indicator.setText(SpaceBundle.message("share.project.action.progress.title.initializing.repository.title", new Object[0]));
        GitCommandResult gitCommandResult = Git.getInstance().init(project2, root2, new GitLineHandlerListener[0]);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"init(...)");
        GitCommandResult result2 = gitCommandResult;
        if (!result2.success()) {
            VcsNotifier.getInstance((Project)project2).notifyError("space.git.repo.init.error", GitBundle.message((String)"initializing.title", (Object[])new Object[0]), result2.getErrorOutputAsHtmlString());
            KLogger this_$iv = SpaceShareProjectActionKt.access$getLOG$p();
            boolean $i$f$info = false;
            if (this_$iv.isInfoEnabled()) {
                boolean bl = false;
                String msgStr$iv = "Failed to create empty git repo: " + result2.getErrorOutputAsJoinedString();
                this_$iv.info(msgStr$iv);
            }
            return false;
        }
        GitInit.refreshAndConfigureVcsMappings((Project)project2, (VirtualFile)root2, (String)root2.getPath());
        GitUtil.generateGitignoreFileIfNeeded((Project)project2, (VirtualFile)root2);
        return true;
    }

    private final Pair<String, String> addRemoteUrl(RepoDetails repoDetails, Git git, GitRepository gitRepo, ProgressIndicator indicator) {
        String string2 = switch (WhenMappings.$EnumSwitchMapping$0[SpaceSettings.Companion.getInstance().getCloneType().ordinal()]) {
            case 1 -> repoDetails.getUrls().getHttpUrl();
            case 2 -> repoDetails.getUrls().getSshUrl();
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String remoteUrl = string2;
        String remoteName = "space";
        indicator.setText(SpaceBundle.message("share.project.action.progress.title.adding.remote.title", new Object[0]));
        GitCommandResult gitCommandResult = git.addRemote(gitRepo, remoteName, remoteUrl);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"addRemote(...)");
        GitCommandResult commandResult = gitCommandResult;
        if (commandResult.success()) {
            gitRepo.update();
        } else {
            KLogger this_$iv = SpaceShareProjectActionKt.access$getLOG$p();
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                String msgStr$iv = commandResult.getErrorOutputAsJoinedString();
                this_$iv.error(msgStr$iv);
            }
        }
        return new Pair((Object)remoteUrl, (Object)remoteName);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean performFirstCommitIfRequired(Project project2, VirtualFile root2, GitRepository repository, ProgressIndicator indicator, String name2, String url2) {
        if (!repository.isFresh()) {
            return true;
        }
        try {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            SpaceShareProjectActionKt.access$getLOG$p().info("Adding files for commit");
            indicator.setText(SpaceBundle.message("share.project.action.progress.title.adding.files.title", new Object[0]));
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
            Collection collection = repository.getUntrackedFilesHolder().retrieveUntrackedFilePaths();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"retrieveUntrackedFilePaths(...)");
            Iterable iterable = collection;
            boolean $i$f$mapNotNull = false;
            void var12_16 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            String[] stringArray = $this$forEach$iv$iv$iv.iterator();
            while (stringArray.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = stringArray.next();
                boolean bl = false;
                FilePath p0 = (FilePath)element$iv$iv;
                boolean bl2 = false;
                if (p0.getVirtualFile() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile file2 = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!(!vcsManager.isIgnored(file2) && !changeListManager2.isIgnoredFile(file2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List untrackedFiles = (List)destination$iv$iv;
            List list2 = changeListManager2.getAffectedFiles();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAffectedFiles(...)");
            List trackedFiles = list2;
            trackedFiles.removeAll(untrackedFiles);
            List allFiles = CollectionsKt.plus((Collection)trackedFiles, (Iterable)untrackedFiles);
            Collection<VirtualFile> filesToCommit = this.selectFilesToCommit(project2, indicator, allFiles, trackedFiles);
            if (filesToCommit.isEmpty()) {
                return false;
            }
            Collection collection2 = ContainerUtil.intersection((Collection)untrackedFiles, filesToCommit);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"intersection(...)");
            Collection filesToAdd = collection2;
            Collection collection3 = ContainerUtil.subtract((Collection)trackedFiles, filesToCommit);
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"subtract(...)");
            Collection filesToDelete = collection3;
            HashSet affectedFiles = new HashSet(CollectionsKt.plus((Collection)trackedFiles, (Iterable)filesToCommit));
            GitFileUtils.addFiles((Project)project2, (VirtualFile)root2, (Collection)filesToAdd);
            GitFileUtils.deleteFilesFromCache((Project)project2, (VirtualFile)root2, (Collection)filesToDelete);
            SpaceShareProjectActionKt.access$getLOG$p().info("Performing commit");
            indicator.setText(SpaceBundle.message("share.project.action.progress.title.committing.title", new Object[0]));
            GitLineHandler handler = new GitLineHandler(project2, root2, GitCommand.COMMIT);
            handler.setStdoutSuppressed(false);
            stringArray = new String[]{"-m", "Initial commit"};
            handler.addParameters(stringArray);
            handler.endOptions();
            Git.getInstance().runCommand(handler).throwOnError(new int[0]);
            VcsFileUtil.markFilesDirty((Project)project2, (Collection)affectedFiles);
        }
        catch (VcsException e) {
            BaseLogger.DefaultImpls.warn$default(SpaceShareProjectActionKt.access$getLOG$p(), e, null, 2, null);
            String string2 = XmlStringUtil.formatLink((String)url2, (String)("'" + name2 + "'"));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatLink(...)");
            String repositoryLink = string2;
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            Object[] objectArray = new Object[]{repositoryLink};
            spreadBuilder.add((Object)SpaceBundle.message("share.project.error.notification.initial.commit.failed.message", objectArray));
            spreadBuilder.addSpread((Object)e.getMessages());
            String string3 = XmlStringUtil.wrapInHtmlLines((CharSequence[])((CharSequence[])spreadBuilder.toArray((Object[])new CharSequence[spreadBuilder.size()])));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"wrapInHtmlLines(...)");
            this.notifyError(project2, string3);
            return false;
        }
        SpaceShareProjectActionKt.access$getLOG$p().info("Successfully created initial commit");
        return true;
    }

    private final Collection<VirtualFile> selectFilesToCommit(Project project2, ProgressIndicator indicator, List<? extends VirtualFile> allFiles, List<VirtualFile> preselectedFiles) {
        SelectFilesDialog dialog2 = (SelectFilesDialog)ActionsKt.invokeAndWaitIfNeeded((ModalityState)indicator.getModalityState(), (Function0)((Function0)new Function0<SelectFilesDialog>(project2, allFiles, preselectedFiles){
            final /* synthetic */ Project $project;
            final /* synthetic */ List<VirtualFile> $allFiles;
            final /* synthetic */ List<VirtualFile> $preselectedFiles;
            {
                this.$project = $project;
                this.$allFiles = $allFiles;
                this.$preselectedFiles = $preselectedFiles;
                super(0);
            }

            @NotNull
            public final SelectFilesDialog invoke() {
                SelectFilesDialog selectFilesDialog = SelectFilesDialog.init((Project)this.$project, this.$allFiles, null, null, (boolean)true, (boolean)false, (String)CommonBundle.getAddButtonText(), (String)CommonBundle.getCancelButtonText());
                Intrinsics.checkNotNullExpressionValue((Object)selectFilesDialog, (String)"init(...)");
                SelectFilesDialog selectFilesDialog2 = selectFilesDialog;
                selectFilesDialog2.setTitle(SpaceBundle.message("share.project.action.progress.title.adding.files.to.commit.title", new Object[0]));
                if (!((Collection)this.$preselectedFiles).isEmpty()) {
                    selectFilesDialog2.setSelectedFiles((Collection)this.$preselectedFiles);
                }
                selectFilesDialog2.showAndGet();
                return selectFilesDialog2;
            }
        }));
        if (!dialog2.isOK()) {
            return CollectionsKt.emptyList();
        }
        Collection collection = dialog2.getSelectedFiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSelectedFiles(...)");
        return collection;
    }

    private final boolean pushCurrentBranch(Project project2, GitRepository repository, String remoteName, String remoteUrl, String name2, String url2, ProgressIndicator indicator) {
        SpaceShareProjectActionKt.access$getLOG$p().info("Pushing to master");
        indicator.setText(SpaceBundle.message("share.project.action.progress.title.pushing.title", new Object[0]));
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        String string2 = XmlStringUtil.formatLink((String)url2, (String)("'" + name2 + "'"));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatLink(...)");
        String repositoryLink = string2;
        if (currentBranch == null) {
            Object[] objectArray = new Object[]{repositoryLink};
            String string3 = SpaceBundle.message("share.project.error.notification.no.current.branch.message", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            this.notifyError(project2, string3);
            return false;
        }
        Git git = Git.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)git, (String)"getInstance(...)");
        Git git2 = git;
        GitCommandResult gitCommandResult = git2.push(repository, remoteName, remoteUrl, currentBranch.getName(), true, new GitLineHandlerListener[0]);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"push(...)");
        GitCommandResult result2 = gitCommandResult;
        if (!result2.success()) {
            if (result2.getExitCode() == 128) {
                SpaceShareProjectActionKt.access$getLOG$p().info("Couldn't push shared project. Git output: " + result2.getErrorOutputAsHtmlString());
                this.showInitialPushNotPerformedNotification(project2, url2, name2);
                return false;
            }
            CharSequence[] charSequenceArray = new CharSequence[2];
            Object[] objectArray = new Object[]{repositoryLink};
            charSequenceArray[0] = SpaceBundle.message("share.project.error.notification.push.failed.message", objectArray);
            charSequenceArray[1] = result2.getErrorOutputAsHtmlString();
            String string4 = XmlStringUtil.wrapInHtmlLines((CharSequence[])charSequenceArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"wrapInHtmlLines(...)");
            this.notifyError(project2, string4);
            return false;
        }
        return true;
    }

    private final void notifyError(Project project2, @NlsContexts.NotificationContent String message2) {
        VcsNotifier.getInstance((Project)project2).notifyError("space.sharing.not.finished", SpaceBundle.message("share.project.error.notification.title", new Object[0]), message2, NotificationListener.URL_OPENING_LISTENER);
    }

    private static final void showInitialPushNotPerformedNotification$lambda$0(Workspace $workspace, AnActionEvent it) {
        String gitAccessConfigurationPageUrl = SpaceUrls.INSTANCE.git($workspace.getMe().getValue().getUsername());
        BrowserUtil.browse((String)gitAccessConfigurationPageUrl);
    }

    public static final /* synthetic */ boolean access$createEmptyGitRepository(SpaceShareProjectAction $this, Project project2, VirtualFile root2, ProgressIndicator indicator) {
        return $this.createEmptyGitRepository(project2, root2, indicator);
    }

    public static final /* synthetic */ Pair access$addRemoteUrl(SpaceShareProjectAction $this, RepoDetails repoDetails, Git git, GitRepository gitRepo, ProgressIndicator indicator) {
        return $this.addRemoteUrl(repoDetails, git, gitRepo, indicator);
    }

    public static final /* synthetic */ boolean access$performFirstCommitIfRequired(SpaceShareProjectAction $this, Project project2, VirtualFile root2, GitRepository repository, ProgressIndicator indicator, String name2, String url2) {
        return $this.performFirstCommitIfRequired(project2, root2, repository, indicator, name2, url2);
    }

    public static final /* synthetic */ boolean access$pushCurrentBranch(SpaceShareProjectAction $this, Project project2, GitRepository repository, String remoteName, String remoteUrl, String name2, String url2, ProgressIndicator indicator) {
        return $this.pushCurrentBranch(project2, repository, remoteName, remoteUrl, name2, url2, indicator);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CloneType.values().length];
            try {
                nArray[CloneType.HTTPS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloneType.SSH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

