/*
 * Decompiled with CFR 0.152.
 */
package libraries.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import libraries.io.PrefixSize;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0010\u001a.\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u0014*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u001a\u0014\u0010\u0018\u001a\u00020\u0010*\u00020\u00012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u001a \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u0014*\u00020\u00012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"GB", "", "GiB", "KB", "KiB", "MB", "MiB", "PB", "PiB", "TB", "TiB", "binaryUnits", "", "Llibraries/io/PrefixSize;", "decimalUnits", "prefixes", "", "parseDataSize", "fileSizeStr", "roundWithPrefix", "Lkotlin/Pair;", "", "startingPrefix", "prefixSizes", "toDataSize", "binaryPrefix", "", "toDataSizeWithUnit", "libraries-io"})
@SourceDebugExtension(value={"SMAP\ndataSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dataSize.kt\nlibraries/io/DataSizeKt\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n107#2:113\n79#2,22:114\n1549#3:136\n1620#3,3:137\n1549#3:140\n1620#3,3:141\n*S KotlinDebug\n*F\n+ 1 dataSize.kt\nlibraries/io/DataSizeKt\n*L\n72#1:113\n72#1:114,22\n24#1:136\n24#1:137,3\n25#1:140\n25#1:141,3\n*E\n"})
public final class DataSizeKt {
    public static final long KB = 1000L;
    public static final long MB = 1000000L;
    public static final long GB = 1000000000L;
    public static final long TB = 1000000000000L;
    public static final long PB = 1000000000000000L;
    public static final long KiB = 1024L;
    public static final long MiB = 0x100000L;
    public static final long GiB = 0x40000000L;
    public static final long TiB = 0x10000000000L;
    public static final long PiB = 0x4000000000000L;
    @NotNull
    private static final List<String> prefixes;
    @NotNull
    private static final List<PrefixSize> decimalUnits;
    @NotNull
    private static final List<PrefixSize> binaryUnits;

    @NotNull
    public static final String toDataSize(long $this$toDataSize, boolean binaryPrefix) {
        Pair<Number, String> pair = DataSizeKt.roundWithPrefix($this$toDataSize, "B", binaryPrefix ? binaryUnits : decimalUnits);
        Number number2 = (Number)pair.component1();
        String prefix = (String)pair.component2();
        return number2 + " " + prefix;
    }

    public static /* synthetic */ String toDataSize$default(long l, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return DataSizeKt.toDataSize(l, bl);
    }

    private static final Pair<Number, String> roundWithPrefix(long $this$roundWithPrefix, String startingPrefix, List<PrefixSize> prefixSizes) {
        Number number2;
        double number3;
        long totalSize = 1L;
        String currentPrefix = startingPrefix;
        for (PrefixSize prefixSize : prefixSizes) {
            int size2 = prefixSize.component1();
            String prefix = prefixSize.component2();
            if (MathKt.roundToInt((double)((double)$this$roundWithPrefix / (double)totalSize)) < size2) break;
            totalSize *= (long)size2;
            currentPrefix = prefix;
        }
        if ((number3 = (double)$this$roundWithPrefix / (double)totalSize) < 100.0) {
            int elevated = MathKt.roundToInt((double)(number3 * (double)10));
            int rounded = elevated / 10;
            int digit = elevated % 10;
            number2 = digit == 0 ? (Number)rounded : (Number)((double)rounded + (double)digit / (double)10);
        } else {
            number2 = MathKt.roundToInt((double)number3);
        }
        Integer roundedNumber = number2;
        return TuplesKt.to((Object)roundedNumber, (Object)currentPrefix);
    }

    @NotNull
    public static final Pair<Number, String> toDataSizeWithUnit(long $this$toDataSizeWithUnit, boolean binaryPrefix) {
        return DataSizeKt.roundWithPrefix($this$toDataSizeWithUnit, "B", binaryPrefix ? binaryUnits : decimalUnits);
    }

    public static /* synthetic */ Pair toDataSizeWithUnit$default(long l, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return DataSizeKt.toDataSizeWithUnit(l, bl);
    }

    public static final long parseDataSize(@NotNull String fileSizeStr) {
        Intrinsics.checkNotNullParameter((Object)fileSizeStr, (String)"fileSizeStr");
        String $this$trim$iv = StringsKt.replace$default((String)fileSizeStr, (String)" ", (String)"", (boolean)false, (int)4, null);
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String value2 = string2;
        if (new Regex("\\d*\\.?\\d+b").matches((CharSequence)value2)) {
            String string3 = value2.substring(0, value2.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return DataSizeKt.parseDataSize(string3);
        }
        if (new Regex("\\d*\\.?\\d+kb").matches((CharSequence)value2)) {
            String string4 = value2.substring(0, value2.length() - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return DataSizeKt.parseDataSize(string4) * 1000L;
        }
        if (new Regex("\\d*\\.?\\d+mb").matches((CharSequence)value2)) {
            String string5 = value2.substring(0, value2.length() - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return DataSizeKt.parseDataSize(string5) * 1000000L;
        }
        if (new Regex("\\d*\\.?\\d+gb").matches((CharSequence)value2)) {
            String string6 = value2.substring(0, value2.length() - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return DataSizeKt.parseDataSize(string6) * 1000000000L;
        }
        if (new Regex("\\d*\\.?\\d+tb").matches((CharSequence)value2)) {
            String string7 = value2.substring(0, value2.length() - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return DataSizeKt.parseDataSize(string7) * 1000000000000L;
        }
        if (new Regex("\\d*\\.?\\d+pb").matches((CharSequence)value2)) {
            String string8 = value2.substring(0, value2.length() - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return DataSizeKt.parseDataSize(string8) * 1000000000000000L;
        }
        if (new Regex("\\d*\\.?\\d+kib").matches((CharSequence)value2)) {
            String string9 = value2.substring(0, value2.length() - 3);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return DataSizeKt.parseDataSize(string9) * 1024L;
        }
        if (new Regex("\\d*\\.?\\d+mib").matches((CharSequence)value2)) {
            String string10 = value2.substring(0, value2.length() - 3);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return DataSizeKt.parseDataSize(string10) * 0x100000L;
        }
        if (new Regex("\\d*\\.?\\d+gib").matches((CharSequence)value2)) {
            String string11 = value2.substring(0, value2.length() - 3);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return DataSizeKt.parseDataSize(string11) * 0x40000000L;
        }
        if (new Regex("\\d*\\.?\\d+tib").matches((CharSequence)value2)) {
            String string12 = value2.substring(0, value2.length() - 3);
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return DataSizeKt.parseDataSize(string12) * 0x10000000000L;
        }
        if (new Regex("\\d*\\.?\\d+pib").matches((CharSequence)value2)) {
            String string13 = value2.substring(0, value2.length() - 3);
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return DataSizeKt.parseDataSize(string13) * 0x4000000000000L;
        }
        return MathKt.roundToLong((double)Double.parseDouble(fileSizeStr));
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object[] objectArray = new String[]{"K", "M", "G", "T", "P"};
        prefixes = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$map$iv = prefixes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PrefixSize(1000, it + "B"));
        }
        decimalUnits = (List)destination$iv$iv;
        $this$map$iv = prefixes;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PrefixSize(1024, it + "iB"));
        }
        binaryUnits = (List)var3_3;
    }
}

