/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.channels;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicBoolean;
import kotlinx.atomicfu.AtomicFU;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Llibraries/io/channels/BufferedReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "delegate", "byteBuffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/channels/ReadableByteChannel;Ljava/nio/ByteBuffer;)V", "bufferArray", "", "bufferRead", "Lkotlinx/atomicfu/AtomicBoolean;", "close", "", "isOpen", "", "read", "", "dst", "libraries-io"})
public final class BufferedReadableByteChannel
implements ReadableByteChannel {
    @NotNull
    private final ReadableByteChannel delegate;
    @NotNull
    private final ByteBuffer byteBuffer;
    @NotNull
    private final AtomicBoolean bufferRead;
    @NotNull
    private final byte[] bufferArray;

    public BufferedReadableByteChannel(@NotNull ReadableByteChannel delegate2, @NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        this.delegate = delegate2;
        this.byteBuffer = byteBuffer;
        int readBytes = this.delegate.read(this.byteBuffer);
        this.bufferArray = new byte[Math.max(readBytes, 0)];
        this.byteBuffer.flip();
        this.byteBuffer.get(this.bufferArray);
        this.bufferRead = AtomicFU.atomic((this.bufferArray.length == 0 ? 1 : 0) != 0);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean isOpen() {
        return !this.bufferRead.getValue() || this.delegate.isOpen();
    }

    @Override
    public int read(@NotNull ByteBuffer dst) {
        int n;
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (this.bufferRead.compareAndSet(false, true)) {
            dst.put(this.bufferArray);
            n = this.bufferArray.length;
        } else {
            n = this.delegate.read(dst);
        }
        return n;
    }
}

