/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.random;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import libraries.io.random.SecureRandom;
import libraries.io.random.UID;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Llibraries/io/random/RandomProvider;", "", "()V", "len", "", "radix", "nextBytes", "", "nextDouble", "", "nextInt", "bound", "nextLong", "", "nextUID", "Llibraries/io/random/UID;", "libraries-io"})
@SourceDebugExtension(value={"SMAP\nRandomProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RandomProvider.kt\nlibraries/io/random/RandomProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class RandomProvider {
    @NotNull
    public static final RandomProvider INSTANCE = new RandomProvider();
    private static final int len = 10;
    private static final int radix = 36;

    private RandomProvider() {
    }

    @NotNull
    public final UID nextUID() {
        String string2 = new BigInteger(128, SecureRandom.INSTANCE.getRnd$libraries_io().get()).toString(36);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return new UID(StringsKt.take((String)string2, (int)10));
    }

    @NotNull
    public final byte[] nextBytes(int len) {
        byte[] byArray;
        byte[] $this$nextBytes_u24lambda_u240 = byArray = new byte[len];
        boolean bl = false;
        SecureRandom.INSTANCE.getRnd$libraries_io().get().nextBytes($this$nextBytes_u24lambda_u240);
        return byArray;
    }

    public final long nextLong() {
        long l = SecureRandom.INSTANCE.getRnd$libraries_io().get().nextLong();
        if (l == 0L || l == Long.MIN_VALUE) {
            long l2 = l;
            l = l2 + 1L;
        }
        return l < 0L ? -l : l;
    }

    public final int nextInt(int bound2) {
        return SecureRandom.INSTANCE.getRnd$libraries_io().get().nextInt(bound2);
    }

    public final double nextDouble() {
        return SecureRandom.INSTANCE.getRnd$libraries_io().get().nextDouble();
    }
}

