/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.cli;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.cli.CommandLine;
import org.apache.ivy.util.cli.Option;
import org.apache.ivy.util.cli.ParseException;

public class CommandLineParser {
    private static final int MIN_DESC_WIDTH = 40;
    private static final int MAX_SPEC_WIDTH = 30;
    private Map<String, Option> options = new LinkedHashMap<String, Option>();
    private Map<String, List<Option>> categories = new LinkedHashMap<String, List<Option>>();

    public CommandLineParser addCategory(String category) {
        this.categories.put(category, new ArrayList());
        return this;
    }

    public CommandLineParser addOption(Option option) {
        this.options.put(option.getName(), option);
        if (!this.categories.isEmpty()) {
            new LinkedList<List<Option>>(this.categories.values()).getLast().add(option);
        }
        return this;
    }

    public CommandLine parse(String[] args) throws ParseException {
        CommandLine line2 = new CommandLine();
        int index2 = args.length;
        ListIterator<String> iterator2 = Arrays.asList(args).listIterator();
        while (iterator2.hasNext()) {
            String arg = iterator2.next();
            if ("--".equals(arg)) {
                index2 = iterator2.nextIndex();
                break;
            }
            if (!arg.startsWith("-")) {
                index2 = iterator2.previousIndex();
                break;
            }
            Option option = this.options.get(arg.substring(1));
            if (option == null) {
                throw new ParseException("Unrecognized option: " + arg);
            }
            line2.addOptionValues(arg.substring(1), option.parse(iterator2));
        }
        String[] leftOverArgs = new String[args.length - index2];
        System.arraycopy(args, index2, leftOverArgs, 0, leftOverArgs.length);
        line2.setLeftOverArgs(leftOverArgs);
        return line2;
    }

    public void printHelp(PrintWriter pw, int width, String command, boolean showDeprecated) {
        pw.println("usage: " + command);
        int specWidth = 0;
        for (Option option : this.options.values()) {
            if (option.isDeprecated() && !showDeprecated) continue;
            specWidth = Math.min(30, Math.max(specWidth, option.getSpec().length()));
        }
        for (Map.Entry entry : this.categories.entrySet()) {
            pw.println("==== " + (String)entry.getKey());
            for (Option option : (List)entry.getValue()) {
                if (option.isDeprecated() && !showDeprecated) continue;
                String spec = option.getSpec();
                pw.print(" " + spec);
                int specLength = spec.length() + 1;
                pw.print(StringUtils.repeat(" ", specWidth - specLength));
                StringBuilder desc = new StringBuilder((option.isDeprecated() ? "DEPRECATED: " : "") + option.getDescription());
                int count2 = Math.min(desc.length(), width - Math.max(specLength, specWidth));
                if (count2 > 40 || desc.length() + specLength < width) {
                    pw.print(desc.substring(0, count2));
                    desc.delete(0, count2);
                }
                pw.println();
                while (desc.length() > 0) {
                    pw.print(StringUtils.repeat(" ", specWidth));
                    count2 = Math.min(desc.length(), width - specWidth);
                    pw.println(desc.substring(0, count2));
                    desc.delete(0, count2);
                }
            }
            pw.println();
        }
    }
}

