/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.ivy.core.settings.TimeoutConstraint;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.HostUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.AbstractURLHandler;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.TimeoutConstrainedURLHandler;
import org.apache.ivy.util.url.URLHandler;

public class HttpClientHandler
extends AbstractURLHandler
implements TimeoutConstrainedURLHandler,
AutoCloseable {
    private static final SimpleDateFormat LAST_MODIFIED_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
    static final HttpClientHandler DELETE_ON_EXIT_INSTANCE = new HttpClientHandler();
    private final CloseableHttpClient httpClient = this.buildUnderlyingClient();

    private CloseableHttpClient buildUnderlyingClient() {
        return HttpClients.custom().setConnectionManager(HttpClientHandler.createConnectionManager()).setRoutePlanner(HttpClientHandler.createProxyRoutePlanner()).setUserAgent(this.getUserAgent()).setDefaultAuthSchemeRegistry(HttpClientHandler.createAuthSchemeRegistry()).setDefaultCredentialsProvider((CredentialsProvider)new IvyCredentialsProvider()).build();
    }

    private static HttpRoutePlanner createProxyRoutePlanner() {
        Message.verbose("Using JRE standard ProxySelector for configuring HTTP proxy");
        return new SystemDefaultRoutePlanner(ProxySelector.getDefault());
    }

    private static Lookup<AuthSchemeProvider> createAuthSchemeRegistry() {
        return RegistryBuilder.create().register("Digest", (Object)new DigestSchemeFactory()).register("Basic", (Object)new BasicSchemeFactory()).register("NTLM", (Object)new NTLMSchemeFactory()).build();
    }

    private static HttpClientConnectionManager createConnectionManager() {
        return new PoolingHttpClientConnectionManager();
    }

    private static List<String> getAuthSchemePreferredOrder() {
        return Arrays.asList("Digest", "Basic", "NTLM");
    }

    @Override
    public InputStream openStream(URL url2) throws IOException {
        return this.openStream(url2, null);
    }

    @Override
    public InputStream openStream(URL url2, TimeoutConstraint timeoutConstraint) throws IOException {
        int connectionTimeout = timeoutConstraint == null || timeoutConstraint.getConnectionTimeout() < 0 ? 0 : timeoutConstraint.getConnectionTimeout();
        int readTimeout = timeoutConstraint == null || timeoutConstraint.getReadTimeout() < 0 ? 0 : timeoutConstraint.getReadTimeout();
        CloseableHttpResponse response2 = this.doGet(url2, connectionTimeout, readTimeout);
        this.requireSuccessStatus("GET", url2, response2);
        Header encoding = this.getContentEncoding((HttpResponse)response2);
        return this.getDecodingInputStream(encoding == null ? null : encoding.getValue(), response2.getEntity().getContent());
    }

    @Override
    public void download(URL src, File dest, CopyProgressListener l) throws IOException {
        this.download(src, dest, l, null);
    }

    @Override
    public void download(URL src, File dest, CopyProgressListener listener2, TimeoutConstraint timeoutConstraint) throws IOException {
        int connectionTimeout = timeoutConstraint == null || timeoutConstraint.getConnectionTimeout() < 0 ? 0 : timeoutConstraint.getConnectionTimeout();
        int readTimeout = timeoutConstraint == null || timeoutConstraint.getReadTimeout() < 0 ? 0 : timeoutConstraint.getReadTimeout();
        try (CloseableHttpResponse response2 = this.doGet(src, connectionTimeout, readTimeout);){
            this.requireSuccessStatus("GET", src, response2);
            Header encoding = this.getContentEncoding((HttpResponse)response2);
            try (InputStream is = this.getDecodingInputStream(encoding == null ? null : encoding.getValue(), response2.getEntity().getContent());){
                FileUtil.copy(is, dest, listener2);
            }
            dest.setLastModified(this.getLastModified((HttpResponse)response2));
        }
    }

    @Override
    public void upload(File src, URL dest, CopyProgressListener l) throws IOException {
        this.upload(src, dest, l, null);
    }

    @Override
    public void upload(File src, URL dest, CopyProgressListener listener2, TimeoutConstraint timeoutConstraint) throws IOException {
        int connectionTimeout = timeoutConstraint == null || timeoutConstraint.getConnectionTimeout() < 0 ? 0 : timeoutConstraint.getConnectionTimeout();
        int readTimeout = timeoutConstraint == null || timeoutConstraint.getReadTimeout() < 0 ? 0 : timeoutConstraint.getReadTimeout();
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectionTimeout).setAuthenticationEnabled(this.hasCredentialsConfigured(dest)).setTargetPreferredAuthSchemes(HttpClientHandler.getAuthSchemePreferredOrder()).setProxyPreferredAuthSchemes(HttpClientHandler.getAuthSchemePreferredOrder()).setExpectContinueEnabled(true).build();
        HttpPut put2 = new HttpPut(this.normalizeToString(dest));
        put2.setConfig(requestConfig);
        put2.setEntity((HttpEntity)new FileEntity(src));
        try (CloseableHttpResponse response2 = this.httpClient.execute((HttpUriRequest)put2);){
            this.validatePutStatusCode(dest, response2.getStatusLine().getStatusCode(), response2.getStatusLine().getReasonPhrase());
        }
    }

    @Override
    public URLHandler.URLInfo getURLInfo(URL url2) {
        return this.getURLInfo(url2, null);
    }

    @Override
    public URLHandler.URLInfo getURLInfo(URL url2, int timeout) {
        return this.getURLInfo(url2, HttpClientHandler.createTimeoutConstraints(timeout));
    }

    @Override
    public boolean isReachable(URL url2, TimeoutConstraint timeoutConstraint) {
        return this.getURLInfo(url2, timeoutConstraint).isReachable();
    }

    @Override
    public long getContentLength(URL url2, TimeoutConstraint timeoutConstraint) {
        return this.getURLInfo(url2, timeoutConstraint).getContentLength();
    }

    @Override
    public long getLastModified(URL url2, TimeoutConstraint timeoutConstraint) {
        return this.getURLInfo(url2, timeoutConstraint).getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URLHandler.URLInfo getURLInfo(URL url2, TimeoutConstraint timeoutConstraint) {
        int connectionTimeout = timeoutConstraint == null || timeoutConstraint.getConnectionTimeout() < 0 ? 0 : timeoutConstraint.getConnectionTimeout();
        int readTimeout = timeoutConstraint == null || timeoutConstraint.getReadTimeout() < 0 ? 0 : timeoutConstraint.getReadTimeout();
        CloseableHttpResponse response2 = null;
        try {
            String httpMethod;
            if (this.getRequestMethod() == 2) {
                httpMethod = "HEAD";
                response2 = this.doHead(url2, connectionTimeout, readTimeout);
            } else {
                httpMethod = "GET";
                response2 = this.doGet(url2, connectionTimeout, readTimeout);
            }
            if (this.checkStatusCode(httpMethod, url2, (HttpResponse)response2)) {
                HttpEntity responseEntity = response2.getEntity();
                Charset charSet = ContentType.getOrDefault((HttpEntity)responseEntity).getCharset();
                URLHandler.URLInfo uRLInfo = new URLHandler.URLInfo(true, responseEntity == null ? 0L : responseEntity.getContentLength(), this.getLastModified((HttpResponse)response2), charSet.name());
                return uRLInfo;
            }
        }
        catch (IOException | IllegalArgumentException e) {
            Message.error("HttpClientHandler: " + e.getMessage() + " url=" + url2);
        }
        finally {
            if (response2 != null) {
                try {
                    response2.close();
                }
                catch (IOException iOException) {}
            }
        }
        return UNAVAILABLE;
    }

    private boolean checkStatusCode(String httpMethod, URL sourceURL, HttpResponse response2) {
        int status2 = response2.getStatusLine().getStatusCode();
        if (status2 == 200) {
            return true;
        }
        if ("HEAD".equals(httpMethod) && status2 == 204) {
            return true;
        }
        Message.debug("HTTP response status: " + status2 + " url=" + sourceURL);
        if (status2 == 407) {
            Message.warn("Your proxy requires authentication.");
        } else if (String.valueOf(status2).startsWith("4")) {
            Message.verbose("CLIENT ERROR: " + response2.getStatusLine().getReasonPhrase() + " url=" + sourceURL);
        } else if (String.valueOf(status2).startsWith("5")) {
            Message.error("SERVER ERROR: " + response2.getStatusLine().getReasonPhrase() + " url=" + sourceURL);
        }
        return false;
    }

    private void requireSuccessStatus(String httpMethod, URL sourceURL, CloseableHttpResponse response2) throws IOException {
        if (this.checkStatusCode(httpMethod, sourceURL, (HttpResponse)response2)) {
            return;
        }
        try {
            response2.close();
        }
        catch (Exception e) {
            Message.debug("Could not close the HTTP response for url=" + sourceURL, e);
        }
        throw new IOException("Failed response to request '" + httpMethod + " " + sourceURL + "' " + response2.getStatusLine().getStatusCode() + " - '" + response2.getStatusLine().getReasonPhrase());
    }

    private Header getContentEncoding(HttpResponse response2) {
        return response2.getFirstHeader("Content-Encoding");
    }

    private long getLastModified(HttpResponse response2) {
        Header header2 = response2.getFirstHeader("last-modified");
        if (header2 == null) {
            return System.currentTimeMillis();
        }
        String lastModified = header2.getValue();
        try {
            return LAST_MODIFIED_FORMAT.parse(lastModified).getTime();
        }
        catch (ParseException parseException) {
            return System.currentTimeMillis();
        }
    }

    private CloseableHttpResponse doGet(URL url2, int connectionTimeout, int readTimeout) throws IOException {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectionTimeout).setAuthenticationEnabled(this.hasCredentialsConfigured(url2)).setTargetPreferredAuthSchemes(HttpClientHandler.getAuthSchemePreferredOrder()).setProxyPreferredAuthSchemes(HttpClientHandler.getAuthSchemePreferredOrder()).build();
        HttpGet httpGet = new HttpGet(this.normalizeToString(url2));
        httpGet.setConfig(requestConfig);
        httpGet.addHeader("Accept-Encoding", "gzip,deflate");
        return this.httpClient.execute((HttpUriRequest)httpGet);
    }

    private CloseableHttpResponse doHead(URL url2, int connectionTimeout, int readTimeout) throws IOException {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectionTimeout).setAuthenticationEnabled(this.hasCredentialsConfigured(url2)).setTargetPreferredAuthSchemes(HttpClientHandler.getAuthSchemePreferredOrder()).setProxyPreferredAuthSchemes(HttpClientHandler.getAuthSchemePreferredOrder()).build();
        HttpHead httpHead = new HttpHead(this.normalizeToString(url2));
        httpHead.setConfig(requestConfig);
        return this.httpClient.execute((HttpUriRequest)httpHead);
    }

    private boolean hasCredentialsConfigured(URL url2) {
        return CredentialsStore.INSTANCE.hasCredentials(url2.getHost());
    }

    @Override
    public void close() throws Exception {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    static {
        Thread shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DELETE_ON_EXIT_INSTANCE.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        });
        shutdownHook.setName("ivy-httpclient-shutdown-handler");
        shutdownHook.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    private static class IvyCredentialsProvider
    implements CredentialsProvider {
        private final ConcurrentHashMap<AuthScope, org.apache.http.auth.Credentials> cachedCreds = new ConcurrentHashMap();

        private IvyCredentialsProvider() {
        }

        public void setCredentials(AuthScope authscope, org.apache.http.auth.Credentials credentials) {
            if (authscope == null) {
                throw new IllegalArgumentException("AuthScope cannot be null");
            }
            this.cachedCreds.put(authscope, credentials);
        }

        public org.apache.http.auth.Credentials getCredentials(AuthScope authscope) {
            String host;
            if (authscope == null) {
                return null;
            }
            String realm = authscope.getRealm();
            Credentials ivyConfiguredCred = CredentialsStore.INSTANCE.getCredentials(realm, host = authscope.getHost());
            if (ivyConfiguredCred == null) {
                return null;
            }
            return IvyCredentialsProvider.createCredentials(ivyConfiguredCred.getUserName(), ivyConfiguredCred.getPasswd());
        }

        public void clear() {
            this.cachedCreds.clear();
        }

        private static org.apache.http.auth.Credentials createCredentials(String username, String password) {
            String domain;
            String user;
            int backslashIndex = username.indexOf(92);
            if (backslashIndex >= 0) {
                user = username.substring(backslashIndex + 1);
                domain = username.substring(0, backslashIndex);
            } else {
                user = username;
                domain = System.getProperty("http.auth.ntlm.domain", "");
            }
            return new NTCredentials(user, password, HostUtil.getLocalHostName(), domain);
        }
    }
}

