/*
 * Decompiled with CFR 0.152.
 */
package runtime;

import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineName;
import libraries.coroutines.extra.LifetimeTerminatedException;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import runtime.DefaultLogContainer;
import runtime.system.JStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lruntime/CoroutineExceptionLogger;", "", "()V", "loggedCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "create", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "logger", "Llibraries/klogging/KLogger;", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nCoroutineExceptionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineExceptionHandler.kt\nruntime/CoroutineExceptionLogger\n+ 2 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n*L\n1#1,22:1\n48#2,4:23\n*S KotlinDebug\n*F\n+ 1 CoroutineExceptionHandler.kt\nruntime/CoroutineExceptionLogger\n*L\n12#1:23,4\n*E\n"})
public final class CoroutineExceptionLogger {
    @NotNull
    public static final CoroutineExceptionLogger INSTANCE = new CoroutineExceptionLogger();
    @NotNull
    private static final AtomicInteger loggedCount = new AtomicInteger();

    private CoroutineExceptionLogger() {
    }

    @NotNull
    public final CoroutineExceptionHandler create(@NotNull KLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key2 = CoroutineExceptionHandler.Key;
        return new CoroutineExceptionHandler(key2, logger2){
            final /* synthetic */ KLogger $logger$inlined;
            {
                this.$logger$inlined = kLogger;
                super((CoroutineContext.Key)$super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public void handleException(@NotNull CoroutineContext context2, @NotNull Throwable exception2) {
                void throwable;
                Throwable throwable2 = exception2;
                CoroutineContext context3 = context2;
                boolean bl = false;
                if (throwable instanceof OutOfMemoryError) {
                    if (CoroutineExceptionLogger.access$getLoggedCount$p().incrementAndGet() <= 5) {
                        KLogger this_$iv = this.$logger$inlined;
                        boolean $i$f$error = false;
                        if (this_$iv.isErrorEnabled()) {
                            boolean bl2 = false;
                            String msgStr$iv = JStack.dumpThreads$default(JStack.INSTANCE, null, 1, null);
                            this_$iv.error(msgStr$iv);
                        }
                    }
                } else if (!(throwable instanceof CancellationException) && !(throwable instanceof LifetimeTerminatedException)) {
                    KLogger this_$iv = this.$logger$inlined;
                    boolean $i$f$error = false;
                    if (this_$iv.isErrorEnabled()) {
                        boolean bl3 = false;
                        Object object = (CoroutineName)context3.get((CoroutineContext.Key)CoroutineName.Key);
                        if (object == null || (object = object.getName()) == null) {
                            object = "unnamed";
                        }
                        String msgStr$iv = "Unhandled exception in " + (String)object + " coroutine";
                        this_$iv.error((Throwable)throwable, msgStr$iv);
                    }
                }
            }
        };
    }

    public static /* synthetic */ CoroutineExceptionHandler create$default(CoroutineExceptionLogger coroutineExceptionLogger, KLogger kLogger, int n, Object object) {
        if ((n & 1) != 0) {
            kLogger = DefaultLogContainer.INSTANCE.getLog();
        }
        return coroutineExceptionLogger.create(kLogger);
    }

    public static final /* synthetic */ AtomicInteger access$getLoggedCount$p() {
        return loggedCount;
    }
}

