/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.basics.DebugCommonKt;
import libraries.basics.DebugKt;
import libraries.basics.DevEnv;
import libraries.collections.Collections;
import libraries.collections.MutableSetLike;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import libraries.klogging.GroupsKt;
import libraries.klogging.KLogger;
import libraries.klogging.RichLogRecord;
import libraries.klogging.RichLogRecordKt;
import libraries.klogging.RichLoggable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.CellTracker;
import runtime.reactive.CellTrackerKt;
import runtime.reactive.Computed;
import runtime.reactive.ComputedKt;
import runtime.reactive.DependenciesState;
import runtime.reactive.DevCellTrackerChecks;
import runtime.reactive.DevTool;
import runtime.reactive.Property;
import runtime.reactive.ReactionsKt;
import runtime.reactive.Signal;
import runtime.reactive.Source;
import runtime.reactive.SourceKt;
import runtime.reactive.XTrackable;
import runtime.reactive.XTrackableLifetimed;
import runtime.reactive.XTrackableValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002@AB\u001e\u0012\u0017\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007J2\u0010\u0014\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0018j\u0002`\u00190\u00170\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010\u001c\u001a\u00020\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00162\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0016H\bJ$\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020!0\u0004H\u0016J$\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020!0\u0004H\u0016J\b\u0010'\u001a\u00020\u001bH$J\b\u0010(\u001a\u00020\u001dH&J\u0010\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0016H\u0002J$\u0010*\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010+0\u00152\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\bJ\b\u0010-\u001a\u00020\u001dH$J\u0010\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u000200H\u0002J$\u00101\u001a\u00020!2\u000e\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00162\n\u00103\u001a\u0006\u0012\u0002\b\u00030\u0000H\bJ(\u00104\u001a\u00020!2\u000e\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00162\u000e\u00103\u001a\n\u0012\u0002\b\u00030\u0018j\u0002`\u0019H\bJ\u0012\u00105\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00020#H$J>\u00106\u001a\u00020!2\u000e\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00162\u000e\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00162\u0014\u00108\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0018j\u0002`\u00190\u0017H\bJ2\u00109\u001a\u00020!2\u000e\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00162\u0018\u0010:\u001a\u0014\u0012\f\u0012\n\u0012\u0002\b\u00030\u0018j\u0002`\u00190\u0017j\u0002`;H\bJ,\u0010<\u001a\u00020!2\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0014\u00108\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0018j\u0002`\u00190\u0017H\bJ\u0006\u0010=\u001a\u00020\u001dJ.\u0010>\u001a\u00020!2\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0016\u0010?\u001a\u0012\u0012\f\u0012\n\u0012\u0002\b\u00030\u0018j\u0002`\u0019\u0018\u00010\u0017H\bR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001f\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0088\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006B"}, d2={"Lruntime/reactive/ComputedExpression;", "T", "Lruntime/reactive/Computed;", "expression", "Lkotlin/Function1;", "Lruntime/reactive/XTrackableLifetimed;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)V", "changeEvents", "Lruntime/reactive/Signal;", "Lruntime/reactive/Computed$ChangeEvent;", "changes", "Lruntime/reactive/Source;", "getChanges", "()Lruntime/reactive/Source;", "lastValue", "Lruntime/reactive/ComputedExpression$ComputedValueState;", "value", "getValue", "()Ljava/lang/Object;", "compute", "Lkotlin/Pair;", "Lruntime/reactive/ComputedExpression$ComputedValueState$Computed;", "Llibraries/collections/MutableSetLike;", "Lruntime/reactive/Property;", "Lruntime/reactive/CellTrackerDependency;", "expressionLifetime", "Llibraries/coroutines/extra/LifetimeSource;", "equals", "", "val1", "val2", "forEach", "", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "sink", "forEachChange", "handler", "getNewExpressionLifetime", "hasTracker", "invalidate", "isNeedToBeRecomputed", "", "currentValue", "isRecomputingDisabled", "logInvalidate", "froOrTo", "", "markAsPossiblyStale", "cachedRecord", "dependency", "markAsStale", "newTrackingLifetime", "swapOldValueWithNewOne", "newValue", "newDependencies", "trackDependencies", "dependencies", "Lruntime/reactive/CellTrackerDependencies;", "trackOldValueAgain", "tryInvalidate", "updateStateIfNotTracked", "currentDependencies", "ComputedValueState", "ExpressionContext", "platform-ui"})
@SourceDebugExtension(value={"SMAP\nComputed.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Computed.kt\nruntime/reactive/ComputedExpression\n+ 2 DevCellTrackerChecks.kt\nruntime/reactive/DevCellTrackerChecks\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 groupsCommon.kt\nlibraries/klogging/GroupsCommonKt\n+ 5 RichLogRecord.kt\nlibraries/klogging/RichLogRecordKt\n+ 6 KLogger.kt\nlibraries/klogging/KLogger\n+ 7 DebugCommon.kt\nlibraries/basics/DebugCommonKt\n+ 8 Debug.kt\nlibraries/basics/DebugKt\n*L\n1#1,517:1\n5#2:518\n1#3:519\n6#4,9:520\n16#4,4:569\n119#5,2:529\n122#5:536\n119#5,2:537\n122#5:544\n119#5,2:545\n122#5:552\n119#5,2:553\n122#5:560\n119#5,2:561\n122#5:568\n119#5,2:573\n122#5:580\n14#6,5:531\n14#6,5:539\n14#6,5:547\n14#6,5:555\n14#6,5:563\n14#6,5:575\n29#7,3:581\n29#7,3:585\n17#8:584\n*S KotlinDebug\n*F\n+ 1 Computed.kt\nruntime/reactive/ComputedExpression\n*L\n112#1:518\n140#1:520,9\n140#1:569,4\n145#1:529,2\n145#1:536\n160#1:537,2\n160#1:544\n168#1:545,2\n168#1:552\n181#1:553,2\n181#1:560\n193#1:561,2\n193#1:568\n288#1:573,2\n288#1:580\n145#1:531,5\n160#1:539,5\n168#1:547,5\n181#1:555,5\n193#1:563,5\n288#1:575,5\n318#1:581,3\n365#1:585,3\n336#1:584\n*E\n"})
public abstract class ComputedExpression<T>
implements Computed<T> {
    @NotNull
    private final Function1<XTrackableLifetimed, T> expression;
    @NotNull
    private ComputedValueState<? extends T> lastValue;
    @NotNull
    private final Signal<Computed.ChangeEvent> changeEvents;
    @NotNull
    private final Source<T> changes;

    public ComputedExpression(@NotNull Function1<? super XTrackableLifetimed, ? extends T> expression) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        this.expression = expression;
        this.lastValue = ComputedValueState.None.INSTANCE;
        this.changeEvents = Signal.Companion.create();
        this.changes = SourceKt.skip(this, 1);
    }

    @Override
    @NotNull
    public Source<T> getChanges() {
        return this.changes;
    }

    @Override
    public void forEachChange(@NotNull Lifetime lifetime, @NotNull Function1<? super Computed.ChangeEvent, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.changeEvents.forEach(lifetime, handler);
    }

    @Override
    public T getValue() {
        DevCellTrackerChecks this_$iv = DevCellTrackerChecks.INSTANCE;
        boolean $i$f$suspendRenderInProcessChecks = false;
        boolean bl = false;
        ComputedValueState.Computed invalidatedValue = this.invalidate();
        if (!(invalidatedValue instanceof ComputedValueState.Computed.Success)) {
            if (invalidatedValue instanceof ComputedValueState.Computed.Failure) {
                throw ((ComputedValueState.Computed.Failure)invalidatedValue).getError();
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((ComputedValueState.Computed.Success)invalidatedValue).getValue();
    }

    @Override
    public void forEach(@NotNull Lifetime lifetime, @NotNull Function1<? super T, Unit> sink2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(sink2, (String)"sink");
        Function1 effect2 = (Function1)new Function1<XTrackableLifetimed, Unit>(sink2, this){
            final /* synthetic */ Function1<T, Unit> $sink;
            final /* synthetic */ ComputedExpression<T> this$0;
            {
                this.$sink = $sink;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull XTrackableLifetimed xTrackableLifetimed) {
                Intrinsics.checkNotNullParameter((Object)xTrackableLifetimed, (String)"<this>");
                this.$sink.invoke(xTrackableLifetimed.getLive((Property)this.this$0));
            }
        };
        DebugKt.assignDbgName(effect2, DebugCommonKt.getDbgName(sink2));
        ReactionsKt.effect(lifetime, (Function1<? super XTrackableLifetimed, Unit>)effect2);
    }

    public final boolean tryInvalidate() {
        ComputedValueState<? extends T> prevCacheRecord = this.lastValue;
        ComputedValueState.Computed<T> newCacheRecord = this.invalidate();
        return !Intrinsics.areEqual(prevCacheRecord, newCacheRecord);
    }

    public abstract boolean hasTracker();

    protected abstract boolean isRecomputingDisabled();

    private final boolean equals(ComputedValueState.Computed<? extends T> val1, ComputedValueState.Computed<? extends T> val2) {
        return Intrinsics.areEqual(val1, val2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ComputedValueState.Computed<? extends T> invalidate() {
        ComputedValueState.Computed computed2;
        String string2;
        String string3 = DebugCommonKt.getDbgName(this);
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            string2 = "Computed(" + it + "): invalidate";
        } else {
            string2 = null;
        }
        String label$iv = string2;
        boolean collapsed$iv = true;
        boolean $i$f$logGroup = false;
        boolean $i$f$logGroupInline = false;
        if (label$iv != null) {
            GroupsKt.logGroupStart(label$iv, collapsed$iv);
        }
        try {
            Object it;
            Object object;
            Object object2;
            ComputedValueState computedValueState;
            boolean bl = false;
            ComputedValueState currentValue = this.lastValue;
            if (currentValue instanceof ComputedValueState.Computed) {
                Pair dbgName$iv;
                if (this.isRecomputingDisabled()) {
                    computedValueState = currentValue;
                    ComputedValueState.Computed it2 = (ComputedValueState.Computed)computedValueState;
                    boolean bl2 = false;
                    object2 = ComputedKt.access$getLog$p();
                    String string4 = DebugCommonKt.getDbgName(this);
                    Function2 msg$iv = (Function2)new Function2<RichLogRecord, String, Unit>(currentValue){
                        final /* synthetic */ ComputedValueState<T> $currentValue;
                        {
                            this.$currentValue = $currentValue;
                            super(2);
                        }

                        public final void invoke(@NotNull RichLogRecord $this$richDebug, @NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)$this$richDebug, (String)"$this$richDebug");
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            $this$richDebug.unaryPlus("recomputing disabled:");
                            $this$richDebug.richLog(this.$currentValue);
                            $this$richDebug.unaryPlus(Unit.INSTANCE);
                        }
                    };
                    boolean $i$f$richDebug = false;
                    if (dbgName$iv != null) {
                        void $this$richDebug$iv;
                        void this_$iv$iv = $this$richDebug$iv;
                        boolean $i$f$debug = false;
                        if (this_$iv$iv.isDebugEnabled()) {
                            boolean bl3 = false;
                            RichLogRecord msgStr$iv$iv = RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)((Function1)new Function1<RichLogRecord, Unit>(msg$iv, (String)dbgName$iv){
                                final /* synthetic */ Function2 $msg;
                                final /* synthetic */ String $dbgName;
                                {
                                    this.$msg = $msg;
                                    this.$dbgName = $dbgName;
                                    super(1);
                                }

                                public final void invoke(@NotNull RichLogRecord $this$richLog) {
                                    Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"$this$richLog");
                                    this.$msg.invoke((Object)$this$richLog, (Object)this.$dbgName);
                                }
                            }));
                            this_$iv$iv.debug(msgStr$iv$iv);
                        }
                    }
                    object = (ComputedValueState.Computed)computedValueState;
                } else {
                    computedValueState = this.isNeedToBeRecomputed((ComputedValueState.Computed)currentValue);
                    boolean needsToBeRecomputed = (Boolean)computedValueState.component1();
                    Void currentDependencies = (Void)computedValueState.component2();
                    if (needsToBeRecomputed) {
                        LifetimeSource newExpressionLifetime = !((ComputedValueState.Computed)currentValue).getDependsOnLifetime() ? ((ComputedValueState.Computed)currentValue).getLifetime() : this.getNewExpressionLifetime();
                        dbgName$iv = this.compute(newExpressionLifetime);
                        ComputedValueState.Computed newValue = (ComputedValueState.Computed)dbgName$iv.component1();
                        MutableSetLike newDependencies = (MutableSetLike)dbgName$iv.component2();
                        boolean equals = this.equals(newValue, (ComputedValueState.Computed)currentValue);
                        if (((ComputedValueState.Computed)currentValue).getDependsOnLifetime() || !equals) {
                            void dbgName$iv2;
                            ComputedValueState.Computed $i$f$debug;
                            this.swapOldValueWithNewOne((ComputedValueState.Computed)currentValue, newValue, newDependencies);
                            this.changeEvents.fire(Computed.ChangeEvent.ChangeVerified);
                            ComputedValueState.Computed it3 = $i$f$debug = newValue;
                            boolean bl4 = false;
                            KLogger kLogger = ComputedKt.access$getLog$p();
                            String string5 = DebugCommonKt.getDbgName(this);
                            Function2 msg$iv = (Function2)new Function2<RichLogRecord, String, Unit>(newValue){
                                final /* synthetic */ ComputedValueState.Computed<? extends T> $newValue;
                                {
                                    this.$newValue = $newValue;
                                    super(2);
                                }

                                public final void invoke(@NotNull RichLogRecord $this$richDebug, @NotNull String it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$richDebug, (String)"$this$richDebug");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    $this$richDebug.unaryPlus("new value:");
                                    $this$richDebug.richLog(this.$newValue);
                                }
                            };
                            boolean $i$f$richDebug = false;
                            if (dbgName$iv2 != null) {
                                void $this$richDebug$iv;
                                void this_$iv$iv = $this$richDebug$iv;
                                boolean $i$f$debug2 = false;
                                if (this_$iv$iv.isDebugEnabled()) {
                                    boolean bl5 = false;
                                    RichLogRecord msgStr$iv$iv = RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)((Function1)new Function1<RichLogRecord, Unit>(msg$iv, (String)dbgName$iv2){
                                        final /* synthetic */ Function2 $msg;
                                        final /* synthetic */ String $dbgName;
                                        {
                                            this.$msg = $msg;
                                            this.$dbgName = $dbgName;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull RichLogRecord $this$richLog) {
                                            Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"$this$richLog");
                                            this.$msg.invoke((Object)$this$richLog, (Object)this.$dbgName);
                                        }
                                    }));
                                    this_$iv$iv.debug(msgStr$iv$iv);
                                }
                            }
                            object = $i$f$debug;
                        } else {
                            this.trackOldValueAgain((ComputedValueState.Computed)currentValue, newDependencies);
                            ComputedValueState $i$f$debug = currentValue;
                            ComputedValueState.Computed it4 = (ComputedValueState.Computed)$i$f$debug;
                            boolean bl6 = false;
                            KLogger $this$richDebug$iv = ComputedKt.access$getLog$p();
                            String dbgName$iv2 = DebugCommonKt.getDbgName(this);
                            Function2 msg$iv = (Function2)new Function2<RichLogRecord, String, Unit>(currentValue, newValue){
                                final /* synthetic */ ComputedValueState<T> $currentValue;
                                final /* synthetic */ ComputedValueState.Computed<? extends T> $newValue;
                                {
                                    this.$currentValue = $currentValue;
                                    this.$newValue = $newValue;
                                    super(2);
                                }

                                public final void invoke(@NotNull RichLogRecord $this$richDebug, @NotNull String it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$richDebug, (String)"$this$richDebug");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    $this$richDebug.unaryPlus("new value equals to old:");
                                    $this$richDebug.unaryPlus("\nold value:");
                                    $this$richDebug.richLog(this.$currentValue);
                                    $this$richDebug.unaryPlus("\nnew value:");
                                    $this$richDebug.richLog(this.$newValue);
                                    $this$richDebug.unaryPlus("\nold value is returned");
                                }
                            };
                            boolean $i$f$richDebug = false;
                            if (dbgName$iv2 != null) {
                                KLogger this_$iv$iv = $this$richDebug$iv;
                                boolean $i$f$debug3 = false;
                                if (this_$iv$iv.isDebugEnabled()) {
                                    boolean bl7 = false;
                                    RichLogRecord msgStr$iv$iv = RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)((Function1)new Function1<RichLogRecord, Unit>(msg$iv, dbgName$iv2){
                                        final /* synthetic */ Function2 $msg;
                                        final /* synthetic */ String $dbgName;
                                        {
                                            this.$msg = $msg;
                                            this.$dbgName = $dbgName;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull RichLogRecord $this$richLog) {
                                            Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"$this$richLog");
                                            this.$msg.invoke((Object)$this$richLog, (Object)this.$dbgName);
                                        }
                                    }));
                                    this_$iv$iv.debug(msgStr$iv$iv);
                                }
                            }
                            object = (ComputedValueState.Computed)$i$f$debug;
                        }
                    } else {
                        void dbgName$iv3;
                        this.updateStateIfNotTracked((ComputedValueState.Computed)currentValue, (MutableSetLike)((Object)currentDependencies));
                        object2 = currentValue;
                        it = (ComputedValueState.Computed)object2;
                        boolean bl8 = false;
                        KLogger newDependencies = ComputedKt.access$getLog$p();
                        String equals = DebugCommonKt.getDbgName(this);
                        Function2 msg$iv = (Function2)new Function2<RichLogRecord, String, Unit>(currentValue){
                            final /* synthetic */ ComputedValueState<T> $currentValue;
                            {
                                this.$currentValue = $currentValue;
                                super(2);
                            }

                            public final void invoke(@NotNull RichLogRecord $this$richDebug, @NotNull String it) {
                                Intrinsics.checkNotNullParameter((Object)$this$richDebug, (String)"$this$richDebug");
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                $this$richDebug.unaryPlus("recalculation isn't needed:");
                                $this$richDebug.richLog(this.$currentValue);
                            }
                        };
                        boolean $i$f$richDebug = false;
                        if (dbgName$iv3 != null) {
                            void $this$richDebug$iv;
                            void this_$iv$iv = $this$richDebug$iv;
                            boolean $i$f$debug = false;
                            if (this_$iv$iv.isDebugEnabled()) {
                                boolean bl9 = false;
                                RichLogRecord msgStr$iv$iv = RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)((Function1)new Function1<RichLogRecord, Unit>(msg$iv, (String)dbgName$iv3){
                                    final /* synthetic */ Function2 $msg;
                                    final /* synthetic */ String $dbgName;
                                    {
                                        this.$msg = $msg;
                                        this.$dbgName = $dbgName;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull RichLogRecord $this$richLog) {
                                        Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"$this$richLog");
                                        this.$msg.invoke((Object)$this$richLog, (Object)this.$dbgName);
                                    }
                                }));
                                this_$iv$iv.debug(msgStr$iv$iv);
                            }
                        }
                        object = (ComputedValueState.Computed)object2;
                    }
                }
            } else if (Intrinsics.areEqual((Object)currentValue, (Object)ComputedValueState.None.INSTANCE)) {
                computedValueState = this.compute(this.getNewExpressionLifetime());
                ComputedValueState.Computed newValue = (ComputedValueState.Computed)computedValueState.component1();
                MutableSetLike dependencies = (MutableSetLike)computedValueState.component2();
                this.trackDependencies(newValue, dependencies);
                this.lastValue = newValue;
                it = object2 = newValue;
                boolean bl10 = false;
                KLogger $this$richDebug$iv = ComputedKt.access$getLog$p();
                String dbgName$iv3 = DebugCommonKt.getDbgName(this);
                Function2 msg$iv = (Function2)new Function2<RichLogRecord, String, Unit>(newValue){
                    final /* synthetic */ ComputedValueState.Computed<? extends T> $newValue;
                    {
                        this.$newValue = $newValue;
                        super(2);
                    }

                    public final void invoke(@NotNull RichLogRecord $this$richDebug, @NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)$this$richDebug, (String)"$this$richDebug");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        $this$richDebug.unaryPlus("calculated first time:");
                        $this$richDebug.richLog(this.$newValue);
                    }
                };
                boolean $i$f$richDebug = false;
                if (dbgName$iv3 != null) {
                    KLogger this_$iv$iv = $this$richDebug$iv;
                    boolean $i$f$debug = false;
                    if (this_$iv$iv.isDebugEnabled()) {
                        boolean bl11 = false;
                        RichLogRecord msgStr$iv$iv = RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)((Function1)new Function1<RichLogRecord, Unit>(msg$iv, dbgName$iv3){
                            final /* synthetic */ Function2 $msg;
                            final /* synthetic */ String $dbgName;
                            {
                                this.$msg = $msg;
                                this.$dbgName = $dbgName;
                                super(1);
                            }

                            public final void invoke(@NotNull RichLogRecord $this$richLog) {
                                Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"$this$richLog");
                                this.$msg.invoke((Object)$this$richLog, (Object)this.$dbgName);
                            }
                        }));
                        this_$iv$iv.debug(msgStr$iv$iv);
                    }
                }
                object = object2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            computed2 = object;
        }
        finally {
            if (label$iv != null) {
                GroupsKt.logGroupEnd(label$iv);
            }
        }
        return computed2;
    }

    private final void updateStateIfNotTracked(ComputedValueState.Computed<T> currentValue, MutableSetLike<Property<?>> currentDependencies) {
        if (this.hasTracker()) {
            currentValue.setDependenciesState(DependenciesState.Tracked.UpToDate.INSTANCE);
        } else if (currentValue.getDependenciesState() != DependenciesState.NotTracked.INSTANCE || currentDependencies != null) {
            currentValue.setDependenciesState(DependenciesState.NotTracked.INSTANCE);
        }
    }

    private final void trackOldValueAgain(ComputedValueState.Computed<T> currentValue, MutableSetLike<Property<?>> newDependencies) {
        if (this.hasTracker()) {
            if (currentValue.getDependenciesState() == DependenciesState.Tracked.Stale.INSTANCE || currentValue.getDependenciesState() == DependenciesState.NotTracked.INSTANCE) {
                this.trackDependencies(currentValue, newDependencies);
            } else {
                currentValue.setDependenciesState(DependenciesState.Tracked.UpToDate.INSTANCE);
            }
        } else {
            currentValue.setDependenciesState(DependenciesState.NotTracked.INSTANCE);
        }
    }

    private final void swapOldValueWithNewOne(ComputedValueState.Computed<? extends T> currentValue, ComputedValueState.Computed<? extends T> newValue, MutableSetLike<Property<?>> newDependencies) {
        if (currentValue.getDependsOnLifetime()) {
            DebugKt.assignDbgName(currentValue.getLifetime(), null);
            currentValue.getLifetime().terminate();
            DebugCommonKt.assignDbgName(newValue.getLifetime(), this, "expressionLifetime");
        }
        if (this.hasTracker()) {
            this.trackDependencies(newValue, newDependencies);
        }
        this.lastValue = newValue;
    }

    private final Pair isNeedToBeRecomputed(ComputedValueState.Computed<T> currentValue) {
        Pair pair;
        DependenciesState dependenciesState = currentValue.getDependenciesState();
        if (Intrinsics.areEqual((Object)dependenciesState, (Object)DependenciesState.Tracked.UpToDate.INSTANCE)) {
            pair = TuplesKt.to((Object)false, null);
        } else if (Intrinsics.areEqual((Object)dependenciesState, (Object)DependenciesState.NotTracked.INSTANCE)) {
            pair = TuplesKt.to((Object)true, null);
        } else if (Intrinsics.areEqual((Object)dependenciesState, (Object)DependenciesState.Tracked.Stale.INSTANCE)) {
            pair = TuplesKt.to((Object)true, null);
        } else if (dependenciesState instanceof DependenciesState.Tracked.PossiblyStale) {
            boolean needsToBeRecomputed = false;
            MutableSetLike<ComputedExpression<?>> dependenciesToInvalidate = ((DependenciesState.Tracked.PossiblyStale)dependenciesState).getDependenciesMightHaveChanged().copy();
            while (!needsToBeRecomputed) {
                MutableSetLike<ComputedExpression<?>> mutableSetLike = dependenciesToInvalidate;
                boolean bl = mutableSetLike != null ? !mutableSetLike.isEmpty() : false;
                if (!bl) break;
                needsToBeRecomputed = dependenciesToInvalidate.any((Function1)new Function1<ComputedExpression<?>, Boolean>(dependenciesState, this){
                    final /* synthetic */ DependenciesState $dependenciesState;
                    final /* synthetic */ ComputedExpression<T> this$0;
                    {
                        this.$dependenciesState = $dependenciesState;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull ComputedExpression<?> dependency) {
                        boolean changed;
                        block2: {
                            Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
                            ((DependenciesState.Tracked.PossiblyStale)this.$dependenciesState).getDependenciesMightHaveChanged().remove(dependency);
                            changed = dependency.tryInvalidate();
                            ComputedExpression<T> computedExpression = this.this$0;
                            boolean $i$f$ifDevEnv = false;
                            if (!DebugKt.getIS_DEV_ENV()) break block2;
                            DevEnv $this$invoke_u24lambda_u240 = DevEnv.INSTANCE;
                            boolean bl = false;
                            if (changed) {
                                DevTool devTool = CellTrackerKt.getDevTool($this$invoke_u24lambda_u240);
                                if (devTool != null) {
                                    devTool.onRecomputeDerived((Computed)computedExpression, (Property)dependency);
                                }
                            }
                        }
                        return changed;
                    }
                });
                if (needsToBeRecomputed) continue;
                DependenciesState newDependenciesState = currentValue.getDependenciesState();
                if (Intrinsics.areEqual((Object)newDependenciesState, (Object)DependenciesState.Tracked.Stale.INSTANCE)) {
                    needsToBeRecomputed = true;
                    continue;
                }
                if (newDependenciesState instanceof DependenciesState.Tracked.PossiblyStale) {
                    dependenciesToInvalidate = ((DependenciesState.Tracked.PossiblyStale)newDependenciesState).getDependenciesMightHaveChanged().copy();
                    continue;
                }
                dependenciesToInvalidate = null;
            }
            pair = TuplesKt.to((Object)needsToBeRecomputed, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final void logInvalidate(String froOrTo) {
        void dbgName$iv;
        KLogger kLogger = ComputedKt.access$getLog$p();
        String string2 = DebugCommonKt.getDbgName(this);
        Function2 msg$iv = (Function2)new Function2<RichLogRecord, String, Unit>(froOrTo, this){
            final /* synthetic */ String $froOrTo;
            final /* synthetic */ ComputedExpression<T> this$0;
            {
                this.$froOrTo = $froOrTo;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull RichLogRecord $this$richDebug, @NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)$this$richDebug, (String)"$this$richDebug");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $this$richDebug.unaryPlus("Computed(" + it + "): invalidate " + this.$froOrTo);
                $this$richDebug.unaryPlus(ComputedExpression.access$getLastValue$p(this.this$0));
            }
        };
        boolean $i$f$richDebug = false;
        if (dbgName$iv != null) {
            void $this$richDebug$iv;
            void this_$iv$iv = $this$richDebug$iv;
            boolean $i$f$debug = false;
            if (this_$iv$iv.isDebugEnabled()) {
                boolean bl = false;
                RichLogRecord msgStr$iv$iv = RichLogRecordKt.richLog((Function1<? super RichLogRecord, Unit>)((Function1)new Function1<RichLogRecord, Unit>(msg$iv, (String)dbgName$iv){
                    final /* synthetic */ Function2 $msg;
                    final /* synthetic */ String $dbgName;
                    {
                        this.$msg = $msg;
                        this.$dbgName = $dbgName;
                        super(1);
                    }

                    public final void invoke(@NotNull RichLogRecord $this$richLog) {
                        Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"$this$richLog");
                        this.$msg.invoke((Object)$this$richLog, (Object)this.$dbgName);
                    }
                }));
                this_$iv$iv.debug(msgStr$iv$iv);
            }
        }
    }

    @NotNull
    protected abstract LifetimeSource getNewExpressionLifetime();

    private final Pair<ComputedValueState.Computed<? extends T>, MutableSetLike<Property<?>>> compute(LifetimeSource expressionLifetime) {
        MutableSetLike dependencies = Collections.INSTANCE.fastSet();
        ExpressionContext context2 = new ExpressionContext(expressionLifetime);
        ComputedValueState.Computed computedValue2 = (ComputedValueState.Computed)CellTracker.INSTANCE.frameAccess((Function1)new Function1<Property<?>, Unit>(dependencies){

            public final void invoke(@NotNull Property<?> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((MutableSetLike)this.receiver).add(p0);
            }
        }, (Function0)new Function0<ComputedValueState.Computed<? extends T>>(this, context2, expressionLifetime){
            final /* synthetic */ ComputedExpression<T> this$0;
            final /* synthetic */ ExpressionContext $context;
            final /* synthetic */ LifetimeSource $expressionLifetime;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$expressionLifetime = $expressionLifetime;
                super(0);
            }

            @NotNull
            public final ComputedValueState.Computed<? extends T> invoke() {
                ComputedValueState.Computed computed2;
                try {
                    Object result2 = ComputedExpression.access$getExpression$p(this.this$0).invoke((Object)this.$context);
                    computed2 = new ComputedValueState.Computed.Success<T>(result2, this.$expressionLifetime, this.$context.getDependsOnLifetime(), null, 8, null);
                }
                catch (Throwable e) {
                    computed2 = new ComputedValueState.Computed.Failure(e, this.$expressionLifetime, this.$context.getDependsOnLifetime(), null, 8, null);
                }
                return computed2;
            }
        });
        return TuplesKt.to((Object)computedValue2, dependencies);
    }

    @Nullable
    protected abstract LifetimeSource newTrackingLifetime(@NotNull Lifetime var1);

    private final void trackDependencies(ComputedValueState.Computed<? extends T> cachedRecord, MutableSetLike<Property<?>> dependencies) {
        boolean $i$f$ifDevEnv = false;
        if (DebugKt.getIS_DEV_ENV()) {
            DevEnv $this$trackDependencies_u24lambda_u248 = DevEnv.INSTANCE;
            boolean bl = false;
            DevTool devTool = CellTrackerKt.getDevTool($this$trackDependencies_u24lambda_u248);
            if (devTool != null) {
                devTool.onTrackDependenciesDerived(this, dependencies);
            }
        }
        LifetimeSource trackingLifetime = this.newTrackingLifetime(cachedRecord.getLifetime());
        if (trackingLifetime != null && !trackingLifetime.isTerminated()) {
            cachedRecord.setDependenciesState(DependenciesState.Tracked.UpToDate.INSTANCE);
            cachedRecord.getLifetime().add((Function)new Function0<Unit>(cachedRecord){
                final /* synthetic */ ComputedValueState.Computed<? extends T> $cachedRecord;
                {
                    this.$cachedRecord = $cachedRecord;
                    super(0);
                }

                public final void invoke() {
                    this.$cachedRecord.setDependenciesState(DependenciesState.NotTracked.INSTANCE);
                }
            });
            ComputedExpression $this$getDbgName$iv = this;
            boolean $i$f$getDbgName = false;
            ComputedKt.trackDependencies(trackingLifetime, dependencies, (Function1)new Function1<ComputedExpression<?>, Unit>(this, cachedRecord){
                final /* synthetic */ ComputedExpression<T> this$0;
                final /* synthetic */ ComputedValueState.Computed<? extends T> $cachedRecord;
                {
                    this.this$0 = $receiver;
                    this.$cachedRecord = $cachedRecord;
                    super(1);
                }

                public final void invoke(@NotNull ComputedExpression<?> dependency) {
                    Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
                    ComputedExpression.access$markAsPossiblyStale(this.this$0, this.$cachedRecord, dependency);
                }
            }, (Function1)new Function1<Property<?>, Unit>(this, cachedRecord){
                final /* synthetic */ ComputedExpression<T> this$0;
                final /* synthetic */ ComputedValueState.Computed<? extends T> $cachedRecord;
                {
                    this.this$0 = $receiver;
                    this.$cachedRecord = $cachedRecord;
                    super(1);
                }

                public final void invoke(@NotNull Property<?> dependency) {
                    Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
                    ComputedExpression.access$markAsStale(this.this$0, this.$cachedRecord, dependency);
                }
            }, null);
        } else {
            cachedRecord.setDependenciesState(DependenciesState.NotTracked.INSTANCE);
        }
    }

    private final void markAsPossiblyStale(ComputedValueState.Computed<? extends T> cachedRecord, ComputedExpression<?> dependency) {
        DependenciesState dependenciesState = cachedRecord.getDependenciesState();
        if (Intrinsics.areEqual((Object)dependenciesState, (Object)DependenciesState.Tracked.UpToDate.INSTANCE)) {
            DependenciesState.Tracked.PossiblyStale newDependenciesState = new DependenciesState.Tracked.PossiblyStale();
            cachedRecord.setDependenciesState(newDependenciesState);
            newDependenciesState.getDependenciesMightHaveChanged().add(dependency);
            this.changeEvents.fire(Computed.ChangeEvent.MaybeChanged);
        } else if (dependenciesState instanceof DependenciesState.Tracked.PossiblyStale) {
            ((DependenciesState.Tracked.PossiblyStale)dependenciesState).getDependenciesMightHaveChanged().add(dependency);
        }
    }

    private final void markAsStale(ComputedValueState.Computed<? extends T> cachedRecord, Property<?> dependency) {
        DependenciesState prevDependenciesState = cachedRecord.getDependenciesState();
        cachedRecord.setDependenciesState(DependenciesState.Tracked.Stale.INSTANCE);
        if (prevDependenciesState == DependenciesState.Tracked.UpToDate.INSTANCE) {
            boolean $i$f$ifDevEnv = false;
            if (DebugKt.getIS_DEV_ENV()) {
                DevEnv $this$markAsStale_u24lambda_u2410 = DevEnv.INSTANCE;
                boolean bl = false;
                DevTool devTool = CellTrackerKt.getDevTool($this$markAsStale_u24lambda_u2410);
                if (devTool != null) {
                    devTool.onRecomputeDerived(this, dependency);
                }
            }
            this.changeEvents.fire(Computed.ChangeEvent.MaybeChanged);
        }
    }

    @Override
    public void forEachWithPrevious(@NotNull Lifetime lifetime, @NotNull Function2<? super T, ? super T, Unit> consume) {
        Computed.DefaultImpls.forEachWithPrevious(this, lifetime, consume);
    }

    public static final /* synthetic */ Function1 access$getExpression$p(ComputedExpression $this) {
        return $this.expression;
    }

    public static final /* synthetic */ void access$markAsPossiblyStale(ComputedExpression $this, ComputedValueState.Computed cachedRecord, ComputedExpression dependency) {
        $this.markAsPossiblyStale(cachedRecord, dependency);
    }

    public static final /* synthetic */ void access$markAsStale(ComputedExpression $this, ComputedValueState.Computed cachedRecord, Property dependency) {
        $this.markAsStale(cachedRecord, dependency);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\u00020\u0002:\u0002\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lruntime/reactive/ComputedExpression$ComputedValueState;", "T", "Llibraries/klogging/RichLoggable;", "()V", "Computed", "None", "Lruntime/reactive/ComputedExpression$ComputedValueState$Computed;", "Lruntime/reactive/ComputedExpression$ComputedValueState$None;", "platform-ui"})
    protected static abstract class ComputedValueState<T>
    implements RichLoggable {
        private ComputedValueState() {
        }

        @Override
        public void richLog(@NotNull RichLogRecord $this$richLog) {
            RichLoggable.DefaultImpls.richLog(this, $this$richLog);
        }

        public /* synthetic */ ComputedValueState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u0012\u0013B!\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lruntime/reactive/ComputedExpression$ComputedValueState$Computed;", "T", "Lruntime/reactive/ComputedExpression$ComputedValueState;", "lifetime", "Llibraries/coroutines/extra/LifetimeSource;", "dependsOnLifetime", "", "dependenciesState", "Lruntime/reactive/DependenciesState;", "(Llibraries/coroutines/extra/LifetimeSource;ZLruntime/reactive/DependenciesState;)V", "getDependenciesState", "()Lruntime/reactive/DependenciesState;", "setDependenciesState", "(Lruntime/reactive/DependenciesState;)V", "getDependsOnLifetime", "()Z", "getLifetime", "()Llibraries/coroutines/extra/LifetimeSource;", "Failure", "Success", "Lruntime/reactive/ComputedExpression$ComputedValueState$Computed$Failure;", "Lruntime/reactive/ComputedExpression$ComputedValueState$Computed$Success;", "platform-ui"})
        public static abstract class Computed<T>
        extends ComputedValueState<T> {
            @NotNull
            private final LifetimeSource lifetime;
            private final boolean dependsOnLifetime;
            @NotNull
            private DependenciesState dependenciesState;

            private Computed(LifetimeSource lifetime, boolean dependsOnLifetime, DependenciesState dependenciesState) {
                super(null);
                this.lifetime = lifetime;
                this.dependsOnLifetime = dependsOnLifetime;
                this.dependenciesState = dependenciesState;
            }

            public /* synthetic */ Computed(LifetimeSource lifetimeSource, boolean bl, DependenciesState dependenciesState, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    dependenciesState = DependenciesState.NotTracked.INSTANCE;
                }
                this(lifetimeSource, bl, dependenciesState, null);
            }

            @NotNull
            public final LifetimeSource getLifetime() {
                return this.lifetime;
            }

            public final boolean getDependsOnLifetime() {
                return this.dependsOnLifetime;
            }

            @NotNull
            public final DependenciesState getDependenciesState() {
                return this.dependenciesState;
            }

            public final void setDependenciesState(@NotNull DependenciesState dependenciesState) {
                Intrinsics.checkNotNullParameter((Object)dependenciesState, (String)"<set-?>");
                this.dependenciesState = dependenciesState;
            }

            public /* synthetic */ Computed(LifetimeSource lifetime, boolean dependsOnLifetime, DependenciesState dependenciesState, DefaultConstructorMarker $constructor_marker) {
                this(lifetime, dependsOnLifetime, dependenciesState);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lruntime/reactive/ComputedExpression$ComputedValueState$Computed$Failure;", "Lruntime/reactive/ComputedExpression$ComputedValueState$Computed;", "", "error", "", "lifetime", "Llibraries/coroutines/extra/LifetimeSource;", "dependsOnLifetime", "", "dependenciesState", "Lruntime/reactive/DependenciesState;", "(Ljava/lang/Throwable;Llibraries/coroutines/extra/LifetimeSource;ZLruntime/reactive/DependenciesState;)V", "getError", "()Ljava/lang/Throwable;", "equals", "other", "", "richLog", "", "Llibraries/klogging/RichLogRecord;", "platform-ui"})
            public static final class Failure
            extends Computed {
                @NotNull
                private final Throwable error;

                public Failure(@NotNull Throwable error2, @NotNull LifetimeSource lifetime, boolean dependsOnLifetime, @NotNull DependenciesState dependenciesState) {
                    Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
                    Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                    Intrinsics.checkNotNullParameter((Object)dependenciesState, (String)"dependenciesState");
                    super(lifetime, dependsOnLifetime, dependenciesState, null);
                    this.error = error2;
                }

                public /* synthetic */ Failure(Throwable throwable, LifetimeSource lifetimeSource, boolean bl, DependenciesState dependenciesState, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 8) != 0) {
                        dependenciesState = DependenciesState.NotTracked.INSTANCE;
                    }
                    this(throwable, lifetimeSource, bl, dependenciesState);
                }

                @NotNull
                public final Throwable getError() {
                    return this.error;
                }

                @Override
                public void richLog(@NotNull RichLogRecord $this$richLog) {
                    Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"<this>");
                    $this$richLog.unaryPlus("ComputedValueState.Computed( value =");
                    $this$richLog.unaryPlus(this.error);
                    $this$richLog.unaryPlus(", dependenciesState =");
                    $this$richLog.unaryPlus(this.getDependenciesState());
                    $this$richLog.unaryPlus(")");
                }

                public boolean equals(@Nullable Object other) {
                    return this == other || other instanceof Failure && Intrinsics.areEqual((Object)((Failure)other).error, (Object)this.error);
                }
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0003\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B'\u0012\u0006\u0010\u0003\u001a\u00028\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0016R\u0013\u0010\u0003\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lruntime/reactive/ComputedExpression$ComputedValueState$Computed$Success;", "T", "Lruntime/reactive/ComputedExpression$ComputedValueState$Computed;", "value", "lifetime", "Llibraries/coroutines/extra/LifetimeSource;", "dependsOnLifetime", "", "dependenciesState", "Lruntime/reactive/DependenciesState;", "(Ljava/lang/Object;Llibraries/coroutines/extra/LifetimeSource;ZLruntime/reactive/DependenciesState;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "equals", "other", "", "richLog", "", "Llibraries/klogging/RichLogRecord;", "platform-ui"})
            @SourceDebugExtension(value={"SMAP\nComputed.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Computed.kt\nruntime/reactive/ComputedExpression$ComputedValueState$Computed$Success\n+ 2 Debug.kt\nlibraries/basics/DebugKt\n*L\n1#1,517:1\n17#2:518\n*S KotlinDebug\n*F\n+ 1 Computed.kt\nruntime/reactive/ComputedExpression$ComputedValueState$Computed$Success\n*L\n89#1:518\n*E\n"})
            public static final class Success<T>
            extends Computed<T> {
                private final T value;

                public Success(T value2, @NotNull LifetimeSource lifetime, boolean dependsOnLifetime, @NotNull DependenciesState dependenciesState) {
                    Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                    Intrinsics.checkNotNullParameter((Object)dependenciesState, (String)"dependenciesState");
                    super(lifetime, dependsOnLifetime, dependenciesState, null);
                    this.value = value2;
                }

                public /* synthetic */ Success(Object object, LifetimeSource lifetimeSource, boolean bl, DependenciesState dependenciesState, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 8) != 0) {
                        dependenciesState = DependenciesState.NotTracked.INSTANCE;
                    }
                    this(object, lifetimeSource, bl, dependenciesState);
                }

                public final T getValue() {
                    return this.value;
                }

                @Override
                public void richLog(@NotNull RichLogRecord $this$richLog) {
                    Intrinsics.checkNotNullParameter((Object)$this$richLog, (String)"<this>");
                    $this$richLog.unaryPlus("ComputedValueState.Computed( value =");
                    T t = this.value;
                    if (t != null) {
                        T $this$getDbgName$iv = t;
                        boolean $i$f$getDbgName = false;
                    }
                    $this$richLog.unaryPlus(this.value);
                    $this$richLog.unaryPlus(", dependenciesState =");
                    $this$richLog.unaryPlus(this.getDependenciesState());
                    $this$richLog.unaryPlus(")");
                }

                public boolean equals(@Nullable Object other) {
                    return this == other || other instanceof Success && Intrinsics.areEqual(((Success)other).value, this.value);
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lruntime/reactive/ComputedExpression$ComputedValueState$None;", "Lruntime/reactive/ComputedExpression$ComputedValueState;", "", "()V", "toString", "", "platform-ui"})
        public static final class None
        extends ComputedValueState {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "ComputedValueState.None";
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lruntime/reactive/ComputedExpression$ExpressionContext;", "Lruntime/reactive/XTrackableLifetimed;", "expressionLifetime", "Llibraries/coroutines/extra/Lifetime;", "(Llibraries/coroutines/extra/Lifetime;)V", "dependsOnLifetime", "", "getDependsOnLifetime", "()Z", "setDependsOnLifetime", "(Z)V", "getExpressionLifetime", "()Llibraries/coroutines/extra/Lifetime;", "lifetime", "getLifetime", "platform-ui"})
    private static final class ExpressionContext
    implements XTrackableLifetimed {
        @NotNull
        private final Lifetime expressionLifetime;
        private boolean dependsOnLifetime;

        public ExpressionContext(@NotNull Lifetime expressionLifetime) {
            Intrinsics.checkNotNullParameter((Object)expressionLifetime, (String)"expressionLifetime");
            this.expressionLifetime = expressionLifetime;
        }

        @NotNull
        public final Lifetime getExpressionLifetime() {
            return this.expressionLifetime;
        }

        public final boolean getDependsOnLifetime() {
            return this.dependsOnLifetime;
        }

        public final void setDependsOnLifetime(boolean bl) {
            this.dependsOnLifetime = bl;
        }

        @Override
        @NotNull
        public Lifetime getLifetime() {
            this.dependsOnLifetime = true;
            return this.expressionLifetime;
        }

        @Override
        public <T> T getLive(@NotNull XTrackableValue<? extends T> $this$live) {
            return XTrackableLifetimed.DefaultImpls.getLive((XTrackableLifetimed)this, $this$live);
        }

        @Override
        public <T> T getLive(@NotNull Property<? extends T> $this$live) {
            return XTrackableLifetimed.DefaultImpls.getLive((XTrackableLifetimed)this, $this$live);
        }

        @Override
        @NotNull
        public XTrackable getLive() {
            return XTrackableLifetimed.DefaultImpls.getLive(this);
        }

        @Override
        public <R> R getLive(@NotNull Function1<? super XTrackable, ? extends R> $this$live) {
            return XTrackableLifetimed.DefaultImpls.getLive((XTrackableLifetimed)this, $this$live);
        }

        @Override
        public <R> R live(@NotNull Property<? extends Function0<? extends R>> $this$live) {
            return XTrackableLifetimed.DefaultImpls.live(this, $this$live);
        }

        @Override
        public <T1, R> R live(@NotNull Property<? extends Function1<? super T1, ? extends R>> $this$live, T1 a1) {
            return XTrackableLifetimed.DefaultImpls.live(this, $this$live, a1);
        }

        @Override
        public <T1, T2, R> R live(@NotNull Property<? extends Function2<? super T1, ? super T2, ? extends R>> $this$live, T1 a1, T2 a2) {
            return XTrackableLifetimed.DefaultImpls.live(this, $this$live, a1, a2);
        }
    }
}

