/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.basics.AssertKt;
import libraries.basics.DebugCommonKt;
import libraries.klogging.GroupsKt;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import runtime.DispatchJvmKt;
import runtime.reactive.CellTracker;
import runtime.reactive.Effect;
import runtime.reactive.ReactionsKt;
import runtime.reactive.ReactionsNotEmptyAtStartOfAction;
import runtime.reactive.TransactionalReactionsScheduler;
import runtime.reactive.XTrackable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u001f\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lruntime/reactive/TransactionalReactionsScheduler;", "", "()V", "isTransaction", "", "scheduledEffects", "", "Lruntime/reactive/Effect;", "invokeTriggeredReactions", "", "schedule", "effect", "transaction", "T", "actionHandler", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "platform-ui"})
@SourceDebugExtension(value={"SMAP\nReactions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Reactions.kt\nruntime/reactive/TransactionalReactionsScheduler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 groupsCommon.kt\nlibraries/klogging/GroupsCommonKt\n+ 4 RichLogRecord.kt\nlibraries/klogging/RichLogRecordKt\n+ 5 KLogger.kt\nlibraries/klogging/KLogger\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,298:1\n1#2:299\n6#3,9:300\n16#3,4:317\n6#3,9:330\n16#3,4:347\n125#4,2:309\n128#4:316\n125#4,2:321\n128#4:328\n125#4,2:339\n128#4:346\n14#5,5:311\n14#5,5:323\n14#5,5:341\n70#5,5:351\n1855#6:329\n1856#6:356\n*S KotlinDebug\n*F\n+ 1 Reactions.kt\nruntime/reactive/TransactionalReactionsScheduler\n*L\n19#1:300,9\n19#1:317,4\n59#1:330,9\n59#1:347,4\n20#1:309,2\n20#1:316\n24#1:321,2\n24#1:328\n60#1:339,2\n60#1:346\n20#1:311,5\n24#1:323,5\n60#1:341,5\n64#1:351,5\n57#1:329\n57#1:356\n*E\n"})
public final class TransactionalReactionsScheduler {
    @NotNull
    public static final TransactionalReactionsScheduler INSTANCE = new TransactionalReactionsScheduler();
    @NotNull
    private static List<Effect> scheduledEffects = new ArrayList();
    private static boolean isTransaction;

    private TransactionalReactionsScheduler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void schedule(@NotNull Effect effect2) {
        Intrinsics.checkNotNullParameter((Object)effect2, (String)"effect");
        DispatchJvmKt.assertUIDispatcher();
        if (!isTransaction) {
            String string2;
            String string3 = DebugCommonKt.getDbgName(effect2);
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                string2 = "reaction(" + it + ") invoked immediately";
            } else {
                string2 = null;
            }
            String label$iv = string2;
            boolean collapsed$iv = true;
            boolean $i$f$logGroup = false;
            boolean $i$f$logGroupInline = false;
            if (label$iv != null) {
                GroupsKt.logGroupStart(label$iv, collapsed$iv);
            }
            try {
                void dbgName$iv;
                boolean bl = false;
                KLogger kLogger = ReactionsKt.access$getLog$p();
                String string4 = DebugCommonKt.getDbgName(effect2);
                Function1 msg$iv = schedule.2.1.INSTANCE;
                boolean $i$f$debug = false;
                if (dbgName$iv != null) {
                    void $this$debug$iv;
                    void this_$iv$iv = $this$debug$iv;
                    boolean $i$f$debug2 = false;
                    if (this_$iv$iv.isDebugEnabled()) {
                        boolean bl2 = false;
                        Object msgStr$iv$iv = msg$iv.invoke((Object)dbgName$iv);
                        this_$iv$iv.debug(msgStr$iv$iv);
                    }
                }
                effect2.invalidate();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                if (label$iv != null) {
                    GroupsKt.logGroupEnd(label$iv);
                }
            }
        } else {
            void dbgName$iv;
            KLogger label$iv = ReactionsKt.access$getLog$p();
            String collapsed$iv = DebugCommonKt.getDbgName(effect2);
            Function1 msg$iv = schedule.3.INSTANCE;
            boolean $i$f$debug = false;
            if (dbgName$iv != null) {
                void $this$debug$iv;
                void this_$iv$iv = $this$debug$iv;
                boolean $i$f$debug3 = false;
                if (this_$iv$iv.isDebugEnabled()) {
                    boolean bl = false;
                    Object msgStr$iv$iv = msg$iv.invoke((Object)dbgName$iv);
                    this_$iv$iv.debug(msgStr$iv$iv);
                }
            }
            if (!scheduledEffects.contains(effect2)) {
                scheduledEffects.add(effect2);
            } else {
                AssertKt.assert(!scheduledEffects.contains(effect2), "reaction is already scheduled");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <T> T transaction(@NotNull Function0<? extends T> actionHandler) {
        Object object;
        Intrinsics.checkNotNullParameter(actionHandler, (String)"actionHandler");
        DispatchJvmKt.assertUIDispatcher();
        if (!isTransaction) {
            void var2_2;
            if (!((Collection)scheduledEffects).isEmpty()) {
                throw new ReactionsNotEmptyAtStartOfAction();
            }
            isTransaction = true;
            Object result2 = null;
            try {
                result2 = CellTracker.INSTANCE.untrack((Function1)new Function1<XTrackable, T>(actionHandler){
                    final /* synthetic */ Function0<T> $actionHandler;
                    {
                        this.$actionHandler = $actionHandler;
                        super(1);
                    }

                    public final T invoke(@NotNull XTrackable $this$untrack) {
                        Intrinsics.checkNotNullParameter((Object)$this$untrack, (String)"$this$untrack");
                        return (T)this.$actionHandler.invoke();
                    }
                });
            }
            finally {
                this.invokeTriggeredReactions();
                isTransaction = false;
            }
            object = var2_2;
        } else {
            object = actionHandler.invoke();
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void invokeTriggeredReactions() {
        while (!((Collection)scheduledEffects).isEmpty()) {
            List<Effect> invokingReactions = scheduledEffects;
            scheduledEffects = new ArrayList();
            Iterable $this$forEach$iv = invokingReactions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Effect it = (Effect)element$iv;
                boolean bl = false;
                try {
                    String string2;
                    if (DebugCommonKt.getDbgName(it) != null) {
                        String it2;
                        boolean bl2 = false;
                        string2 = "reaction(" + it2 + ") invoked by scheduler";
                    } else {
                        string2 = null;
                    }
                    String label$iv = string2;
                    boolean collapsed$iv = true;
                    boolean $i$f$logGroup = false;
                    boolean $i$f$logGroupInline = false;
                    if (label$iv != null) {
                        GroupsKt.logGroupStart(label$iv, collapsed$iv);
                    }
                    try {
                        void dbgName$iv;
                        boolean bl3 = false;
                        KLogger kLogger = ReactionsKt.access$getLog$p();
                        String string3 = DebugCommonKt.getDbgName(it);
                        Function1 msg$iv = invokeTriggeredReactions.1.2.1.INSTANCE;
                        boolean $i$f$debug = false;
                        if (dbgName$iv != null) {
                            void $this$debug$iv;
                            void this_$iv$iv = $this$debug$iv;
                            boolean $i$f$debug2 = false;
                            if (this_$iv$iv.isDebugEnabled()) {
                                boolean bl4 = false;
                                Object msgStr$iv$iv = msg$iv.invoke((Object)dbgName$iv);
                                this_$iv$iv.debug(msgStr$iv$iv);
                            }
                        }
                        it.invalidate();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        if (label$iv == null) continue;
                        GroupsKt.logGroupEnd(label$iv);
                    }
                }
                catch (Throwable e) {
                    KLogger this_$iv = ReactionsKt.access$getLog$p();
                    boolean $i$f$error = false;
                    if (!this_$iv.isErrorEnabled()) continue;
                    boolean bl5 = false;
                    String msgStr$iv = "Failed to trigger reaction";
                    this_$iv.error(e, msgStr$iv);
                }
            }
        }
    }
}

