/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.embedder.ArtifactDescriptorRequestData;
import org.jetbrains.idea.maven.server.embedder.ArtifactDescriptorResultData;

public class CustomMaven36ArtifactDescriptorReader
implements ArtifactDescriptorReader {
    private final ArtifactDescriptorReader myWrapee;
    private final Map<ArtifactDescriptorRequestData, ArtifactDescriptorResultData> descriptorCache = new ConcurrentHashMap<ArtifactDescriptorRequestData, ArtifactDescriptorResultData>();

    public CustomMaven36ArtifactDescriptorReader(ArtifactDescriptorReader wrapee) {
        this.myWrapee = wrapee;
    }

    private ArtifactDescriptorResultData doReadArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) {
        try {
            return new ArtifactDescriptorResultData(this.myWrapee.readArtifactDescriptor(session, request), null);
        }
        catch (ArtifactDescriptorException e) {
            return new ArtifactDescriptorResultData(e.getResult(), e);
        }
    }

    @NotNull
    private static ArtifactDescriptorResult getResult(ArtifactDescriptorRequest request, ArtifactDescriptorResultData resultData) {
        ArtifactDescriptorResult result = new ArtifactDescriptorResult(request);
        result.setArtifact(resultData.getArtifact());
        result.setRepository(resultData.getRepository());
        result.setExceptions(resultData.getExceptions());
        result.setRelocations(resultData.getRelocations());
        result.setAliases(resultData.getAliases());
        result.setDependencies(resultData.getDependencies());
        result.setManagedDependencies(resultData.getManagedDependencies());
        result.setRepositories(resultData.getRepositories());
        result.setProperties(resultData.getProperties());
        ArtifactDescriptorResult artifactDescriptorResult = result;
        if (artifactDescriptorResult == null) {
            CustomMaven36ArtifactDescriptorReader.$$$reportNull$$$0(0);
        }
        return artifactDescriptorResult;
    }

    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        if (null == request) {
            return null;
        }
        ArtifactDescriptorRequestData requestData = new ArtifactDescriptorRequestData(request);
        ArtifactDescriptorResultData resultData = this.descriptorCache.computeIfAbsent(requestData, rd -> this.doReadArtifactDescriptor(session, request));
        if (null != resultData.getDescriptorException()) {
            throw resultData.getDescriptorException();
        }
        return CustomMaven36ArtifactDescriptorReader.getResult(request, resultData);
    }

    public void reset() {
        this.descriptorCache.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/embedder/CustomMaven36ArtifactDescriptorReader", "getResult"));
    }
}

