/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.evaluate;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValue;
import org.jetbrains.kotlin.analysis.api.components.KtConstantEvaluationMode;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.OperationsMapGeneratedKt;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\n*\u0006\u0012\u0002\b\u00030\nH\u0002J\u001c\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\n*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u001e\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010 \u001a\u00020!H\u0002J*\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010 \u001a\u00020!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J\u0016\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\nH\u0002J\u000e\u0010$\u001a\u0004\u0018\u00010%*\u00020\u0013H\u0002J\u0018\u0010&\u001a\u00020'\"\u0004\b\u0000\u0010(*\b\u0012\u0004\u0012\u0002H(0\u001dH\u0002J\u001a\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n*\u00020*2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n*\u00020+2\u0006\u0010\r\u001a\u00020\u000eH\u0002J2\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0\n\"\u0004\b\u0000\u0010(*\b\u0012\u0004\u0012\u0002H(0\u001d2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0002J\u001b\u0010.\u001a\u0006\u0012\u0002\b\u00030\u001d\"\u0004\b\u0000\u0010(*\u0002H(H\u0002\u00a2\u0006\u0002\u0010/J\u0012\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001d*\u00020\u0015H\u0002J\u0012\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001d*\u00020\u001bH\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006R\u0018\u0010\b\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator;", "", "()V", "isStringEquals", "", "Lorg/jetbrains/kotlin/name/CallableId;", "(Lorg/jetbrains/kotlin/name/CallableId;)Z", "isStringLength", "isStringPlus", "evaluate", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "fir", "Lorg/jetbrains/kotlin/fir/FirElement;", "mode", "Lorg/jetbrains/kotlin/analysis/api/components/KtConstantEvaluationMode;", "evaluateAsKtConstantValue", "Lorg/jetbrains/kotlin/analysis/api/base/KtConstantValue;", "evaluateFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "evaluateStringConcatenationCall", "", "stringConcatenationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "adaptToConstKind", "adjustType", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "convertToNumber", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "value", "", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "other", "evaluateStringLength", "getOriginalFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "toCompileTimeType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "T", "toConstExpression", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "toConstantValueKind", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/types/ConstantValueKind;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nFirCompileTimeConstantEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,384:1\n32#2:385\n24#2:386\n16#2:387\n44#3:388\n44#3:389\n*S KotlinDebug\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator\n*L\n86#1:385\n100#1:386\n100#1:387\n164#1:388\n184#1:389\n*E\n"})
public final class FirCompileTimeConstantEvaluator {
    @NotNull
    public static final FirCompileTimeConstantEvaluator INSTANCE = new FirCompileTimeConstantEvaluator();

    private FirCompileTimeConstantEvaluator() {
    }

    @Nullable
    public final FirConstExpression<?> evaluate(@Nullable FirElement fir, @NotNull KtConstantEvaluationMode mode) {
        FirConstExpression<Object> firConstExpression;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        FirElement firElement = fir;
        if (firElement instanceof FirPropertyAccessExpression) {
            FirVariableSymbol referredVariable = FirReferenceUtilsKt.toResolvedVariableSymbol$default(((FirPropertyAccessExpression)fir).getCalleeReference(), false, 1, null);
            if (referredVariable instanceof FirPropertySymbol) {
                if (this.isStringLength(referredVariable.getCallableId())) {
                    FirConstExpression<?> firConstExpression2 = this.evaluate(((FirPropertyAccessExpression)fir).getExplicitReceiver(), mode);
                    firConstExpression = firConstExpression2 != null ? this.evaluateStringLength(firConstExpression2) : null;
                } else {
                    firConstExpression = this.toConstExpression((FirPropertySymbol)referredVariable, mode);
                }
            } else {
                firConstExpression = referredVariable instanceof FirFieldSymbol ? this.toConstExpression((FirFieldSymbol)referredVariable, mode) : null;
            }
        } else if (firElement instanceof FirConstExpression) {
            firConstExpression = this.adaptToConstKind((FirConstExpression)fir);
        } else if (firElement instanceof FirFunctionCall) {
            firConstExpression = this.evaluateFunctionCall((FirFunctionCall)fir, mode);
        } else if (firElement instanceof FirStringConcatenationCall) {
            firConstExpression = this.evaluateStringConcatenationCall((FirStringConcatenationCall)fir, mode);
        } else if (firElement instanceof FirNamedReference) {
            FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)fir, false, 1, null);
            firConstExpression = firPropertySymbol != null ? this.toConstExpression(firPropertySymbol, mode) : null;
        } else {
            firConstExpression = null;
        }
        return firConstExpression;
    }

    private final boolean isStringLength(CallableId $this$isStringLength) {
        return Intrinsics.areEqual((Object)$this$isStringLength.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringLength.getCallableName().getIdentifierOrNullIfSpecial(), (Object)"length");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FirConstExpression<?> toConstExpression(FirPropertySymbol $this$toConstExpression, KtConstantEvaluationMode mode) {
        if (mode == KtConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION) {
            FirCallableSymbol $this$isConst$iv = $this$toConstExpression;
            boolean $i$f$isConst = false;
            if (!$this$isConst$iv.getRawStatus().isConst()) {
                return null;
            }
        }
        if (!$this$toConstExpression.isVal()) return null;
        if (!$this$toConstExpression.getHasInitializer()) return null;
        FirLazyDeclarationResolverKt.lazyResolveToPhase($this$toConstExpression, FirResolvePhase.BODY_RESOLVE);
        FirConstExpression<?> firConstExpression = this.evaluate(((FirProperty)$this$toConstExpression.getFir()).getInitializer(), mode);
        return firConstExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FirConstExpression<?> toConstExpression(FirFieldSymbol $this$toConstExpression, KtConstantEvaluationMode mode) {
        if (mode == KtConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION) {
            FirCallableSymbol $this$isStatic$iv = $this$toConstExpression;
            boolean $i$f$isStatic = false;
            if (!$this$isStatic$iv.getRawStatus().isStatic()) return null;
            FirCallableSymbol $this$isFinal$iv = $this$toConstExpression;
            boolean $i$f$isFinal = false;
            if ($this$isFinal$iv.getResolvedStatus().getModality() != Modality.FINAL) return null;
            boolean bl = true;
            if (!bl) {
                return null;
            }
        }
        if (!$this$toConstExpression.isVal()) return null;
        if (!$this$toConstExpression.getHasInitializer()) return null;
        FirConstExpression<?> firConstExpression = this.evaluate(((FirField)$this$toConstExpression.getFir()).getInitializer(), mode);
        return firConstExpression;
    }

    @Nullable
    public final KtConstantValue evaluateAsKtConstantValue(@NotNull FirElement fir, @NotNull KtConstantEvaluationMode mode) {
        KtConstantValue ktConstantValue;
        Intrinsics.checkNotNullParameter((Object)fir, (String)"fir");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        FirConstExpression<?> firConstExpression = this.evaluate(fir, mode);
        if (firConstExpression == null) {
            return null;
        }
        FirConstExpression<?> evaluated = firConstExpression;
        Object value2 = evaluated.getValue();
        ConstantValueKind<?> constantValueKind = UtilsKt.getPsi(evaluated);
        KtElement psi2 = constantValueKind instanceof KtElement ? (KtElement)constantValueKind : null;
        constantValueKind = evaluated.getKind();
        if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Byte");
            ktConstantValue = new KtConstantValue.KtByteConstantValue((Byte)value2, psi2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Int");
            ktConstantValue = new KtConstantValue.KtIntConstantValue((Integer)value2, psi2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Long");
            ktConstantValue = new KtConstantValue.KtLongConstantValue((Long)value2, psi2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Short");
            ktConstantValue = new KtConstantValue.KtShortConstantValue((Short)value2, psi2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.UByte");
            ktConstantValue = new KtConstantValue.KtUnsignedByteConstantValue(((UByte)value2).unbox-impl(), psi2, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.UInt");
            ktConstantValue = new KtConstantValue.KtUnsignedIntConstantValue(((UInt)value2).unbox-impl(), psi2, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.ULong");
            ktConstantValue = new KtConstantValue.KtUnsignedLongConstantValue(((ULong)value2).unbox-impl(), psi2, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.UShort");
            ktConstantValue = new KtConstantValue.KtUnsignedShortConstantValue(((UShort)value2).unbox-impl(), psi2, null);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Double");
            ktConstantValue = new KtConstantValue.KtDoubleConstantValue((Double)value2, psi2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Float");
            ktConstantValue = new KtConstantValue.KtFloatConstantValue(((Float)value2).floatValue(), psi2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Boolean");
            ktConstantValue = new KtConstantValue.KtBooleanConstantValue((Boolean)value2, psi2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Char.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Char");
            ktConstantValue = new KtConstantValue.KtCharConstantValue(((Character)value2).charValue(), psi2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.String.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.String");
            ktConstantValue = new KtConstantValue.KtStringConstantValue((String)value2, psi2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Null.INSTANCE)) {
            ktConstantValue = new KtConstantValue.KtNullConstantValue(psi2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.IntegerLiteral.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.Long");
            long l = (Long)value2;
            ktConstantValue = Integer.MIN_VALUE < l && l < Integer.MAX_VALUE ? (KtConstantValue)new KtConstantValue.KtIntConstantValue((int)l, psi2) : (KtConstantValue)new KtConstantValue.KtLongConstantValue(l, psi2);
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE)) {
            Intrinsics.checkNotNull(value2, (String)"null cannot be cast to non-null type kotlin.ULong");
            long l = ((ULong)value2).unbox-impl();
            ktConstantValue = Long.compareUnsigned(ULong.constructor-impl((long)(0L & 0xFFFFFFFFL)), l) < 0 && Long.compareUnsigned(l, ULong.constructor-impl((long)((long)-1 & 0xFFFFFFFFL))) < 0 ? (KtConstantValue)new KtConstantValue.KtUnsignedIntConstantValue(UInt.constructor-impl((int)((int)l)), psi2, null) : (KtConstantValue)new KtConstantValue.KtUnsignedLongConstantValue(l, psi2, null);
        } else {
            if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Error.INSTANCE)) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("Should not be possible to get from FIR tree", null, fir, null, null, null, 58, null);
                throw null;
            }
            throw new NoWhenBranchMatchedException();
        }
        return ktConstantValue;
    }

    private final FirConstExpression<?> adaptToConstKind(FirConstExpression<?> $this$adaptToConstKind) {
        Object obj;
        ConstantValueKind<?> constantValueKind = $this$adaptToConstKind.getKind();
        KtSourceElement ktSourceElement = $this$adaptToConstKind.getSource();
        Object object = this.convertToNumber($this$adaptToConstKind.getKind(), (obj = $this$adaptToConstKind.getValue()) instanceof Number ? (Number)((Number)obj) : (Number)null);
        if (object == null) {
            object = $this$adaptToConstKind.getValue();
        }
        return this.toConstExpression(constantValueKind, ktSourceElement, object);
    }

    private final FirConstExpression<String> evaluateStringConcatenationCall(FirStringConcatenationCall stringConcatenationCall, KtConstantEvaluationMode mode) {
        StringBuilder stringBuilder;
        StringBuilder $this$evaluateStringConcatenationCall_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        FirCall $this$arguments$iv = stringConcatenationCall;
        boolean $i$f$getArguments = false;
        for (FirExpression arg : $this$arguments$iv.getArgumentList().getArguments()) {
            FirConstExpression<?> evaluated;
            if (INSTANCE.evaluate(arg, mode) == null) {
                return null;
            }
            $this$evaluateStringConcatenationCall_u24lambda_u240.append(String.valueOf(evaluated.getValue()));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String concatenated = string;
        return this.toConstExpression((ConstantValueKind)ConstantValueKind.String.INSTANCE, stringConcatenationCall.getSource(), concatenated);
    }

    private final FirConstExpression<?> evaluateFunctionCall(FirFunctionCall functionCall, KtConstantEvaluationMode mode) {
        FirPureAbstractElement firPureAbstractElement = this.getOriginalFunction(functionCall);
        FirSimpleFunction firSimpleFunction = firPureAbstractElement instanceof FirSimpleFunction ? (FirSimpleFunction)firPureAbstractElement : null;
        if (firSimpleFunction == null) {
            return null;
        }
        FirSimpleFunction function2 = firSimpleFunction;
        FirConstExpression<?> firConstExpression = this.evaluate(functionCall.getExplicitReceiver(), mode);
        if (firConstExpression == null) {
            return null;
        }
        FirConstExpression<?> opr1 = firConstExpression;
        firPureAbstractElement = this.evaluate(opr1, function2);
        if (firPureAbstractElement != null) {
            FirPureAbstractElement it = firPureAbstractElement;
            boolean bl = false;
            return INSTANCE.adjustType((FirConstExpression<?>)it, FirTypeUtilsKt.getResolvedType(functionCall));
        }
        FirCall $this$arguments$iv = functionCall;
        boolean $i$f$getArguments = false;
        FirExpression firExpression2 = (FirExpression)CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
        if (firExpression2 == null) {
            return null;
        }
        FirExpression argument2 = firExpression2;
        FirConstExpression<?> firConstExpression2 = this.evaluate(argument2, mode);
        if (firConstExpression2 == null) {
            return null;
        }
        FirConstExpression<?> opr2 = firConstExpression2;
        FirConstExpression<?> firConstExpression3 = this.evaluate(opr1, function2, opr2);
        if (firConstExpression3 != null) {
            FirConstExpression<?> it = firConstExpression3;
            boolean bl = false;
            return INSTANCE.adjustType(it, FirTypeUtilsKt.getResolvedType(functionCall));
        }
        return null;
    }

    private final FirConstExpression<?> adjustType(FirConstExpression<?> $this$adjustType, ConeKotlinType expectedType) {
        FirConstExpression<?> expression2;
        FirConstExpression<?> firConstExpression;
        FirConstExpression<?> firConstExpression2;
        ConstantValueKind<?> expectedKind = this.toConstantValueKind((Object)expectedType);
        if (expectedKind != null && !Intrinsics.areEqual(expectedKind, $this$adjustType.getKind()) && $this$adjustType.getValue() instanceof Number) {
            Object obj = $this$adjustType.getValue();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
            Object object = this.convertToNumber(expectedKind, (Number)obj);
            Intrinsics.checkNotNull((Object)object);
            Object typeAdjustedValue = object;
            firConstExpression2 = this.toConstExpression(expectedKind, $this$adjustType.getSource(), typeAdjustedValue);
        } else {
            firConstExpression2 = $this$adjustType;
        }
        FirConstExpression<?> $this$adjustType_u24lambda_u243 = firConstExpression = (expression2 = firConstExpression2);
        boolean bl = false;
        $this$adjustType_u24lambda_u243.replaceConeTypeOrNull(expectedType);
        return firConstExpression;
    }

    private final <T> CompileTimeType toCompileTimeType(ConstantValueKind<T> $this$toCompileTimeType) {
        ConstantValueKind<T> constantValueKind = $this$toCompileTimeType;
        return Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE) ? CompileTimeType.BYTE : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE) ? CompileTimeType.SHORT : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE) ? CompileTimeType.INT : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE) ? CompileTimeType.LONG : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE) ? CompileTimeType.DOUBLE : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE) ? CompileTimeType.FLOAT : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Char.INSTANCE) ? CompileTimeType.CHAR : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE) ? CompileTimeType.BOOLEAN : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.String.INSTANCE) ? CompileTimeType.STRING : CompileTimeType.ANY))))))));
    }

    private final FirConstExpression<?> evaluate(FirConstExpression<?> $this$evaluate, FirSimpleFunction function2) {
        FirConstExpression<?> firConstExpression;
        Object object;
        Object opr;
        if ($this$evaluate.getValue() == null) {
            return null;
        }
        Object obj = $this$evaluate.getValue();
        String string = obj instanceof String ? (String)obj : null;
        if (string != null) {
            opr = string;
            boolean bl = false;
            String string2 = function2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            object = OperationsMapGeneratedKt.evalUnaryOp((String)string2, (CompileTimeType)INSTANCE.toCompileTimeType($this$evaluate.getKind()), (Object)opr);
            if (object != null) {
                Object it = object;
                boolean bl2 = false;
                return INSTANCE.toConstExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
            }
        }
        Object object2 = this.convertToNumber($this$evaluate.getKind(), (obj = $this$evaluate.getValue()) instanceof Number ? (Number)((Number)obj) : (Number)null);
        if (object2 != null) {
            opr = object2;
            boolean bl = false;
            String string3 = function2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
            object = OperationsMapGeneratedKt.evalUnaryOp((String)string3, (CompileTimeType)INSTANCE.toCompileTimeType($this$evaluate.getKind()), (Object)opr);
            if (object != null) {
                Object it = object;
                boolean bl3 = false;
                firConstExpression = INSTANCE.toConstExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
            } else {
                firConstExpression = null;
            }
        } else {
            firConstExpression = null;
        }
        return firConstExpression;
    }

    private final FirConstExpression<?> evaluateStringLength(FirConstExpression<?> $this$evaluateStringLength) {
        FirConstExpression<?> firConstExpression;
        Object obj = $this$evaluateStringLength.getValue();
        String string = obj instanceof String ? (String)obj : null;
        if (string != null) {
            int it = string.length();
            boolean bl = false;
            firConstExpression = INSTANCE.toConstExpression(INSTANCE.toConstantValueKind(it), $this$evaluateStringLength.getSource(), it);
        } else {
            firConstExpression = null;
        }
        return firConstExpression;
    }

    private final FirConstExpression<?> evaluate(FirConstExpression<?> $this$evaluate, FirSimpleFunction function2, FirConstExpression<?> other2) {
        FirConstExpression<?> firConstExpression;
        Object opr1;
        if ($this$evaluate.getValue() == null || other2.getValue() == null) {
            return null;
        }
        CompileTimeType rightType = this.isStringEquals(function2.getSymbol().getCallableId()) ? CompileTimeType.ANY : (this.isStringPlus(function2.getSymbol().getCallableId()) ? CompileTimeType.ANY : this.toCompileTimeType(other2.getKind()));
        Object obj = $this$evaluate.getValue();
        String string = obj instanceof String ? (String)obj : null;
        if (string != null) {
            opr1 = string;
            boolean bl = false;
            Object obj2 = other2.getValue();
            if (obj2 != null) {
                Object opr2 = obj2;
                boolean bl2 = false;
                String string2 = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                Object object = OperationsMapGeneratedKt.evalBinaryOp((String)string2, (CompileTimeType)INSTANCE.toCompileTimeType($this$evaluate.getKind()), (Object)opr1, (CompileTimeType)rightType, opr2);
                if (object != null) {
                    Object it = object;
                    boolean bl3 = false;
                    return INSTANCE.toConstExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
                }
            }
        }
        obj = $this$evaluate.getValue();
        Object object = this.convertToNumber($this$evaluate.getKind(), obj instanceof Number ? (Number)((Number)obj) : (Number)null);
        if (object != null) {
            Object obj3;
            opr1 = object;
            boolean bl = false;
            Object object2 = INSTANCE.convertToNumber(other2.getKind(), (obj3 = other2.getValue()) instanceof Number ? (Number)((Number)obj3) : (Number)null);
            if (object2 != null) {
                Object opr2 = object2;
                boolean bl4 = false;
                String string3 = function2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                Object object3 = OperationsMapGeneratedKt.evalBinaryOp((String)string3, (CompileTimeType)INSTANCE.toCompileTimeType($this$evaluate.getKind()), (Object)opr1, (CompileTimeType)INSTANCE.toCompileTimeType(other2.getKind()), (Object)opr2);
                if (object3 != null) {
                    Object it = object3;
                    boolean bl5 = false;
                    firConstExpression = INSTANCE.toConstExpression(INSTANCE.toConstantValueKind(it), $this$evaluate.getSource(), it);
                } else {
                    firConstExpression = null;
                }
            } else {
                firConstExpression = null;
            }
        } else {
            firConstExpression = null;
        }
        return firConstExpression;
    }

    private final boolean isStringEquals(CallableId $this$isStringEquals) {
        return Intrinsics.areEqual((Object)$this$isStringEquals.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringEquals.getCallableName().getIdentifierOrNullIfSpecial(), (Object)"equals");
    }

    private final boolean isStringPlus(CallableId $this$isStringPlus) {
        return Intrinsics.areEqual((Object)$this$isStringPlus.getClassId(), (Object)StandardClassIds.INSTANCE.getString()) && Intrinsics.areEqual((Object)$this$isStringPlus.getCallableName().getIdentifierOrNullIfSpecial(), (Object)"plus");
    }

    private final ConstantValueKind<?> toConstantValueKind(ConeKotlinType $this$toConstantValueKind) {
        Object object;
        ConeKotlinType coneKotlinType = $this$toConstantValueKind;
        if (coneKotlinType instanceof ConeErrorType) {
            object = null;
        } else if (coneKotlinType instanceof ConeLookupTagBasedType) {
            String string = ((ConeLookupTagBasedType)$this$toConstantValueKind).getLookupTag().getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            object = this.toConstantValueKind((Object)string);
        } else if (coneKotlinType instanceof ConeFlexibleType) {
            object = this.toConstantValueKind((Object)((ConeFlexibleType)$this$toConstantValueKind).getUpperBound());
        } else if (coneKotlinType instanceof ConeCapturedType) {
            object = ((ConeCapturedType)$this$toConstantValueKind).getLowerType();
            if (object == null || (object = this.toConstantValueKind(object)) == null) {
                List<ConeKotlinType> list2 = ((ConeCapturedType)$this$toConstantValueKind).getConstructor().getSupertypes();
                Intrinsics.checkNotNull(list2);
                object = this.toConstantValueKind((Object)((ConeKotlinType)CollectionsKt.first(list2)));
            }
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            object = this.toConstantValueKind((Object)((ConeDefinitelyNotNullType)$this$toConstantValueKind).getOriginal());
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            object = this.toConstantValueKind((Object)((ConeKotlinType)CollectionsKt.first((Iterable)((ConeIntersectionType)$this$toConstantValueKind).getIntersectedTypes())));
        } else if (coneKotlinType instanceof ConeStubType) {
            object = null;
        } else if (coneKotlinType instanceof ConeIntegerLiteralType) {
            object = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final ConstantValueKind<?> toConstantValueKind(String $this$toConstantValueKind) {
        ConstantValueKind constantValueKind;
        switch ($this$toConstantValueKind) {
            case "Byte": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Byte.INSTANCE;
                break;
            }
            case "Double": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Double.INSTANCE;
                break;
            }
            case "Float": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Float.INSTANCE;
                break;
            }
            case "Int": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Int.INSTANCE;
                break;
            }
            case "Long": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Long.INSTANCE;
                break;
            }
            case "Short": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Short.INSTANCE;
                break;
            }
            case "Char": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Char.INSTANCE;
                break;
            }
            case "String": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.String.INSTANCE;
                break;
            }
            case "Boolean": {
                constantValueKind = (ConstantValueKind)ConstantValueKind.Boolean.INSTANCE;
                break;
            }
            default: {
                constantValueKind = null;
            }
        }
        return constantValueKind;
    }

    private final <T> ConstantValueKind<?> toConstantValueKind(T $this$toConstantValueKind) {
        ConstantValueKind constantValueKind;
        T t = $this$toConstantValueKind;
        if (t instanceof Byte) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Byte.INSTANCE;
        } else if (t instanceof Double) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Double.INSTANCE;
        } else if (t instanceof Float) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Float.INSTANCE;
        } else if (t instanceof Integer) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Int.INSTANCE;
        } else if (t instanceof Long) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Long.INSTANCE;
        } else if (t instanceof Short) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Short.INSTANCE;
        } else if (t instanceof Character) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Char.INSTANCE;
        } else if (t instanceof String) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.String.INSTANCE;
        } else if (t instanceof Boolean) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Boolean.INSTANCE;
        } else if (t == null) {
            constantValueKind = (ConstantValueKind)ConstantValueKind.Null.INSTANCE;
        } else {
            throw new IllegalStateException("Unknown constant value".toString());
        }
        return constantValueKind;
    }

    private final Object convertToNumber(ConstantValueKind<?> $this$convertToNumber, Number value2) {
        if (value2 == null) {
            return null;
        }
        ConstantValueKind<?> constantValueKind = $this$convertToNumber;
        return Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE) ? (Comparable)Byte.valueOf(value2.byteValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Double.INSTANCE) ? (Comparable)Double.valueOf(value2.doubleValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Float.INSTANCE) ? (Comparable)Float.valueOf(value2.floatValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Int.INSTANCE) ? (Comparable)Integer.valueOf(value2.intValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Long.INSTANCE) ? (Comparable)Long.valueOf(value2.longValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Short.INSTANCE) ? (Comparable)Short.valueOf(value2.shortValue()) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE) ? UByte.box-impl((byte)UByte.constructor-impl((byte)((byte)value2.longValue()))) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE) ? UShort.box-impl((short)UShort.constructor-impl((short)((short)value2.longValue()))) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE) ? UInt.box-impl((int)UInt.constructor-impl((int)((int)value2.longValue()))) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE) ? ULong.box-impl((long)ULong.constructor-impl((long)value2.longValue())) : (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE) ? ULong.box-impl((long)ULong.constructor-impl((long)value2.longValue())) : null))))))))));
    }

    private final <T> FirConstExpression<T> toConstExpression(ConstantValueKind<T> $this$toConstExpression, KtSourceElement source, Object value2) {
        return FirConstExpressionBuilderKt.buildConstExpression$default(source, $this$toConstExpression, value2, null, false, 8, null);
    }

    private final FirCallableDeclaration getOriginalFunction(FirFunctionCall $this$getOriginalFunction) {
        FirBasedSymbol<?> symbol2;
        FirNamedReference reference2 = $this$getOriginalFunction.getCalleeReference();
        FirBasedSymbol<?> firBasedSymbol = symbol2 = reference2 instanceof FirResolvedNamedReference ? ((FirResolvedNamedReference)reference2).getResolvedSymbol() : null;
        Object obj = firBasedSymbol != null ? firBasedSymbol.getFir() : null;
        return obj instanceof FirCallableDeclaration ? (FirCallableDeclaration)obj : null;
    }
}

