/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.providers.KotlinPackageProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0016H\u0016J2\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u0016H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinPackageProviderBase;", "Lorg/jetbrains/kotlin/analysis/providers/KotlinPackageProvider;", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSearchScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "doesPackageExist", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "doesPlatformSpecificPackageExist", "getPlatformSpecificSubPackagesFqNames", "", "Lorg/jetbrains/kotlin/name/Name;", "nameFilter", "Lkotlin/Function1;", "getSubPackageFqNames", "analysis-api-providers"})
@SourceDebugExtension(value={"SMAP\nKotlinPackageProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPackageProviderBase.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinPackageProviderBase\n+ 2 implUtils.kt\norg/jetbrains/kotlin/analysis/providers/impl/ImplUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n12#2,7:80\n12#2,5:87\n18#2:93\n1#3:92\n*S KotlinDebug\n*F\n+ 1 KotlinPackageProviderBase.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinPackageProviderBase\n*L\n31#1:80,7\n62#1:87,5\n62#1:93\n*E\n"})
public abstract class KotlinPackageProviderBase
extends KotlinPackageProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final GlobalSearchScope searchScope;

    public KotlinPackageProviderBase(@NotNull Project project2, @NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        this.project = project2;
        this.searchScope = searchScope2;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final GlobalSearchScope getSearchScope() {
        return this.searchScope;
    }

    @Override
    public boolean doesPackageExist(@NotNull FqName packageFqName, @NotNull TargetPlatform platform2) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)platform2, (String)"platform");
        return this.doesPlatformSpecificPackageExist(packageFqName, platform2) || this.doesKotlinOnlyPackageExist(packageFqName);
    }

    @Override
    public boolean doesPlatformSpecificPackageExist(@NotNull FqName packageFqName, @NotNull TargetPlatform platform2) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)platform2, (String)"platform");
        if (JvmPlatformKt.isJvm((TargetPlatform)platform2)) {
            String string = packageFqName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String fqNameString = string;
            Project project$iv = this.project;
            boolean $i$f$forEachNonKotlinPsiElementFinder = false;
            for (PsiElementFinder finder$iv : PsiElementFinder.EP.getPoint((AreaInstance)project$iv).getExtensionList()) {
                if (Intrinsics.areEqual((Object)finder$iv.getClass().getName(), (Object)"org.jetbrains.kotlin.asJava.finder.JavaElementFinder")) continue;
                Intrinsics.checkNotNull((Object)finder$iv);
                PsiElementFinder finder = finder$iv;
                boolean bl = false;
                PsiPackage psiPackage = finder.findPackage(fqNameString);
                if (psiPackage == null) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<Name> getSubPackageFqNames(@NotNull FqName packageFqName, @NotNull TargetPlatform platform2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Set set2;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)platform2, (String)"platform");
        Intrinsics.checkNotNullParameter(nameFilter2, (String)"nameFilter");
        Set $this$getSubPackageFqNames_u24lambda_u241 = set2 = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$getSubPackageFqNames_u24lambda_u241.addAll((Collection)this.getKotlinOnlySubPackagesFqNames(packageFqName, nameFilter2));
        $this$getSubPackageFqNames_u24lambda_u241.addAll((Collection)this.getPlatformSpecificSubPackagesFqNames(packageFqName, platform2, nameFilter2));
        return SetsKt.build((Set)set2);
    }

    @Override
    @NotNull
    public Set<Name> getPlatformSpecificSubPackagesFqNames(@NotNull FqName packageFqName, @NotNull TargetPlatform platform2, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Set set2;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)platform2, (String)"platform");
        Intrinsics.checkNotNullParameter(nameFilter2, (String)"nameFilter");
        if (JvmPlatformKt.isJvm((TargetPlatform)platform2)) {
            Set set3;
            String string = packageFqName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String fqNameString = string;
            Set $this$getPlatformSpecificSubPackagesFqNames_u24lambda_u243 = set3 = SetsKt.createSetBuilder();
            boolean bl = false;
            Project project$iv = this.project;
            boolean $i$f$forEachNonKotlinPsiElementFinder = false;
            for (PsiElementFinder finder$iv : PsiElementFinder.EP.getPoint((AreaInstance)project$iv).getExtensionList()) {
                if (Intrinsics.areEqual((Object)finder$iv.getClass().getName(), (Object)"org.jetbrains.kotlin.asJava.finder.JavaElementFinder")) continue;
                Intrinsics.checkNotNull((Object)finder$iv);
                PsiElementFinder finder = finder$iv;
                boolean bl2 = false;
                PsiPackage[] psiPackageArray = finder.findPackage(fqNameString);
                if (psiPackageArray == null) continue;
                PsiPackage[] psiPackageArray2 = psiPackageArray;
                Intrinsics.checkNotNull((Object)psiPackageArray2);
                PsiPackage[] psiPackage = psiPackageArray2;
                PsiPackage[] psiPackageArray3 = finder.getSubPackages((PsiPackage)psiPackage, this.searchScope);
                Intrinsics.checkNotNullExpressionValue((Object)psiPackageArray3, (String)"getSubPackages(...)");
                for (PsiPackage subPackage : psiPackageArray3) {
                    String string2 = subPackage.getName();
                    if (string2 == null) continue;
                    String p0 = string2;
                    boolean bl3 = false;
                    Name name2 = Name.identifierIfValid((String)p0);
                    string2 = name2;
                    if (name2 == null) {
                        continue;
                    }
                    String string3 = string2;
                    Intrinsics.checkNotNull((Object)string3);
                    String name3 = string3;
                    if (!((Boolean)nameFilter2.invoke((Object)name3)).booleanValue()) continue;
                    $this$getPlatformSpecificSubPackagesFqNames_u24lambda_u243.add(name3);
                }
            }
            set2 = SetsKt.build((Set)set3);
        } else {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }
}

