/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.console.CommandHistory;
import org.jetbrains.kotlin.console.HistoryUpdater;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/console/CommandExecutor;", "", "runner", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "(Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;)V", "commandHistory", "Lorg/jetbrains/kotlin/console/CommandHistory;", "historyUpdater", "Lorg/jetbrains/kotlin/console/HistoryUpdater;", "executeCommand", "", "getTrimmedCommandText", "", "sendCommandToProcess", "command", "kotlin.repl"})
public final class CommandExecutor {
    @NotNull
    private final KotlinConsoleRunner runner;
    @NotNull
    private final CommandHistory commandHistory;
    @NotNull
    private final HistoryUpdater historyUpdater;

    public CommandExecutor(@NotNull KotlinConsoleRunner runner) {
        Intrinsics.checkNotNullParameter((Object)((Object)runner), (String)"runner");
        this.runner = runner;
        this.commandHistory = this.runner.getCommandHistory();
        this.historyUpdater = new HistoryUpdater(this.runner);
    }

    public final void executeCommand() {
        WriteCommandAction.runWriteCommandAction((Project)this.runner.getProject(), () -> CommandExecutor.executeCommand$lambda$0(this));
    }

    private final String getTrimmedCommandText() {
        LanguageConsoleView consoleView2 = this.runner.getConsoleView();
        Document document = consoleView2.getEditorDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getEditorDocument(...)");
        Document document2 = document;
        String string = document2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private final void sendCommandToProcess(String command2) {
        ProcessHandler processHandler = this.runner.getProcessHandler();
        OutputStream outputStream = processHandler.getProcessInput();
        if (outputStream == null) {
            RunExecuteActionsKt.logError$default(this.getClass(), "<p>Broken process stream</p>", null, 4, null);
            return;
        }
        OutputStream processInputOS = outputStream;
        Object object = processHandler instanceof BaseOSProcessHandler ? (BaseOSProcessHandler)processHandler : null;
        if (object == null || (object = object.getCharset()) == null) {
            object = Charsets.UTF_8;
        }
        Object object2 = object;
        Intrinsics.checkNotNull((Object)object2);
        Object charset = object2;
        String xmlRes = ReplUtilKt.replInputAsXml((String)command2);
        byte[] byArray = (xmlRes + "\n").getBytes((Charset)charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bytes2 = byArray;
        processInputOS.write(bytes2);
        processInputOS.flush();
    }

    private static final void executeCommand$lambda$0(CommandExecutor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String commandText = this$0.getTrimmedCommandText();
        if (((CharSequence)commandText).length() == 0) {
            return;
        }
        TextRange historyDocumentRange = this$0.historyUpdater.printNewCommandInHistory(commandText);
        this$0.commandHistory.addEntry(new CommandHistory.Entry(commandText, historyDocumentRange));
        this$0.sendCommandToProcess(commandText);
    }
}

