/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.Check;
import org.jetbrains.kotlin.fir.declarations.Checks;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0014J(\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00170\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0005R\u0011\u0010\n\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0005R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0005R\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0005\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/Checks;", "", "()V", "isKProperty", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "()Lorg/jetbrains/kotlin/fir/declarations/Check;", "kPropertyType", "Lorg/jetbrains/kotlin/fir/types/impl/ConeClassLikeTypeImpl;", "member", "getMember", "memberOrExtension", "getMemberOrExtension", "noDefaultAndVarargs", "getNoDefaultAndVarargs", "nonSuspend", "getNonSuspend", "full", "message", "", "predicate", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "", "simple", "Returns", "ValueParametersCount", "providers"})
final class Checks {
    @NotNull
    public static final Checks INSTANCE = new Checks();
    @NotNull
    private static final Check memberOrExtension = INSTANCE.simple("must be a member or an extension function", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)memberOrExtension.1.INSTANCE));
    @NotNull
    private static final Check member = INSTANCE.simple("must be a member function", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)member.1.INSTANCE));
    @NotNull
    private static final Check nonSuspend = INSTANCE.simple("must not be suspend", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)nonSuspend.1.INSTANCE));
    @NotNull
    private static final Check noDefaultAndVarargs = INSTANCE.simple("should not have varargs or parameters with default values", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)noDefaultAndVarargs.1.INSTANCE));
    @NotNull
    private static final ConeClassLikeTypeImpl kPropertyType;
    @NotNull
    private static final Check isKProperty;

    private Checks() {
    }

    @NotNull
    public final Check simple(@NotNull String message2, @NotNull Function2<? super FirSimpleFunction, ? super FirSession, Boolean> predicate2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
        return new Check(message2, predicate2){
            final /* synthetic */ String $message;
            final /* synthetic */ Function2<FirSimpleFunction, FirSession, Boolean> $predicate;
            {
                this.$message = $message;
                this.$predicate = $predicate;
            }

            @Nullable
            public String check(@NotNull FirSimpleFunction function2, @NotNull FirSession session2, @Nullable ScopeSession scopeSession) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
                String string = this.$message;
                Function2<FirSimpleFunction, FirSession, Boolean> function22 = this.$predicate;
                String it = string;
                boolean bl = false;
                return (Boolean)function22.invoke((Object)function2, (Object)((Object)session2)) == false ? string : null;
            }
        };
    }

    @NotNull
    public final Check full(@NotNull String message2, @NotNull Function2<? super FirSession, ? super FirSimpleFunction, Boolean> predicate2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
        return new Check(message2, predicate2){
            final /* synthetic */ String $message;
            final /* synthetic */ Function2<FirSession, FirSimpleFunction, Boolean> $predicate;
            {
                this.$message = $message;
                this.$predicate = $predicate;
            }

            @Nullable
            public String check(@NotNull FirSimpleFunction function2, @NotNull FirSession session2, @Nullable ScopeSession scopeSession) {
                Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
                String string = this.$message;
                Function2<FirSession, FirSimpleFunction, Boolean> function22 = this.$predicate;
                String it = string;
                boolean bl = false;
                return (Boolean)function22.invoke((Object)((Object)session2), (Object)function2) == false ? string : null;
            }
        };
    }

    @NotNull
    public final Check getMemberOrExtension() {
        return memberOrExtension;
    }

    @NotNull
    public final Check getMember() {
        return member;
    }

    @NotNull
    public final Check getNonSuspend() {
        return nonSuspend;
    }

    @NotNull
    public final Check getNoDefaultAndVarargs() {
        return noDefaultAndVarargs;
    }

    @NotNull
    public final Check isKProperty() {
        return isKProperty;
    }

    public static final /* synthetic */ ConeClassLikeTypeImpl access$getKPropertyType$p() {
        return kPropertyType;
    }

    static {
        ConeStarProjection[] coneStarProjectionArray = new ConeStarProjection[]{ConeStarProjection.INSTANCE};
        kPropertyType = new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(StandardClassIds.INSTANCE.getKProperty()), coneStarProjectionArray, false, null, 8, null);
        isKProperty = INSTANCE.full("second parameter must be of type KProperty<*> or its supertype", (Function2<? super FirSession, ? super FirSimpleFunction, Boolean>)((Function2)isKProperty.1.INSTANCE));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/Checks$Returns;", "", "()V", "boolean", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "getBoolean", "()Lorg/jetbrains/kotlin/fir/declarations/Check;", "int", "getInt", "unit", "getUnit", "providers"})
    public static final class Returns {
        @NotNull
        public static final Returns INSTANCE = new Returns();
        @NotNull
        private static final Check boolean = INSTANCE.simple("must return Boolean", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)boolean.1.INSTANCE));
        @NotNull
        private static final Check int = INSTANCE.simple("must return Int", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)int.1.INSTANCE));
        @NotNull
        private static final Check unit = INSTANCE.simple("must return Unit", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)unit.1.INSTANCE));

        private Returns() {
        }

        @NotNull
        public final Check getBoolean() {
            return boolean;
        }

        @NotNull
        public final Check getInt() {
            return int;
        }

        @NotNull
        public final Check getUnit() {
            return unit;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/Checks$ValueParametersCount;", "", "()V", "none", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "getNone", "()Lorg/jetbrains/kotlin/fir/declarations/Check;", "single", "getSingle", "atLeast", "n", "", "exactly", "providers"})
    public static final class ValueParametersCount {
        @NotNull
        public static final ValueParametersCount INSTANCE = new ValueParametersCount();
        @NotNull
        private static final Check single = INSTANCE.simple("must have a single value parameter", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)single.1.INSTANCE));
        @NotNull
        private static final Check none = INSTANCE.simple("must have no value parameters", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)none.1.INSTANCE));

        private ValueParametersCount() {
        }

        @NotNull
        public final Check atLeast(int n) {
            return INSTANCE.simple("must have at least " + n + " value parameter" + (n > 1 ? "s" : ""), (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)new Function2<FirSimpleFunction, FirSession, Boolean>(n){
                final /* synthetic */ int $n;
                {
                    this.$n = $n;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull FirSimpleFunction it, @NotNull FirSession firSession) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<anonymous parameter 1>");
                    return it.getValueParameters().size() >= this.$n;
                }
            }));
        }

        @NotNull
        public final Check exactly(int n) {
            return INSTANCE.simple("must have exactly " + n + " value parameters", (Function2<? super FirSimpleFunction, ? super FirSession, Boolean>)((Function2)new Function2<FirSimpleFunction, FirSession, Boolean>(n){
                final /* synthetic */ int $n;
                {
                    this.$n = $n;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull FirSimpleFunction it, @NotNull FirSession firSession) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<anonymous parameter 1>");
                    return it.getValueParameters().size() == this.$n;
                }
            }));
        }

        @NotNull
        public final Check getSingle() {
            return single;
        }

        @NotNull
        public final Check getNone() {
            return none;
        }
    }
}

