/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.renderer.ConeAttributeRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeIdRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRenderer;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bB\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\f\u0010\u0017\u001a\u00020\u000b*\u00020\u0013H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRendererForReadability;", "Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRenderer;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "idRendererCreator", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "(Ljava/lang/StringBuilder;Lkotlin/jvm/functions/Function0;)V", "(Lkotlin/jvm/functions/Function0;)V", "render", "", "flexibleType", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;", "renderBound", "", "bound", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "renderFlexibleTypeCompact", "lowerRendered", "upperRendered", "renderAttributes", "cones"})
public final class ConeTypeRendererForReadability
extends ConeTypeRenderer {
    @NotNull
    private final Function0<ConeIdRenderer> idRendererCreator;

    public ConeTypeRendererForReadability(@NotNull Function0<? extends ConeIdRenderer> idRendererCreator2) {
        Intrinsics.checkNotNullParameter(idRendererCreator2, (String)"idRendererCreator");
        super(ConeAttributeRenderer.ForReadability.INSTANCE);
        this.idRendererCreator = idRendererCreator2;
    }

    public ConeTypeRendererForReadability(@NotNull StringBuilder builder2, @NotNull Function0<? extends ConeIdRenderer> idRendererCreator2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(idRendererCreator2, (String)"idRendererCreator");
        this(idRendererCreator2);
        this.setBuilder(builder2);
        this.setIdRenderer((ConeIdRenderer)idRendererCreator2.invoke());
        this.getIdRenderer().setBuilder(builder2);
    }

    @Override
    protected void render(@NotNull ConeFlexibleType flexibleType) {
        Intrinsics.checkNotNullParameter((Object)flexibleType, (String)"flexibleType");
        ConeSimpleKotlinType lower = flexibleType.getLowerBound();
        String lowerRendered = this.renderBound(lower);
        String upperRendered = this.renderBound(flexibleType.getUpperBound());
        String string = this.renderFlexibleTypeCompact(lowerRendered, upperRendered);
        if (string == null) {
            ConeTypeRendererForReadability $this$render_u24lambda_u240 = this;
            boolean bl = false;
            String string2 = lower instanceof ConeDefinitelyNotNullType ? $this$render_u24lambda_u240.renderFlexibleTypeCompact($this$render_u24lambda_u240.renderBound(((ConeDefinitelyNotNullType)lower).getOriginal()), upperRendered) : null;
            string = string2;
            if (string2 == null) {
                string = '(' + lowerRendered + ".." + upperRendered + ')';
            }
        }
        String rendered2 = string;
        this.getBuilder().append(rendered2);
    }

    private final String renderBound(ConeKotlinType bound2) {
        ConeTypeRendererForReadability renderer2 = new ConeTypeRendererForReadability(new StringBuilder(), this.idRendererCreator);
        renderer2.render(bound2);
        String string = renderer2.getBuilder().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String renderFlexibleTypeCompact(String lowerRendered, String upperRendered) {
        String array2;
        String mutableEntry2;
        String simpleCollection;
        if (RenderingUtilsKt.typeStringsDifferOnlyInNullability((String)lowerRendered, (String)upperRendered)) {
            if (StringsKt.startsWith$default((String)upperRendered, (String)"(", (boolean)false, (int)2, null)) {
                return '(' + lowerRendered + ")!";
            }
            return lowerRendered + '!';
        }
        String kotlinCollectionsPrefix = StandardNames.COLLECTIONS_PACKAGE_FQ_NAME.asString() + '.';
        String mutablePrefix = "Mutable";
        String string = simpleCollection = RenderingUtilsKt.replacePrefixesInTypeRepresentations((String)lowerRendered, (String)(kotlinCollectionsPrefix + mutablePrefix), (String)upperRendered, (String)kotlinCollectionsPrefix, (String)(kotlinCollectionsPrefix + '(' + mutablePrefix + ')'));
        if (string != null) {
            return string;
        }
        String string2 = mutableEntry2 = RenderingUtilsKt.replacePrefixesInTypeRepresentations((String)lowerRendered, (String)(kotlinCollectionsPrefix + "MutableMap.MutableEntry"), (String)upperRendered, (String)(kotlinCollectionsPrefix + "Map.Entry"), (String)(kotlinCollectionsPrefix + "(Mutable)Map.(Mutable)Entry"));
        if (string2 != null) {
            return string2;
        }
        String kotlinPrefix = StandardNames.BUILT_INS_PACKAGE_FQ_NAME.asString() + '.';
        String string3 = array2 = RenderingUtilsKt.replacePrefixesInTypeRepresentations((String)lowerRendered, (String)(kotlinPrefix + "Array<"), (String)upperRendered, (String)(kotlinPrefix + "Array<out "), (String)(kotlinPrefix + "Array<(out) "));
        if (string3 != null) {
            return string3;
        }
        return null;
    }

    @Override
    protected void render(@NotNull ConeIntegerLiteralType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.render(ConeIntegerLiteralType.getApproximatedType$default(type2, null, 1, null));
    }

    @Override
    protected void renderAttributes(@NotNull ConeKotlinType $this$renderAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$renderAttributes, (String)"<this>");
        this.renderNonCompilerAttributes($this$renderAttributes);
    }
}

