/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMap;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\rH$J\b\u0010\u0011\u001a\u00020\u0012H&J.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\r2\u001c\u0010\u0015\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00140\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getKlass", "()Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getCallableNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getNestedClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "name", "isEmpty", "", "processClassifiersByNameWithSubstitution", "", "processor", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "providers"})
@SourceDebugExtension(value={"SMAP\nFirNestedClassifierScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNestedClassifierScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1179#2,2:98\n1253#2,4:100\n*S KotlinDebug\n*F\n+ 1 FirNestedClassifierScope.kt\norg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope\n*L\n37#1:98,2\n37#1:100,4\n*E\n"})
public abstract class FirNestedClassifierScope
extends FirContainingNamesAwareScope {
    @NotNull
    private final FirClass klass;
    @NotNull
    private final FirSession useSiteSession;

    public FirNestedClassifierScope(@NotNull FirClass klass2, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter((Object)klass2, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)((Object)useSiteSession), (String)"useSiteSession");
        this.klass = klass2;
        this.useSiteSession = useSiteSession;
    }

    @NotNull
    public final FirClass getKlass() {
        return this.klass;
    }

    @NotNull
    public final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    @Nullable
    protected abstract FirClassLikeSymbol<?> getNestedClassSymbol(@NotNull Name var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name2, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor2) {
        ConeSubstitutor coneSubstitutor;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        FirClassLikeSymbol<?> firClassLikeSymbol = this.getNestedClassSymbol(name2);
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> matchedClass = firClassLikeSymbol;
        if (this.klass.getTypeParameters().isEmpty()) {
            coneSubstitutor = ConeSubstitutor.Empty.INSTANCE;
        } else {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = this.klass.getTypeParameters();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)it.getSymbol(), (Object)FirNestedClassifierScopeKt.toConeType(it));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map substitution2 = destination$iv$iv;
            coneSubstitutor = new ConeSubstitutorByMap(substitution2, this.useSiteSession);
        }
        ConeSubstitutor substitutor3 = coneSubstitutor;
        processor2.invoke(matchedClass, (Object)substitutor3);
    }

    public abstract boolean isEmpty();

    @Override
    @NotNull
    public Set<Name> getCallableNames() {
        return SetsKt.emptySet();
    }
}

