/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.idea.actions.DescriptorBasedAutoImportVariant;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportAction;
import org.jetbrains.kotlin.idea.actions.KotlinAddImportActionInfo;
import org.jetbrains.kotlin.idea.actions.VariantWithPriority;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.completion.KotlinStatisticsInfo;
import org.jetbrains.kotlin.idea.core.util.ProgressUtilsKt;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.quickfix.AutoImportVariant;
import org.jetbrains.kotlin.idea.quickfix.ImportFixHelper;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B-\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0006\u001a\u0004\u0018\u00010\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/actions/KotlinAddImportAction;", "Lcom/intellij/codeInsight/hint/QuestionAction;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "variants", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/idea/actions/VariantWithPriority;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/sequences/Sequence;)V", "singleImportVariant", "Lorg/jetbrains/kotlin/idea/actions/DescriptorBasedAutoImportVariant;", "addImport", "", "variant", "Lorg/jetbrains/kotlin/idea/quickfix/AutoImportVariant;", "execute", "", "getKind", "", "Lcom/intellij/psi/PsiElement;", "showHint", "variantsList", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinAddImportAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinAddImportAction.kt\norg/jetbrains/kotlin/idea/actions/KotlinAddImportAction\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,345:1\n77#2:346\n77#2:347\n77#2:348\n*S KotlinDebug\n*F\n+ 1 KotlinAddImportAction.kt\norg/jetbrains/kotlin/idea/actions/KotlinAddImportAction\n*L\n145#1:346\n152#1:347\n201#1:348\n*E\n"})
public final class KotlinAddImportAction
implements QuestionAction {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final KtElement element;
    @NotNull
    private final Sequence<VariantWithPriority> variants;
    @Nullable
    private DescriptorBasedAutoImportVariant singleImportVariant;

    public KotlinAddImportAction(@NotNull Project project2, @NotNull Editor editor2, @NotNull KtElement element3, @NotNull Sequence<VariantWithPriority> variants2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(variants2, (String)"variants");
        this.project = project2;
        this.editor = editor2;
        this.element = element3;
        this.variants = variants2;
    }

    private final List<DescriptorBasedAutoImportVariant> variantsList() {
        List list2;
        if (this.singleImportVariant != null) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                DescriptorBasedAutoImportVariant descriptorBasedAutoImportVariant = this.singleImportVariant;
                Intrinsics.checkNotNull((Object)descriptorBasedAutoImportVariant);
                return CollectionsKt.listOf((Object)descriptorBasedAutoImportVariant);
            }
        }
        Function0 variantsList2 = (Function0)new Function0<List<? extends DescriptorBasedAutoImportVariant>>(this){
            final /* synthetic */ KotlinAddImportAction this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<DescriptorBasedAutoImportVariant> invoke() {
                return (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends DescriptorBasedAutoImportVariant>>(this.this$0){
                    final /* synthetic */ KotlinAddImportAction this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final List<DescriptorBasedAutoImportVariant> invoke() {
                        Sequence $this$sortedBy$iv = KotlinAddImportAction.access$getVariants$p(this.this$0);
                        boolean $i$f$sortedBy = false;
                        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                            public final int compare(T a, T b2) {
                                VariantWithPriority it = (VariantWithPriority)a;
                                boolean bl = false;
                                Comparable comparable = it.getPriority();
                                it = (VariantWithPriority)b2;
                                Comparable comparable2 = comparable;
                                bl = false;
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getPriority());
                            }
                        }), (Function1)variantsList.variantsList.2.INSTANCE));
                    }
                }));
            }
        };
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            list2 = (List)variantsList2.invoke();
        } else {
            list2 = (List)ProgressUtilsKt.runSynchronouslyWithProgress(this.project, KotlinBundle.message("import.progress.text.resolve.imports", new Object[0]), true, (Function0)new Function0<List<? extends DescriptorBasedAutoImportVariant>>((Function0<? extends List<? extends DescriptorBasedAutoImportVariant>>)variantsList2){
                final /* synthetic */ Function0<List<DescriptorBasedAutoImportVariant>> $variantsList;
                {
                    this.$variantsList = $variantsList;
                    super(0);
                }

                @NotNull
                public final List<DescriptorBasedAutoImportVariant> invoke() {
                    return (List)this.$variantsList.invoke();
                }
            });
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
        }
        return list2;
    }

    public final boolean showHint() {
        boolean bl;
        Iterator iterator2 = this.variants.iterator();
        if (!iterator2.hasNext()) {
            return false;
        }
        DescriptorBasedAutoImportVariant first2 = ((VariantWithPriority)iterator2.next()).getVariant();
        if (iterator2.hasNext()) {
            bl = true;
        } else {
            this.singleImportVariant = first2;
            bl = false;
        }
        boolean multiple = bl;
        String string = ShowAutoImportPass.getMessage((boolean)multiple, (String)this.getKind(first2.getDeclarationToImport()), (String)first2.getHint());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        String hintText = string;
        HintManager.getInstance().showQuestionHint(this.editor, hintText, PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)this.element)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)this.element)), (QuestionAction)this);
        return true;
    }

    private final String getKind(PsiElement element3) {
        if (element3 instanceof PsiClass) {
            return KotlinBundle.message("text.class", new Object[0]);
        }
        if (element3 instanceof PsiField) {
            return KotlinBundle.message("text.property", new Object[0]);
        }
        if (element3 instanceof PsiMethod) {
            return KotlinBundle.message("text.function", new Object[0]);
        }
        return null;
    }

    public boolean execute() {
        List<DescriptorBasedAutoImportVariant> variantsList2;
        block7: {
            block6: {
                PsiDocumentManager.getInstance((Project)this.project).commitAllDocuments();
                if (!this.element.isValid()) {
                    return false;
                }
                variantsList2 = this.variantsList();
                KtFile ktFile = this.element.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
                KotlinAddImportActionInfo.ExecuteListener executeListener = KotlinAddImportActionInfo.INSTANCE.getExecuteListener((PsiFile)ktFile);
                if (executeListener != null) {
                    executeListener.onExecute(variantsList2);
                }
                if (variantsList2.isEmpty()) {
                    return false;
                }
                if (variantsList2.size() == 1) break block6;
                boolean $i$f$isUnitTestMode = false;
                if (!ApplicationManager.getApplication().isUnitTestMode()) break block7;
            }
            this.addImport((AutoImportVariant)CollectionsKt.first(variantsList2));
            return true;
        }
        ImportFixHelper.INSTANCE.createListPopupWithImportVariants(this.project, variantsList2, (Function1<? super AutoImportVariant, Unit>)((Function1)new Function1<AutoImportVariant, Unit>((Object)this){

            public final void invoke(@NotNull AutoImportVariant p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                KotlinAddImportAction.access$addImport((KotlinAddImportAction)this.receiver, p0);
            }
        })).showInBestPositionFor(this.editor);
        return true;
    }

    private final void addImport(AutoImportVariant variant) {
        if (!(variant instanceof DescriptorBasedAutoImportVariant)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        psiDocumentManager.commitAllDocuments();
        String string = QuickFixBundle.message((String)"add.import", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ApplicationUtilsKt.executeWriteCommand(this.project, string, (Function0<Unit>)((Function0)new Function0<Unit>(this, variant){
            final /* synthetic */ KotlinAddImportAction this$0;
            final /* synthetic */ AutoImportVariant $variant;
            {
                this.this$0 = $receiver;
                this.$variant = $variant;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                if (!KotlinAddImportAction.access$getElement$p(this.this$0).isValid()) {
                    return;
                }
                KtFile ktFile = KotlinAddImportAction.access$getElement$p(this.this$0).getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
                KtFile file2 = ktFile;
                StatisticsManager statisticsManager = StatisticsManager.getInstance();
                Iterable iterable = ((DescriptorBasedAutoImportVariant)this.$variant).getDescriptorsToImport();
                KotlinAddImportAction kotlinAddImportAction = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    KtImportAlias ktImportAlias;
                    DeclarationDescriptor descriptor2 = (DeclarationDescriptor)element$iv;
                    boolean bl = false;
                    StatisticsInfo statisticsInfo = KotlinStatisticsInfo.forDescriptor$default(KotlinStatisticsInfo.INSTANCE, descriptor2, null, 2, null);
                    statisticsManager.incUseCount(statisticsInfo);
                    FqName importableFqName = ImportsUtils.getImportableFqName(descriptor2);
                    if (importableFqName != null) {
                        FqName it;
                        boolean bl2 = false;
                        ktImportAlias = file2.findAliasByFqName(it);
                    } else {
                        ktImportAlias = null;
                    }
                    KtImportAlias importAlias = ktImportAlias;
                    FqName fqName2 = importableFqName;
                    if (!(fqName2 != null ? FqNamesUtilKt.isOneSegmentFQN((FqName)fqName2) : false) && (importAlias != null || descriptor2 instanceof ClassDescriptor || descriptor2 instanceof PackageViewDescriptor)) {
                        if (!(KotlinAddImportAction.access$getElement$p(kotlinAddImportAction) instanceof KtSimpleNameExpression)) continue;
                        if (importAlias != null) {
                            DeclarationDescriptor resultDescriptor;
                            PsiElement psiElement2;
                            PsiElement psiElement3 = importAlias.getNameIdentifier();
                            if (psiElement3 != null && (psiElement3 = (psiElement2 = psiElement3.copy())) != null) {
                                Intrinsics.checkNotNull((Object)psiElement3);
                                PsiElement it = psiElement2;
                                boolean bl3 = false;
                                PsiElement psiElement4 = ((KtSimpleNameExpression)KotlinAddImportAction.access$getElement$p(kotlinAddImportAction)).getIdentifier();
                                if (psiElement4 != null) {
                                    psiElement4.replace(it);
                                }
                            }
                            DeclarationDescriptor declarationDescriptor = resultDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors(KotlinAddImportAction.access$getElement$p(kotlinAddImportAction)));
                            if (Intrinsics.areEqual((Object)importableFqName, (Object)(declarationDescriptor != null ? ImportsUtils.getImportableFqName(declarationDescriptor) : null))) continue;
                        }
                        if (importableFqName == null) continue;
                        Project project2 = KotlinAddImportAction.access$getProject$p(kotlinAddImportAction);
                        Object[] objectArray = new Object[1];
                        Intrinsics.checkNotNullExpressionValue((Object)importableFqName.asString(), (String)"asString(...)");
                        ApplicationUtilsKt.underModalProgressOrUnderWriteActionWithNonCancellableProgressInDispatchThread(project2, KotlinBundle.message("add.import.for.0", objectArray), (Function0)new Function0<PsiElement>(kotlinAddImportAction, importableFqName){
                            final /* synthetic */ KotlinAddImportAction this$0;
                            final /* synthetic */ FqName $importableFqName;
                            {
                                this.this$0 = $receiver;
                                this.$importableFqName = $importableFqName;
                                super(0);
                            }

                            @NotNull
                            public final PsiElement invoke() {
                                return KtSimpleNameReference.bindToFqName$default((KtSimpleNameReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)KotlinAddImportAction.access$getElement$p(this.this$0))), (FqName)this.$importableFqName, (KtSimpleNameReference.ShorteningMode)KtSimpleNameReference.ShorteningMode.FORCED_SHORTENING, null, (int)4, null);
                            }
                        });
                        continue;
                    }
                    ImportInsertHelper.importDescriptor$default(ImportInsertHelper.Companion.getInstance(KotlinAddImportAction.access$getProject$p(kotlinAddImportAction)), file2, descriptor2, false, 4, null);
                }
            }
        }));
    }

    public static final /* synthetic */ Sequence access$getVariants$p(KotlinAddImportAction $this) {
        return $this.variants;
    }

    public static final /* synthetic */ void access$addImport(KotlinAddImportAction $this, AutoImportVariant variant) {
        $this.addImport(variant);
    }

    public static final /* synthetic */ KtElement access$getElement$p(KotlinAddImportAction $this) {
        return $this.element;
    }

    public static final /* synthetic */ Project access$getProject$p(KotlinAddImportAction $this) {
        return $this.project;
    }
}

