/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal.resolutionDebugging;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.Rectangle;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.actions.internal.resolutionDebugging.DebugTypeResolutionActionKt;
import org.jetbrains.kotlin.idea.actions.internal.resolutionDebugging.ReportContext;
import org.jetbrains.kotlin.idea.actions.internal.resolutionDebugging.TypeMismatchDebugReport;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J4\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\r2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/resolutionDebugging/DebugTypeResolutionAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "buildAndShowReport", "expected", "Lorg/jetbrains/kotlin/types/KotlinType;", "actual", "showReportWindow", "content", "", "somethingWentWrong", "message", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "caret", "Lcom/intellij/openapi/editor/Caret;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nDebugTypeResolutionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugTypeResolutionAction.kt\norg/jetbrains/kotlin/idea/actions/internal/resolutionDebugging/DebugTypeResolutionAction\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n146#2:118\n1#3:119\n*S KotlinDebug\n*F\n+ 1 DebugTypeResolutionAction.kt\norg/jetbrains/kotlin/idea/actions/internal/resolutionDebugging/DebugTypeResolutionAction\n*L\n33#1:118\n*E\n"})
public final class DebugTypeResolutionAction
extends AnAction {
    public DebugTypeResolutionAction() {
        super("Debug Resolution of Type at Caret");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        KotlinType kotlinType;
        KotlinTypeInfo actualType;
        PsiElement expression2;
        Caret caret;
        KtFile psiFile2;
        block9: {
            PsiElement psiElement2;
            block11: {
                block10: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (!ApplicationManager.getApplication().isInternal()) {
                        return;
                    }
                    Object object = e.getData(CommonDataKeys.PSI_FILE);
                    KtFile ktFile = object instanceof KtFile ? (KtFile)object : null;
                    if (ktFile == null) {
                        DebugTypeResolutionAction.somethingWentWrong$default(this, "Can't get a KtFile at current location. Are you in .kt-file?", null, null, null, 14, null);
                        return;
                    }
                    psiFile2 = ktFile;
                    Caret caret2 = (Caret)e.getData(CommonDataKeys.CARET);
                    if (caret2 == null) {
                        DebugTypeResolutionAction.somethingWentWrong$default(this, "Can't get a position of caret in file", psiFile2, null, null, 12, null);
                        return;
                    }
                    caret = caret2;
                    psiElement2 = psiFile2.findElementAt(caret.getOffset());
                    if (psiElement2 == null) break block10;
                    PsiElement $this$getNonStrictParentOfType$iv = psiElement2;
                    boolean $i$f$getNonStrictParentOfType = false;
                    psiElement2 = (KtNameReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtNameReferenceExpression.class, (boolean)false);
                    if (psiElement2 != null) break block11;
                }
                DebugTypeResolutionAction.somethingWentWrong$default(this, "Can't find a KtExpression at the caret. Check that the caret is at an expression", psiFile2, caret, null, 8, null);
                return;
            }
            expression2 = psiElement2;
            BindingContext bindingContext2 = ResolutionUtils.analyzeWithAllCompilerChecks(psiFile2, new KtFile[0]).getBindingContext();
            KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)bindingContext2.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)expression2);
            if (kotlinTypeInfo == null || (kotlinTypeInfo = kotlinTypeInfo.getType()) == null) {
                this.somethingWentWrong("Couldn't get a type from EXPRESSION_TYPE_INFO slice of BindingContext", psiFile2, caret, (KtExpression)expression2);
                return;
            }
            actualType = kotlinTypeInfo;
            for (PsiElement it : PsiUtilsKt.getParentsWithSelf((PsiElement)expression2)) {
                boolean bl = false;
                KotlinType kotlinType2 = it instanceof KtExpression ? (KotlinType)bindingContext2.get((ReadOnlySlice)BindingContext.EXPECTED_EXPRESSION_TYPE, (Object)it) : null;
                if (kotlinType2 == null) continue;
                kotlinType = kotlinType2;
                break block9;
            }
            kotlinType = null;
        }
        if (kotlinType == null) {
            this.somethingWentWrong("Couldn't get a type from the EXPECTED_EXPRESSION_TYPE slice of BindingContext", psiFile2, caret, (KtExpression)expression2);
            return;
        }
        KotlinType expectedType = kotlinType;
        this.buildAndShowReport(expectedType, (KotlinType)actualType);
    }

    private final void somethingWentWrong(String message2, KtFile psiFile2, Caret caret, KtExpression expression2) {
        KtExpression ktExpression = expression2;
        this.showReportWindow(StringsKt.trimIndent((String)("\n            Something went wrong!\n            \n            " + message2 + "\n            \n            Context:\n            psiFile=" + psiFile2 + "\n            caret=" + caret + "\n            expression=" + (ktExpression != null ? ktExpression.getText() : null) + "\n        ")));
    }

    static /* synthetic */ void somethingWentWrong$default(DebugTypeResolutionAction debugTypeResolutionAction, String string, KtFile ktFile, Caret caret, KtExpression ktExpression, int n, Object object) {
        if ((n & 2) != 0) {
            ktFile = null;
        }
        if ((n & 4) != 0) {
            caret = null;
        }
        if ((n & 8) != 0) {
            ktExpression = null;
        }
        debugTypeResolutionAction.somethingWentWrong(string, ktFile, caret, ktExpression);
    }

    private final void buildAndShowReport(KotlinType expected, KotlinType actual) {
        TypeMismatchDebugReport report;
        ReportContext ctx = new ReportContext();
        TypeMismatchDebugReport $this$buildAndShowReport_u24lambda_u241 = report = DebugTypeResolutionActionKt.TypeMismatchDebugReport(ctx, expected, actual);
        boolean bl = false;
        String reportRendered = $this$buildAndShowReport_u24lambda_u241.render(ctx);
        this.showReportWindow(reportRendered);
    }

    private final void showReportWindow(String content2) {
        Rectangle screenBounds = ScreenUtil.getMainScreenBounds();
        int width = (int)((double)screenBounds.width * 0.8);
        int height = (int)((double)screenBounds.height * 0.8);
        DialogPanel window2 = (DialogPanel)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(content2){
            final /* synthetic */ String $content;
            {
                this.$content = $content;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$content){
                    final /* synthetic */ String $content;
                    {
                        this.$content = $content;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.textArea().align(Align.FILL).applyToComponent((Function1)new Function1<JBTextArea, Unit>(this.$content){
                            final /* synthetic */ String $content;
                            {
                                this.$content = $content;
                                super(1);
                            }

                            public final void invoke(@NotNull JBTextArea $this$applyToComponent) {
                                Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                $this$applyToComponent.setText(this.$content);
                            }
                        }).resizableColumn();
                    }
                }), (int)1, null).resizableRow();
            }
        })).withPreferredSize(width, height);
        Intrinsics.checkNotNull((Object)window2);
        ComponentsKt.dialog$default((String)"Debug Mismatch", (JComponent)((JComponent)window2), (boolean)false, null, (boolean)false, null, null, null, null, null, null, (int)2044, null).showAndGet();
    }
}

