/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysis.api.utils;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotatedKt;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplicationWithArgumentsInfo;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtConstantAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtNamedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValue;
import org.jetbrains.kotlin.analysis.api.calls.KtCall;
import org.jetbrains.kotlin.analysis.api.calls.KtCallCandidateInfo;
import org.jetbrains.kotlin.analysis.api.calls.KtCallInfo;
import org.jetbrains.kotlin.analysis.api.calls.KtCallKt;
import org.jetbrains.kotlin.analysis.api.calls.KtCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.calls.KtFunctionCall;
import org.jetbrains.kotlin.analysis.api.components.KtImplicitReceiver;
import org.jetbrains.kotlin.analysis.api.components.KtScopeContext;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.signatures.KtFunctionLikeSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KtFileSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPackageSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtAnnotatedSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KtSymbolWithVisibility;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.api.types.KtTypeNullability;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.ArrayFqNames;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001d\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bR\u00020\u0006\u00a2\u0006\u0002\u0010\t\u001a'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rR\u00020\u0006\u00a2\u0006\u0002\u0010\u000e\u001a3\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u00020\u0006\u00a2\u0006\u0002\u0010\u0014\u001a7\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rR\u00020\u0006\u00a2\u0006\u0002\u0010\u0019\u001a\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dR\u00020\u0006\u00a2\u0006\u0002\u0010\u001e\u001a\u0017\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020 R\u00020\u0006\u00a2\u0006\u0002\u0010!\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"ARRAY_OF_FUNCTION_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "collectCallCandidates", "", "Lorg/jetbrains/kotlin/analysis/api/calls/KtCallCandidateInfo;", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "callElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtElement;)Ljava/util/List;", "collectReceiverTypesForElement", "Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "explicitReceiver", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtExpression;)Ljava/util/List;", "filterCandidate", "", "candidateInfo", "fileSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFileSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/calls/KtCallCandidateInfo;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/analysis/api/symbols/KtFileSymbol;Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "filterCandidateByReceiverTypeAndVisibility", "signature", "Lorg/jetbrains/kotlin/analysis/api/signatures/KtFunctionLikeSignature;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtFunctionLikeSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/signatures/KtFunctionLikeSignature;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/analysis/api/symbols/KtFileSymbol;Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "getJvmName", "", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KtAnnotatedSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KtAnnotatedSymbol;)Ljava/lang/String;", "isArrayOfCall", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtCallElement;)Z", "kotlin.base.analysis-api.utils"})
@SourceDebugExtension(value={"SMAP\nresolveUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 resolveUtils.kt\norg/jetbrains/kotlin/idea/base/analysis/api/utils/ResolveUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n766#2:150\n857#2,2:151\n2624#2,3:153\n1549#2:156\n1620#2,3:157\n*S KotlinDebug\n*F\n+ 1 resolveUtils.kt\norg/jetbrains/kotlin/idea/base/analysis/api/utils/ResolveUtilsKt\n*L\n44#1:150\n44#1:151,2\n92#1:153,3\n125#1:156\n125#1:157,3\n*E\n"})
public final class ResolveUtilsKt {
    @NotNull
    private static final Set<Name> ARRAY_OF_FUNCTION_NAMES = SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.setOf((Object)ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION()), (Iterable)ArrayFqNames.INSTANCE.getPRIMITIVE_TYPE_TO_ARRAY().values()), (Object)ArrayFqNames.INSTANCE.getEMPTY_ARRAY());

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtCallCandidateInfo> collectCallCandidates(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtElement callElement2) {
        void $this$filterTo$iv$iv;
        Pair pair;
        KtExpression explicitReceiver;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)callElement2, (String)"callElement");
        KtElement ktElement = callElement2;
        if (ktElement instanceof KtCallElement) {
            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)callElement2);
            explicitReceiver = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
            pair = TuplesKt.to($context_receiver_0.collectCallCandidates(callElement2), (Object)explicitReceiver);
        } else if (ktElement instanceof KtArrayAccessExpression) {
            pair = TuplesKt.to($context_receiver_0.collectCallCandidates(callElement2), (Object)((KtArrayAccessExpression)callElement2).getArrayExpression());
        } else {
            return CollectionsKt.emptyList();
        }
        Pair pair2 = pair;
        List candidates2 = (List)pair2.component1();
        explicitReceiver = (KtExpression)pair2.component2();
        if (candidates2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        KtFile ktFile = callElement2.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
        KtFileSymbol fileSymbol = $context_receiver_0.getFileSymbol(ktFile);
        Iterable $this$filter$iv = candidates2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtCallCandidateInfo it = (KtCallCandidateInfo)element$iv$iv;
            boolean bl = false;
            if (!ResolveUtilsKt.filterCandidate($context_receiver_0, it, callElement2, fileSymbol, explicitReceiver)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean filterCandidate(KtAnalysisSession $context_receiver_0, KtCallCandidateInfo candidateInfo, KtElement callElement2, KtFileSymbol fileSymbol, KtExpression explicitReceiver) {
        KtCall candidateCall = candidateInfo.getCandidate();
        if (!(candidateCall instanceof KtFunctionCall)) {
            return false;
        }
        KtFunctionLikeSignature signature2 = (KtFunctionLikeSignature)((KtFunctionCall)candidateCall).getPartiallyAppliedSymbol().getSignature();
        return ResolveUtilsKt.filterCandidateByReceiverTypeAndVisibility($context_receiver_0, signature2, callElement2, fileSymbol, explicitReceiver);
    }

    public static final boolean filterCandidateByReceiverTypeAndVisibility(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtFunctionLikeSignature<? extends KtFunctionLikeSymbol> signature2, @NotNull KtElement callElement2, @NotNull KtFileSymbol fileSymbol, @Nullable KtExpression explicitReceiver) {
        PsiElement candidatePsi;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter(signature2, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)callElement2, (String)"callElement");
        Intrinsics.checkNotNullParameter((Object)fileSymbol, (String)"fileSymbol");
        KtFunctionLikeSymbol candidateSymbol = (KtFunctionLikeSymbol)signature2.getSymbol();
        if (callElement2 instanceof KtConstructorDelegationCall && (candidatePsi = candidateSymbol.getPsi()) != null && Intrinsics.areEqual((Object)candidatePsi, (Object)((KtConstructorDelegationCall)callElement2).getParent())) {
            return false;
        }
        List<KtType> receiverTypes = ResolveUtilsKt.collectReceiverTypesForElement($context_receiver_0, callElement2, explicitReceiver);
        KtType candidateReceiverType = signature2.getReceiverType();
        if (candidateReceiverType != null) {
            boolean bl;
            block6: {
                Iterable $this$none$iv = receiverTypes;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        KtType it = (KtType)element$iv;
                        boolean bl2 = false;
                        if (!$context_receiver_0.isSubTypeOf(it, candidateReceiverType)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return false;
            }
        }
        return !(candidateSymbol instanceof KtSymbolWithVisibility) || $context_receiver_0.isVisible((KtSymbolWithVisibility)((Object)candidateSymbol), fileSymbol, explicitReceiver, (PsiElement)callElement2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtType> collectReceiverTypesForElement(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtElement callElement2, @Nullable KtExpression explicitReceiver) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)callElement2, (String)"callElement");
        if (explicitReceiver != null) {
            KtReferenceExpression ktReferenceExpression = KtPsiUtilKt.referenceExpression((KtExpression)explicitReceiver);
            if (ktReferenceExpression != null && (ktReferenceExpression = ReferenceUtilsKt.getMainReference((KtReferenceExpression)ktReferenceExpression)) != null) {
                KtReferenceExpression receiverReference = ktReferenceExpression;
                boolean bl = false;
                KtSymbol receiverSymbol = $context_receiver_0.resolveToSymbol((KtReference)receiverReference);
                if (receiverSymbol == null || receiverSymbol instanceof KtPackageSymbol) {
                    return CollectionsKt.emptyList();
                }
            }
            boolean isSafeCall = explicitReceiver.getParent() instanceof KtSafeQualifiedExpression;
            KtType ktType = $context_receiver_0.getKtType(explicitReceiver);
            if (ktType == null) {
                throw new IllegalStateException("Receiver should have a KtType".toString());
            }
            KtType explicitReceiverType = ktType;
            KtType adjustedType = isSafeCall ? $context_receiver_0.withNullability(explicitReceiverType, KtTypeNullability.NON_NULLABLE) : explicitReceiverType;
            list2 = CollectionsKt.listOf((Object)adjustedType);
        } else {
            void $this$mapTo$iv$iv;
            KtFile ktFile = callElement2.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
            KtScopeContext scopeContext = $context_receiver_0.getScopeContextForPosition(ktFile, callElement2);
            Iterable $this$map$iv = scopeContext.getImplicitReceivers();
            boolean $i$f$map = false;
            Iterable receiverReference = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtImplicitReceiver ktImplicitReceiver = (KtImplicitReceiver)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getType());
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    public static final boolean isArrayOfCall(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtCallElement callElement2) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)callElement2, (String)"callElement");
        KtLifetimeOwner ktLifetimeOwner = $context_receiver_0.resolveCall((KtElement)callElement2);
        if (ktLifetimeOwner == null || (ktLifetimeOwner = KtCallKt.singleFunctionCallOrNull((KtCallInfo)ktLifetimeOwner)) == null) {
            return false;
        }
        KtLifetimeOwner resolvedCall2 = ktLifetimeOwner;
        CallableId callableId = ((KtFunctionLikeSignature)((KtCallableMemberCall)resolvedCall2).getPartiallyAppliedSymbol().getSignature()).getCallableIdIfNonLocal();
        if (callableId == null) {
            return false;
        }
        CallableId callableId2 = callableId;
        return Intrinsics.areEqual((Object)callableId2.getPackageName(), (Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME) && ARRAY_OF_FUNCTION_NAMES.contains(callableId2.getCallableName());
    }

    @Nullable
    public static final String getJvmName(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtAnnotatedSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        KtAnnotationApplicationWithArgumentsInfo ktAnnotationApplicationWithArgumentsInfo = (KtAnnotationApplicationWithArgumentsInfo)CollectionsKt.firstOrNull((List)KtAnnotatedKt.annotationsByClassId$default(symbol2, JvmStandardClassIds.Annotations.INSTANCE.getJvmName(), null, 2, null));
        if (ktAnnotationApplicationWithArgumentsInfo == null) {
            return null;
        }
        KtAnnotationApplicationWithArgumentsInfo jvmNameAnnotation = ktAnnotationApplicationWithArgumentsInfo;
        KtNamedAnnotationValue ktNamedAnnotationValue = (KtNamedAnnotationValue)CollectionsKt.singleOrNull(jvmNameAnnotation.getArguments());
        KtAnnotationValue ktAnnotationValue = ktNamedAnnotationValue != null ? ktNamedAnnotationValue.getExpression() : null;
        KtConstantAnnotationValue ktConstantAnnotationValue = ktAnnotationValue instanceof KtConstantAnnotationValue ? (KtConstantAnnotationValue)ktAnnotationValue : null;
        if (ktConstantAnnotationValue == null) {
            return null;
        }
        KtConstantAnnotationValue annotationValue = ktConstantAnnotationValue;
        KtConstantValue ktConstantValue = annotationValue.getConstantValue();
        KtConstantValue.KtStringConstantValue ktStringConstantValue = ktConstantValue instanceof KtConstantValue.KtStringConstantValue ? (KtConstantValue.KtStringConstantValue)ktConstantValue : null;
        if (ktStringConstantValue == null) {
            return null;
        }
        KtConstantValue.KtStringConstantValue stringValue = ktStringConstantValue;
        return stringValue.getValue();
    }
}

