/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.highlighting;

import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ScriptDiagnostic;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.NotUnderContentRootModuleInfo;
import org.jetbrains.kotlin.idea.base.util.KotlinPlatformUtils;
import org.jetbrains.kotlin.idea.core.script.IdeScriptReportSink;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u0004\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0002H\u0002\u00a8\u0006\b"}, d2={"calculateShouldHighlightFile", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "shouldCheckScript", "(Lorg/jetbrains/kotlin/psi/KtFile;)Ljava/lang/Boolean;", "shouldHighlightErrors", "shouldHighlightFile", "shouldHighlightScript", "kotlin.highlighting.shared"})
@JvmName(name="KotlinHighlightingUtils")
@SourceDebugExtension(value={"SMAP\nKotlinHighlightingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinHighlightingUtils.kt\norg/jetbrains/kotlin/idea/base/highlighting/KotlinHighlightingUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1747#2,3:86\n*S KotlinDebug\n*F\n+ 1 KotlinHighlightingUtils.kt\norg/jetbrains/kotlin/idea/base/highlighting/KotlinHighlightingUtils\n*L\n85#1:86,3\n*E\n"})
public final class KotlinHighlightingUtils {
    @ApiStatus.Internal
    public static final boolean shouldHighlightErrors(@NotNull KtFile $this$shouldHighlightErrors) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHighlightErrors, (String)"<this>");
        if ($this$shouldHighlightErrors.isCompiled()) {
            return false;
        }
        if ($this$shouldHighlightErrors instanceof KtCodeFragment && ((KtCodeFragment)$this$shouldHighlightErrors).getContext() != null) {
            return true;
        }
        Boolean canCheckScript = KotlinHighlightingUtils.shouldCheckScript($this$shouldHighlightErrors);
        if (Intrinsics.areEqual((Object)canCheckScript, (Object)true)) {
            return KotlinHighlightingUtils.shouldHighlightScript($this$shouldHighlightErrors);
        }
        return SourceKindFilterUtils.matches(RootKindFilter.copy$default(RootKindFilter.projectSources, false, false, false, false, canCheckScript == null, 15, null), (PsiElement)$this$shouldHighlightErrors);
    }

    @ApiStatus.Internal
    public static final boolean shouldHighlightFile(@NotNull KtFile $this$shouldHighlightFile) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHighlightFile, (String)"<this>");
        KtFile file2 = $this$shouldHighlightFile;
        Object object = CachedValuesManager.getManager((Project)$this$shouldHighlightFile.getProject()).getCachedValue((UserDataHolder)file2, () -> KotlinHighlightingUtils.shouldHighlightFile$lambda$0(file2, $this$shouldHighlightFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    private static final boolean calculateShouldHighlightFile(KtFile $this$calculateShouldHighlightFile) {
        if ($this$calculateShouldHighlightFile instanceof KtCodeFragment && ((KtCodeFragment)$this$calculateShouldHighlightFile).getContext() != null) {
            return true;
        }
        if (OutsidersPsiFileSupport.isOutsiderFile((VirtualFile)$this$calculateShouldHighlightFile.getVirtualFile())) {
            return true;
        }
        Boolean shouldCheckScript2 = KotlinHighlightingUtils.shouldCheckScript($this$calculateShouldHighlightFile);
        if (Intrinsics.areEqual((Object)shouldCheckScript2, (Object)true)) {
            return KotlinHighlightingUtils.shouldHighlightScript($this$calculateShouldHighlightFile);
        }
        return shouldCheckScript2 != null ? SourceKindFilterUtils.matches(RootKindFilter.everything, (PsiElement)$this$calculateShouldHighlightFile) && !(ModuleInfoProviderUtils.getModuleInfo((PsiElement)$this$calculateShouldHighlightFile) instanceof NotUnderContentRootModuleInfo) : SourceKindFilterUtils.matches(RootKindFilter.copy$default(RootKindFilter.everything, false, false, false, false, true, 15, null), (PsiElement)$this$calculateShouldHighlightFile);
    }

    private static final Boolean shouldCheckScript(KtFile $this$shouldCheckScript) {
        return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>($this$shouldCheckScript){
            final /* synthetic */ KtFile $this_shouldCheckScript;
            {
                this.$this_shouldCheckScript = $receiver;
                super(0);
            }

            @Nullable
            public final Boolean invoke() {
                Project project2 = this.$this_shouldCheckScript.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                return DumbService.Companion.getInstance(project2).isDumb() ? null : (this.$this_shouldCheckScript.isScript() ? Boolean.valueOf(true) : Boolean.valueOf(false));
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldHighlightScript(KtFile $this$shouldHighlightScript) {
        boolean bl;
        if (KotlinPlatformUtils.isCidr()) return false;
        Iterable $this$any$iv = IdeScriptReportSink.Companion.getReports($this$shouldHighlightScript);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            ScriptDiagnostic it = (ScriptDiagnostic)element$iv;
            boolean bl2 = false;
            if (it.getSeverity() == ScriptDiagnostic.Severity.FATAL) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    private static final CachedValueProvider.Result shouldHighlightFile$lambda$0(KtFile $file, KtFile $this_shouldHighlightFile) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$this_shouldHighlightFile, (String)"$this_shouldHighlightFile");
        Object[] objectArray = new Object[]{ProjectRootModificationTracker.getInstance((Project)$this_shouldHighlightFile.getProject())};
        return CachedValueProvider.Result.create((Object)KotlinHighlightingUtils.calculateShouldHighlightFile($file), (Object[])objectArray);
    }
}

