/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.scripting.projectStructure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinBaseProjectStructureBundle;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryInfoCache;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LanguageSettingsOwner;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleOrigin;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SdkInfo;
import org.jetbrains.kotlin.idea.base.scripting.ScriptingTargetPlatformDetectorKt;
import org.jetbrains.kotlin.idea.base.scripting.projectStructure.ScriptDependenciesInfo;
import org.jetbrains.kotlin.idea.core.script.dependencies.KotlinScriptSearchScope;
import org.jetbrains.kotlin.idea.core.script.dependencies.ScriptAdditionalIdeaDependenciesProvider;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformVersion;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u00103\u001a\u00020\u0004H\u00c6\u0003J\t\u00104\u001a\u00020\u0006H\u00c6\u0003J\t\u00105\u001a\u00020\bH\u00c6\u0003J'\u00106\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020\u000108H\u0016J\u0013\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010<H\u0096\u0002J\b\u0010=\u001a\u00020>H\u0016J\t\u0010?\u001a\u00020\u0014H\u00d6\u0001R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u0002008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/idea/base/scripting/projectStructure/ScriptModuleInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/LanguageSettingsOwner;", "project", "Lcom/intellij/openapi/project/Project;", "scriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;)V", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "getContentScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "displayedName", "", "getDisplayedName", "()Ljava/lang/String;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "moduleContentScope", "getModuleContentScope", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScriptDefinition", "()Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getScriptFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "targetPlatformVersion", "Lorg/jetbrains/kotlin/platform/TargetPlatformVersion;", "getTargetPlatformVersion", "()Lorg/jetbrains/kotlin/platform/TargetPlatformVersion;", "component1", "component2", "component3", "copy", "dependencies", "", "equals", "", "other", "", "hashCode", "", "toString", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptModuleInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptModuleInfo.kt\norg/jetbrains/kotlin/idea/base/scripting/projectStructure/ScriptModuleInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1855#2,2:92\n1855#2,2:94\n1#3:96\n*S KotlinDebug\n*F\n+ 1 ScriptModuleInfo.kt\norg/jetbrains/kotlin/idea/base/scripting/projectStructure/ScriptModuleInfo\n*L\n48#1:92,2\n54#1:94,2\n*E\n"})
public final class ScriptModuleInfo
implements IdeaModuleInfo,
LanguageSettingsOwner {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile scriptFile;
    @NotNull
    private final ScriptDefinition scriptDefinition;
    @NotNull
    private final Name name;

    public ScriptModuleInfo(@NotNull Project project2, @NotNull VirtualFile scriptFile, @NotNull ScriptDefinition scriptDefinition) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        this.project = project2;
        this.scriptFile = scriptFile;
        this.scriptDefinition = scriptDefinition;
        Name name2 = Name.special((String)("<script " + this.scriptFile.getName() + " " + this.scriptDefinition.getName() + ">"));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        this.name = name2;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getScriptFile() {
        return this.scriptFile;
    }

    @NotNull
    public final ScriptDefinition getScriptDefinition() {
        return this.scriptDefinition;
    }

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.OTHER;
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayedName() {
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNullExpressionValue((Object)this.scriptFile.getPresentableName(), (String)"getPresentableName(...)");
        objectArray[1] = this.scriptDefinition.getName();
        return KotlinBaseProjectStructureBundle.message("script.0.1", objectArray);
    }

    @Override
    @NotNull
    public GlobalSearchScope getContentScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((Project)this.getProject(), (VirtualFile)this.scriptFile);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(...)");
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        return (GlobalSearchScope)new KotlinScriptSearchScope(this.getProject(), this.getContentScope());
    }

    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        Object object;
        block2: {
            object = new IdeaModuleInfo[]{this};
            Object $this$dependencies_u24lambda_u243 = object = SetsKt.mutableSetOf((Object[])object);
            boolean bl = false;
            List<Module> scriptDependentModules = ScriptAdditionalIdeaDependenciesProvider.Companion.getRelatedModules(this.scriptFile, this.getProject());
            Iterable $this$forEach$iv = scriptDependentModules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Module it = (Module)element$iv;
                boolean bl2 = false;
                $this$dependencies_u24lambda_u243.addAll((Collection)KotlinProjectStructureUtils.getSourceModuleInfos(it));
            }
            List<Library> scriptDependentLibraries = ScriptAdditionalIdeaDependenciesProvider.Companion.getRelatedLibraries(this.scriptFile, this.getProject());
            LibraryInfoCache libraryInfoCache2 = LibraryInfoCache.Companion.getInstance(this.getProject());
            Iterable $this$forEach$iv2 = scriptDependentLibraries;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Library it = (Library)element$iv;
                boolean bl3 = false;
                $this$dependencies_u24lambda_u243.addAll((Collection)libraryInfoCache2.get(it));
            }
            ScriptDependenciesInfo.ForFile dependenciesInfo = new ScriptDependenciesInfo.ForFile(this.getProject(), this.scriptFile, this.scriptDefinition);
            $this$dependencies_u24lambda_u243.add(dependenciesInfo);
            Sdk sdk2 = dependenciesInfo.getSdk();
            if (sdk2 == null) break block2;
            Sdk it = sdk2;
            boolean bl4 = false;
            $this$dependencies_u24lambda_u243.add(new SdkInfo(this.getProject(), it));
        }
        return CollectionsKt.toList((Iterable)((Iterable)object));
    }

    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        if (!(other2 instanceof ScriptModuleInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getProject(), (Object)((ScriptModuleInfo)other2).getProject())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.scriptFile, (Object)((ScriptModuleInfo)other2).scriptFile);
    }

    public int hashCode() {
        int result2 = this.getProject().hashCode();
        result2 = 31 * result2 + this.scriptFile.hashCode();
        return result2;
    }

    @NotNull
    public TargetPlatform getPlatform() {
        return ScriptingTargetPlatformDetectorKt.getPlatform(this.getProject(), this.scriptFile, this.scriptDefinition);
    }

    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return (PlatformDependentAnalyzerServices)JvmPlatformAnalyzerServices.INSTANCE;
    }

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return ScriptingTargetPlatformDetectorKt.getLanguageVersionSettings(this.getProject(), this.scriptFile, this.scriptDefinition);
    }

    @Override
    @NotNull
    public TargetPlatformVersion getTargetPlatformVersion() {
        return ScriptingTargetPlatformDetectorKt.getTargetPlatformVersion(this.getProject(), this.scriptFile, this.scriptDefinition);
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final VirtualFile component2() {
        return this.scriptFile;
    }

    @NotNull
    public final ScriptDefinition component3() {
        return this.scriptDefinition;
    }

    @NotNull
    public final ScriptModuleInfo copy(@NotNull Project project2, @NotNull VirtualFile scriptFile, @NotNull ScriptDefinition scriptDefinition) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        return new ScriptModuleInfo(project2, scriptFile, scriptDefinition);
    }

    public static /* synthetic */ ScriptModuleInfo copy$default(ScriptModuleInfo scriptModuleInfo, Project project2, VirtualFile virtualFile2, ScriptDefinition scriptDefinition, int n, Object object) {
        if ((n & 1) != 0) {
            project2 = scriptModuleInfo.project;
        }
        if ((n & 2) != 0) {
            virtualFile2 = scriptModuleInfo.scriptFile;
        }
        if ((n & 4) != 0) {
            scriptDefinition = scriptModuleInfo.scriptDefinition;
        }
        return scriptModuleInfo.copy(project2, virtualFile2, scriptDefinition);
    }

    @NotNull
    public String toString() {
        return "ScriptModuleInfo(project=" + this.project + ", scriptFile=" + this.scriptFile + ", scriptDefinition=" + this.scriptDefinition + ")";
    }
}

