/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.util;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0004\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0007\u001a#\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\f\u001a+\u0010\r\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00022\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\u000f\u001a\u0012\u0010\u0010\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0002\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0012\u001a\u0015\u0010\u0013\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u0010\u0013\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0086\u0002\u001a\r\u0010\u0014\u001a\u00020\u0001*\u00020\u0001H\u0086\u0002\u001a\u0015\u0010\u0015\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0004\u001a\u0015\u0010\u0015\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0086\u0004\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0002\u001a\u0017\u0010\u0017\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0018*\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u000b\u001a\u0012\u0010\u0017\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000b\u001a\u000f\u0010\u001a\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0018*\u00020\u0001\u001a\n\u0010\u001a\u001a\u00020\u0004*\u00020\u0004\u001a\n\u0010\u001b\u001a\u00020\u0004*\u00020\u0007\u00a8\u0006\u001c"}, d2={"allScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lcom/intellij/openapi/project/Project;", "and", "Lcom/intellij/psi/search/SearchScope;", "otherScope", "codeUsageScope", "Lcom/intellij/psi/PsiElement;", "everythingScopeExcludeFileTypes", "fileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/fileTypes/FileType;)Lcom/intellij/psi/search/GlobalSearchScope;", "excludeFileTypes", "project", "(Lcom/intellij/psi/search/SearchScope;Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/fileTypes/FileType;)Lcom/intellij/psi/search/SearchScope;", "excludeKotlinSources", "fileScope", "Lcom/intellij/psi/PsiFile;", "minus", "not", "or", "projectScope", "restrictByFileType", "Lorg/jetbrains/annotations/NotNull;", "fileType", "restrictToKotlinSources", "useScope", "kotlin.base.util"})
@JvmName(name="KotlinScopeUtils")
@SourceDebugExtension(value={"SMAP\nKotlinScopeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinScopeUtils.kt\norg/jetbrains/kotlin/idea/base/util/KotlinScopeUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,76:1\n3792#2:77\n4307#2,2:78\n3792#2:82\n4307#2,2:83\n37#3,2:80\n37#3,2:85\n*S KotlinDebug\n*F\n+ 1 KotlinScopeUtils.kt\norg/jetbrains/kotlin/idea/base/util/KotlinScopeUtils\n*L\n48#1:77\n48#1:78,2\n67#1:82\n67#1:83,2\n52#1:80,2\n69#1:85,2\n*E\n"})
public final class KotlinScopeUtils {
    @NotNull
    public static final SearchScope and(@NotNull SearchScope $this$and, @NotNull SearchScope otherScope) {
        Intrinsics.checkNotNullParameter((Object)$this$and, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)otherScope, (String)"otherScope");
        SearchScope searchScope2 = $this$and.intersectWith(otherScope);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"intersectWith(...)");
        return searchScope2;
    }

    @NotNull
    public static final SearchScope or(@NotNull SearchScope $this$or, @NotNull SearchScope otherScope) {
        Intrinsics.checkNotNullParameter((Object)$this$or, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)otherScope, (String)"otherScope");
        SearchScope searchScope2 = $this$or.union(otherScope);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"union(...)");
        return searchScope2;
    }

    @NotNull
    public static final GlobalSearchScope or(@NotNull GlobalSearchScope $this$or, @NotNull SearchScope otherScope) {
        Intrinsics.checkNotNullParameter((Object)$this$or, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)otherScope, (String)"otherScope");
        GlobalSearchScope globalSearchScope = $this$or.union(otherScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"union(...)");
        return globalSearchScope;
    }

    @NotNull
    public static final SearchScope minus(@NotNull SearchScope $this$minus, @NotNull GlobalSearchScope otherScope) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)otherScope, (String)"otherScope");
        return KotlinScopeUtils.and($this$minus, (SearchScope)KotlinScopeUtils.not(otherScope));
    }

    @NotNull
    public static final GlobalSearchScope minus(@NotNull GlobalSearchScope $this$minus, @NotNull GlobalSearchScope otherScope) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)otherScope, (String)"otherScope");
        GlobalSearchScope globalSearchScope = $this$minus.intersectWith(KotlinScopeUtils.not(otherScope));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"intersectWith(...)");
        return globalSearchScope;
    }

    @NotNull
    public static final GlobalSearchScope not(@NotNull GlobalSearchScope $this$not) {
        Intrinsics.checkNotNullParameter((Object)$this$not, (String)"<this>");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.notScope((GlobalSearchScope)$this$not);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"notScope(...)");
        return globalSearchScope;
    }

    @NotNull
    public static final GlobalSearchScope allScope(@NotNull Project $this$allScope) {
        Intrinsics.checkNotNullParameter((Object)$this$allScope, (String)"<this>");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)$this$allScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return globalSearchScope;
    }

    @NotNull
    public static final GlobalSearchScope projectScope(@NotNull Project $this$projectScope) {
        Intrinsics.checkNotNullParameter((Object)$this$projectScope, (String)"<this>");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)$this$projectScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(...)");
        return globalSearchScope;
    }

    @NotNull
    public static final GlobalSearchScope fileScope(@NotNull PsiFile $this$fileScope) {
        Intrinsics.checkNotNullParameter((Object)$this$fileScope, (String)"<this>");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)$this$fileScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(...)");
        return globalSearchScope;
    }

    @NotNull
    public static final SearchScope useScope(@NotNull PsiElement $this$useScope) {
        Intrinsics.checkNotNullParameter((Object)$this$useScope, (String)"<this>");
        SearchScope searchScope2 = PsiSearchHelper.getInstance((Project)$this$useScope.getProject()).getUseScope($this$useScope);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"getUseScope(...)");
        return searchScope2;
    }

    @NotNull
    public static final SearchScope codeUsageScope(@NotNull PsiElement $this$codeUsageScope) {
        Intrinsics.checkNotNullParameter((Object)$this$codeUsageScope, (String)"<this>");
        SearchScope searchScope2 = PsiSearchHelper.getInstance((Project)$this$codeUsageScope.getProject()).getCodeUsageScope($this$codeUsageScope);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"getCodeUsageScope(...)");
        return searchScope2;
    }

    @NotNull
    public static final GlobalSearchScope everythingScopeExcludeFileTypes(@NotNull Project $this$everythingScopeExcludeFileTypes, FileType ... fileTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$everythingScopeExcludeFileTypes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileTypes, (String)"fileTypes");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.everythingScope((Project)$this$everythingScopeExcludeFileTypes), (FileType[])Arrays.copyOf(fileTypes, fileTypes.length));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getScopeRestrictedByFileTypes(...)");
        return KotlinScopeUtils.not(globalSearchScope);
    }

    @NotNull
    public static final GlobalSearchScope restrictByFileType(@NotNull GlobalSearchScope $this$restrictByFileType, @NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)$this$restrictByFileType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        FileType[] fileTypeArray = new FileType[]{fileType};
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)$this$restrictByFileType, (FileType[])fileTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getScopeRestrictedByFileTypes(...)");
        return globalSearchScope;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SearchScope restrictByFileType(@NotNull SearchScope $this$restrictByFileType, @NotNull FileType fileType) {
        SearchScope searchScope2;
        Intrinsics.checkNotNullParameter((Object)$this$restrictByFileType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        SearchScope searchScope3 = $this$restrictByFileType;
        if (searchScope3 instanceof GlobalSearchScope) {
            searchScope2 = (SearchScope)KotlinScopeUtils.restrictByFileType((GlobalSearchScope)$this$restrictByFileType, fileType);
        } else if (searchScope3 instanceof LocalSearchScope) {
            LocalSearchScope localSearchScope;
            void $this$filterTo$iv$iv;
            PsiElement[] psiElementArray = ((LocalSearchScope)$this$restrictByFileType).getScope();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getScope(...)");
            Object[] $this$filter$iv = psiElementArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                PsiElement it = (PsiElement)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getContainingFile().getFileType(), (Object)fileType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List elements2 = (List)destination$iv$iv;
            int n = elements2.size();
            if (n == 0) {
                localSearchScope = LocalSearchScope.EMPTY;
            } else if (n == ((LocalSearchScope)$this$restrictByFileType).getScope().length) {
                localSearchScope = (LocalSearchScope)$this$restrictByFileType;
            } else {
                Collection $this$toTypedArray$iv = elements2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalSearchScope localSearchScope2 = new LocalSearchScope(thisCollection$iv.toArray(new PsiElement[0]));
                localSearchScope = localSearchScope2;
            }
            LocalSearchScope localSearchScope3 = localSearchScope;
            Intrinsics.checkNotNull((Object)localSearchScope3);
            searchScope2 = (SearchScope)localSearchScope3;
        } else {
            searchScope2 = $this$restrictByFileType;
        }
        return searchScope2;
    }

    @NotNull
    public static final GlobalSearchScope restrictToKotlinSources(@NotNull GlobalSearchScope $this$restrictToKotlinSources) {
        Intrinsics.checkNotNullParameter((Object)$this$restrictToKotlinSources, (String)"<this>");
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"INSTANCE");
        return KotlinScopeUtils.restrictByFileType($this$restrictToKotlinSources, (FileType)kotlinFileType);
    }

    @NotNull
    public static final SearchScope restrictToKotlinSources(@NotNull SearchScope $this$restrictToKotlinSources) {
        Intrinsics.checkNotNullParameter((Object)$this$restrictToKotlinSources, (String)"<this>");
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"INSTANCE");
        return KotlinScopeUtils.restrictByFileType($this$restrictToKotlinSources, (FileType)kotlinFileType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SearchScope excludeFileTypes(@NotNull SearchScope $this$excludeFileTypes, @NotNull Project project2, FileType ... fileTypes) {
        SearchScope searchScope2;
        Intrinsics.checkNotNullParameter((Object)$this$excludeFileTypes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileTypes, (String)"fileTypes");
        if ($this$excludeFileTypes instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = ((GlobalSearchScope)$this$excludeFileTypes).intersectWith(KotlinScopeUtils.everythingScopeExcludeFileTypes(project2, Arrays.copyOf(fileTypes, fileTypes.length)));
            Intrinsics.checkNotNull((Object)globalSearchScope);
            searchScope2 = (SearchScope)globalSearchScope;
        } else {
            LocalSearchScope localSearchScope;
            void $this$filterTo$iv$iv;
            LocalSearchScope cfr_ignored_0 = (LocalSearchScope)$this$excludeFileTypes;
            PsiElement[] psiElementArray = ((LocalSearchScope)$this$excludeFileTypes).getScope();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getScope(...)");
            Object[] $this$filter$iv = psiElementArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                PsiElement it = (PsiElement)element$iv$iv;
                boolean bl = false;
                if (!(!ArraysKt.contains((Object[])fileTypes, (Object)it.getContainingFile().getFileType()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filteredElements = (List)destination$iv$iv;
            if (!((Collection)filteredElements).isEmpty()) {
                Collection $this$toTypedArray$iv = filteredElements;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                LocalSearchScope localSearchScope2 = new LocalSearchScope(thisCollection$iv.toArray(new PsiElement[0]));
                localSearchScope = localSearchScope2;
            } else {
                localSearchScope = LocalSearchScope.EMPTY;
            }
            LocalSearchScope localSearchScope3 = localSearchScope;
            Intrinsics.checkNotNull((Object)localSearchScope3);
            searchScope2 = (SearchScope)localSearchScope3;
        }
        return searchScope2;
    }

    @NotNull
    public static final SearchScope excludeKotlinSources(@NotNull SearchScope $this$excludeKotlinSources, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$excludeKotlinSources, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        FileType[] fileTypeArray = new FileType[1];
        Intrinsics.checkNotNullExpressionValue((Object)KotlinFileType.INSTANCE, (String)"INSTANCE");
        return KotlinScopeUtils.excludeFileTypes($this$excludeKotlinSources, project2, fileTypeArray);
    }
}

