/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtNamedClassOrObjectSymbol;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.FilterIsInstanceCallWithClassLiteralArgumentInspectionKt;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.AbstractKotlinApplicableInspection;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.KotlinApplicabilityRange;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.applicators.ApplicabilityRanges;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0019\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0002H\u0016R\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/FilterIsInstanceCallWithClassLiteralArgumentInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/AbstractKotlinApplicableInspection;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "apply", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getActionFamilyName", "", "getApplicabilityRange", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/KotlinApplicabilityRange;", "getProblemDescription", "isApplicableByAnalyze", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/psi/KtCallExpression;)Z", "isApplicableByPsi", "kotlin.code-insight.inspections-shared"})
public final class FilterIsInstanceCallWithClassLiteralArgumentInspection
extends AbstractKotlinApplicableInspection<KtCallExpression>
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return (PsiElementVisitor)new KtVisitorVoid(this, holder, isOnTheFly){
            final /* synthetic */ FilterIsInstanceCallWithClassLiteralArgumentInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            public void visitCallExpression(@NotNull KtCallExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                this.this$0.visitTargetElement((KtElement)expression2, this.$holder, this.$isOnTheFly);
            }
        };
    }

    @Override
    @NotNull
    public String getProblemDescription(@NotNull KtCallExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("inspection.filter.is.instance.call.with.class.literal.argument.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String getActionFamilyName() {
        return KotlinBundle.message("inspection.filter.is.instance.call.with.class.literal.argument.quick.fix.text", new Object[0]);
    }

    @Override
    @NotNull
    public KotlinApplicabilityRange<KtCallExpression> getApplicabilityRange() {
        return ApplicabilityRanges.INSTANCE.getSELF();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableByPsi(@NotNull KtCallExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getCalleeExpression();
        if (!Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"filterIsInstance")) return false;
        List list2 = element3.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list2);
        if (ktValueArgument == null) return false;
        if (!FilterIsInstanceCallWithClassLiteralArgumentInspectionKt.access$isClassLiteral(ktValueArgument)) return false;
        return true;
    }

    @Override
    public boolean isApplicableByAnalyze(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtCallExpression element3) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtFunctionSymbol ktFunctionSymbol = FilterIsInstanceCallWithClassLiteralArgumentInspectionKt.access$resolveToFunctionSymbol(element3, $context_receiver_0);
        if (!Intrinsics.areEqual((Object)(ktFunctionSymbol != null ? ktFunctionSymbol.getCallableIdIfNonLocal() : null), (Object)FilterIsInstanceCallWithClassLiteralArgumentInspectionKt.access$getFILTER_IS_INSTANCE_CALLABLE_ID$p())) {
            return false;
        }
        List list2 = element3.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list2);
        if (ktValueArgument == null || (ktValueArgument = FilterIsInstanceCallWithClassLiteralArgumentInspectionKt.access$classLiteral(ktValueArgument)) == null) {
            return false;
        }
        KtValueArgument classLiteral2 = ktValueArgument;
        KtExpression ktExpression = classLiteral2.getReceiverExpression();
        if (ktExpression == null || (ktExpression = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)ktExpression))) == null) {
            return false;
        }
        KtExpression classNameReference = ktExpression;
        KtNamedClassOrObjectSymbol ktNamedClassOrObjectSymbol = FilterIsInstanceCallWithClassLiteralArgumentInspectionKt.access$resolveToClassSymbol((KtElement)classNameReference, $context_receiver_0);
        if (ktNamedClassOrObjectSymbol == null) {
            return false;
        }
        KtNamedClassOrObjectSymbol classSymbol2 = ktNamedClassOrObjectSymbol;
        return classSymbol2.getTypeParameters().isEmpty();
    }

    @Override
    public void apply(@NotNull KtCallExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            KtExpression ktExpression = element3.getCalleeExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression callee = ktExpression;
            List list2 = element3.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list2);
            if (ktValueArgument == null) {
                return;
            }
            KtValueArgument argument2 = ktValueArgument;
            KtClassLiteralExpression ktClassLiteralExpression = FilterIsInstanceCallWithClassLiteralArgumentInspectionKt.access$classLiteral(argument2);
            String string = ktClassLiteralExpression != null && (ktClassLiteralExpression = ktClassLiteralExpression.getReceiverExpression()) != null ? ktClassLiteralExpression.getText() : null;
            if (string == null) {
                return;
            }
            String typeName = string;
            KtTypeArgumentList ktTypeArgumentList = element3.getTypeArgumentList();
            if (ktTypeArgumentList != null) {
                ktTypeArgumentList.delete();
            }
            KtTypeArgumentList typeArguments2 = new KtPsiFactory(project2, false, 2, null).createTypeArguments("<" + typeName + ">");
            PsiElement psiElement2 = element3.addAfter((PsiElement)typeArguments2, (PsiElement)callee);
            KtElement ktElement = psiElement2 instanceof KtElement ? (KtElement)psiElement2 : null;
            if (ktElement == null) {
                return;
            }
            KtElement newTypeArguments = ktElement;
            ShortenReferencesFacility.Companion.getInstance().shorten(newTypeArguments);
            KtValueArgumentList ktValueArgumentList = element3.getValueArgumentList();
            if (ktValueArgumentList == null) break block5;
            ktValueArgumentList.removeArgument(argument2);
        }
    }
}

