/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/RemoveSetterParameterTypeInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionText", "isApplicable", "", "kotlin.code-insight.inspections-shared"})
public final class RemoveSetterParameterTypeInspection
extends AbstractApplicabilityBasedInspection<KtParameter> {
    public RemoveSetterParameterTypeInspection() {
        super(KtParameter.class);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtParameter element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("redundant.setter.parameter.type", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("remove.explicit.type.specification", new Object[0]);
    }

    @Override
    public void applyTo(@NotNull KtParameter element3, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        element3.setTypeReference(null);
    }

    @Override
    public boolean isApplicable(@NotNull KtParameter element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!KotlinPsiUtilsKt.isSetterParameter(element3)) {
            return false;
        }
        KtTypeReference ktTypeReference = element3.getTypeReference();
        if (ktTypeReference == null) {
            return false;
        }
        KtTypeReference typeReference2 = ktTypeReference;
        return PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)typeReference2)) > PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)typeReference2));
    }
}

