/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.SwapBinaryExpressionIntention;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.SwapBinaryExpressionIntentionKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.util.PsiPrecedences;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J7\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0019\u0010\u000f\u001a\u0015\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0010\u00a2\u0006\u0002\b\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/SwapBinaryExpressionIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "firstDescendantOfTighterPrecedence", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "precedence", "", "getChild", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "isApplicableTo", "", "caretOffset", "leftSubject", "rightSubject", "kotlin.code-insight.intentions-shared"})
@SourceDebugExtension(value={"SMAP\nSwapBinaryExpressionIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwapBinaryExpressionIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/SwapBinaryExpressionIntention\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,91:1\n20#2:92\n20#2:93\n*S KotlinDebug\n*F\n+ 1 SwapBinaryExpressionIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/SwapBinaryExpressionIntention\n*L\n54#1:92\n55#1:93\n*E\n"})
public final class SwapBinaryExpressionIntention
extends SelfTargetingIntention<KtBinaryExpression>
implements LowPriorityAction {
    public SwapBinaryExpressionIntention() {
        super(KtBinaryExpression.class, KotlinBundle.lazyMessage("flip.binary.expression", new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtBinaryExpression element3, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtOperationReferenceExpression ktOperationReferenceExpression = element3.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
        KtOperationReferenceExpression opRef = ktOperationReferenceExpression;
        if (!opRef.getTextRange().containsOffset(caretOffset)) {
            return false;
        }
        if (this.leftSubject(element3) == null || this.rightSubject(element3) == null) {
            return false;
        }
        IElementType iElementType = element3.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
        IElementType operationToken = iElementType;
        String operationTokenText = opRef.getText();
        if (CollectionsKt.contains((Iterable)SwapBinaryExpressionIntentionKt.access$getSUPPORTED_OPERATIONS(), (Object)operationToken) || Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.IDENTIFIER) && SwapBinaryExpressionIntentionKt.access$getSUPPORTED_OPERATION_NAMES().contains(operationTokenText)) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNull((Object)operationTokenText);
            objectArray[0] = operationTokenText;
            this.setTextGetter(KotlinBundle.lazyMessage("flip.0", objectArray));
            return true;
        }
        return false;
    }

    @Override
    public void applyTo(@NotNull KtBinaryExpression element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        String string = element3.getOperationReference().getText();
        Intrinsics.checkNotNull((Object)string);
        String convertedOperator = switch (string) {
            case ">" -> "<";
            case "<" -> ">";
            case "<=" -> ">=";
            case ">=" -> "<=";
            default -> {
                String operator;
                yield operator;
            }
        };
        KtExpression ktExpression = this.leftSubject(element3);
        if (ktExpression == null) {
            return;
        }
        KtExpression left = ktExpression;
        KtExpression ktExpression2 = this.rightSubject(element3);
        if (ktExpression2 == null) {
            return;
        }
        KtExpression right = ktExpression2;
        PsiElement $this$copied$iv = (PsiElement)right;
        boolean $i$f$copied = false;
        PsiElement psiElement2 = $this$copied$iv.copy();
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        KtExpression rightCopy = (KtExpression)((PsiElement)((KtExpression)psiElement2));
        PsiElement $this$copied$iv2 = (PsiElement)left;
        boolean $i$f$copied2 = false;
        PsiElement psiElement3 = $this$copied$iv2.copy();
        if (psiElement3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        KtExpression leftCopy = (KtExpression)((PsiElement)((KtExpression)psiElement3));
        left.replace((PsiElement)rightCopy);
        right.replace((PsiElement)leftCopy);
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project2, false, 2, null);
        String string2 = "$0 " + convertedOperator + " $1";
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNull((Object)element3.getLeft());
        Intrinsics.checkNotNull((Object)element3.getRight());
        element3.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)string2, (Object[])objectArray, (boolean)false, (int)4, null));
    }

    private final KtExpression leftSubject(KtBinaryExpression element3) {
        return this.firstDescendantOfTighterPrecedence(element3.getLeft(), PsiPrecedences.INSTANCE.getPrecedence((KtExpression)element3), (Function1<? super KtBinaryExpression, ? extends KtExpression>)((Function1)leftSubject.1.INSTANCE));
    }

    private final KtExpression rightSubject(KtBinaryExpression element3) {
        return this.firstDescendantOfTighterPrecedence(element3.getRight(), PsiPrecedences.INSTANCE.getPrecedence((KtExpression)element3), (Function1<? super KtBinaryExpression, ? extends KtExpression>)((Function1)rightSubject.1.INSTANCE));
    }

    private final KtExpression firstDescendantOfTighterPrecedence(KtExpression expression2, int precedence, Function1<? super KtBinaryExpression, ? extends KtExpression> getChild) {
        int expressionPrecedence;
        if (expression2 instanceof KtBinaryExpression && !PsiPrecedences.INSTANCE.isTighter(expressionPrecedence = PsiPrecedences.INSTANCE.getPrecedence(expression2), precedence)) {
            return this.firstDescendantOfTighterPrecedence((KtExpression)getChild.invoke((Object)expression2), precedence, getChild);
        }
        return expression2;
    }
}

