/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.api.applicators.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.internal.statistic.ReportingClassSubstitutor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.BaseKotlinApplicator;
import org.jetbrains.kotlin.idea.codeinsight.api.applicators.KotlinApplicatorInput;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\n\b\u0001\u0010\u0003 \u0000*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u00052\u00020\u0006B)\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00028\u0001\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J#\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0094\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\"\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\b\u001a\u00028\u00018\bX\u0089\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/fixes/KotlinApplicatorBasedQuickFix;", "PSI", "Lcom/intellij/psi/PsiElement;", "INPUT", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/KotlinApplicatorInput;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lcom/intellij/internal/statistic/ReportingClassSubstitutor;", "target", "input", "applicator", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/BaseKotlinApplicator;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/KotlinApplicatorInput;Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/BaseKotlinApplicator;)V", "getApplicator", "()Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/BaseKotlinApplicator;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicators/KotlinApplicatorInput;", "getFamilyName", "", "getSubstitutedClass", "Ljava/lang/Class;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "", "kotlin.code-insight.api"})
public final class KotlinApplicatorBasedQuickFix<PSI extends PsiElement, INPUT extends KotlinApplicatorInput>
extends KotlinQuickFixAction<PSI>
implements ReportingClassSubstitutor {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final INPUT input;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final BaseKotlinApplicator<PSI, INPUT> applicator;

    public KotlinApplicatorBasedQuickFix(@NotNull PSI target2, @NotNull INPUT input, @NotNull BaseKotlinApplicator<? super PSI, ? super INPUT> applicator2) {
        Intrinsics.checkNotNullParameter(target2, (String)"target");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(applicator2, (String)"applicator");
        super(target2);
        this.input = input;
        this.applicator = applicator2;
    }

    @NotNull
    public final BaseKotlinApplicator<PSI, INPUT> getApplicator() {
        return this.applicator;
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object t = this.getElement();
        if (t == null) {
            return;
        }
        Object element3 = t;
        if (this.applicator.isApplicableByPsi(element3, project2) && this.input.isValidFor((PsiElement)element3)) {
            this.applicator.applyTo(element3, this.input, project2, editor2);
        }
    }

    @NotNull
    public String getText() {
        Object t = this.getElement();
        if (t == null) {
            return this.getFamilyName();
        }
        Object element3 = t;
        return this.input.isValidFor((PsiElement)element3) ? this.applicator.getActionName(element3, this.input) : this.applicator.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return this.applicator.getFamilyName();
    }

    @Override
    public boolean startInWriteAction() {
        return this.applicator.startInWriteAction();
    }

    @NotNull
    public Class<?> getSubstitutedClass() {
        BaseKotlinApplicator<PSI, INPUT> baseKotlinApplicator = this.applicator;
        ReportingClassSubstitutor reportingClassSubstitutor = baseKotlinApplicator instanceof ReportingClassSubstitutor ? (ReportingClassSubstitutor)baseKotlinApplicator : null;
        Class<Object> clazz = reportingClassSubstitutor != null ? reportingClassSubstitutor.getSubstitutedClass() : null;
        if (clazz == null) {
            clazz = this.applicator.getClass();
        }
        return clazz;
    }
}

