/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiCommentUtilsKt;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.intentions.ConvertConcatenationToBuildStringIntentionUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.psi.BuildStringUtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a*\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006*\u00020\u0003H\u0002\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0001H\u0002\u001a\f\u0010\u000e\u001a\u00020\n*\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"convertConcatenationToBuildStringCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "transformOperand", "Lkotlin/Pair;", "", "Lcom/intellij/psi/PsiElement;", "expression", "isLast", "", "collectOperands", "deleteTailComments", "", "isWhiteSpaceWithLineBreak", "kotlin.code-insight.impl-base"})
@SourceDebugExtension(value={"SMAP\nConvertConcatenationToBuildStringIntentionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertConcatenationToBuildStringIntentionUtils.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/intentions/ConvertConcatenationToBuildStringIntentionUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,65:1\n1559#2:66\n1590#2,4:67\n24#3,7:71\n1313#4,2:78\n*S KotlinDebug\n*F\n+ 1 ConvertConcatenationToBuildStringIntentionUtils.kt\norg/jetbrains/kotlin/idea/codeinsights/impl/base/intentions/ConvertConcatenationToBuildStringIntentionUtilsKt\n*L\n18#1:66\n18#1:67,4\n23#1:71,7\n62#1:78,2\n*E\n"})
public final class ConvertConcatenationToBuildStringIntentionUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtExpression convertConcatenationToBuildStringCall(@NotNull KtBinaryExpression element3) {
        PsiElement psiElement2;
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        List<KtExpression> operands2 = ConvertConcatenationToBuildStringIntentionUtilsKt.collectOperands(element3);
        Iterable $this$mapIndexed$iv = operands2;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void expression2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KtExpression ktExpression = (KtExpression)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ConvertConcatenationToBuildStringIntentionUtilsKt.transformOperand((KtExpression)expression2, index == CollectionsKt.getLastIndex(operands2)));
        }
        List operandsWithExtras = (List)destination$iv$iv;
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtExpression call = BuildStringUtilsKt.generateBuildStringCallWithExtras(project2, operandsWithExtras);
        ConvertConcatenationToBuildStringIntentionUtilsKt.deleteTailComments((KtExpression)element3);
        PsiElement $this$replaced$iv = (PsiElement)element3;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)call))) {
            psiElement2 = (PsiElement)call;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace((PsiElement)call);
            if (result$iv instanceof KtExpression) {
                psiElement2 = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement2 = (PsiElement)ktExpression;
            }
        }
        KtExpression replacedElement = (KtExpression)psiElement2;
        GenericPsiUtils.reformat((PsiElement)replacedElement, true);
        return replacedElement;
    }

    private static final Pair<KtExpression, List<PsiElement>> transformOperand(KtExpression expression2, boolean isLast) {
        KtExpression ktExpression;
        if (expression2 instanceof KtStringTemplateExpression) {
            KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)expression2).getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
            Object object = ArraysKt.singleOrNull((Object[])ktStringTemplateEntryArray);
            ktExpression = object instanceof KtStringTemplateEntryWithExpression ? (KtStringTemplateEntryWithExpression)object : null;
            if (ktExpression == null || (ktExpression = ktExpression.getExpression()) == null) {
                ktExpression = expression2;
            }
        } else {
            ktExpression = expression2;
        }
        KtExpression ktExpression2 = ktExpression;
        Intrinsics.checkNotNull((Object)ktExpression2);
        KtExpression unpackedExpression = ktExpression2;
        List<PsiElement> tailComments2 = KotlinPsiCommentUtilsKt.tailComments(expression2, !isLast, (Function1<? super PsiElement, Boolean>)((Function1)transformOperand.tailComments.1.INSTANCE));
        return new Pair((Object)unpackedExpression, tailComments2);
    }

    private static final List<KtExpression> collectOperands(KtBinaryExpression $this$collectOperands) {
        List expressions2 = new ArrayList();
        ConvertConcatenationToBuildStringIntentionUtilsKt.collectOperands$collect(expressions2, (KtExpression)$this$collectOperands);
        return expressions2;
    }

    private static final void deleteTailComments(KtExpression $this$deleteTailComments) {
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.siblings$default((PsiElement)((PsiElement)$this$deleteTailComments), (boolean)false, (boolean)false, (int)1, null), (Function1)deleteTailComments.1.INSTANCE), (Function1)deleteTailComments.2.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            it.delete();
        }
    }

    private static final boolean isWhiteSpaceWithLineBreak(PsiElement $this$isWhiteSpaceWithLineBreak) {
        return $this$isWhiteSpaceWithLineBreak instanceof PsiWhiteSpace && $this$isWhiteSpaceWithLineBreak.textContains('\n');
    }

    private static final void collectOperands$collect(List<KtExpression> expressions2, KtExpression expression2) {
        KtExpression ktExpression = expression2;
        if (ktExpression instanceof KtBinaryExpression) {
            ConvertConcatenationToBuildStringIntentionUtilsKt.collectOperands$collect(expressions2, ((KtBinaryExpression)expression2).getLeft());
            ConvertConcatenationToBuildStringIntentionUtilsKt.collectOperands$collect(expressions2, ((KtBinaryExpression)expression2).getRight());
        } else if (ktExpression != null) {
            expressions2.add(expression2);
        }
    }

    public static final /* synthetic */ boolean access$isWhiteSpaceWithLineBreak(PsiElement $receiver) {
        return ConvertConcatenationToBuildStringIntentionUtilsKt.isWhiteSpaceWithLineBreak($receiver);
    }
}

