/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.lookups;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.signatures.KtCallableSignature;
import org.jetbrains.kotlin.analysis.api.signatures.KtFunctionLikeSignature;
import org.jetbrains.kotlin.analysis.api.signatures.KtVariableLikeSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtFunctionalType;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.idea.completion.impl.k2.KotlinCompletionImplK2Bundle;
import org.jetbrains.kotlin.idea.completion.lookups.CompletionShortNamesRenderer;
import org.jetbrains.kotlin.idea.completion.lookups.TailTextProvider;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007R\u00020\u0005\u00a2\u0006\u0002\u0010\bJ+\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fR\u00020\u0005\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u000f\u001a\u00020\f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0010R\u00020\u0005\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0012R\u00020\u0005\u00a2\u0006\u0002\u0010\u0013J\f\u0010\u0014\u001a\u00020\u0004*\u00020\u0015H\u0002J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u0004*\u00020\u0017H\u0002R\u00020\u0005\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/completion/lookups/TailTextProvider;", "", "()V", "getTailText", "", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "signature", "Lorg/jetbrains/kotlin/analysis/api/signatures/KtCallableSignature;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/signatures/KtCallableSignature;)Ljava/lang/String;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol;", "usePackageFqName", "", "addTypeParameters", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol;ZZ)Ljava/lang/String;", "insertLambdaBraces", "Lorg/jetbrains/kotlin/analysis/api/signatures/KtFunctionLikeSignature;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/signatures/KtFunctionLikeSignature;)Z", "Lorg/jetbrains/kotlin/analysis/api/types/KtFunctionalType;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/types/KtFunctionalType;)Z", "asStringForTailText", "Lorg/jetbrains/kotlin/name/FqName;", "getContainerPresentation", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KtCallableSymbol;)Ljava/lang/String;", "kotlin.completion.impl-k2"})
@SourceDebugExtension(value={"SMAP\nTailTextProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TailTextProvider.kt\norg/jetbrains/kotlin/idea/completion/lookups/TailTextProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class TailTextProvider {
    @NotNull
    public static final TailTextProvider INSTANCE = new TailTextProvider();

    private TailTextProvider() {
    }

    @NotNull
    public final String getTailText(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtCallableSignature<?> signature2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter(signature2, (String)"signature");
        StringBuilder $this$getTailText_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (signature2 instanceof KtFunctionLikeSignature) {
            if (INSTANCE.insertLambdaBraces($context_receiver_0, (KtFunctionLikeSignature)signature2)) {
                $this$getTailText_u24lambda_u242.append(" {...} ");
            }
            $this$getTailText_u24lambda_u242.append(CompletionShortNamesRenderer.INSTANCE.renderFunctionParameters($context_receiver_0, (KtFunctionLikeSignature)signature2));
        }
        KtType ktType = KtCallableSymbolKt.getReceiverType(signature2.getSymbol());
        if (ktType != null) {
            KtType receiverType2 = ktType;
            boolean bl2 = false;
            String renderedType = $context_receiver_0.render(receiverType2, CompletionShortNamesRenderer.INSTANCE.getRendererVerbose(), Variance.INVARIANT);
            Object[] objectArray = new Object[]{renderedType};
            $this$getTailText_u24lambda_u242.append(KotlinCompletionImplK2Bundle.INSTANCE.message("presentation.tail.for.0", objectArray));
        }
        String string = INSTANCE.getContainerPresentation($context_receiver_0, (KtCallableSymbol)signature2.getSymbol());
        if (string != null) {
            String it = string;
            boolean bl3 = false;
            $this$getTailText_u24lambda_u242.append(it);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    public final String getTailText(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtClassLikeSymbol symbol2, boolean usePackageFqName, boolean addTypeParameters) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        StringBuilder $this$getTailText_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        ClassId classId = symbol2.getClassIdIfNonLocal();
        if (classId != null) {
            FqName fqName2;
            ClassId classId2 = classId;
            boolean bl2 = false;
            if (addTypeParameters && !((Collection)symbol2.getTypeParameters()).isEmpty()) {
                $this$getTailText_u24lambda_u244.append(CollectionsKt.joinToString$default((Iterable)symbol2.getTypeParameters(), (CharSequence)", ", (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)getTailText.2.1.1.INSTANCE, (int)24, null));
            }
            if (usePackageFqName) {
                fqName2 = classId2.getPackageFqName();
            } else {
                FqName fqName3 = classId2.asSingleFqName().parent();
                fqName2 = fqName3;
                Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"parent(...)");
            }
            FqName fqName4 = fqName2;
            $this$getTailText_u24lambda_u244.append(" (");
            $this$getTailText_u24lambda_u244.append(INSTANCE.asStringForTailText(fqName4));
            $this$getTailText_u24lambda_u244.append(")");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static /* synthetic */ String getTailText$default(TailTextProvider tailTextProvider, KtAnalysisSession ktAnalysisSession, KtClassLikeSymbol ktClassLikeSymbol, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return tailTextProvider.getTailText(ktAnalysisSession, ktClassLikeSymbol, bl, bl2);
    }

    private final String getContainerPresentation(KtAnalysisSession $context_receiver_0, KtCallableSymbol $this$getContainerPresentation) {
        Object object;
        CallableId callableId = $this$getContainerPresentation.getCallableIdIfNonLocal();
        if (callableId == null) {
            return null;
        }
        CallableId callableId2 = callableId;
        FqName className = callableId2.getClassName();
        String packagePresentation = this.asStringForTailText(callableId2.getPackageName());
        if (!$this$getContainerPresentation.isExtension() && className != null) {
            object = null;
        } else if (!$this$getContainerPresentation.isExtension()) {
            object = " (" + packagePresentation + ")";
        } else {
            Object object2 = className;
            if (object2 == null || (object2 = object2.asString()) == null) {
                object2 = packagePresentation;
            }
            Object[] objectArray = object2;
            Intrinsics.checkNotNull((Object)objectArray);
            Object containerPresentation = objectArray;
            objectArray = new Object[]{containerPresentation};
            object = KotlinCompletionImplK2Bundle.INSTANCE.message("presentation.tail.in.0", objectArray);
        }
        return object;
    }

    private final String asStringForTailText(FqName $this$asStringForTailText) {
        String string;
        if ($this$asStringForTailText.isRoot()) {
            string = "<root>";
        } else {
            String string2 = $this$asStringForTailText.asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        }
        return string;
    }

    public final boolean insertLambdaBraces(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtFunctionLikeSignature<?> symbol2) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        KtVariableLikeSignature singleParam = (KtVariableLikeSignature)CollectionsKt.singleOrNull(symbol2.getValueParameters());
        return singleParam != null && !((KtValueParameterSymbol)singleParam.getSymbol()).getHasDefaultValue() && singleParam.getReturnType() instanceof KtFunctionalType;
    }

    public final boolean insertLambdaBraces(@NotNull KtAnalysisSession $context_receiver_0, @NotNull KtFunctionalType symbol2) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        KtType singleParam = (KtType)CollectionsKt.singleOrNull(symbol2.getParameterTypes());
        return singleParam != null && singleParam instanceof KtFunctionalType;
    }
}

