/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.conversion.copy;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiUnnamedClass;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.LocalTimeCounter;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.conversion.copy.ContextDeclarations;
import org.jetbrains.kotlin.idea.conversion.copy.ConversionResult;
import org.jetbrains.kotlin.idea.conversion.copy.ConversionTargetData;
import org.jetbrains.kotlin.idea.conversion.copy.ConversionTargetDataKt;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertJavaCopyPasteProcessorKt;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertTextJavaCopyPasteProcessor;
import org.jetbrains.kotlin.idea.conversion.copy.ConvertTextJavaCopyPasteProcessor$isParsedAsFile$;
import org.jetbrains.kotlin.idea.conversion.copy.CopiedJavaCode;
import org.jetbrains.kotlin.idea.conversion.copy.CopiedKotlinCode;
import org.jetbrains.kotlin.idea.conversion.copy.DataForConversion;
import org.jetbrains.kotlin.idea.conversion.copy.ElementAndTextList;
import org.jetbrains.kotlin.idea.conversion.copy.JavaContextDeclarationRenderer;
import org.jetbrains.kotlin.idea.conversion.copy.PlainTextPasteImportResolver;
import org.jetbrains.kotlin.idea.editor.KotlinEditorOptions;
import org.jetbrains.kotlin.idea.statistics.ConversionType;
import org.jetbrains.kotlin.idea.statistics.J2KFusCollector;
import org.jetbrains.kotlin.j2k.J2kConverterExtension;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 F2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004FGHIB\u0005\u00a2\u0006\u0002\u0010\u0003J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010'\u001a\u00020(H\u0016J \u0010)\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010-\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010/\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u00100\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u00101\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u00102\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001f\u001a\u00020 H\u0002J \u00103\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u000bH\u0002JF\u00105\u001a\u0002062\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020$2\u000e\u0010:\u001a\n\u0012\u0006\b\u0000\u0012\u00020*0;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016J&\u0010=\u001a\u00020>*\u00020?2\u0006\u0010\u001f\u001a\u00020 2\b\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020*H\u0002J\u0014\u0010C\u001a\u00020D*\u00020?2\u0006\u0010E\u001a\u00020\"H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePostProcessor;", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "javaContextDeclarationRenderer", "Lorg/jetbrains/kotlin/idea/conversion/copy/JavaContextDeclarationRenderer;", "pasteContext", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$KotlinContext;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getPasteContext", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$KotlinContext;", "collectTransferableData", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startOffsets", "", "endOffsets", "createCopiedJavaCode", "Lorg/jetbrains/kotlin/idea/conversion/copy/CopiedJavaCode;", "prefix", "", "templateWithoutPrefix", "text", "detectConversionContext", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$JavaContext;", "project", "Lcom/intellij/openapi/project/Project;", "detectPasteTarget", "Lorg/jetbrains/kotlin/psi/KtFile;", "startOffset", "", "endOffset", "extractTransferableData", "content", "Ljava/awt/datatransfer/Transferable;", "isParsedAsFile", "", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "isParsedAsJavaCode", "context", "isParsedAsJavaFile", "isParsedAsKotlinCode", "isParsedAsKotlinFile", "parseAsFile", "prepareCopiedJavaCodeByContext", "target", "processTransferableData", "", "bounds", "Lcom/intellij/openapi/editor/RangeMarker;", "caretOffset", "indented", "Lcom/intellij/openapi/util/Ref;", "values", "convertCodeToKotlin", "Lorg/jetbrains/kotlin/idea/conversion/copy/ConversionResult;", "Lorg/jetbrains/kotlin/idea/conversion/copy/DataForConversion;", "targetModule", "Lcom/intellij/openapi/module/Module;", "useNewJ2k", "tryResolveImports", "Lorg/jetbrains/kotlin/idea/conversion/copy/ElementAndTextList;", "targetFile", "Companion", "JavaContext", "KotlinContext", "MyTransferableData", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nConvertTextJavaCopyPasteProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertTextJavaCopyPasteProcessor.kt\norg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,336:1\n17#2,6:337\n1#3:343\n264#4,2:344\n276#4,10:346\n298#4:356\n125#4:365\n12474#5,2:357\n1360#6:359\n1446#6,5:360\n1855#6,2:368\n190#7:366\n190#7:367\n*S KotlinDebug\n*F\n+ 1 ConvertTextJavaCopyPasteProcessor.kt\norg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor\n*L\n154#1:337,6\n246#1:344,2\n246#1:346,10\n246#1:356\n289#1:365\n250#1:357,2\n267#1:359\n267#1:360,5\n144#1:368,2\n294#1:366\n300#1:367\n*E\n"})
public final class ConvertTextJavaCopyPasteProcessor
extends CopyPastePostProcessor<TextBlockTransferableData> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger LOG;
    @NotNull
    private final JavaContextDeclarationRenderer javaContextDeclarationRenderer;
    private static boolean conversionPerformed;

    public ConvertTextJavaCopyPasteProcessor() {
        Logger logger = Logger.getInstance(ConvertTextJavaCopyPasteProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
        this.javaContextDeclarationRenderer = new JavaContextDeclarationRenderer();
    }

    @NotNull
    public List<TextBlockTransferableData> collectTransferableData(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        if (file2 instanceof KtFile) {
            String string = ((KtFile)file2).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return CollectionsKt.listOf((Object)new CopiedKotlinCode(string, startOffsets, endOffsets));
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<TextBlockTransferableData> extractTransferableData(@NotNull Transferable content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        try {
            if (content2.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                if (content2.isDataFlavorSupported(CopiedKotlinCode.Companion.getDATA_FLAVOR()) || content2.isDataFlavorSupported(CopiedJavaCode.Companion.getDATA_FLAVOR())) {
                    return CollectionsKt.emptyList();
                }
                Object object = content2.getTransferData(DataFlavor.stringFlavor);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String text2 = (String)object;
                return CollectionsKt.listOf((Object)new MyTransferableData(text2));
            }
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            this.LOG.error(e);
        }
        return CollectionsKt.emptyList();
    }

    public void processTransferableData(@NotNull Project project2, @NotNull Editor editor2, @NotNull RangeMarker bounds, int caretOffset, @NotNull Ref<? super Boolean> indented, @NotNull List<? extends TextBlockTransferableData> values2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(indented, (String)"indented");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        if (DumbService.Companion.getInstance(project2).isDumb()) {
            return;
        }
        if (!KotlinEditorOptions.getInstance().isEnableJavaToKotlinConversion()) {
            return;
        }
        Object object = CollectionsKt.single(values2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.conversion.copy.ConvertTextJavaCopyPasteProcessor.MyTransferableData");
        String string = TextBlockTransferable.convertLineSeparators((Editor)editor2, (String)((MyTransferableData)object).getText(), (Collection)values2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        String text2 = string;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        ConversionTargetData conversionTargetData = ConversionTargetDataKt.getTargetData(project2, editor2, caretOffset, bounds);
        if (conversionTargetData == null) {
            return;
        }
        ConversionTargetData conversionTargetData2 = conversionTargetData;
        KtFile targetFile2 = conversionTargetData2.component1();
        RangeMarker targetBounds = conversionTargetData2.component2();
        Document targetDocument = conversionTargetData2.component3();
        psiDocumentManager.commitDocument(targetDocument);
        boolean useNewJ2k = ConvertJavaCopyPasteProcessorKt.checkUseNewJ2k(targetFile2);
        Module targetModule = GenericPsiUtils.getModule((PsiElement)targetFile2);
        KtElement ktElement = this.detectPasteTarget(targetFile2, targetBounds.getStartOffset(), targetBounds.getEndOffset());
        if (ktElement == null) {
            return;
        }
        KtElement pasteTarget = ktElement;
        JavaContext javaContext = this.detectConversionContext(this.getPasteContext(pasteTarget), text2, project2);
        if (javaContext == null) {
            return;
        }
        JavaContext conversionContext = javaContext;
        if (!ConvertJavaCopyPasteProcessorKt.confirmConvertJavaOnPaste(project2, true)) {
            return;
        }
        CopiedJavaCode copiedJavaCode = this.prepareCopiedJavaCodeByContext(text2, conversionContext, pasteTarget);
        DataForConversion dataForConversion = DataForConversion.Companion.prepare(copiedJavaCode, project2);
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        ConvertTextJavaCopyPasteProcessor.processTransferableData$convert(this, dataForConversion, targetFile2, project2, targetModule, useNewJ2k, psiDocumentManager, targetDocument, targetBounds, bounds, editor2);
        long conversionTime = System.currentTimeMillis() - start$iv;
        J2KFusCollector.INSTANCE.log(ConversionType.TEXT_EXPRESSION, ConvertJavaCopyPasteProcessorKt.checkUseNewJ2k(targetFile2), conversionTime, ConvertJavaCopyPasteProcessorKt.linesCount(dataForConversion.getElementsAndTexts()), 1);
    }

    private final ConversionResult convertCodeToKotlin(DataForConversion $this$convertCodeToKotlin, Project project2, Module targetModule, boolean useNewJ2k) {
        return ConvertJavaCopyPasteProcessorKt.convertCodeToKotlin($this$convertCodeToKotlin.getElementsAndTexts(), project2, targetModule, useNewJ2k);
    }

    private final KotlinContext getPasteContext(KtElement $this$pasteContext) {
        KtElement ktElement = $this$pasteContext;
        return ktElement instanceof KtFile ? KotlinContext.TOP_LEVEL : (ktElement instanceof KtClassBody ? KotlinContext.CLASS_BODY : (ktElement instanceof KtBlockExpression ? KotlinContext.IN_BLOCK : KotlinContext.EXPRESSION));
    }

    private final KtElement detectPasteTarget(KtFile file2, int startOffset, int endOffset2) {
        if (ConvertJavaCopyPasteProcessorKt.isNoConversionPosition(file2, startOffset)) {
            return null;
        }
        String fileText2 = file2.getText();
        String dummyDeclarationText = "fun dummy(){}";
        Intrinsics.checkNotNull((Object)fileText2);
        String string = fileText2.substring(0, startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String string2 = fileText2.substring(endOffset2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        String newFileText = string + " " + dummyDeclarationText + "\n" + string2;
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"INSTANCE");
        LanguageFileType languageFileType = (LanguageFileType)kotlinFileType;
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        PsiFile newFile = this.parseAsFile(newFileText, languageFileType, project2);
        Intrinsics.checkNotNull((Object)newFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtPsiFactoryKt.setAnalysisContext((KtFile)((KtFile)newFile), (PsiElement)((PsiElement)file2));
        PsiElement psiElement2 = newFile.findElementAt(startOffset + 1);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement funKeyword = psiElement2;
        if (!Intrinsics.areEqual((Object)funKeyword.getNode().getElementType(), (Object)KtTokens.FUN_KEYWORD)) {
            return null;
        }
        PsiElement psiElement3 = funKeyword.getParent();
        KtFunction ktFunction = psiElement3 instanceof KtFunction ? (KtFunction)psiElement3 : null;
        if (ktFunction == null) {
            return null;
        }
        KtFunction declaration2 = ktFunction;
        PsiElement psiElement4 = declaration2.getParent();
        return psiElement4 instanceof KtElement ? (KtElement)psiElement4 : null;
    }

    private final JavaContext detectConversionContext(KotlinContext pasteContext, String text2, Project project2) {
        if (this.isParsedAsKotlinCode(text2, pasteContext, project2)) {
            return null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[pasteContext.ordinal()]) {
            case 1: {
                JavaContext javaContext = ConvertTextJavaCopyPasteProcessor.detectConversionContext$check(JavaContext.TOP_LEVEL, this, text2, project2);
                if (javaContext != null) {
                    JavaContext it = javaContext;
                    boolean bl = false;
                    return it;
                }
                javaContext = ConvertTextJavaCopyPasteProcessor.detectConversionContext$check(JavaContext.CLASS_BODY, this, text2, project2);
                if (javaContext != null) {
                    JavaContext it = javaContext;
                    boolean bl = false;
                    return it;
                }
                return null;
            }
            case 2: {
                return ConvertTextJavaCopyPasteProcessor.detectConversionContext$check(JavaContext.CLASS_BODY, this, text2, project2);
            }
            case 3: {
                return ConvertTextJavaCopyPasteProcessor.detectConversionContext$check(JavaContext.IN_BLOCK, this, text2, project2);
            }
            case 4: {
                return ConvertTextJavaCopyPasteProcessor.detectConversionContext$check(JavaContext.EXPRESSION, this, text2, project2);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final boolean isParsedAsJavaCode(String text2, JavaContext context2, Project project2) {
        return switch (WhenMappings.$EnumSwitchMapping$1[context2.ordinal()]) {
            case 1 -> this.isParsedAsJavaFile(text2, project2);
            case 2 -> this.isParsedAsJavaFile("class Dummy { " + text2 + "\n}", project2);
            case 3 -> this.isParsedAsJavaFile("class Dummy { void foo() {" + text2 + "\n}\n}", project2);
            case 4 -> this.isParsedAsJavaFile("class Dummy { Object field = " + text2 + "; }", project2);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isParsedAsKotlinCode(String text2, KotlinContext context2, Project project2) {
        return switch (WhenMappings.$EnumSwitchMapping$0[context2.ordinal()]) {
            case 1 -> this.isParsedAsKotlinFile(text2, project2);
            case 2 -> this.isParsedAsKotlinFile("class Dummy { " + text2 + "\n}", project2);
            case 3 -> this.isParsedAsKotlinFile("fun foo() {" + text2 + "\n}", project2);
            case 4 -> this.isParsedAsKotlinFile("val v = " + text2, project2);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isParsedAsJavaFile(String text2, Project project2) {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)javaFileType, (String)"INSTANCE");
        return this.isParsedAsFile(text2, (LanguageFileType)javaFileType, project2);
    }

    private final boolean isParsedAsKotlinFile(String text2, Project project2) {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"INSTANCE");
        return this.isParsedAsFile(text2, (LanguageFileType)kotlinFileType, project2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isParsedAsFile(String text2, LanguageFileType fileType, Project project2) {
        PsiFile psiFile2 = this.parseAsFile(text2, fileType, project2);
        PsiElement $this$anyDescendantOfType_u24default$iv = (PsiElement)psiFile2;
        Function1 predicate$iv = isParsedAsFile$$inlined$anyDescendantOfType$default$1.INSTANCE;
        boolean $i$f$anyDescendantOfType = false;
        PsiElement $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType_u24default$iv;
        boolean $i$f$findDescendantOfType = false;
        PsiElement $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (element3 instanceof PsiErrorElement && ((Boolean)this.$predicate.invoke((Object)element3)).booleanValue()) {
                    this.$result.element = element3;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element3;
                boolean bl = false;
                super.visitElement(element3);
            }
        });
        if ((PsiElement)result$iv$iv$iv.element != null) {
            return false;
        }
        boolean bl = false;
        boolean hasErrors = bl;
        if (hasErrors) {
            return false;
        }
        if (!(psiFile2 instanceof PsiJavaFile)) return true;
        PsiClass[] psiClassArray = ((PsiJavaFile)psiFile2).getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
        Object[] $this$any$iv = psiClassArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            Object element$iv = $this$any$iv[n];
            PsiClass it = (PsiClass)element$iv;
            boolean bl2 = false;
            if (it instanceof PsiUnnamedClass) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final PsiFile parseAsFile(String text2, LanguageFileType fileType, Project project2) {
        PsiFile psiFile2 = PsiFileFactory.getInstance((Project)project2).createFileFromText("Dummy." + fileType.getDefaultExtension(), (FileType)fileType, (CharSequence)text2, LocalTimeCounter.currentTime(), true);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"createFileFromText(...)");
        return psiFile2;
    }

    /*
     * WARNING - void declaration
     */
    private final ElementAndTextList tryResolveImports(DataForConversion $this$tryResolveImports, KtFile targetFile2) {
        void $this$flatMapTo$iv$iv;
        PlainTextPasteImportResolver importResolver = new PlainTextPasteImportResolver($this$tryResolveImports, targetFile2);
        importResolver.addImportsFromTargetFile();
        importResolver.tryResolveReferences();
        Iterable $this$flatMap$iv = importResolver.getAddedImports();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiImportStatementBase importStatement = (PsiImportStatementBase)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{"\n", importStatement};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)"\n\n");
        return new ElementAndTextList(list2);
    }

    /*
     * WARNING - void declaration
     */
    private final CopiedJavaCode prepareCopiedJavaCodeByContext(String text2, JavaContext context2, KtElement target2) {
        String string;
        StringBuilder stringBuilder;
        PsiFile psiFile2 = target2.getContainingFile();
        Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtFile targetFile2 = (KtFile)psiFile2;
        ContextDeclarations contextDeclarations = this.javaContextDeclarationRenderer.render(target2);
        String localDeclarations2 = contextDeclarations.component1();
        String memberDeclarations2 = contextDeclarations.component2();
        StringBuilder $this$prepareCopiedJavaCodeByContext_u24lambda_u248 = stringBuilder = new StringBuilder();
        boolean bl = false;
        KtPackageDirective ktPackageDirective = targetFile2.getPackageDirective();
        if (ktPackageDirective != null) {
            KtPackageDirective it = ktPackageDirective;
            boolean bl2 = false;
            String string2 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            if (((CharSequence)string2).length() > 0) {
                $this$prepareCopiedJavaCodeByContext_u24lambda_u248.append(it.getText());
                $this$prepareCopiedJavaCodeByContext_u24lambda_u248.append(";\n");
            }
        }
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        String prefix2 = string3;
        switch (WhenMappings.$EnumSwitchMapping$1[context2.ordinal()]) {
            case 1: {
                string = "";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                boolean $i$f$ifNotEmpty;
                Object[] $this$ifNotEmpty$iv;
                StringBuilder stringBuilder2;
                void $this$getParentOfType$iv;
                PsiElement psiElement2 = (PsiElement)target2;
                boolean strict$iv = false;
                boolean $i$f$getParentOfType = false;
                KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, (boolean)strict$iv);
                Object[] lightClass = ktClass2 != null ? LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass2)) : null;
                StringBuilder $this$prepareCopiedJavaCodeByContext_u24lambda_u2411 = stringBuilder2 = new StringBuilder();
                boolean bl3 = false;
                $this$prepareCopiedJavaCodeByContext_u24lambda_u2411.append("class ");
                Object object = lightClass;
                if (lightClass == null || (object = object.getName()) == null) {
                    object = "Dummy";
                }
                $this$prepareCopiedJavaCodeByContext_u24lambda_u2411.append((String)object);
                Object[] objectArray = lightClass;
                if (lightClass != null && (objectArray = objectArray.getExtendsListTypes()) != null) {
                    $this$ifNotEmpty$iv = objectArray;
                    $i$f$ifNotEmpty = false;
                    if (!($this$ifNotEmpty$iv.length == 0)) {
                        Object[] $this$prepareCopiedJavaCodeByContext_u24lambda_u2411_u24lambda_u249 = $this$ifNotEmpty$iv;
                        boolean bl4 = false;
                        StringBuilder cfr_ignored_0 = (StringBuilder)ArraysKt.joinTo$default((Object[])$this$prepareCopiedJavaCodeByContext_u24lambda_u2411_u24lambda_u249, (Appendable)$this$prepareCopiedJavaCodeByContext_u24lambda_u2411, null, (CharSequence)" extends ", null, (int)0, null, (Function1)prepareCopiedJavaCodeByContext.classDef.1.1.1.INSTANCE, (int)58, null);
                    }
                }
                Object[] objectArray2 = lightClass;
                if (lightClass != null && (objectArray2 = objectArray2.getImplementsListTypes()) != null) {
                    $this$ifNotEmpty$iv = objectArray2;
                    $i$f$ifNotEmpty = false;
                    if (!($this$ifNotEmpty$iv.length == 0)) {
                        Object[] $this$prepareCopiedJavaCodeByContext_u24lambda_u2411_u24lambda_u2410 = $this$ifNotEmpty$iv;
                        boolean bl5 = false;
                        StringBuilder cfr_ignored_1 = (StringBuilder)ArraysKt.joinTo$default((Object[])$this$prepareCopiedJavaCodeByContext_u24lambda_u2411_u24lambda_u2410, (Appendable)$this$prepareCopiedJavaCodeByContext_u24lambda_u2411, null, (CharSequence)" implements ", null, (int)0, null, (Function1)prepareCopiedJavaCodeByContext.classDef.1.2.1.INSTANCE, (int)58, null);
                    }
                }
                String string4 = stringBuilder2.toString();
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String classDef2 = string;
        return switch (WhenMappings.$EnumSwitchMapping$1[context2.ordinal()]) {
            case 1 -> this.createCopiedJavaCode(prefix2, "$", text2);
            case 2 -> this.createCopiedJavaCode(prefix2, classDef2 + " {\n" + memberDeclarations2 + " $\n}", text2);
            case 3 -> this.createCopiedJavaCode(prefix2, classDef2 + " {\n" + memberDeclarations2 + " void foo() {\n" + localDeclarations2 + " $\n}\n}", text2);
            case 4 -> this.createCopiedJavaCode(prefix2, classDef2 + " {\nObject field = $\n}", text2);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final CopiedJavaCode createCopiedJavaCode(String prefix2, String templateWithoutPrefix, String text2) {
        boolean bl;
        String template2 = prefix2 + templateWithoutPrefix;
        int index = StringsKt.indexOf$default((CharSequence)template2, (String)"$", (int)0, (boolean)false, (int)6, null);
        boolean bl2 = bl = index >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = template2.substring(0, index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String string2 = template2.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        String fileText2 = string + text2 + string2;
        int[] nArray = new int[]{index};
        int[] nArray2 = nArray;
        nArray = new int[]{index + text2.length()};
        return new CopiedJavaCode(fileText2, nArray2, nArray);
    }

    private static final void processTransferableData$convert(ConvertTextJavaCopyPasteProcessor this$0, DataForConversion dataForConversion, KtFile targetFile2, Project $project, Module targetModule, boolean useNewJ2k, PsiDocumentManager psiDocumentManager, Document targetDocument, RangeMarker targetBounds, RangeMarker $bounds, Editor $editor) {
        ElementAndTextList additionalImports = this$0.tryResolveImports(dataForConversion, targetFile2);
        ProgressManager.checkCanceled();
        Ref.ObjectRef convertedImportsText = new Ref.ObjectRef();
        convertedImportsText.element = ConvertJavaCopyPasteProcessorKt.convertCodeToKotlin(additionalImports, $project, targetModule, useNewJ2k).getText();
        ConversionResult convertedResult = this$0.convertCodeToKotlin(dataForConversion, $project, targetModule, useNewJ2k);
        String convertedText = convertedResult.getText();
        ProgressManager.checkCanceled();
        Object object = ActionsKt.runWriteAction((Function0)((Function0)new Function0<RangeMarker>(targetFile2, (Ref.ObjectRef<String>)convertedImportsText, targetDocument, targetBounds, convertedText, $bounds, $editor){
            final /* synthetic */ KtFile $targetFile;
            final /* synthetic */ Ref.ObjectRef<String> $convertedImportsText;
            final /* synthetic */ Document $targetDocument;
            final /* synthetic */ RangeMarker $targetBounds;
            final /* synthetic */ String $convertedText;
            final /* synthetic */ RangeMarker $bounds;
            final /* synthetic */ Editor $editor;
            {
                this.$targetFile = $targetFile;
                this.$convertedImportsText = $convertedImportsText;
                this.$targetDocument = $targetDocument;
                this.$targetBounds = $targetBounds;
                this.$convertedText = $convertedText;
                this.$bounds = $bounds;
                this.$editor = $editor;
                super(0);
            }

            @NotNull
            public final RangeMarker invoke() {
                int importsInsertOffset;
                KtImportList ktImportList = this.$targetFile.getImportList();
                int n = importsInsertOffset = ktImportList != null ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)ktImportList)) : 0;
                if (this.$targetFile.getImportDirectives().isEmpty() && importsInsertOffset > 0) {
                    this.$convertedImportsText.element = "\n" + this.$convertedImportsText.element;
                }
                if (!StringsKt.isBlank((CharSequence)((CharSequence)this.$convertedImportsText.element))) {
                    this.$targetDocument.insertString(importsInsertOffset, (CharSequence)this.$convertedImportsText.element);
                }
                int startOffset = this.$targetBounds.getStartOffset();
                this.$targetDocument.replaceString(startOffset, this.$targetBounds.getEndOffset(), (CharSequence)this.$convertedText);
                int endOffsetAfterCopy = this.$bounds.getStartOffset() + this.$convertedText.length();
                this.$editor.getCaretModel().moveToOffset(endOffsetAfterCopy);
                return this.$targetDocument.createRangeMarker(startOffset, startOffset + this.$convertedText.length());
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteAction(...)");
        RangeMarker newBounds2 = (RangeMarker)object;
        psiDocumentManager.commitAllDocuments();
        ProgressManager.checkCanceled();
        if (useNewJ2k) {
            PostProcessor postProcessor2 = J2kConverterExtension.Companion.extension(true).createPostProcessor(true);
            Iterable $this$forEach$iv = convertedResult.getImportsToAdd();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FqName fqName2 = (FqName)element$iv;
                boolean bl = false;
                postProcessor2.insertImport(targetFile2, fqName2);
            }
        }
        ConvertJavaCopyPasteProcessorKt.runPostProcessing($project, targetFile2, UtilsKt.getRange((RangeMarker)newBounds2), convertedResult.getConverterContext(), useNewJ2k);
        conversionPerformed = true;
    }

    private static final JavaContext detectConversionContext$check(JavaContext $this$detectConversionContext_u24check, ConvertTextJavaCopyPasteProcessor this$0, String $text, Project $project) {
        JavaContext javaContext;
        JavaContext it = javaContext = $this$detectConversionContext_u24check;
        boolean bl = false;
        return this$0.isParsedAsJavaCode($text, it, $project) ? javaContext : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$Companion;", "", "()V", "conversionPerformed", "", "getConversionPerformed", "()Z", "setConversionPerformed", "(Z)V", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        public final boolean getConversionPerformed() {
            return conversionPerformed;
        }

        public final void setConversionPerformed(boolean bl) {
            conversionPerformed = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$JavaContext;", "", "(Ljava/lang/String;I)V", "TOP_LEVEL", "CLASS_BODY", "IN_BLOCK", "EXPRESSION", "kotlin.idea"})
    private static final class JavaContext
    extends Enum<JavaContext> {
        public static final /* enum */ JavaContext TOP_LEVEL = new JavaContext();
        public static final /* enum */ JavaContext CLASS_BODY = new JavaContext();
        public static final /* enum */ JavaContext IN_BLOCK = new JavaContext();
        public static final /* enum */ JavaContext EXPRESSION = new JavaContext();
        private static final /* synthetic */ JavaContext[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static JavaContext[] values() {
            return (JavaContext[])$VALUES.clone();
        }

        public static JavaContext valueOf(String value2) {
            return Enum.valueOf(JavaContext.class, value2);
        }

        @NotNull
        public static EnumEntries<JavaContext> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = javaContextArray = new JavaContext[]{JavaContext.TOP_LEVEL, JavaContext.CLASS_BODY, JavaContext.IN_BLOCK, JavaContext.EXPRESSION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$KotlinContext;", "", "(Ljava/lang/String;I)V", "TOP_LEVEL", "CLASS_BODY", "IN_BLOCK", "EXPRESSION", "kotlin.idea"})
    private static final class KotlinContext
    extends Enum<KotlinContext> {
        public static final /* enum */ KotlinContext TOP_LEVEL = new KotlinContext();
        public static final /* enum */ KotlinContext CLASS_BODY = new KotlinContext();
        public static final /* enum */ KotlinContext IN_BLOCK = new KotlinContext();
        public static final /* enum */ KotlinContext EXPRESSION = new KotlinContext();
        private static final /* synthetic */ KotlinContext[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static KotlinContext[] values() {
            return (KotlinContext[])$VALUES.clone();
        }

        public static KotlinContext valueOf(String value2) {
            return Enum.valueOf(KotlinContext.class, value2);
        }

        @NotNull
        public static EnumEntries<KotlinContext> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = kotlinContextArray = new KotlinContext[]{KotlinContext.TOP_LEVEL, KotlinContext.CLASS_BODY, KotlinContext.IN_BLOCK, KotlinContext.EXPRESSION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$MyTransferableData;", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "getFlavor", "Ljava/awt/datatransfer/DataFlavor;", "Companion", "kotlin.idea"})
    private static final class MyTransferableData
    implements TextBlockTransferableData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String text;
        @NotNull
        private static final DataFlavor DATA_FLAVOR = new DataFlavor(ConvertTextJavaCopyPasteProcessor.class, "class: ConvertTextJavaCopyPasteProcessor");

        public MyTransferableData(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public DataFlavor getFlavor() {
            return DATA_FLAVOR;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/conversion/copy/ConvertTextJavaCopyPasteProcessor$MyTransferableData$Companion;", "", "()V", "DATA_FLAVOR", "Ljava/awt/datatransfer/DataFlavor;", "getDATA_FLAVOR", "()Ljava/awt/datatransfer/DataFlavor;", "kotlin.idea"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DataFlavor getDATA_FLAVOR() {
                return DATA_FLAVOR;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[KotlinContext.values().length];
            try {
                nArray[KotlinContext.TOP_LEVEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinContext.CLASS_BODY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinContext.IN_BLOCK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinContext.EXPRESSION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JavaContext.values().length];
            try {
                nArray[JavaContext.TOP_LEVEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaContext.CLASS_BODY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaContext.IN_BLOCK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JavaContext.EXPRESSION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

