/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.LineBreakpointExpressionVisitorKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.Lines;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 ^2\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001:\u0001^B\u0017\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\rJ\u001f\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0015J%\u0010\u0016\u001a\u00020\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\"J\u001f\u0010#\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020$2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010%J\u001f\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010)J\u001f\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010-J\u001f\u0010.\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020/2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00100J\u001f\u00101\u001a\u00020\u00022\u0006\u00102\u001a\u0002032\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00104J\u001f\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u0002072\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00108J\u001f\u00109\u001a\u00020\u00022\u0006\u0010:\u001a\u00020;2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010<J\u001f\u0010=\u001a\u00020\u00022\u0006\u0010>\u001a\u00020?2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010@J\u001f\u0010A\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020B2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010CJ\u001f\u0010D\u001a\u00020\u00022\u0006\u0010E\u001a\u00020F2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010GJ\u001f\u0010H\u001a\u00020\u00022\u0006\u0010I\u001a\u00020J2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010KJ\u001f\u0010L\u001a\u00020\u00022\u0006\u0010M\u001a\u00020N2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010OJ\u001f\u0010P\u001a\u00020\u00022\u0006\u0010Q\u001a\u00020R2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010SJ\u001f\u0010T\u001a\u00020\u00022\u0006\u0010U\u001a\u00020V2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010WJ\u0016\u0010X\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010Y\u001a\u00020$H\u0002J\u000e\u0010Z\u001a\u00020[*\u0004\u0018\u00010\u0019H\u0002J\u000e\u0010\\\u001a\u00020]*\u0004\u0018\u00010\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/LineBreakpointExpressionVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "", "document", "Lcom/intellij/openapi/editor/Document;", "mainLine", "", "(Lcom/intellij/openapi/editor/Document;I)V", "visitAnnotationEntry", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "data", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitBlockExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "(Lorg/jetbrains/kotlin/psi/KtBlockExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitCatchSection", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "(Lorg/jetbrains/kotlin/psi/KtCatchClause;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitChildren", "children", "", "Lcom/intellij/psi/PsiElement;", "(Ljava/util/List;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitDestructuringDeclaration", "multiDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitImportDirective", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "(Lorg/jetbrains/kotlin/psi/KtImportDirective;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitKtElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "(Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitPackageDirective", "directive", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "(Lorg/jetbrains/kotlin/psi/KtPackageDirective;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "(Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitPropertyAccessor", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "(Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitPropertyDelegate", "delegate", "Lorg/jetbrains/kotlin/psi/KtPropertyDelegate;", "(Lorg/jetbrains/kotlin/psi/KtPropertyDelegate;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitSecondaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "visitWhenEntry", "ktWhenEntry", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "(Lorg/jetbrains/kotlin/psi/KtWhenEntry;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/ApplicabilityResult;", "acceptIfMultiLineParent", "parent", "getLines", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/Lines;", "isSameLine", "", "Companion", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nLineBreakpointExpressionVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineBreakpointExpressionVisitor.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/LineBreakpointExpressionVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public final class LineBreakpointExpressionVisitor
extends KtVisitor<ApplicabilityResult, Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Document document;
    private final int mainLine;

    private LineBreakpointExpressionVisitor(Document document, int mainLine) {
        this.document = document;
        this.mainLine = mainLine;
    }

    @NotNull
    public ApplicabilityResult visitKtElement(@NotNull KtElement element3, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiElement[] psiElementArray = element3.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        return this.visitChildren(ArraysKt.asList((Object[])psiElementArray), data2);
    }

    private final ApplicabilityResult visitChildren(List<? extends PsiElement> children2, Unit data2) {
        if (children2.isEmpty() || !this.isSameLine((PsiElement)CollectionsKt.first(children2))) {
            return ApplicabilityResult.UNKNOWN;
        }
        boolean isApplicable2 = false;
        for (PsiElement psiElement2 : children2) {
            KtElement ktElement = psiElement2 instanceof KtElement ? (KtElement)psiElement2 : null;
            if (ktElement == null) continue;
            KtElement ktElement2 = ktElement;
            ApplicabilityResult result2 = (ApplicabilityResult)ktElement2.accept((KtVisitor)this, (Object)data2);
            if (result2.getShouldStop()) {
                return result2;
            }
            isApplicable2 |= result2.isApplicable();
        }
        return ApplicabilityResult.Companion.maybe(isApplicable2);
    }

    @NotNull
    public ApplicabilityResult visitExpression(@NotNull KtExpression expression2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (this.isSameLine((PsiElement)expression2)) {
            ApplicabilityResult superResult = (ApplicabilityResult)super.visitExpression(expression2, (Object)data2);
            if (superResult.getShouldStop()) {
                Intrinsics.checkNotNull((Object)superResult);
                return superResult;
            }
            return ApplicabilityResult.MAYBE_YES;
        }
        return ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitClass(@NotNull KtClass klass2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)klass2, (String)"klass");
        ApplicabilityResult applicabilityResult = LineBreakpointExpressionVisitorKt.access$handle(this.visitChildren(klass2.getPrimaryConstructorParameters(), data2));
        if (applicabilityResult != null) {
            ApplicabilityResult it = applicabilityResult;
            boolean bl = false;
            return it;
        }
        KtClassBody ktClassBody = klass2.getBody();
        ApplicabilityResult applicabilityResult2 = ktClassBody != null ? (ApplicabilityResult)ktClassBody.accept((KtVisitor)this, (Object)data2) : null;
        if (applicabilityResult2 == null) {
            applicabilityResult2 = ApplicabilityResult.UNKNOWN;
        }
        return applicabilityResult2;
    }

    @NotNull
    public ApplicabilityResult visitObjectDeclaration(@NotNull KtObjectDeclaration declaration2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KtClassBody ktClassBody = declaration2.getBody();
        ApplicabilityResult applicabilityResult = ktClassBody != null ? (ApplicabilityResult)ktClassBody.accept((KtVisitor)this, (Object)data2) : null;
        if (applicabilityResult == null) {
            applicabilityResult = ApplicabilityResult.UNKNOWN;
        }
        return applicabilityResult;
    }

    @NotNull
    public ApplicabilityResult visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor2, @Nullable Unit data2) {
        ApplicabilityResult applicabilityResult;
        ApplicabilityResult applicabilityResult2;
        Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
        KtBlockExpression ktBlockExpression = constructor2.getBodyExpression();
        return ktBlockExpression != null && (applicabilityResult2 = (ApplicabilityResult)ktBlockExpression.accept((KtVisitor)this, (Object)data2)) != null && (applicabilityResult = this.acceptIfMultiLineParent(applicabilityResult2, (KtExpression)constructor2)) != null ? applicabilityResult : ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitParameter(@NotNull KtParameter parameter2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
        KtExpression defaultValue = parameter2.getDefaultValue();
        if (this.isSameLine((PsiElement)defaultValue)) {
            return ApplicabilityResult.DEFINITELY_YES;
        }
        return ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitCatchSection(@NotNull KtCatchClause catchClause, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
        return ApplicabilityResult.MAYBE_YES;
    }

    @NotNull
    public ApplicabilityResult visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
        return ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitPackageDirective(@NotNull KtPackageDirective directive, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        return ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitImportDirective(@NotNull KtImportDirective importDirective2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)importDirective2, (String)"importDirective");
        return ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitProperty(@NotNull KtProperty property2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        if (property2.hasModifier(KtTokens.CONST_KEYWORD)) {
            return ApplicabilityResult.UNKNOWN;
        }
        Object object = super.visitProperty(property2, (Object)data2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"visitProperty(...)");
        return (ApplicabilityResult)object;
    }

    @NotNull
    public ApplicabilityResult visitNamedFunction(@NotNull KtNamedFunction function2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        if (this.isSameLine((PsiElement)function2) && KtPsiUtil.isLocal((KtDeclaration)((KtDeclaration)function2))) {
            return ApplicabilityResult.MAYBE_YES;
        }
        List list2 = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        ApplicabilityResult applicabilityResult = LineBreakpointExpressionVisitorKt.access$handle(this.visitChildren(list2, data2));
        if (applicabilityResult != null) {
            ApplicabilityResult it = applicabilityResult;
            boolean bl = false;
            return it;
        }
        KtExpression ktExpression = function2.getBodyExpression();
        applicabilityResult = ktExpression != null ? (ApplicabilityResult)ktExpression.accept((KtVisitor)this, (Object)data2) : null;
        return applicabilityResult == null ? ApplicabilityResult.UNKNOWN : applicabilityResult;
    }

    @NotNull
    public ApplicabilityResult visitPropertyAccessor(@NotNull KtPropertyAccessor accessor, @Nullable Unit data2) {
        ApplicabilityResult applicabilityResult;
        ApplicabilityResult applicabilityResult2;
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        KtExpression ktExpression = accessor.getBodyExpression();
        return ktExpression != null && (applicabilityResult2 = (ApplicabilityResult)ktExpression.accept((KtVisitor)this, (Object)data2)) != null && (applicabilityResult = this.acceptIfMultiLineParent(applicabilityResult2, (KtExpression)accessor)) != null ? applicabilityResult : ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitPropertyDelegate(@NotNull KtPropertyDelegate delegate, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        return ApplicabilityResult.Companion.maybe(this.isSameLine((PsiElement)delegate));
    }

    @NotNull
    public ApplicabilityResult visitLambdaExpression(@NotNull KtLambdaExpression expression2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (this.isSameLine((PsiElement)expression2)) {
            return ApplicabilityResult.DEFINITELY_YES;
        }
        return ApplicabilityResult.UNKNOWN;
    }

    @NotNull
    public ApplicabilityResult visitWhenEntry(@NotNull KtWhenEntry ktWhenEntry, @Nullable Unit data2) {
        ApplicabilityResult applicabilityResult;
        ApplicabilityResult applicabilityResult2;
        Intrinsics.checkNotNullParameter((Object)ktWhenEntry, (String)"ktWhenEntry");
        KtExpression ktExpression = ktWhenEntry.getExpression();
        if (ktExpression != null && (applicabilityResult2 = (ApplicabilityResult)ktExpression.accept((KtVisitor)this, (Object)data2)) != null && (applicabilityResult = LineBreakpointExpressionVisitorKt.access$handle(applicabilityResult2)) != null) {
            ApplicabilityResult it = applicabilityResult;
            boolean bl = false;
            return it;
        }
        KtWhenCondition[] ktWhenConditionArray = ktWhenEntry.getConditions();
        Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"getConditions(...)");
        return ApplicabilityResult.Companion.maybe(!(((Object[])ktWhenConditionArray).length == 0) || ktWhenEntry.isElse());
    }

    @NotNull
    public ApplicabilityResult visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)multiDeclaration, (String)"multiDeclaration");
        return ApplicabilityResult.Companion.maybe(this.isSameLine((PsiElement)multiDeclaration));
    }

    @NotNull
    public ApplicabilityResult visitBlockExpression(@NotNull KtBlockExpression expression2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        List list2 = expression2.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
        return this.visitChildren(list2, data2);
    }

    @NotNull
    public ApplicabilityResult visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtExpression ktExpression = expression2.getExpression();
        if (ktExpression == null) {
            return ApplicabilityResult.UNKNOWN;
        }
        KtExpression parenthesized = ktExpression;
        Lines lines = this.getLines((PsiElement)parenthesized);
        if (lines.getStart() > this.mainLine) {
            return ApplicabilityResult.UNKNOWN;
        }
        if (lines.isMultiLine()) {
            Object object = parenthesized.accept((KtVisitor)this, (Object)data2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"accept(...)");
            return (ApplicabilityResult)object;
        }
        return ApplicabilityResult.UNKNOWN;
    }

    private final boolean isSameLine(PsiElement $this$isSameLine) {
        Lines lines = this.getLines($this$isSameLine);
        return lines.getStart() == this.mainLine;
    }

    private final Lines getLines(PsiElement $this$getLines) {
        if ($this$getLines == null) {
            return Lines.Companion.getEMPTY();
        }
        int startOffset = Math.max(PsiUtilsKt.getStartOffset((PsiElement)$this$getLines), $this$getLines.getTextOffset());
        int endOffset2 = PsiUtilsKt.getEndOffset((PsiElement)$this$getLines);
        if (startOffset < 0 || endOffset2 < 0 || startOffset > endOffset2) {
            return Lines.Companion.getEMPTY();
        }
        int maxOffset = this.document.getTextLength();
        if (startOffset > maxOffset || endOffset2 > maxOffset) {
            return Lines.Companion.getEMPTY();
        }
        int startLine = this.document.getLineNumber(startOffset);
        int endLine = this.document.getLineNumber(endOffset2);
        return new Lines(startLine, endLine);
    }

    private final ApplicabilityResult acceptIfMultiLineParent(ApplicabilityResult $this$acceptIfMultiLineParent, KtExpression parent2) {
        if ($this$acceptIfMultiLineParent.getShouldStop()) {
            return $this$acceptIfMultiLineParent;
        }
        if (this.getLines((PsiElement)parent2).isSingleLine()) {
            return null;
        }
        return $this$acceptIfMultiLineParent;
    }

    @JvmStatic
    @Nullable
    public static final LineBreakpointExpressionVisitor of(@NotNull VirtualFile file2, int line) {
        return Companion.of(file2, line);
    }

    public /* synthetic */ LineBreakpointExpressionVisitor(Document document, int mainLine, DefaultConstructorMarker $constructor_marker) {
        this(document, mainLine);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/LineBreakpointExpressionVisitor$Companion;", "", "()V", "of", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/LineBreakpointExpressionVisitor;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "kotlin.jvm-debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final LineBreakpointExpressionVisitor of(@NotNull VirtualFile file2, int line) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Document document = FileDocumentManager.getInstance().getDocument(file2);
            if (document == null) {
                return null;
            }
            Document document2 = document;
            return new LineBreakpointExpressionVisitor(document2, line, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

