/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.google.common.collect.ImmutableSet;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.eval4j.AbnormalTermination;
import org.jetbrains.eval4j.AbstractValue;
import org.jetbrains.eval4j.Eval4JInterpretingException;
import org.jetbrains.eval4j.ExceptionThrown;
import org.jetbrains.eval4j.InterpreterLoopKt;
import org.jetbrains.eval4j.InterpreterResult;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValueReturned;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JDIEval;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.compile.CodeFragmentCapturedValue;
import org.jetbrains.kotlin.analysis.api.components.KtCompilationResult;
import org.jetbrains.kotlin.analysis.api.components.KtCompiledFile;
import org.jetbrains.kotlin.analysis.api.components.KtCompilerFacility;
import org.jetbrains.kotlin.analysis.api.components.KtCompilerFacilityKt;
import org.jetbrains.kotlin.analysis.api.components.KtCompilerTarget;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.base.codeInsight.compiler.KotlinCompilerIdeAllowedErrorFilter;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginKindProviderKt;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.base.util.caching.ConcurrentFactoryCache;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentPatcherKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluatorStatisticsCollector;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerSessionRefreshTracker;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.StatisticsEvaluationResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.StatisticsEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoadKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCodegenException;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCodegenExceptionKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilationStats;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompiler;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilerHandler;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilerKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentData;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentDataKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelPropertyDescriptorProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.FragmentCompilerCodegenKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.IRCodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.IRFragmentCompilerCodegenKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.K2CodeFragmentParameterInfo;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.OldCodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.CompilingEvaluatorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.VariableFinder;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ?2\u00020\u0001:\u0003?@AB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0015\u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010 2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010#\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%H\u0002J\"\u0010&\u001a\u00020'2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\n\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002JI\u0010/\u001a\u0002H0\"\u0004\b\u0000\u001002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010%2\u001a\u00101\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e\u0012\u0004\u0012\u0002H002H\u0002\u00a2\u0006\u0002\u00103J\u0018\u00104\u001a\u00020,2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\f\u00109\u001a\u00020:*\u00020;H\u0002J\u000e\u0010<\u001a\u0004\u0018\u00010=*\u00020>H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator;", "Lcom/intellij/debugger/engine/evaluation/expression/Evaluator;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lcom/intellij/debugger/SourcePosition;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "analyze", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$ErrorCheckingResult;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "calculateMainMethodCallArguments", "", "Lcom/sun/jdi/Value;", "variableFinder", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder;", "compiledData", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData;", "compileCodeFragment", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "compiledCodeFragmentDataK1", "compiledCodeFragmentDataK2", "compiledCodeFragmentDataK2Impl", "computeCodeFragmentParameterInfo", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/K2CodeFragmentParameterInfo;", "result", "Lorg/jetbrains/kotlin/analysis/api/components/KtCompilationResult$Success;", "doAnalyze", "evaluate", "", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "evaluateSafe", "evaluateWithCompilation", "classLoader", "Lcom/sun/jdi/ClassLoaderReference;", "evaluateWithEval4J", "Lorg/jetbrains/eval4j/InterpreterResult;", "getCompiledCodeFragment", "getModifier", "", "reportErrorDiagnosticIfAny", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "runEvaluation", "T", "block", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData;Lcom/sun/jdi/ClassLoaderReference;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "updateLocalVariableValue", "converter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter;", "ref", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$RefWrapper;", "isIllegalSuspendFunCallInCodeFragment", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "toDumbCodeFragmentParameter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Dumb;", "Lorg/jetbrains/kotlin/analysis/api/compile/CodeFragmentCapturedValue;", "Companion", "ErrorCheckingResult", "OnRefreshCachedValueProvider", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nKotlinEvaluatorBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinEvaluatorBuilder.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,665:1\n27#2,2:666\n55#3:668\n69#3,4:669\n74#3,3:692\n766#4:673\n857#4,2:674\n1549#4:676\n1620#4,3:677\n618#4,12:680\n288#4,2:695\n766#4:697\n857#4,2:698\n288#4,2:700\n223#4,2:703\n766#4:705\n857#4,2:706\n1855#4,2:708\n1549#4:710\n1620#4,3:711\n1747#4,3:714\n1#5:702\n*S KotlinDebug\n*F\n+ 1 KotlinEvaluatorBuilder.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator\n*L\n237#1:666,2\n237#1:668\n237#1:669,4\n237#1:692,3\n247#1:673\n247#1:674,2\n248#1:676\n248#1:677,3\n250#1:680,12\n389#1:695,2\n397#1:697\n397#1:698,2\n398#1:700,2\n427#1:703,2\n471#1:705\n471#1:706,2\n472#1:708,2\n512#1:710\n512#1:711,3\n522#1:714,3\n*E\n"})
public final class KotlinEvaluator
implements Evaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtCodeFragment codeFragment;
    @Nullable
    private final SourcePosition sourcePosition;
    private static boolean LOG_COMPILATIONS;
    @NotNull
    private static final Set<DiagnosticFactory<?>> IGNORED_DIAGNOSTICS;
    @NotNull
    private static final List<Type> DEFAULT_METHOD_MARKERS;

    public KotlinEvaluator(@NotNull KtCodeFragment codeFragment, @Nullable SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        this.codeFragment = codeFragment;
        this.sourcePosition = sourcePosition2;
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @Nullable
    public Object evaluate(@NotNull EvaluationContextImpl context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        String string = this.codeFragment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() == 0) {
            return context2.getDebugProcess().getVirtualMachineProxy().mirrorOfVoid();
        }
        if (!context2.getDebugProcess().isAttached()) {
            EvaluateException evaluateException = EvaluateExceptionUtil.PROCESS_EXITED;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"PROCESS_EXITED");
            throw (Throwable)evaluateException;
        }
        StackFrameProxyImpl stackFrameProxyImpl = context2.getFrameProxy();
        if (stackFrameProxyImpl == null) {
            KotlinEvaluator $this$evaluate_u24lambda_u240 = this;
            boolean bl = false;
            EvaluateException evaluateException = EvaluateExceptionUtil.NULL_STACK_FRAME;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"NULL_STACK_FRAME");
            throw (Throwable)evaluateException;
        }
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        ThreadReferenceProxyImpl threadReferenceProxyImpl = context2.getSuspendContext().getThread();
        if (threadReferenceProxyImpl == null) {
            KotlinEvaluator $this$evaluate_u24lambda_u241 = this;
            boolean bl = false;
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.thread.unavailable", new Object[0]));
            throw new KotlinNothingValueException();
        }
        ThreadReferenceProxyImpl operatingThread = threadReferenceProxyImpl;
        if (!operatingThread.isSuspended()) {
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.thread.not.suspended", new Object[0]));
            throw new KotlinNothingValueException();
        }
        try {
            ExecutionContext executionContext2 = new ExecutionContext(context2, frameProxy);
            return this.evaluateSafe(executionContext2);
        }
        catch (CodeFragmentCodegenException e) {
            KotlinEvaluatorBuilderKt.evaluationException(e.getReason());
            throw new KotlinNothingValueException();
        }
        catch (EvaluateException e) {
            throw e;
        }
        catch (IndexNotReadyException e) {
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.dumb.mode", new Object[0]));
            throw new KotlinNothingValueException();
        }
        catch (ProcessCanceledException e) {
            KotlinEvaluatorBuilderKt.evaluationException(e);
            throw new KotlinNothingValueException();
        }
        catch (Eval4JInterpretingException e) {
            KotlinEvaluatorBuilderKt.evaluationException(e.getCause());
            throw new KotlinNothingValueException();
        }
        catch (Exception e) {
            boolean isSpecialException = KotlinEvaluatorBuilderKt.access$isSpecialException(e);
            if (isSpecialException) {
                KotlinEvaluatorBuilderKt.evaluationException(e);
                throw new KotlinNothingValueException();
            }
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = KotlinDebuggerEvaluationBundle.message("error.exception.occurred", new Object[0]);
            }
            KotlinEvaluatorBuilderKt.access$reportError(this.codeFragment, this.sourcePosition, string2, e);
            String cause = e.getMessage() != null ? ": " + e.getMessage() : "";
            KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.evaluate", new Object[0]) + cause);
            throw new KotlinNothingValueException();
        }
    }

    private final Object evaluateSafe(ExecutionContext context2) {
        InterpreterResult interpreterResult;
        CompiledCodeFragmentData compiledData = this.getCompiledCodeFragment(context2);
        Object classLoadingResult = CompilingEvaluatorKt.loadClassesSafely(context2, (Collection<ClassToLoad>)compiledData.getClasses());
        ClassLoaderReference classLoaderRef = (ClassLoaderReference)(Result.isFailure-impl((Object)classLoadingResult) ? null : classLoadingResult);
        if (classLoaderRef != null) {
            try {
                return this.evaluateWithCompilation(context2, compiledData, classLoaderRef);
            }
            catch (Throwable e) {
                InterpreterResult interpreterResult2;
                KotlinEvaluatorBuilderKt.getLOG().warn("Compiling evaluator failed: " + e.getMessage(), e);
                interpreterResult = interpreterResult2 = this.evaluateWithEval4J(context2, compiledData, classLoaderRef);
            }
        } else {
            interpreterResult = this.evaluateWithEval4J(context2, compiledData, null);
        }
        InterpreterResult result2 = interpreterResult;
        return KotlinEvaluator.Companion.toJdiValue(result2, context2);
    }

    private final CompiledCodeFragmentData getCompiledCodeFragment(ExecutionContext context2) {
        StringBuilder stringBuilder;
        ConcurrentFactoryCache cache2 = (ConcurrentFactoryCache)ActionsKt.runReadAction((Function0)((Function0)new Function0<ConcurrentFactoryCache<String, CompiledCodeFragmentData>>(this, context2){
            final /* synthetic */ KotlinEvaluator this$0;
            final /* synthetic */ ExecutionContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(0);
            }

            @Nullable
            public final ConcurrentFactoryCache<String, CompiledCodeFragmentData> invoke() {
                PsiElement psiElement2 = this.this$0.getCodeFragment().getContext();
                if (psiElement2 == null) {
                    return null;
                }
                PsiElement contextElement = psiElement2;
                return (ConcurrentFactoryCache)CachedValuesManager.getCachedValue((PsiElement)contextElement, (CachedValueProvider)new OnRefreshCachedValueProvider(this.$context.getProject()));
            }
        }));
        if (cache2 == null) {
            return this.compileCodeFragment(context2);
        }
        StringBuilder $this$getCompiledCodeFragment_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$getCompiledCodeFragment_u24lambda_u242.append(this.codeFragment.importsToString());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        $this$getCompiledCodeFragment_u24lambda_u242.append(this.codeFragment.getText());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String key = string;
        return (CompiledCodeFragmentData)cache2.get(key, (Function1)new Function1<String, CompiledCodeFragmentData>(this, context2){
            final /* synthetic */ KotlinEvaluator this$0;
            final /* synthetic */ ExecutionContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final CompiledCodeFragmentData invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return KotlinEvaluator.access$compileCodeFragment(this.this$0, this.$context);
            }
        });
    }

    private final CompiledCodeFragmentData compileCodeFragment(ExecutionContext context2) {
        try {
            return KotlinPluginKindProviderKt.isK2Plugin() ? this.compiledCodeFragmentDataK2(context2) : this.compiledCodeFragmentDataK1(context2);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
    }

    private final CompiledCodeFragmentData compiledCodeFragmentDataK2(ExecutionContext context2) {
        CodeFragmentCompilationStats stats = new CodeFragmentCompilationStats();
        try {
            KotlinCodeFragmentPatcherKt.patchCodeFragment(context2, this.codeFragment, stats);
            Object object = stats.startAndMeasureAnalysisUnderReadAction-IoAF18A((Function0)new Function0<CompiledCodeFragmentData>(this, context2){
                final /* synthetic */ KotlinEvaluator this$0;
                final /* synthetic */ ExecutionContext $context;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    super(0);
                }

                @NotNull
                public final CompiledCodeFragmentData invoke() {
                    return KotlinEvaluator.access$compiledCodeFragmentDataK2Impl(this.this$0, this.$context);
                }
            });
            ResultKt.throwOnFailure((Object)object);
            CompiledCodeFragmentData result2 = (CompiledCodeFragmentData)object;
            KotlinEvaluator.compiledCodeFragmentDataK2$onFinish(this, stats, StatisticsEvaluationResult.SUCCESS);
            return result2;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            KotlinEvaluator.compiledCodeFragmentDataK2$onFinish(this, stats, StatisticsEvaluationResult.FAILURE);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompiledCodeFragmentData compiledCodeFragmentDataK2Impl(ExecutionContext context2) {
        CompiledCodeFragmentData compiledCodeFragmentData;
        void this_$iv$iv$iv;
        void this_$iv$iv;
        CompilerConfiguration compilerConfiguration;
        Module module2 = GenericPsiUtils.getModule((PsiElement)this.codeFragment);
        CompilerConfiguration $this$compiledCodeFragmentDataK2Impl_u24lambda_u243 = compilerConfiguration = new CompilerConfiguration();
        boolean $i$a$-apply-KotlinEvaluator$compiledCodeFragmentDataK2Impl$compilerConfiguration$22 = false;
        if (module2 != null) {
            $this$compiledCodeFragmentDataK2Impl_u24lambda_u243.put(CommonConfigurationKeys.MODULE_NAME, (Object)module2.getName());
        }
        $this$compiledCodeFragmentDataK2Impl_u24lambda_u243.put(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, (Object)LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)this.codeFragment));
        $this$compiledCodeFragmentDataK2Impl_u24lambda_u243.put(KtCompilerFacility.Companion.getCODE_FRAGMENT_CLASS_NAME(), (Object)"Generated_for_debugger_class");
        $this$compiledCodeFragmentDataK2Impl_u24lambda_u243.put(KtCompilerFacility.Companion.getCODE_FRAGMENT_METHOD_NAME(), (Object)"generated_for_debugger_fun");
        CompilerConfiguration compilerConfiguration2 = compilerConfiguration;
        KtElement useSiteKtElement$iv = (KtElement)this.codeFragment;
        boolean $i$f$analyze = false;
        Project project2 = useSiteKtElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtAnalysisSessionProvider $i$a$-apply-KotlinEvaluator$compiledCodeFragmentDataK2Impl$compilerConfiguration$22 = KtAnalysisSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyse = false;
        void var8_10 = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession(useSiteKtElement$iv);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            CompiledCodeFragmentData compiledCodeFragmentData2;
            KtAnalysisSession $this$compiledCodeFragmentDataK2Impl_u24lambda_u247 = analysisSession$iv$iv$iv;
            boolean bl = false;
            try {
                Object single$iv;
                List classes2;
                ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.BINARIES;
                Intrinsics.checkNotNullExpressionValue((Object)classBuilderFactory, (String)"BINARIES");
                KtCompilerTarget.Jvm compilerTarget = new KtCompilerTarget.Jvm(classBuilderFactory);
                KotlinCompilerIdeAllowedErrorFilter allowedErrorFilter2 = KotlinCompilerIdeAllowedErrorFilter.Companion.getInstance();
                KtCompilationResult result2 = $this$compiledCodeFragmentDataK2Impl_u24lambda_u247.compile((KtFile)this.codeFragment, compilerConfiguration2, compilerTarget, (Function1<? super KtDiagnostic, Boolean>)((Function1)allowedErrorFilter2));
                if (result2 instanceof KtCompilationResult.Success) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Object it;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    KotlinEvaluator.Companion.logCompilation(this.codeFragment);
                    Iterable iterable = ((KtCompilationResult.Success)result2).getOutput();
                    boolean $i$f$filter = false;
                    void var18_24 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (KtCompiledFile)element$iv$iv;
                        boolean bl2 = false;
                        if (!(KtCompilerFacilityKt.isClassFile((KtCompiledFile)it) && FragmentCompilerCodegenKt.isCodeFragmentClassFile((KtCompiledFile)it))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$filterTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (KtCompiledFile)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(new ClassToLoad(CodeFragmentCompilerKt.getInternalClassName((KtCompiledFile)it), it.getPath(), it.getContent()));
                    }
                    classes2 = (List)destination$iv$iv;
                    Iterable $this$single$iv = classes2;
                    boolean $i$f$single = false;
                    single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$single$iv) {
                        it = (ClassToLoad)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)((ClassToLoad)it).getClassName(), (Object)"Generated_for_debugger_class")) continue;
                        if (found$iv) {
                            throw new IllegalArgumentException("Collection contains more than one matching element.");
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    if (!found$iv) {
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                } else {
                    if (result2 instanceof KtCompilationResult.Failure) {
                        KtDiagnostic firstError = (KtDiagnostic)CollectionsKt.first(((KtCompilationResult.Failure)result2).getErrors());
                        EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)firstError.getDefaultMessage());
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"createEvaluateException(...)");
                        throw (Throwable)evaluateException;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                ClassToLoad fragmentClass = single$iv;
                CompiledCodeFragmentData.MethodSignature methodSignature = IRFragmentCompilerCodegenKt.getMethodSignature(fragmentClass);
                K2CodeFragmentParameterInfo parameterInfo = this.computeCodeFragmentParameterInfo((KtCompilationResult.Success)result2);
                CodeFragmentCompiler.CompilationResult ideCompilationResult = new CodeFragmentCompiler.CompilationResult(classes2, parameterInfo, MapsKt.emptyMap(), methodSignature);
                compiledCodeFragmentData2 = KotlinEvaluatorBuilderKt.createCompiledDataDescriptor(ideCompilationResult);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (EvaluateException e) {
                throw e;
            }
            catch (Throwable e) {
                CodeFragmentCodegenExceptionKt.reportErrorWithAttachments(context2, this.codeFragment, e);
                EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"createEvaluateException(...)");
                throw (Throwable)evaluateException;
            }
            compiledCodeFragmentData = compiledCodeFragmentData2;
        }
        finally {
            this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
        return compiledCodeFragmentData;
    }

    private final K2CodeFragmentParameterInfo computeCodeFragmentParameterInfo(KtCompilationResult.Success result2) {
        ArrayList<CodeFragmentParameter.Dumb> parameters2 = new ArrayList<CodeFragmentParameter.Dumb>(result2.getCapturedValues().size());
        HashSet<CodeFragmentParameter.Dumb> crossingBounds = new HashSet<CodeFragmentParameter.Dumb>();
        for (CodeFragmentCapturedValue capturedValue : result2.getCapturedValues()) {
            CodeFragmentParameter.Dumb parameter2;
            if (this.toDumbCodeFragmentParameter(capturedValue) == null) continue;
            parameters2.add(parameter2);
            if (!capturedValue.isCrossingInlineBounds()) continue;
            crossingBounds.add(parameter2);
        }
        return new K2CodeFragmentParameterInfo((List<CodeFragmentParameter.Dumb>)parameters2, (Set<CodeFragmentParameter.Dumb>)crossingBounds);
    }

    private final CodeFragmentParameter.Dumb toDumbCodeFragmentParameter(CodeFragmentCapturedValue $this$toDumbCodeFragmentParameter) {
        CodeFragmentParameter.Dumb dumb;
        CodeFragmentCapturedValue codeFragmentCapturedValue = $this$toDumbCodeFragmentParameter;
        if (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.Local) {
            dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.ORDINARY, $this$toDumbCodeFragmentParameter.getName(), null, 4, null);
        } else if (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.LocalDelegate) {
            dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DELEGATED, $this$toDumbCodeFragmentParameter.getDisplayText(), null, 4, null);
        } else if (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.ContainingClass) {
            dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DISPATCH_RECEIVER, "", $this$toDumbCodeFragmentParameter.getDisplayText());
        } else if (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.SuperClass) {
            dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DISPATCH_RECEIVER, "", $this$toDumbCodeFragmentParameter.getDisplayText());
        } else if (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.ExtensionReceiver) {
            dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.EXTENSION_RECEIVER, $this$toDumbCodeFragmentParameter.getName(), $this$toDumbCodeFragmentParameter.getDisplayText());
        } else if (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.ContextReceiver) {
            String string = NameUtils.contextReceiverName((int)((CodeFragmentCapturedValue.ContextReceiver)$this$toDumbCodeFragmentParameter).getIndex()).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String name2 = string;
            dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.CONTEXT_RECEIVER, name2, $this$toDumbCodeFragmentParameter.getDisplayText());
        } else if (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.ForeignValue) {
            boolean name2 = StringsKt.endsWith$default((String)$this$toDumbCodeFragmentParameter.getName(), (String)"_DebugLabel", (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !name2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            String valueName = StringsKt.substringBeforeLast$default((String)$this$toDumbCodeFragmentParameter.getName(), (String)"_DebugLabel", null, (int)2, null);
            dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DEBUG_LABEL, valueName, $this$toDumbCodeFragmentParameter.getName());
        } else {
            dumb = codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.BackingField ? new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FIELD_VAR, $this$toDumbCodeFragmentParameter.getName(), $this$toDumbCodeFragmentParameter.getDisplayText()) : (codeFragmentCapturedValue instanceof CodeFragmentCapturedValue.CoroutineContext ? new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FAKE_JAVA_OUTER_CLASS, "", null, 4, null) : null);
        }
        return dumb;
    }

    private final CompiledCodeFragmentData compiledCodeFragmentDataK1(ExecutionContext context2) {
        DebugProcessImpl debugProcess = context2.getDebugProcess();
        CodeFragmentCompilingStrategy compilerStrategy = CodeFragmentCompiler.Companion.useIRFragmentCompiler() ? (CodeFragmentCompilingStrategy)new IRCodeFragmentCompilingStrategy(this.codeFragment) : (CodeFragmentCompilingStrategy)new OldCodeFragmentCompilingStrategy(this.codeFragment);
        KotlinCodeFragmentPatcherKt.patchCodeFragment(context2, this.codeFragment, compilerStrategy.getStats$kotlin_jvm_debugger_evaluation());
        compilerStrategy.beforeAnalyzingCodeFragment();
        ErrorCheckingResult analysisResult2 = this.analyze(this.codeFragment, debugProcess);
        Diagnostic diagnostic = analysisResult2.getIllegalSuspendFunCallDiagnostic();
        if (diagnostic != null) {
            Diagnostic it = diagnostic;
            boolean bl = false;
            String string = DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)it));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
            KotlinEvaluatorBuilderKt.evaluationException(string);
            throw new KotlinNothingValueException();
        }
        CodeFragmentCompilerHandler compilerHandler = new CodeFragmentCompilerHandler(compilerStrategy);
        CodeFragmentCompiler.CompilationResult result2 = compilerHandler.compileCodeFragment(this.codeFragment, analysisResult2.getModuleDescriptor(), analysisResult2.getBindingContext(), context2);
        KotlinEvaluator.Companion.logCompilation(this.codeFragment);
        return KotlinEvaluatorBuilderKt.createCompiledDataDescriptor(result2);
    }

    private final ErrorCheckingResult analyze(KtCodeFragment codeFragment, DebugProcessImpl debugProcess) {
        Result result2 = (Result)ReadAction.nonBlocking(() -> KotlinEvaluator.analyze$lambda$9(this, codeFragment, debugProcess)).executeSynchronously();
        Intrinsics.checkNotNull((Object)result2);
        Object object = result2.unbox-impl();
        ResultKt.throwOnFailure((Object)object);
        return (ErrorCheckingResult)object;
    }

    /*
     * WARNING - void declaration
     */
    private final ErrorCheckingResult doAnalyze(KtCodeFragment codeFragment, DebugProcessImpl debugProcess) {
        Object v4;
        BindingContext bindingContext2;
        ModuleDescriptor moduleDescriptor;
        List<KtCodeFragment> list2;
        block5: {
            void $this$firstOrNull$iv;
            try {
                AnalyzingUtils.checkForSyntacticErrors((PsiElement)((PsiElement)codeFragment));
            }
            catch (IllegalArgumentException e) {
                String string = e.getMessage();
                if (string == null) {
                    string = e.toString();
                }
                KotlinEvaluatorBuilderKt.evaluationException(string);
                throw new KotlinNothingValueException();
            }
            ResolutionFacade resolutionFacade2 = KotlinEvaluatorBuilderKt.getResolutionFacadeForCodeFragment(codeFragment);
            new DebugLabelPropertyDescriptorProvider(codeFragment, debugProcess).supplyDebugLabels();
            AnalysisResult analysisResult2 = ResolutionFacade.analyzeWithAllCompilerChecks$default(resolutionFacade2, (KtElement)codeFragment, null, 2, null);
            if (analysisResult2.isError()) {
                KotlinEvaluatorBuilderKt.evaluationException(analysisResult2.getError());
                throw new KotlinNothingValueException();
            }
            BindingContext bindingContext3 = analysisResult2.getBindingContext();
            this.reportErrorDiagnosticIfAny(bindingContext3);
            ModuleDescriptor moduleDescriptor2 = analysisResult2.getModuleDescriptor();
            List<KtCodeFragment> list3 = Collections.singletonList(codeFragment);
            Intrinsics.checkNotNullExpressionValue(list3, (String)"singletonList(...)");
            Diagnostics diagnostics2 = bindingContext3.getDiagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"getDiagnostics(...)");
            Iterable iterable = (Iterable)diagnostics2;
            list2 = list3;
            moduleDescriptor = moduleDescriptor2;
            bindingContext2 = bindingContext3;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Diagnostic it = (Diagnostic)element$iv;
                boolean bl = false;
                if (!this.isIllegalSuspendFunCallInCodeFragment(it)) continue;
                v4 = element$iv;
                break block5;
            }
            v4 = null;
        }
        Object var15_16 = v4;
        Diagnostic diagnostic = var15_16;
        List<KtCodeFragment> list4 = list2;
        ModuleDescriptor moduleDescriptor3 = moduleDescriptor;
        BindingContext bindingContext4 = bindingContext2;
        return new ErrorCheckingResult(bindingContext4, moduleDescriptor3, list4, diagnostic);
    }

    private final void reportErrorDiagnosticIfAny(BindingContext bindingContext2) {
        Object v1;
        block3: {
            Iterator $this$filterTo$iv$iv;
            Diagnostics diagnostics2 = bindingContext2.getDiagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"getDiagnostics(...)");
            Iterable $this$filter$iv = (Iterable)diagnostics2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                Diagnostic it = (Diagnostic)element$iv$iv;
                boolean bl = false;
                if (!(!IGNORED_DIAGNOSTICS.contains(it.getFactory()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Diagnostic it = (Diagnostic)element$iv;
                boolean bl = false;
                if (!(it.getSeverity() == Severity.ERROR && Intrinsics.areEqual((Object)it.getPsiElement().getContainingFile(), (Object)this.codeFragment))) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Diagnostic diagnostic = v1;
        if (diagnostic != null) {
            Diagnostic it = diagnostic;
            boolean bl = false;
            String string = DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)it));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
            KotlinEvaluatorBuilderKt.evaluationException(string);
            throw new KotlinNothingValueException();
        }
    }

    private final boolean isIllegalSuspendFunCallInCodeFragment(Diagnostic $this$isIllegalSuspendFunCallInCodeFragment) {
        return $this$isIllegalSuspendFunCallInCodeFragment.getSeverity() == Severity.ERROR && Intrinsics.areEqual((Object)$this$isIllegalSuspendFunCallInCodeFragment.getPsiElement().getContainingFile(), (Object)this.codeFragment) && Intrinsics.areEqual((Object)$this$isIllegalSuspendFunCallInCodeFragment.getFactory(), (Object)Errors.ILLEGAL_SUSPEND_FUNCTION_CALL);
    }

    private final com.sun.jdi.Value evaluateWithCompilation(ExecutionContext context2, CompiledCodeFragmentData compiledData, ClassLoaderReference classLoader2) {
        return (com.sun.jdi.Value)this.runEvaluation(context2, compiledData, classLoader2, (Function1)new Function1<List<? extends com.sun.jdi.Value>, com.sun.jdi.Value>(context2, classLoader2){
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ ClassLoaderReference $classLoader;
            {
                this.$context = $context;
                this.$classLoader = $classLoader;
                super(1);
            }

            @Nullable
            public final com.sun.jdi.Value invoke(@NotNull List<? extends com.sun.jdi.Value> args) {
                Intrinsics.checkNotNullParameter(args, (String)"args");
                ReferenceType referenceType = this.$context.findClass("Generated_for_debugger_class", this.$classLoader);
                ClassType classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
                if (classType == null) {
                    throw new IllegalStateException("Can not find class \"Generated_for_debugger_class\"".toString());
                }
                ClassType mainClassType = classType;
                List<Method> list2 = mainClassType.methods();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"methods(...)");
                Iterable $this$single$iv = list2;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (T element$iv : $this$single$iv) {
                    Method it = (Method)element$iv;
                    boolean bl = false;
                    String string = it.name();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                    if (!ClassToLoadKt.isEvaluationEntryPoint(string)) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Method mainMethod = single$iv;
                Intrinsics.checkNotNull((Object)mainMethod);
                com.sun.jdi.Value returnValue = this.$context.invokeMethod(mainClassType, mainMethod, args);
                return EvaluatorValueConverter.Companion.unref(returnValue);
            }
        });
    }

    private final InterpreterResult evaluateWithEval4J(ExecutionContext context2, CompiledCodeFragmentData compiledData, ClassLoaderReference classLoader2) {
        Object element$iv2;
        block2: {
            ClassNode classNode;
            byte[] mainClassBytecode = CompiledCodeFragmentDataKt.getMainClass(compiledData).getBytes();
            ClassNode $this$evaluateWithEval4J_u24lambda_u2414 = classNode = new ClassNode();
            boolean bl = false;
            new ClassReader(mainClassBytecode).accept((ClassVisitor)$this$evaluateWithEval4J_u24lambda_u2414, 0);
            ClassNode mainClassAsmNode = classNode;
            List list2 = mainClassAsmNode.methods;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"methods");
            Iterable $this$first$iv = list2;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MethodNode it = (MethodNode)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!ClassToLoadKt.isEvaluationEntryPoint(it)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        MethodNode mainMethod = (MethodNode)element$iv2;
        ClassLoaderReference classLoaderReference = classLoader2;
        if (classLoaderReference == null) {
            classLoaderReference = context2.getEvaluationContext().getClassLoader();
        }
        return (InterpreterResult)this.runEvaluation(context2, compiledData, classLoaderReference, (Function1)new Function1<List<? extends com.sun.jdi.Value>, InterpreterResult>(context2, mainMethod, classLoader2){
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ MethodNode $mainMethod;
            final /* synthetic */ ClassLoaderReference $classLoader;
            {
                this.$context = $context;
                this.$mainMethod = $mainMethod;
                this.$classLoader = $classLoader;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final InterpreterResult invoke(@NotNull List<? extends com.sun.jdi.Value> args) {
                Collection<Value> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object object;
                Object object2;
                VirtualMachine vm;
                block4: {
                    block3: {
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        VirtualMachine virtualMachine = this.$context.getVm().getVirtualMachine();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"getVirtualMachine(...)");
                        vm = virtualMachine;
                        object2 = this.$context.getSuspendContext().getThread();
                        if (object2 == null || (object2 = object2.getThreadReference()) == null) break block3;
                        Object it = object = object2;
                        boolean bl = false;
                        object2 = it.isSuspended() ? object : null;
                        if (object2 != null) break block4;
                    }
                    throw new IllegalStateException("Can not find a thread to run evaluation on".toString());
                }
                Object thread = object2;
                int n = this.$context.getInvokePolicy();
                JDIEval eval2 = new JDIEval(vm, this.$classLoader, (ThreadReference)thread, this.$context, n){
                    final /* synthetic */ ExecutionContext $context;
                    {
                        this.$context = $context;
                        super($vm, $classLoader, $thread, $super_call_param$1);
                    }

                    @Nullable
                    public com.sun.jdi.Value jdiInvokeStaticMethod(@NotNull ClassType type2, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int invokePolicy) {
                        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.$context.invokeMethod(type2, method, args);
                    }

                    @Nullable
                    public com.sun.jdi.Value jdiInvokeStaticMethod(@NotNull InterfaceType type2, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int invokePolicy) {
                        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.$context.invokeMethod(type2, method, args);
                    }

                    @Nullable
                    public com.sun.jdi.Value jdiInvokeMethod(@NotNull ObjectReference obj, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int policy) {
                        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
                        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.$context.invokeMethod(obj, method, args, 2);
                    }

                    @NotNull
                    public com.sun.jdi.Value jdiNewInstance(@NotNull ClassType clazz, @NotNull Method ctor, @NotNull List<? extends com.sun.jdi.Value> args, int policy) {
                        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
                        Intrinsics.checkNotNullParameter((Object)ctor, (String)"ctor");
                        Intrinsics.checkNotNullParameter(args, (String)"args");
                        return this.$context.newInstance(clazz, ctor, args);
                    }

                    @NotNull
                    public StringReference jdiMirrorOfString(@NotNull String str) {
                        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                        StringReference stringReference = DebuggerUtilsEx.mirrorOfString((String)str, (VirtualMachineProxyImpl)this.$context.getVm(), (EvaluationContext)((EvaluationContext)this.$context.getEvaluationContext()));
                        Intrinsics.checkNotNullExpressionValue((Object)stringReference, (String)"mirrorOfString(...)");
                        return stringReference;
                    }

                    @NotNull
                    public ArrayReference jdiNewArray(@NotNull ArrayType arrayType, int size) {
                        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
                        ArrayReference arrayReference = DebuggerUtilsEx.mirrorOfArray((ArrayType)arrayType, (int)size, (EvaluationContext)((EvaluationContext)this.$context.getEvaluationContext()));
                        Intrinsics.checkNotNullExpressionValue((Object)arrayReference, (String)"mirrorOfArray(...)");
                        return arrayReference;
                    }
                };
                MethodNode methodNode = this.$mainMethod;
                Intrinsics.checkNotNullExpressionValue((Object)methodNode, (String)"$mainMethod");
                MethodNode methodNode2 = this.$mainMethod;
                Intrinsics.checkNotNullExpressionValue((Object)methodNode2, (String)"$mainMethod");
                Iterable iterable = args;
                MethodNode methodNode3 = methodNode2;
                MethodNode methodNode4 = methodNode;
                boolean $i$f$map = false;
                object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    com.sun.jdi.Value value2 = (com.sun.jdi.Value)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(JdiValuesKt.asValue((com.sun.jdi.Value)it));
                }
                collection = (List)destination$iv$iv;
                return InterpreterLoopKt.interpreterLoop$default(methodNode4, JdiValuesKt.makeInitialFrame(methodNode3, (List<? extends Value>)collection), eval2, null, 8, null);
            }
        });
    }

    private final <T> T runEvaluation(ExecutionContext context2, CompiledCodeFragmentData compiledData, ClassLoaderReference classLoader2, Function1<? super List<? extends com.sun.jdi.Value>, ? extends T> block2) {
        Iterator<Type> $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = compiledData.getClasses();
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            ClassToLoad it = (ClassToLoad)element$iv$iv;
            boolean bl = false;
            if (!(!it.isMainClass())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Object element$iv = $this$filterTo$iv$iv.next();
            ClassToLoad it = (ClassToLoad)element$iv;
            boolean bl = false;
            context2.findClass(it.getClassName(), classLoader2);
        }
        for (Type parameterType : compiledData.getMainMethodSignature().getParameterTypes()) {
            context2.findClass(parameterType, classLoader2);
        }
        VariableFinder variableFinder = new VariableFinder(context2);
        List<com.sun.jdi.Value> args = this.calculateMainMethodCallArguments(variableFinder, compiledData);
        Object result2 = block2.invoke(args);
        for (VariableFinder.RefWrapper wrapper : variableFinder.getRefWrappers()) {
            this.updateLocalVariableValue(variableFinder.getEvaluatorValueConverter(), wrapper);
        }
        return (T)result2;
    }

    private final void updateLocalVariableValue(EvaluatorValueConverter converter, VariableFinder.RefWrapper ref) {
        StackFrameProxyImpl frameProxy = converter.getContext().getFrameProxy();
        com.sun.jdi.Value newValue2 = EvaluatorValueConverter.Companion.unref(ref.getWrapper());
        LocalVariableProxyImpl variable2 = SafeUtilKt.safeVisibleVariableByName(frameProxy, ref.getLocalVariableName());
        if (variable2 != null) {
            try {
                frameProxy.setValue(variable2, newValue2);
            }
            catch (InvalidTypeException e) {
                com.sun.jdi.Value value2 = newValue2;
                KotlinEvaluatorBuilderKt.getLOG().error("Cannot update local variable value: expected type " + variable2.getType() + ", actual type " + (value2 != null ? value2.type() : null), (Throwable)e);
            }
        } else if (frameProxy instanceof CoroutineStackFrameProxyImpl) {
            ((CoroutineStackFrameProxyImpl)frameProxy).updateSpilledVariableValue(ref.getLocalVariableName(), newValue2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<com.sun.jdi.Value> calculateMainMethodCallArguments(VariableFinder variableFinder, CompiledCodeFragmentData compiledData) {
        void $this$mapTo$iv$iv;
        List<Type> asmValueParameters = compiledData.getMainMethodSignature().getParameterTypes();
        List<CodeFragmentParameter.Dumb> valueParameters2 = compiledData.getParameters();
        if (!(asmValueParameters.size() == valueParameters2.size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List args = CollectionsKt.zip((Iterable)valueParameters2, (Iterable)asmValueParameters);
        Iterable $this$map$iv = args;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Type asmType;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CodeFragmentParameter.Dumb parameter2 = (CodeFragmentParameter.Dumb)pair.component1();
            VariableFinder.Result result2 = variableFinder.find(parameter2, asmType = (Type)pair.component2());
            if (result2 == null) {
                String name2 = parameter2.getDebugString();
                StackFrameProxyImpl frameProxy = variableFinder.getContext().getFrameProxy();
                if (parameter2.getKind() == CodeFragmentParameter.Kind.COROUTINE_CONTEXT) {
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.coroutine.context.unavailable", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                if (compiledData.getCrossingBounds().contains(parameter2)) {
                    Object[] objectArray = new Object[]{name2};
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.not.captured", objectArray));
                    throw new KotlinNothingValueException();
                }
                if (parameter2.getKind() == CodeFragmentParameter.Kind.FIELD_VAR) {
                    Object[] objectArray = new Object[]{parameter2.getName()};
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.find.backing.field", objectArray));
                    throw new KotlinNothingValueException();
                }
                if (parameter2.getKind() == CodeFragmentParameter.Kind.ORDINARY && KotlinEvaluator.calculateMainMethodCallArguments$lambda$19$isInsideDefaultInterfaceMethod(frameProxy)) {
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.parameter.evaluation.default.methods", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                if (parameter2.getKind() == CodeFragmentParameter.Kind.ORDINARY && frameProxy instanceof CoroutineStackFrameProxyImpl) {
                    KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.variable.was.optimised", new Object[0]));
                    throw new KotlinNothingValueException();
                }
                Object[] objectArray = new Object[2];
                objectArray[0] = name2;
                Intrinsics.checkNotNullExpressionValue((Object)asmType.getClassName(), (String)"getClassName(...)");
                KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.cant.find.variable", objectArray));
                throw new KotlinNothingValueException();
            }
            collection.add(result2.getValue());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public Void getModifier() {
        return null;
    }

    private static final void compiledCodeFragmentDataK2$onFinish(KotlinEvaluator this$0, CodeFragmentCompilationStats stats, StatisticsEvaluationResult status) {
        KotlinDebuggerEvaluatorStatisticsCollector.logEvaluationResult$kotlin_jvm_debugger_evaluation(this$0.codeFragment.getProject(), StatisticsEvaluator.K2, status, stats);
    }

    private static final Result analyze$lambda$9(KotlinEvaluator this$0, KtCodeFragment $codeFragment, DebugProcessImpl $debugProcess) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$codeFragment, (String)"$codeFragment");
        Intrinsics.checkNotNullParameter((Object)$debugProcess, (String)"$debugProcess");
        try {
            object = Result.constructor-impl((Object)this$0.doAnalyze($codeFragment, $debugProcess));
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Exception ex) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)ex));
        }
        return Result.box-impl((Object)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean calculateMainMethodCallArguments$lambda$19$isInsideDefaultInterfaceMethod(StackFrameProxyImpl frameProxy) {
        Type it;
        Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)frameProxy);
        Comparable<Location> comparable = location2;
        if (location2 == null) return false;
        if ((comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) {
            return false;
        }
        Comparable<Location> method = comparable;
        String desc2 = method.signature();
        String string = method.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        if (!StringsKt.endsWith$default((String)string, (String)"$default", (boolean)false, (int)2, null)) return false;
        Iterable $this$any$iv = DEFAULT_METHOD_MARKERS;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (Type)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)desc2);
        } while (!StringsKt.contains$default((CharSequence)desc2, (CharSequence)("I" + it.getDescriptor() + ")"), (boolean)false, (int)2, null));
        return true;
    }

    public static final /* synthetic */ CompiledCodeFragmentData access$compileCodeFragment(KotlinEvaluator $this, ExecutionContext context2) {
        return $this.compileCodeFragment(context2);
    }

    public static final /* synthetic */ CompiledCodeFragmentData access$compiledCodeFragmentDataK2Impl(KotlinEvaluator $this, ExecutionContext context2) {
        return $this.compiledCodeFragmentDataK2Impl(context2);
    }

    static {
        ImmutableSet immutableSet = Errors.INVISIBLE_REFERENCE_DIAGNOSTICS;
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"INVISIBLE_REFERENCE_DIAGNOSTICS");
        Object[] objectArray = new DiagnosticFactoryWithPsiElement[]{Errors.OPT_IN_USAGE_ERROR, Errors.MISSING_DEPENDENCY_SUPERCLASS, Errors.IR_WITH_UNSTABLE_ABI_COMPILED_CLASS, Errors.FIR_COMPILED_CLASS, Errors.ILLEGAL_SUSPEND_FUNCTION_CALL, ErrorsJvm.JAVA_MODULE_DOES_NOT_DEPEND_ON_MODULE, ErrorsJvm.JAVA_MODULE_DOES_NOT_READ_UNNAMED_MODULE, ErrorsJvm.JAVA_MODULE_DOES_NOT_EXPORT_PACKAGE};
        IGNORED_DIAGNOSTICS = SetsKt.plus((Set)((Set)immutableSet), (Iterable)SetsKt.setOf((Object[])objectArray));
        objectArray = new Type[]{AsmTypes.OBJECT_TYPE, AsmTypes.DEFAULT_CONSTRUCTOR_MARKER};
        DEFAULT_METHOD_MARKERS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u00020\r8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$Companion;", "", "()V", "DEFAULT_METHOD_MARKERS", "", "Lorg/jetbrains/org/objectweb/asm/Type;", "kotlin.jvm.PlatformType", "IGNORED_DIAGNOSTICS", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "getIGNORED_DIAGNOSTICS$kotlin_jvm_debugger_evaluation", "()Ljava/util/Set;", "LOG_COMPILATIONS", "", "getLOG_COMPILATIONS", "()Z", "setLOG_COMPILATIONS", "(Z)V", "getValueIfSharedVar", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "value", "Lorg/jetbrains/eval4j/Value;", "logCompilation", "", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "toJdiValue", "Lcom/sun/jdi/Value;", "Lorg/jetbrains/eval4j/InterpreterResult;", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        @ApiStatus.Internal
        public final boolean getLOG_COMPILATIONS() {
            return LOG_COMPILATIONS;
        }

        public final void setLOG_COMPILATIONS(boolean bl) {
            LOG_COMPILATIONS = bl;
        }

        private final void logCompilation(KtCodeFragment codeFragment) {
            if (this.getLOG_COMPILATIONS()) {
                KotlinEvaluatorBuilderKt.getLOG().debug("Compile bytecode for " + codeFragment.getText());
            }
        }

        @NotNull
        public final Set<DiagnosticFactory<?>> getIGNORED_DIAGNOSTICS$kotlin_jvm_debugger_evaluation() {
            return IGNORED_DIAGNOSTICS;
        }

        private final com.sun.jdi.Value toJdiValue(InterpreterResult $this$toJdiValue, ExecutionContext context2) {
            InterpreterResult interpreterResult = $this$toJdiValue;
            if (!(interpreterResult instanceof ValueReturned)) {
                if (interpreterResult instanceof ExceptionThrown) {
                    switch (WhenMappings.$EnumSwitchMapping$0[((ExceptionThrown)$this$toJdiValue).getKind().ordinal()]) {
                        case 1: {
                            Object v = ((ExceptionThrown)$this$toJdiValue).getException().getValue();
                            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.sun.jdi.ObjectReference");
                            ObjectReference exceptionReference = (ObjectReference)v;
                            KotlinEvaluatorBuilderKt.evaluationException(new InvocationException(exceptionReference));
                            throw new KotlinNothingValueException();
                        }
                        case 2: {
                            Object v = ((ExceptionThrown)$this$toJdiValue).getException().getValue();
                            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.Throwable");
                            throw (Throwable)v;
                        }
                    }
                    KotlinEvaluatorBuilderKt.evaluationException(((ExceptionThrown)$this$toJdiValue).getException().toString());
                    throw new KotlinNothingValueException();
                }
                if (interpreterResult instanceof AbnormalTermination) {
                    KotlinEvaluatorBuilderKt.evaluationException(((AbnormalTermination)$this$toJdiValue).getMessage());
                    throw new KotlinNothingValueException();
                }
                throw new IllegalStateException("Unknown result value produced by eval4j");
            }
            Value jdiValue = ((ValueReturned)$this$toJdiValue).getResult();
            VariableFinder.Result sharedVar = jdiValue instanceof AbstractValue ? this.getValueIfSharedVar(jdiValue) : null;
            Object object = sharedVar;
            if (object == null || (object = ((VariableFinder.Result)object).getValue()) == null) {
                VirtualMachine virtualMachine = context2.getVm().getVirtualMachine();
                Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"getVirtualMachine(...)");
                object = JdiValuesKt.asJdiValue(jdiValue, virtualMachine, jdiValue.getAsmType());
            }
            return object;
        }

        private final VariableFinder.Result getValueIfSharedVar(Value value2) {
            Object object = ValuesKt.obj(value2, value2.getAsmType());
            ObjectReference objectReference = object instanceof ObjectReference ? (ObjectReference)object : null;
            if (objectReference == null) {
                return null;
            }
            ObjectReference obj = objectReference;
            return new VariableFinder.Result(EvaluatorValueConverter.Companion.unref(obj));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ExceptionThrown.ExceptionKind.values().length];
                try {
                    nArray[ExceptionThrown.ExceptionKind.FROM_EVALUATED_CODE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ExceptionThrown.ExceptionKind.BROKEN_CODE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\nH\u00c6\u0003J9\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$ErrorCheckingResult;", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "illegalSuspendFunCallDiagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Ljava/util/List;Lorg/jetbrains/kotlin/diagnostics/Diagnostic;)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "getFiles", "()Ljava/util/List;", "getIllegalSuspendFunCallDiagnostic", "()Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.jvm-debugger.evaluation"})
    private static final class ErrorCheckingResult {
        @NotNull
        private final BindingContext bindingContext;
        @NotNull
        private final ModuleDescriptor moduleDescriptor;
        @NotNull
        private final List<KtFile> files;
        @Nullable
        private final Diagnostic illegalSuspendFunCallDiagnostic;

        public ErrorCheckingResult(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends KtFile> files2, @Nullable Diagnostic illegalSuspendFunCallDiagnostic) {
            Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            this.bindingContext = bindingContext2;
            this.moduleDescriptor = moduleDescriptor;
            this.files = files2;
            this.illegalSuspendFunCallDiagnostic = illegalSuspendFunCallDiagnostic;
        }

        @NotNull
        public final BindingContext getBindingContext() {
            return this.bindingContext;
        }

        @NotNull
        public final ModuleDescriptor getModuleDescriptor() {
            return this.moduleDescriptor;
        }

        @NotNull
        public final List<KtFile> getFiles() {
            return this.files;
        }

        @Nullable
        public final Diagnostic getIllegalSuspendFunCallDiagnostic() {
            return this.illegalSuspendFunCallDiagnostic;
        }

        @NotNull
        public final BindingContext component1() {
            return this.bindingContext;
        }

        @NotNull
        public final ModuleDescriptor component2() {
            return this.moduleDescriptor;
        }

        @NotNull
        public final List<KtFile> component3() {
            return this.files;
        }

        @Nullable
        public final Diagnostic component4() {
            return this.illegalSuspendFunCallDiagnostic;
        }

        @NotNull
        public final ErrorCheckingResult copy(@NotNull BindingContext bindingContext2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull List<? extends KtFile> files2, @Nullable Diagnostic illegalSuspendFunCallDiagnostic) {
            Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            Intrinsics.checkNotNullParameter(files2, (String)"files");
            return new ErrorCheckingResult(bindingContext2, moduleDescriptor, files2, illegalSuspendFunCallDiagnostic);
        }

        public static /* synthetic */ ErrorCheckingResult copy$default(ErrorCheckingResult errorCheckingResult, BindingContext bindingContext2, ModuleDescriptor moduleDescriptor, List list2, Diagnostic diagnostic, int n, Object object) {
            if ((n & 1) != 0) {
                bindingContext2 = errorCheckingResult.bindingContext;
            }
            if ((n & 2) != 0) {
                moduleDescriptor = errorCheckingResult.moduleDescriptor;
            }
            if ((n & 4) != 0) {
                list2 = errorCheckingResult.files;
            }
            if ((n & 8) != 0) {
                diagnostic = errorCheckingResult.illegalSuspendFunCallDiagnostic;
            }
            return errorCheckingResult.copy(bindingContext2, moduleDescriptor, list2, diagnostic);
        }

        @NotNull
        public String toString() {
            return "ErrorCheckingResult(bindingContext=" + this.bindingContext + ", moduleDescriptor=" + this.moduleDescriptor + ", files=" + this.files + ", illegalSuspendFunCallDiagnostic=" + this.illegalSuspendFunCallDiagnostic + ")";
        }

        public int hashCode() {
            int result2 = this.bindingContext.hashCode();
            result2 = result2 * 31 + this.moduleDescriptor.hashCode();
            result2 = result2 * 31 + ((Object)this.files).hashCode();
            result2 = result2 * 31 + (this.illegalSuspendFunCallDiagnostic == null ? 0 : this.illegalSuspendFunCallDiagnostic.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof ErrorCheckingResult)) {
                return false;
            }
            ErrorCheckingResult errorCheckingResult = (ErrorCheckingResult)other2;
            if (!Intrinsics.areEqual((Object)this.bindingContext, (Object)errorCheckingResult.bindingContext)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.moduleDescriptor, (Object)errorCheckingResult.moduleDescriptor)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.files, errorCheckingResult.files)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.illegalSuspendFunCallDiagnostic, (Object)errorCheckingResult.illegalSuspendFunCallDiagnostic);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluator$OnRefreshCachedValueProvider;", "Lcom/intellij/psi/util/CachedValueProvider;", "Lorg/jetbrains/kotlin/idea/base/util/caching/ConcurrentFactoryCache;", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "compute", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "kotlin.jvm-debugger.evaluation"})
    private static final class OnRefreshCachedValueProvider
    implements CachedValueProvider<ConcurrentFactoryCache<String, CompiledCodeFragmentData>> {
        @NotNull
        private final Project project;

        public OnRefreshCachedValueProvider(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.project = project2;
        }

        @NotNull
        public CachedValueProvider.Result<ConcurrentFactoryCache<String, CompiledCodeFragmentData>> compute() {
            ConcurrentHashMap storage = new ConcurrentHashMap();
            Object[] objectArray = new Object[]{KotlinDebuggerSessionRefreshTracker.Companion.getInstance(this.project)};
            return new CachedValueProvider.Result(new ConcurrentFactoryCache(storage), objectArray);
        }
    }
}

