/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.variables;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.idea.debugger.base.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.JdiTypeUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.BaseExecutionContext;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelPropertyDescriptorProvider;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverter;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.EvaluatorValueConverterKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.variables.VariableFinder;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 U2\u00020\u0001:\u0005UVWXYB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\"\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001eH\u0002J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\"\u001a\u0004\u0018\u00010\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020&H\u0002J\n\u0010'\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020)H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010)2\u0006\u0010,\u001a\u00020-H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010)2\u0006\u0010,\u001a\u00020-H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u00152\u0006\u00100\u001a\u000201H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u000203H\u0002J\u0012\u00104\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u000205H\u0002J\u0012\u00106\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u000207H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u000209H\u0002J4\u0010:\u001a\u0004\u0018\u00010\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020=0<H\u0002J<\u0010:\u001a\u0004\u0018\u00010\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010>\u001a\u00020?2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020=0<H\u0002J(\u0010:\u001a\u0004\u0018\u00010\u00152\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00100\u001a\u000201H\u0002J\u0012\u0010@\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020AH\u0002J\u0012\u0010B\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020CH\u0002J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EH\u0002J\u001c\u0010G\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010H\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010I\u001a\u00020=2\u0006\u00100\u001a\u000201H\u0002J\b\u0010J\u001a\u00020=H\u0002J\n\u0010K\u001a\u0004\u0018\u00010)H\u0002J \u0010L\u001a\b\u0012\u0004\u0012\u00020F0E*\b\u0012\u0004\u0012\u00020M0\u00112\u0006\u0010\u0002\u001a\u00020NH\u0002J\u0018\u0010L\u001a\b\u0012\u0004\u0012\u00020F0E*\b\u0012\u0004\u0012\u00020$0\u0011H\u0002J \u0010L\u001a\b\u0012\u0004\u0012\u00020F0E*\b\u0012\u0004\u0012\u00020O0\u00112\u0006\u0010P\u001a\u00020)H\u0002J\u0016\u0010Q\u001a\u00020=*\u00020\u001c2\b\u0010R\u001a\u0004\u0018\u00010SH\u0002J\u0016\u0010T\u001a\u0004\u0018\u00010\u0015*\u00020F2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006Z"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;)V", "getContext", "()Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "evaluatorValueConverter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter;", "getEvaluatorValueConverter", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/EvaluatorValueConverter;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "mutableRefWrappers", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$RefWrapper;", "refWrappers", "", "getRefWrappers", "()Ljava/util/List;", "find", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "parameter", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "findCapturedVariable", "kind", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "parentFactory", "Lkotlin/Function0;", "Lcom/sun/jdi/Value;", "parent", "findCapturedVariableInContainingThis", "findCapturedVariableInReceiver", "variables", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "findContextReceiver", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ContextReceiver;", "findCoroutineContext", "findCoroutineContextForContinuation", "Lcom/sun/jdi/ObjectReference;", "continuation", "findCoroutineContextForLambda", "method", "Lcom/sun/jdi/Method;", "findCoroutineContextForMethod", "findDebugLabel", "name", "", "findDispatchThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$OuterClassThis;", "findExtensionThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ExtensionThis;", "findFieldVariable", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$FieldVar;", "findLocalFunction", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$LocalFunction;", "findLocalVariable", "namePredicate", "Lkotlin/Function1;", "", "inlineDepth", "", "findOrdinary", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$Ordinary;", "findUnlabeledThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$UnlabeledThis;", "getCoroutineStackFrameNamedEntities", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity;", "getUnwrapDelegate", "rawValue", "isCapturedReceiverFieldName", "isInsideDefaultImpls", "thisObject", "namedEntitySequence", "Lcom/intellij/debugger/engine/JavaValue;", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "Lcom/sun/jdi/Field;", "owner", "typeMatches", "actualType", "Lcom/sun/jdi/Type;", "unwrapAndCheck", "Companion", "NamedEntity", "RefWrapper", "Result", "VariableKind", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nVariableFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableFinder.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,530:1\n1#2:531\n1549#3:532\n1620#3,3:533\n2624#3,3:537\n288#3,2:540\n118#4:536\n*S KotlinDebug\n*F\n+ 1 VariableFinder.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder\n*L\n224#1:532\n224#1:533,3\n386#1:537,3\n408#1:540,2\n296#1:536\n*E\n"})
public final class VariableFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutionContext context;
    @NotNull
    private final StackFrameProxyImpl frameProxy;
    @NotNull
    private final EvaluatorValueConverter evaluatorValueConverter;
    @NotNull
    private final List<RefWrapper> mutableRefWrappers;

    public VariableFinder(@NotNull ExecutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.frameProxy = this.context.getFrameProxy();
        this.evaluatorValueConverter = new EvaluatorValueConverter(this.context);
        this.mutableRefWrappers = new ArrayList();
    }

    @NotNull
    public final ExecutionContext getContext() {
        return this.context;
    }

    @NotNull
    public final EvaluatorValueConverter getEvaluatorValueConverter() {
        return this.evaluatorValueConverter;
    }

    @NotNull
    public final List<RefWrapper> getRefWrappers() {
        return this.mutableRefWrappers;
    }

    @Nullable
    public final Result find(@NotNull CodeFragmentParameter parameter2, @NotNull Type asmType) {
        Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
        return switch (WhenMappings.$EnumSwitchMapping$0[parameter2.getKind().ordinal()]) {
            case 1 -> this.findOrdinary(new VariableKind.Ordinary(parameter2.getName(), asmType, false));
            case 2 -> this.findOrdinary(new VariableKind.Ordinary(parameter2.getName(), asmType, true));
            case 3 -> {
                ObjectReference v1 = this.thisObject();
                if (v1 != null) {
                    ObjectReference it = v1;
                    boolean $i$a$-let-VariableFinder$find$1 = false;
                    yield new Result(it);
                }
                yield null;
            }
            case 4 -> this.findExtensionThis(new VariableKind.ExtensionThis(parameter2.getName(), asmType));
            case 5 -> this.findContextReceiver(new VariableKind.ContextReceiver(asmType));
            case 6 -> this.findLocalFunction(new VariableKind.LocalFunction(parameter2.getName(), asmType));
            case 7 -> this.findDispatchThis(new VariableKind.OuterClassThis(asmType));
            case 8 -> this.findCoroutineContext();
            case 9 -> this.findFieldVariable(new VariableKind.FieldVar(parameter2.getName(), asmType));
            case 10 -> this.findDebugLabel(parameter2.getName());
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Result findOrdinary(VariableKind.Ordinary kind2) {
        List<LocalVariableProxyImpl> variables2 = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        Result result2 = this.findLocalVariable(variables2, (VariableKind)kind2, kind2.getName());
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        Result result3 = this.findLocalVariable(variables2, (VariableKind)kind2, DescriptorUtilsKt.getSynthesizedString((String)kind2.getName()));
        if (result3 != null) {
            Result it = result3;
            boolean bl = false;
            return it;
        }
        Result result4 = this.findCapturedVariableInReceiver(variables2, kind2);
        if (result4 != null) {
            Result it = result4;
            boolean bl = false;
            return it;
        }
        return this.findCapturedVariableInContainingThis(kind2);
    }

    private final Result findFieldVariable(VariableKind.FieldVar kind2) {
        ObjectReference thisObject = this.thisObject();
        if (thisObject != null) {
            Field field2 = thisObject.referenceType().fieldByName(kind2.getFieldName());
            if (field2 == null) {
                return null;
            }
            Field field3 = field2;
            return new Result(thisObject.getValue(field3));
        }
        Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)this.frameProxy);
        ReferenceType referenceType = location2 != null ? location2.declaringType() : null;
        if (referenceType == null) {
            return null;
        }
        ReferenceType containingType = referenceType;
        Field field4 = containingType.fieldByName(kind2.getFieldName());
        if (field4 == null) {
            return null;
        }
        Field field5 = field4;
        return new Result(containingType.getValue(field5));
    }

    private final Result findLocalFunction(VariableKind.LocalFunction kind2) {
        List<LocalVariableProxyImpl> variables2 = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        String newConventionName = "$fun$" + kind2.getName();
        Result result2 = this.findLocalVariable(variables2, (VariableKind)kind2, newConventionName);
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        Result result3 = this.findLocalVariable(variables2, (VariableKind)kind2, kind2.getName() + "$");
        if (result3 != null) {
            Result it = result3;
            boolean bl = false;
            return it;
        }
        Result result4 = this.findCapturedVariableInReceiver(variables2, kind2);
        if (result4 != null) {
            Result it = result4;
            boolean bl = false;
            return it;
        }
        return this.findCapturedVariableInContainingThis(kind2);
    }

    private final Result findCapturedVariableInContainingThis(VariableKind kind2) {
        if (this.frameProxy instanceof CoroutineStackFrameProxyImpl && ((CoroutineStackFrameProxyImpl)this.frameProxy).isCoroutineScopeAvailable()) {
            Result result2 = this.findCapturedVariable(kind2, this.frameProxy.thisObject());
            if (result2 != null) {
                Result it = result2;
                boolean bl = false;
                return it;
            }
            return this.findCapturedVariable(kind2, ((CoroutineStackFrameProxyImpl)this.frameProxy).getContinuation());
        }
        ObjectReference objectReference = this.thisObject();
        if (objectReference == null) {
            return null;
        }
        ObjectReference containingThis = objectReference;
        return this.findCapturedVariable(kind2, containingThis);
    }

    private final Result findExtensionThis(VariableKind.ExtensionThis kind2) {
        Function1 namePredicate2;
        List<LocalVariableProxyImpl> variables2 = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        Result result2 = this.findLocalVariable(variables2, (VariableKind)kind2, (Function1<? super String, Boolean>)(namePredicate2 = (Function1)new Function1<String, Boolean>(kind2){
            final /* synthetic */ VariableKind.ExtensionThis $kind;
            {
                this.$kind = $kind;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return Intrinsics.areEqual((Object)name2, (Object)this.$kind.getParameterName()) || StringsKt.startsWith$default((String)name2, (String)(this.$kind.getParameterName() + "$"), (boolean)false, (int)2, null);
            }
        }));
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        result2 = this.findCapturedVariableInReceiver(variables2, kind2);
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        result2 = this.findCapturedVariableInContainingThis(kind2);
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        if (VariableFinder.Companion.getUSE_UNSAFE_FALLBACK() && (result2 = this.findUnlabeledThis(new VariableKind.UnlabeledThis(kind2.getAsmType()))) != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Result findContextReceiver(VariableKind.ContextReceiver kind2) {
        void $this$mapTo$iv$iv;
        List list2 = this.frameProxy.visibleVariables();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"visibleVariables(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalVariableProxyImpl localVariableProxyImpl = (LocalVariableProxyImpl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LocalVariableProxyImpl(this.frameProxy, it.getVariable()));
        }
        List variableProxies = (List)destination$iv$iv;
        Result result2 = this.findLocalVariable((List<? extends LocalVariableProxyImpl>)variableProxies, (VariableKind)kind2, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(kind2){
            final /* synthetic */ VariableKind.ContextReceiver $kind;
            {
                this.$kind = $kind;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$kind.capturedNameMatches(it) || StringsKt.startsWith$default((String)it, (String)"$this", (boolean)false, (int)2, null);
            }
        }));
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        return this.findCapturedVariableInContainingThis(kind2);
    }

    private final Result findDispatchThis(VariableKind.OuterClassThis kind2) {
        Result it2;
        List<LocalVariableProxyImpl> variables2;
        Result result2;
        Result result3 = this.findCapturedVariableInContainingThis(kind2);
        if (result3 != null) {
            Result it2 = result3;
            boolean bl = false;
            return it2;
        }
        if (this.isInsideDefaultImpls() && (result2 = this.findLocalVariable(variables2 = SafeUtilKt.safeVisibleVariables(this.frameProxy), (VariableKind)kind2, "$this")) != null) {
            Result it3 = result2;
            boolean bl = false;
            return it3;
        }
        variables2 = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        int inlineDepth = InlineUtilsKt.getInlineDepth(variables2);
        if (inlineDepth > 0 && (it2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables2), (Function1)((Function1)new Function1<NamedEntity, Boolean>(inlineDepth, this, kind2){
            final /* synthetic */ int $inlineDepth;
            final /* synthetic */ VariableFinder this$0;
            final /* synthetic */ VariableKind.OuterClassThis $kind;
            {
                this.$inlineDepth = $inlineDepth;
                this.this$0 = $receiver;
                this.$kind = $kind;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull NamedEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CharSequence charSequence = it.getName();
                return InlineUtilsKt.getINLINED_THIS_REGEX().matches(charSequence) && InlineUtilsKt.getInlineDepth(it.getName()) == this.$inlineDepth && VariableFinder.access$typeMatches(this.this$0, this.$kind, it.getType());
            }
        })), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
            final /* synthetic */ VariableFinder this$0;
            final /* synthetic */ VariableKind.OuterClassThis $kind;
            {
                this.this$0 = $receiver;
                this.$kind = $kind;
                super(1);
            }

            @Nullable
            public final Result invoke(@NotNull NamedEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return VariableFinder.access$unwrapAndCheck(this.this$0, it, this.$kind);
            }
        })))) != null) {
            Result it4 = it2;
            boolean bl = false;
            return it4;
        }
        if (VariableFinder.Companion.getUSE_UNSAFE_FALLBACK()) {
            Result result4;
            block7: {
                Object object;
                VariableKind.UnlabeledThis unlabeledThisKind = new VariableKind.UnlabeledThis(kind2.getAsmType());
                result4 = this.findUnlabeledThis(unlabeledThisKind);
                if (result4 != null) {
                    Result it5 = result4;
                    boolean bl = false;
                    return it5;
                }
                for (Object it6 : (Iterable)SafeUtilKt.safeArgumentValues(this.frameProxy)) {
                    boolean bl = false;
                    if ((it6 = this.findCapturedVariable((VariableKind)unlabeledThisKind, (Value)it6)) == null) continue;
                    object = it6;
                    break block7;
                }
                object = result4 = null;
            }
            if (result4 != null) {
                Result it5 = result4;
                boolean bl = false;
                return it5;
            }
        }
        return null;
    }

    private final Result findDebugLabel(String name2) {
        Map<? extends Value, ValueMarkup> markupMap = DebugLabelPropertyDescriptorProvider.Companion.getMarkupMap(this.context.getDebugProcess());
        for (Map.Entry<? extends Value, ValueMarkup> entry : markupMap.entrySet()) {
            Value value2 = entry.getKey();
            ValueMarkup markup = entry.getValue();
            if (!Intrinsics.areEqual((Object)markup.getText(), (Object)name2)) continue;
            return new Result(value2);
        }
        return null;
    }

    private final Result findUnlabeledThis(VariableKind.UnlabeledThis kind2) {
        List<LocalVariableProxyImpl> variables2 = SafeUtilKt.safeVisibleVariables(this.frameProxy);
        Result result2 = this.findCapturedVariableInReceiver(variables2, kind2);
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        return this.findCapturedVariableInContainingThis(kind2);
    }

    private final Result findLocalVariable(List<? extends LocalVariableProxyImpl> variables2, VariableKind kind2, String name2) {
        return this.findLocalVariable(variables2, kind2, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(name2){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$name);
            }
        }));
    }

    private final Result findLocalVariable(List<? extends LocalVariableProxyImpl> variables2, VariableKind kind2, Function1<? super String, Boolean> namePredicate2) {
        StackFrameProxyImpl $this$safeAs$iv = this.frameProxy;
        boolean $i$f$safeAs = false;
        StackFrameProxyImpl stackFrameProxyImpl = $this$safeAs$iv;
        if (!(stackFrameProxyImpl instanceof InlineStackFrameProxyImpl)) {
            stackFrameProxyImpl = null;
        }
        InlineStackFrameProxyImpl inlineStackFrameProxyImpl = (InlineStackFrameProxyImpl)stackFrameProxyImpl;
        int inlineDepth = inlineStackFrameProxyImpl != null ? inlineStackFrameProxyImpl.getInlineDepth() : InlineUtilsKt.getInlineDepth(variables2);
        Result result2 = this.findLocalVariable(variables2, kind2, inlineDepth, namePredicate2);
        if (result2 != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        if (inlineDepth > 0 && VariableFinder.Companion.getUSE_UNSAFE_FALLBACK() && (result2 = this.findLocalVariable(variables2, kind2, 0, namePredicate2)) != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private final Result findLocalVariable(List<? extends LocalVariableProxyImpl> variables2, VariableKind kind2, int inlineDepth, Function1<? super String, Boolean> namePredicate2) {
        Function1 actualPredicate = null;
        actualPredicate = inlineDepth > 0 ? (Function1)new Function1<String, Boolean>(namePredicate2, inlineDepth){
            final /* synthetic */ Function1<String, Boolean> $namePredicate;
            final /* synthetic */ int $inlineDepth;
            {
                this.$namePredicate = $namePredicate;
                this.$inlineDepth = $inlineDepth;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String name2) {
                int endIndex;
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                int depth2 = 0;
                int suffixLen = 3;
                for (endIndex = name2.length(); endIndex >= suffixLen; endIndex -= suffixLen) {
                    String string = name2.substring(endIndex - suffixLen, endIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    if (!Intrinsics.areEqual((Object)string, (Object)"$iv")) break;
                    ++depth2;
                }
                return (Boolean)this.$namePredicate.invoke((Object)StringsKt.take((String)name2, (int)endIndex)) != false && InlineUtilsKt.getInlineDepth(name2) == this.$inlineDepth;
            }
        } : namePredicate2;
        Sequence namedEntities = SequencesKt.plus(this.namedEntitySequence(variables2), this.getCoroutineStackFrameNamedEntities());
        for (NamedEntity item : namedEntities) {
            if (!((Boolean)actualPredicate.invoke((Object)item.getName())).booleanValue() || !this.typeMatches(kind2, item.getType())) continue;
            Value rawValue = item.getValue();
            Result result2 = this.evaluatorValueConverter.coerce(this.getUnwrapDelegate(kind2, rawValue), kind2.getAsmType());
            if (result2 == null) continue;
            Result result3 = result2;
            if (!EvaluatorValueConverterKt.isRefType(rawValue) && EvaluatorValueConverterKt.isRefType(result3.getValue())) {
                ((Collection)this.mutableRefWrappers).add(new RefWrapper(item.getName(), result3.getValue()));
            }
            return result3;
        }
        return null;
    }

    private final Sequence<NamedEntity> getCoroutineStackFrameNamedEntities() {
        return this.frameProxy instanceof CoroutineStackFrameProxyImpl ? this.namedEntitySequence(((CoroutineStackFrameProxyImpl)this.frameProxy).getSpilledVariables(), this.context.getEvaluationContext()) : SequencesKt.emptySequence();
    }

    private final boolean isInsideDefaultImpls() {
        Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)this.frameProxy);
        ReferenceType referenceType = location2 != null ? location2.declaringType() : null;
        if (referenceType == null) {
            return false;
        }
        ReferenceType declaringType = referenceType;
        String string = declaringType.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        return StringsKt.endsWith$default((String)string, (String)"$DefaultImpls", (boolean)false, (int)2, null);
    }

    private final Result findCoroutineContext() {
        Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)this.frameProxy);
        if (comparable == null || (comparable = SafeUtilKt.safeMethod(comparable)) == null) {
            return null;
        }
        Comparable<Location> method = comparable;
        ObjectReference objectReference = this.findCoroutineContextForLambda((Method)method);
        if (objectReference == null && (objectReference = this.findCoroutineContextForMethod((Method)method)) == null) {
            return null;
        }
        ObjectReference result2 = objectReference;
        return new Result(result2);
    }

    private final ObjectReference findCoroutineContextForLambda(Method method) {
        boolean bl;
        ObjectReference continuation2;
        block6: {
            if (!(Intrinsics.areEqual((Object)method.name(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)method.signature(), (Object)"(Ljava/lang/Object;)Ljava/lang/Object;") && this.frameProxy instanceof CoroutineStackFrameProxyImpl)) {
                return null;
            }
            ObjectReference objectReference = ((CoroutineStackFrameProxyImpl)this.frameProxy).getContinuation();
            if (objectReference == null) {
                return null;
            }
            continuation2 = objectReference;
            ReferenceType continuationType = continuation2.referenceType();
            Iterable $this$none$iv = CoroutineUtilsKt.getSUSPEND_LAMBDA_CLASSES();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)continuationType);
                    if (!JdiTypeUtils.isSubtype((com.sun.jdi.Type)continuationType, it)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        return this.findCoroutineContextForContinuation(continuation2);
    }

    private final ObjectReference findCoroutineContextForMethod(Method method) {
        String string = method.signature();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signature(...)");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)(CoroutineUtilsKt.getCONTINUATION_TYPE().getDescriptor() + ")"), (boolean)false, (int)2, null)) {
            return null;
        }
        LocalVariableProxyImpl localVariableProxyImpl = SafeUtilKt.safeVisibleVariableByName(this.frameProxy, "$continuation");
        if (localVariableProxyImpl == null && (localVariableProxyImpl = SafeUtilKt.safeVisibleVariableByName(this.frameProxy, "$completion")) == null) {
            return null;
        }
        LocalVariableProxyImpl continuationVariable = localVariableProxyImpl;
        Value value2 = this.frameProxy.getValue(continuationVariable);
        ObjectReference objectReference = value2 instanceof ObjectReference ? (ObjectReference)value2 : null;
        if (objectReference == null) {
            return null;
        }
        ObjectReference continuation2 = objectReference;
        return this.findCoroutineContextForContinuation(continuation2);
    }

    private final ObjectReference findCoroutineContextForContinuation(ObjectReference continuation2) {
        InterfaceType interfaceType;
        Object object;
        block7: {
            block6: {
                Object v1;
                block5: {
                    ClassType classType;
                    object = continuation2.referenceType();
                    ClassType classType2 = classType = object instanceof ClassType ? (ClassType)object : null;
                    if (classType == null || (object = classType.allInterfaces()) == null) break block6;
                    Iterable $this$firstOrNull$iv = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        InterfaceType it = (InterfaceType)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)Continuation.class.getName())) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                interfaceType = v1;
                if (interfaceType != null) break block7;
            }
            return null;
        }
        InterfaceType continuationType = interfaceType;
        List<Method> list2 = continuationType.methodsByName("getContext", "()Lkotlin/coroutines/CoroutineContext;");
        Intrinsics.checkNotNullExpressionValue(list2, (String)"methodsByName(...)");
        Method method = (Method)CollectionsKt.firstOrNull(list2);
        if (method == null) {
            return null;
        }
        Method getContextMethod = method;
        object = BaseExecutionContext.invokeMethod$default(this.context, continuation2, getContextMethod, CollectionsKt.emptyList(), 0, 8, null);
        return object instanceof ObjectReference ? (ObjectReference)object : null;
    }

    private final Result findCapturedVariableInReceiver(List<? extends LocalVariableProxyImpl> variables2, VariableKind kind2) {
        Result result2;
        if (kind2 instanceof VariableKind.ExtensionThis && (result2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables2), (Function1)((Function1)new Function1<NamedEntity, Boolean>(kind2, this){
            final /* synthetic */ VariableKind $kind;
            final /* synthetic */ VariableFinder this$0;
            {
                this.$kind = $kind;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull NamedEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$kind.capturedNameMatches(it.getName()) && VariableFinder.access$typeMatches(this.this$0, this.$kind, it.getType());
            }
        })), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
            final /* synthetic */ VariableFinder this$0;
            final /* synthetic */ VariableKind $kind;
            {
                this.this$0 = $receiver;
                this.$kind = $kind;
                super(1);
            }

            @Nullable
            public final Result invoke(@NotNull NamedEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return VariableFinder.access$unwrapAndCheck(this.this$0, it, this.$kind);
            }
        })))) != null) {
            Result it = result2;
            boolean bl = false;
            return it;
        }
        return (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(variables2), (Function1)findCapturedVariableInReceiver.4.INSTANCE), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
            final /* synthetic */ VariableFinder this$0;
            final /* synthetic */ VariableKind $kind;
            {
                this.this$0 = $receiver;
                this.$kind = $kind;
                super(1);
            }

            @Nullable
            public final Result invoke(@NotNull NamedEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return VariableFinder.access$findCapturedVariable(this.this$0, this.$kind, it.getValue());
            }
        })));
    }

    private final Result findCapturedVariable(VariableKind kind2, Function0<? extends Value> parentFactory) {
        Value parent2 = this.getUnwrapDelegate(kind2, (Value)parentFactory.invoke());
        return this.findCapturedVariable(kind2, parent2);
    }

    private final Result findCapturedVariable(VariableKind kind2, Value parent2) {
        Result result2;
        boolean acceptsParentValue;
        boolean bl = acceptsParentValue = kind2 instanceof VariableKind.UnlabeledThis || kind2 instanceof VariableKind.OuterClassThis;
        if (parent2 != null && acceptsParentValue && this.typeMatches(kind2, parent2.type())) {
            return new Result(parent2);
        }
        Mirror mirror = parent2 instanceof ObjectReference ? (ObjectReference)parent2 : null;
        List<Field> list2 = mirror != null && (mirror = mirror.referenceType()) != null ? mirror.fields() : null;
        if (list2 == null) {
            return null;
        }
        List<Field> fields2 = list2;
        if (!(kind2 instanceof VariableKind.OuterClassThis)) {
            result2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(fields2, (ObjectReference)parent2), (Function1)((Function1)new Function1<NamedEntity, Boolean>(kind2, this){
                final /* synthetic */ VariableKind $kind;
                final /* synthetic */ VariableFinder this$0;
                {
                    this.$kind = $kind;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$kind.capturedNameMatches(it.getName()) && VariableFinder.access$typeMatches(this.this$0, this.$kind, it.getType());
                }
            })), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind $kind;
                {
                    this.this$0 = $receiver;
                    this.$kind = $kind;
                    super(1);
                }

                @Nullable
                public final Result invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return VariableFinder.access$unwrapAndCheck(this.this$0, it, this.$kind);
                }
            })));
            if (result2 != null) {
                Result it = result2;
                boolean bl2 = false;
                return it;
            }
            result2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(fields2, (ObjectReference)parent2), (Function1)((Function1)new Function1<NamedEntity, Boolean>(this){
                final /* synthetic */ VariableFinder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return VariableFinder.access$isCapturedReceiverFieldName(this.this$0, it.getName());
                }
            })), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
                final /* synthetic */ VariableFinder this$0;
                final /* synthetic */ VariableKind $kind;
                {
                    this.this$0 = $receiver;
                    this.$kind = $kind;
                    super(1);
                }

                @Nullable
                public final Result invoke(@NotNull NamedEntity it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return VariableFinder.access$findCapturedVariable(this.this$0, this.$kind, it.getValue());
                }
            })));
            if (result2 != null) {
                Result it = result2;
                boolean bl3 = false;
                return it;
            }
        }
        if ((result2 = (Result)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter(this.namedEntitySequence(fields2, (ObjectReference)parent2), (Function1)findCapturedVariable.7.INSTANCE), (Function1)((Function1)new Function1<NamedEntity, Result>(this, kind2){
            final /* synthetic */ VariableFinder this$0;
            final /* synthetic */ VariableKind $kind;
            {
                this.this$0 = $receiver;
                this.$kind = $kind;
                super(1);
            }

            @Nullable
            public final Result invoke(@NotNull NamedEntity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return VariableFinder.access$findCapturedVariable(this.this$0, this.$kind, it.getValue());
            }
        })))) != null) {
            Result it = result2;
            boolean bl4 = false;
            return it;
        }
        return null;
    }

    private final Value getUnwrapDelegate(VariableKind kind2, Value rawValue) {
        if (!(kind2 instanceof VariableKind.Ordinary) || !((VariableKind.Ordinary)kind2).isDelegated()) {
            return rawValue;
        }
        ObjectReference objectReference = rawValue instanceof ObjectReference ? (ObjectReference)rawValue : null;
        if (objectReference == null) {
            return rawValue;
        }
        ObjectReference delegateValue = objectReference;
        List<Method> list2 = delegateValue.referenceType().methodsByName("getValue", "()Ljava/lang/Object;");
        Intrinsics.checkNotNullExpressionValue(list2, (String)"methodsByName(...)");
        Method method = (Method)CollectionsKt.firstOrNull(list2);
        if (method == null) {
            return rawValue;
        }
        Method getValueMethod = method;
        return BaseExecutionContext.invokeMethod$default(this.context, delegateValue, getValueMethod, CollectionsKt.emptyList(), 0, 8, null);
    }

    private final boolean isCapturedReceiverFieldName(String name2) {
        String string = AsmUtil.getCapturedFieldName((String)"this_");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCapturedFieldName(...)");
        return StringsKt.startsWith$default((String)name2, (String)string, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name2, (Object)"receiver$0");
    }

    private final boolean typeMatches(VariableKind $this$typeMatches, com.sun.jdi.Type actualType) {
        if ($this$typeMatches instanceof VariableKind.Ordinary && ((VariableKind.Ordinary)$this$typeMatches).isDelegated()) {
            return true;
        }
        return this.evaluatorValueConverter.typeMatches($this$typeMatches.getAsmType(), actualType);
    }

    private final Result unwrapAndCheck(NamedEntity $this$unwrapAndCheck, VariableKind kind2) {
        return this.evaluatorValueConverter.coerce(this.getUnwrapDelegate(kind2, $this$unwrapAndCheck.getValue()), kind2.getAsmType());
    }

    private final Sequence<NamedEntity> namedEntitySequence(List<? extends Field> $this$namedEntitySequence, ObjectReference owner) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$namedEntitySequence), (Function1)((Function1)new Function1<Field, NamedEntity>(owner){
            final /* synthetic */ ObjectReference $owner;
            {
                this.$owner = $owner;
                super(1);
            }

            @NotNull
            public final NamedEntity invoke(@NotNull Field it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return NamedEntity.Companion.of(it, this.$owner);
            }
        }));
    }

    private final Sequence<NamedEntity> namedEntitySequence(List<? extends LocalVariableProxyImpl> $this$namedEntitySequence) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$namedEntitySequence), (Function1)((Function1)new Function1<LocalVariableProxyImpl, NamedEntity>(this){
            final /* synthetic */ VariableFinder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final NamedEntity invoke(@NotNull LocalVariableProxyImpl it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return NamedEntity.Companion.of(it, VariableFinder.access$getFrameProxy$p(this.this$0));
            }
        }));
    }

    private final Sequence<NamedEntity> namedEntitySequence(List<? extends JavaValue> $this$namedEntitySequence, EvaluationContextImpl context2) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$namedEntitySequence), (Function1)((Function1)new Function1<JavaValue, NamedEntity>(context2){
            final /* synthetic */ EvaluationContextImpl $context;
            {
                this.$context = $context;
                super(1);
            }

            @NotNull
            public final NamedEntity invoke(@NotNull JavaValue it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return NamedEntity.Companion.of(it, this.$context);
            }
        }));
    }

    private final ObjectReference thisObject() {
        ObjectReference thisObjectFromEvaluation;
        Value value2 = this.context.getEvaluationContext().computeThisObject();
        ObjectReference objectReference = thisObjectFromEvaluation = value2 instanceof ObjectReference ? (ObjectReference)value2 : null;
        if (thisObjectFromEvaluation != null) {
            return thisObjectFromEvaluation;
        }
        return this.frameProxy.thisObject();
    }

    private static final boolean findCapturedVariableInReceiver$isReceiverOrPassedThis(String name2) {
        return StringsKt.startsWith$default((String)name2, (String)"$this$", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name2, (Object)"$receiver") || Intrinsics.areEqual((Object)name2, (Object)"$this") || InlineUtilsKt.getINLINED_THIS_REGEX().matches((CharSequence)name2);
    }

    public static final /* synthetic */ boolean access$typeMatches(VariableFinder $this, VariableKind $receiver, com.sun.jdi.Type actualType) {
        return $this.typeMatches($receiver, actualType);
    }

    public static final /* synthetic */ Result access$unwrapAndCheck(VariableFinder $this, NamedEntity $receiver, VariableKind kind2) {
        return $this.unwrapAndCheck($receiver, kind2);
    }

    public static final /* synthetic */ boolean access$findCapturedVariableInReceiver$isReceiverOrPassedThis(String name2) {
        return VariableFinder.findCapturedVariableInReceiver$isReceiverOrPassedThis(name2);
    }

    public static final /* synthetic */ Result access$findCapturedVariable(VariableFinder $this, VariableKind kind2, Value parent2) {
        return $this.findCapturedVariable(kind2, parent2);
    }

    public static final /* synthetic */ boolean access$isCapturedReceiverFieldName(VariableFinder $this, String name2) {
        return $this.isCapturedReceiverFieldName(name2);
    }

    public static final /* synthetic */ StackFrameProxyImpl access$getFrameProxy$p(VariableFinder $this) {
        return $this.frameProxy;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Companion;", "", "()V", "USE_UNSAFE_FALLBACK", "", "getUSE_UNSAFE_FALLBACK", "()Z", "getCapturedVariableNameRegex", "Lkotlin/text/Regex;", "capturedName", "", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getUSE_UNSAFE_FALLBACK() {
            return true;
        }

        private final Regex getCapturedVariableNameRegex(String capturedName) {
            String escapedName = Regex.Companion.escape(capturedName);
            String escapedSuffix = Regex.Companion.escape("$inlined");
            return new Regex("^" + escapedName + "(?:" + escapedSuffix + ")?$");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\u0002\u0010\tR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity;", "", "name", "", "lazyType", "Lkotlin/Lazy;", "Lcom/sun/jdi/Type;", "lazyValue", "Lcom/sun/jdi/Value;", "(Ljava/lang/String;Lkotlin/Lazy;Lkotlin/Lazy;)V", "getLazyType", "()Lkotlin/Lazy;", "getLazyValue", "getName", "()Ljava/lang/String;", "type", "getType", "()Lcom/sun/jdi/Type;", "value", "getValue", "()Lcom/sun/jdi/Value;", "Companion", "kotlin.jvm-debugger.evaluation"})
    private static final class NamedEntity {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final Lazy<com.sun.jdi.Type> lazyType;
        @NotNull
        private final Lazy<Value> lazyValue;

        public NamedEntity(@NotNull String name2, @NotNull Lazy<? extends com.sun.jdi.Type> lazyType, @NotNull Lazy<? extends Value> lazyValue) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(lazyType, (String)"lazyType");
            Intrinsics.checkNotNullParameter(lazyValue, (String)"lazyValue");
            this.name = name2;
            this.lazyType = lazyType;
            this.lazyValue = lazyValue;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Lazy<com.sun.jdi.Type> getLazyType() {
            return this.lazyType;
        }

        @NotNull
        public final Lazy<Value> getLazyValue() {
            return this.lazyValue;
        }

        @Nullable
        public final com.sun.jdi.Type getType() {
            return (com.sun.jdi.Type)this.lazyType.getValue();
        }

        @Nullable
        public final Value getValue() {
            return (Value)this.lazyValue.getValue();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity$Companion;", "", "()V", "of", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$NamedEntity;", "variable", "Lcom/intellij/debugger/engine/JavaValue;", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "field", "Lcom/sun/jdi/Field;", "owner", "Lcom/sun/jdi/ObjectReference;", "kotlin.jvm-debugger.evaluation"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final NamedEntity of(@NotNull Field field2, @NotNull ObjectReference owner) {
                Intrinsics.checkNotNullParameter((Object)field2, (String)"field");
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Lazy type2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<com.sun.jdi.Type>(field2){
                    final /* synthetic */ Field $field;
                    {
                        this.$field = $field;
                        super(0);
                    }

                    @Nullable
                    public final com.sun.jdi.Type invoke() {
                        return SafeUtilKt.safeType(this.$field);
                    }
                }));
                Lazy value2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<Value>(owner, field2){
                    final /* synthetic */ ObjectReference $owner;
                    final /* synthetic */ Field $field;
                    {
                        this.$owner = $owner;
                        this.$field = $field;
                        super(0);
                    }

                    public final Value invoke() {
                        return this.$owner.getValue(this.$field);
                    }
                }));
                String string = field2.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                return new NamedEntity(string, (Lazy<? extends com.sun.jdi.Type>)type2, (Lazy<? extends Value>)value2);
            }

            @NotNull
            public final NamedEntity of(@NotNull LocalVariableProxyImpl variable2, @NotNull StackFrameProxyImpl frameProxy) {
                Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
                Lazy type2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<com.sun.jdi.Type>(variable2){
                    final /* synthetic */ LocalVariableProxyImpl $variable;
                    {
                        this.$variable = $variable;
                        super(0);
                    }

                    @Nullable
                    public final com.sun.jdi.Type invoke() {
                        return SafeUtilKt.safeType(this.$variable);
                    }
                }));
                Lazy value2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<Value>(frameProxy, variable2){
                    final /* synthetic */ StackFrameProxyImpl $frameProxy;
                    final /* synthetic */ LocalVariableProxyImpl $variable;
                    {
                        this.$frameProxy = $frameProxy;
                        this.$variable = $variable;
                        super(0);
                    }

                    public final Value invoke() {
                        return this.$frameProxy.getValue(this.$variable);
                    }
                }));
                String string = variable2.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                return new NamedEntity(string, (Lazy<? extends com.sun.jdi.Type>)type2, (Lazy<? extends Value>)value2);
            }

            @NotNull
            public final NamedEntity of(@NotNull JavaValue variable2, @NotNull EvaluationContextImpl context2) {
                Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Lazy type2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<com.sun.jdi.Type>(variable2){
                    final /* synthetic */ JavaValue $variable;
                    {
                        this.$variable = $variable;
                        super(0);
                    }

                    @Nullable
                    public final com.sun.jdi.Type invoke() {
                        return this.$variable.getDescriptor().getType();
                    }
                }));
                Lazy value2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<Value>(variable2, context2){
                    final /* synthetic */ JavaValue $variable;
                    final /* synthetic */ EvaluationContextImpl $context;
                    {
                        this.$variable = $variable;
                        this.$context = $context;
                        super(0);
                    }

                    @Nullable
                    public final Value invoke() {
                        ValueDescriptorImpl valueDescriptorImpl = this.$variable.getDescriptor();
                        Intrinsics.checkNotNullExpressionValue((Object)valueDescriptorImpl, (String)"getDescriptor(...)");
                        return SafeUtilKt.safeCalcValue(valueDescriptorImpl, this.$context);
                    }
                }));
                String string = variable2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return new NamedEntity(string, (Lazy<? extends com.sun.jdi.Type>)type2, (Lazy<? extends Value>)value2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$RefWrapper;", "", "localVariableName", "", "wrapper", "Lcom/sun/jdi/Value;", "(Ljava/lang/String;Lcom/sun/jdi/Value;)V", "getLocalVariableName", "()Ljava/lang/String;", "getWrapper", "()Lcom/sun/jdi/Value;", "kotlin.jvm-debugger.evaluation"})
    public static final class RefWrapper {
        @NotNull
        private final String localVariableName;
        @Nullable
        private final Value wrapper;

        public RefWrapper(@NotNull String localVariableName, @Nullable Value wrapper) {
            Intrinsics.checkNotNullParameter((Object)localVariableName, (String)"localVariableName");
            this.localVariableName = localVariableName;
            this.wrapper = wrapper;
        }

        @NotNull
        public final String getLocalVariableName() {
            return this.localVariableName;
        }

        @Nullable
        public final Value getWrapper() {
            return this.wrapper;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$Result;", "", "value", "Lcom/sun/jdi/Value;", "(Lcom/sun/jdi/Value;)V", "getValue", "()Lcom/sun/jdi/Value;", "kotlin.jvm-debugger.evaluation"})
    public static final class Result {
        @Nullable
        private final Value value;

        public Result(@Nullable Value value2) {
            this.value = value2;
        }

        @Nullable
        public final Value getValue() {
            return this.value;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0007\u000b\f\r\u000e\u000f\u0010\u0011B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0007\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "getAsmType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "capturedNameMatches", "", "name", "", "ContextReceiver", "ExtensionThis", "FieldVar", "LocalFunction", "Ordinary", "OuterClassThis", "UnlabeledThis", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ContextReceiver;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ExtensionThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$FieldVar;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$LocalFunction;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$Ordinary;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$OuterClassThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$UnlabeledThis;", "kotlin.jvm-debugger.evaluation"})
    public static abstract class VariableKind {
        @NotNull
        private final Type asmType;

        private VariableKind(Type asmType) {
            this.asmType = asmType;
        }

        @NotNull
        public final Type getAsmType() {
            return this.asmType;
        }

        public abstract boolean capturedNameMatches(@NotNull String var1);

        public /* synthetic */ VariableKind(Type asmType, DefaultConstructorMarker $constructor_marker) {
            this(asmType);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ContextReceiver;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "capturedNameMatches", "", "name", "", "kotlin.jvm-debugger.evaluation"})
        public static final class ContextReceiver
        extends VariableKind {
            public ContextReceiver(@NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
            }

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return StringsKt.startsWith$default((String)name2, (String)NameUtils.getCONTEXT_RECEIVER_PREFIX(), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)("$" + NameUtils.getCONTEXT_RECEIVER_PREFIX()), (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)"_context_receiver", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name2, (String)"$_context_receiver", (boolean)false, (int)2, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$ExtensionThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "label", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;)V", "capturedNameRegex", "Lkotlin/text/Regex;", "fieldName", "getFieldName", "()Ljava/lang/String;", "getLabel", "parameterName", "getParameterName", "capturedNameMatches", "", "name", "kotlin.jvm-debugger.evaluation"})
        public static final class ExtensionThis
        extends VariableKind {
            @NotNull
            private final String label;
            @NotNull
            private final String parameterName;
            @NotNull
            private final String fieldName;
            @NotNull
            private final Regex capturedNameRegex;

            public ExtensionThis(@NotNull String label2, @NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.label = label2;
                String string = AsmUtil.getLabeledThisName((String)this.label, (String)"$this$", (String)"$receiver");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLabeledThisName(...)");
                this.parameterName = string;
                String string2 = AsmUtil.getLabeledThisName((String)this.label, (String)AsmUtil.getCapturedFieldName((String)"this_"), (String)"receiver$0");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLabeledThisName(...)");
                this.fieldName = string2;
                this.capturedNameRegex = Companion.getCapturedVariableNameRegex(this.fieldName);
            }

            @NotNull
            public final String getLabel() {
                return this.label;
            }

            @NotNull
            public final String getParameterName() {
                return this.parameterName;
            }

            @NotNull
            public final String getFieldName() {
                return this.fieldName;
            }

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return this.capturedNameRegex.matches((CharSequence)name2);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$FieldVar;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "fieldName", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getFieldName", "()Ljava/lang/String;", "capturedNameMatches", "", "name", "kotlin.jvm-debugger.evaluation"})
        public static final class FieldVar
        extends VariableKind {
            @NotNull
            private final String fieldName;

            public FieldVar(@NotNull String fieldName, @NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.fieldName = fieldName;
            }

            @NotNull
            public final String getFieldName() {
                return this.fieldName;
            }

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return false;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$LocalFunction;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "name", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;)V", "getName", "()Ljava/lang/String;", "capturedNameMatches", "", "kotlin.jvm-debugger.evaluation"})
        public static final class LocalFunction
        extends VariableKind {
            @NotNull
            private final String name;

            public LocalFunction(@NotNull String name2, @NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.name = name2;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return Intrinsics.areEqual((Object)name2, (Object)("$" + name2));
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$Ordinary;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "name", "", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "isDelegated", "", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Type;Z)V", "capturedNameRegex", "Lkotlin/text/Regex;", "()Z", "getName", "()Ljava/lang/String;", "capturedNameMatches", "kotlin.jvm-debugger.evaluation"})
        public static final class Ordinary
        extends VariableKind {
            @NotNull
            private final String name;
            private final boolean isDelegated;
            @NotNull
            private final Regex capturedNameRegex;

            public Ordinary(@NotNull String name2, @NotNull Type asmType, boolean isDelegated) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
                this.name = name2;
                this.isDelegated = isDelegated;
                String string = AsmUtil.getCapturedFieldName((String)this.name);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCapturedFieldName(...)");
                this.capturedNameRegex = Companion.getCapturedVariableNameRegex(string);
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public final boolean isDelegated() {
                return this.isDelegated;
            }

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return this.capturedNameRegex.matches((CharSequence)name2);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$OuterClassThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "capturedNameMatches", "", "name", "", "kotlin.jvm-debugger.evaluation"})
        public static final class OuterClassThis
        extends VariableKind {
            public OuterClassThis(@NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
            }

            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return false;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind$UnlabeledThis;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/variables/VariableFinder$VariableKind;", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "(Lorg/jetbrains/org/objectweb/asm/Type;)V", "capturedNameMatches", "", "name", "", "kotlin.jvm-debugger.evaluation"})
        public static final class UnlabeledThis
        extends VariableKind {
            public UnlabeledThis(@NotNull Type asmType) {
                Intrinsics.checkNotNullParameter((Object)asmType, (String)"asmType");
                super(asmType, null);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean capturedNameMatches(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                if (Intrinsics.areEqual((Object)name2, (Object)"receiver$0")) return true;
                String string = AsmUtil.getCapturedFieldName((String)"this_");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCapturedFieldName(...)");
                if (!StringsKt.startsWith$default((String)name2, (String)string, (boolean)false, (int)2, null)) return false;
                return true;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CodeFragmentParameter.Kind.values().length];
            try {
                nArray[CodeFragmentParameter.Kind.ORDINARY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.DELEGATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.FAKE_JAVA_OUTER_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.EXTENSION_RECEIVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.CONTEXT_RECEIVER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.LOCAL_FUNCTION.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.DISPATCH_RECEIVER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.COROUTINE_CONTEXT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.FIELD_VAR.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentParameter.Kind.DEBUG_LABEL.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

