/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorFileSwapper;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.psi.KotlinDeclarationNavigationPolicy;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinEditorFileSwapper;", "Lcom/intellij/openapi/fileEditor/impl/EditorFileSwapper;", "()V", "getCursorPosition", "", "originalOffset", "decompiledFile", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/file/KtDecompiledFile;", "getFileToSwapTo", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "composite", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "getSourcesLocation", "psiFile", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinEditorFileSwapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinEditorFileSwapper.kt\norg/jetbrains/kotlin/idea/editor/KotlinEditorFileSwapper\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,54:1\n51#2:55\n51#2:56\n*S KotlinDebug\n*F\n+ 1 KotlinEditorFileSwapper.kt\norg/jetbrains/kotlin/idea/editor/KotlinEditorFileSwapper\n*L\n36#1:55\n50#1:56\n*E\n"})
public final class KotlinEditorFileSwapper
implements EditorFileSwapper {
    @Nullable
    public Pair<VirtualFile, Integer> getFileToSwapTo(@NotNull Project project2, @NotNull EditorComposite composite) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
        VirtualFile file2 = composite.getFile();
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file2);
        if (psiFile2 == null) {
            return null;
        }
        PsiFile psiFile3 = psiFile2;
        if (!(psiFile3 instanceof KtDecompiledFile)) {
            return null;
        }
        VirtualFile virtualFile2 = this.getSourcesLocation((KtDecompiledFile)psiFile3);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile location2 = virtualFile2;
        TextEditorImpl oldEditor = EditorFileSwapper.findSinglePsiAwareEditor((List)composite.getAllEditors());
        if (oldEditor != null) {
            int offset2 = oldEditor.getEditor().getCaretModel().getOffset();
            offset2 = this.getCursorPosition(offset2, (KtDecompiledFile)psiFile3);
            pair = new Pair((Object)location2, (Object)offset2);
        } else {
            pair = new Pair((Object)location2, (Object)0);
        }
        return pair;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final VirtualFile getSourcesLocation(KtDecompiledFile psiFile2) {
        KtDeclaration ktDeclaration2 = (KtDeclaration)CollectionsKt.firstOrNull((List)psiFile2.getDeclarations());
        if (ktDeclaration2 == null) return null;
        KtDeclaration it = ktDeclaration2;
        boolean bl = false;
        boolean $i$f$serviceOrNull = false;
        Application application = ApplicationManager.getApplication();
        KotlinDeclarationNavigationPolicy kotlinDeclarationNavigationPolicy = (KotlinDeclarationNavigationPolicy)(application != null ? application.getService(KotlinDeclarationNavigationPolicy.class) : null);
        KotlinDeclarationNavigationPolicy kotlinDeclarationNavigationPolicy2 = kotlinDeclarationNavigationPolicy;
        if (kotlinDeclarationNavigationPolicy == null) return null;
        if ((kotlinDeclarationNavigationPolicy2 = kotlinDeclarationNavigationPolicy2.getNavigationElement(it)) == null) {
            return null;
        }
        KotlinDeclarationNavigationPolicy element3 = kotlinDeclarationNavigationPolicy2;
        if (Intrinsics.areEqual((Object)it, (Object)element3)) return null;
        PsiFile sourceFile2 = element3.getContainingFile();
        if (!sourceFile2.isValid()) return null;
        return sourceFile2.getVirtualFile();
    }

    private final int getCursorPosition(int originalOffset, KtDecompiledFile decompiledFile) {
        KtElement declarationInSources;
        Object object;
        PsiElement psiElement2 = decompiledFile.getNavigationElement().findElementAt(originalOffset);
        if (psiElement2 == null) {
            return 0;
        }
        PsiElement cursor = psiElement2;
        KtDeclaration ktDeclaration2 = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)cursor, KtDeclaration.class, (boolean)false);
        if (ktDeclaration2 != null) {
            KtDeclaration it = ktDeclaration2;
            boolean bl = false;
            boolean $i$f$serviceOrNull = false;
            Application application = ApplicationManager.getApplication();
            KotlinDeclarationNavigationPolicy kotlinDeclarationNavigationPolicy = (KotlinDeclarationNavigationPolicy)(application != null ? application.getService(KotlinDeclarationNavigationPolicy.class) : null);
            object = kotlinDeclarationNavigationPolicy != null ? kotlinDeclarationNavigationPolicy.getNavigationElement(it) : null;
        } else {
            object = null;
        }
        KtElement ktElement = declarationInSources = object;
        return ktElement != null ? ktElement.getTextOffset() : 0;
    }
}

