/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.Closeable;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionLoadingKt;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionSourceAsContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.gradle.scripting.GradleKotlinScriptDefinitionWrapper;
import org.jetbrains.kotlin.idea.gradleJava.scripting.ErrorGradleScriptDefinition;
import org.jetbrains.kotlin.idea.gradleJava.scripting.GradleScriptDefinitionsContributor;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.Imported;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.WithoutScriptModels;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptCompilationConfigurationFromDefinitionKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.KotlinScriptDefinitionFromAnnotatedTemplate;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0002()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u001c\u001a\u00020\fH\u0002JN\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\rH\u0002J\"\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fJ\b\u0010$\u001a\u00020\u001aH\u0002J\f\u0010%\u001a\u00020&*\u00020\fH\u0002J\f\u0010'\u001a\u00020\u001a*\u00020\fH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor;", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionSourceAsContributor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "definitions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getDefinitions", "()Lkotlin/sequences/Sequence;", "definitionsByRoots", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor$LightGradleBuildRoot;", "", "id", "", "getId", "()Ljava/lang/String;", "createHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "projectPath", "gradleHome", "javaHome", "gradleExeSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "forceReload", "", "loadGradleDefinitions", "root", "loadGradleTemplates", "templateClass", "templateClasspath", "Ljava/nio/file/Path;", "additionalClassPath", "reloadIfNeeded", "workingDir", "subscribeToGradleSettingChanges", "isError", "", "markAsError", "Companion", "LightGradleBuildRoot", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nGradleScriptDefinitionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleScriptDefinitionsProvider.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 ScriptDefinition.kt\norg/jetbrains/kotlin/scripting/definitions/ScriptDefinition\n*L\n1#1,406:1\n1747#2,3:407\n1549#2:420\n1620#2,2:421\n1622#2:424\n1855#2,2:425\n526#3:410\n511#3,6:411\n215#4,2:417\n76#4:427\n96#4,5:428\n1#5:419\n58#6:423\n*S KotlinDebug\n*F\n+ 1 GradleScriptDefinitionsProvider.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor\n*L\n144#1:407,3\n253#1:420\n253#1:421,2\n253#1:424\n328#1:425,2\n163#1:410\n163#1:411,6\n165#1:417,2\n348#1:427\n348#1:428,5\n254#1:423\n*E\n"})
public final class GradleScriptDefinitionsContributor
implements ScriptDefinitionSourceAsContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String id;
    @NotNull
    private final ConcurrentHashMap<LightGradleBuildRoot, List<ScriptDefinition>> definitionsByRoots;
    @NotNull
    private static final Regex kotlinDslDependencySelector = new Regex("^gradle-(?:kotlin-dsl|core).*\\.jar$");
    @NotNull
    private static final Regex kotlinStdLibSelector = new Regex("^(kotlin-compiler-embeddable|kotlin-stdlib)-(\\d+\\.\\d+).*\\.jar$");

    public GradleScriptDefinitionsContributor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.id = "Gradle Kotlin DSL";
        this.definitionsByRoots = new ConcurrentHashMap();
        this.subscribeToGradleSettingChanges();
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    private final void markAsError(LightGradleBuildRoot $this$markAsError) {
        ((Map)this.definitionsByRoots).put($this$markAsError, CollectionsKt.listOf((Object)((Object)new ErrorGradleScriptDefinition(this.project, null, 2, null))));
    }

    private final boolean isError(LightGradleBuildRoot $this$isError) {
        boolean bl;
        block5: {
            List<ScriptDefinition> list2 = this.definitionsByRoots.get($this$isError);
            if (list2 != null) {
                Iterable $this$any$iv = list2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ScriptDefinition it = (ScriptDefinition)((Object)element$iv);
                        boolean bl2 = false;
                        if (!(it instanceof ErrorGradleScriptDefinition)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final void forceReload() {
        Enumeration<LightGradleBuildRoot> enumeration = this.definitionsByRoots.keys();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"keys(...)");
        Iterator iterator2 = CollectionsKt.iterator(enumeration);
        while (iterator2.hasNext()) {
            LightGradleBuildRoot key = (LightGradleBuildRoot)iterator2.next();
            Intrinsics.checkNotNull((Object)key);
            this.markAsError(key);
        }
        ScriptDefinitionsManager.Companion.getInstance(this.project).reloadDefinitionsBy(this);
    }

    /*
     * WARNING - void declaration
     */
    public final void reloadIfNeeded(@NotNull String workingDir, @Nullable String gradleHome2, @Nullable String javaHome) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        LightGradleBuildRoot root = new LightGradleBuildRoot(workingDir, gradleHome2, javaHome);
        List<ScriptDefinition> value2 = this.definitionsByRoots.get(root);
        if (value2 != null) {
            if (this.isError(root)) {
                ScriptDefinitionsManager.Companion.getInstance(this.project).reloadDefinitionsBy(this);
            }
        } else {
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = this.definitionsByRoots;
            boolean $i$f$filter = false;
            Object object = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((LightGradleBuildRoot)it.getKey()).getWorkingDir(), (Object)workingDir)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map rootWithChangedGradleHome = destination$iv$iv;
            if (!rootWithChangedGradleHome.isEmpty()) {
                Map $this$forEach$iv = rootWithChangedGradleHome;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = (Map.Entry)object.next();
                    boolean bl = false;
                    this.definitionsByRoots.remove(it.getKey());
                }
            }
            this.markAsError(root);
            ScriptDefinitionsManager.Companion.getInstance(this.project).reloadDefinitionsBy(this);
        }
    }

    private final List<ScriptDefinition> loadGradleDefinitions(LightGradleBuildRoot root) {
        try {
            Pair pair = GradleScriptDefinitionsContributor.Companion.getFullDefinitionsClasspath(root.getGradleHome());
            List templateClasspath2 = (List)pair.component1();
            List additionalClassPath = (List)pair.component2();
            ArrayList kotlinDslTemplates = new ArrayList();
            String projectPath2 = root.getWorkingDir();
            List<ScriptDefinition> it = this.loadGradleTemplates(projectPath2, "org.gradle.kotlin.dsl.KotlinInitScript", root.getGradleHome(), root.getJavaHome(), templateClasspath2, additionalClassPath);
            boolean bl = false;
            kotlinDslTemplates.addAll(it);
            it = this.loadGradleTemplates(projectPath2, "org.gradle.kotlin.dsl.KotlinSettingsScript", root.getGradleHome(), root.getJavaHome(), templateClasspath2, additionalClassPath);
            boolean bl2 = false;
            kotlinDslTemplates.addAll(it);
            it = this.loadGradleTemplates(projectPath2, "org.gradle.kotlin.dsl.KotlinBuildScript", root.getGradleHome(), root.getJavaHome(), templateClasspath2, additionalClassPath);
            boolean bl3 = false;
            kotlinDslTemplates.addAll(it);
            if (!((Collection)kotlinDslTemplates).isEmpty()) {
                return CollectionsKt.distinct((Iterable)kotlinDslTemplates);
            }
        }
        catch (Throwable t) {
            if (t instanceof IllegalStateException) {
                ScriptUtilsKt.scriptingInfoLog("IllegalStateException loading gradle script templates: " + t.getMessage());
            } else {
                ScriptUtilsKt.scriptingDebugLog$default(null, (Function0)new Function0<String>(t){
                    final /* synthetic */ Throwable $t;
                    {
                        this.$t = $t;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "error loading gradle script templates " + this.$t.getMessage();
                    }
                }, 1, null);
            }
            return CollectionsKt.listOf((Object)((Object)new ErrorGradleScriptDefinition(this.project, t.getMessage())));
        }
        return CollectionsKt.listOf((Object)((Object)new ErrorGradleScriptDefinition(this.project, null, 2, null)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScriptDefinition> loadGradleTemplates(String projectPath2, String templateClass2, String gradleHome2, String javaHome, List<? extends Path> templateClasspath2, List<? extends Path> additionalClassPath) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        LanguageVersion it;
        Object object;
        GradleExecutionSettings gradleExeSettings;
        block11: {
            block10: {
                gradleExeSettings = (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)this.project, (String)projectPath2, (ProjectSystemId)GradleConstants.SYSTEM_ID);
                object = Companion.findStdLibLanguageVersion(templateClasspath2);
                if (object == null) break block10;
                it = object;
                boolean bl = false;
                Object[] objectArray = new String[]{"-language-version", it.getVersionString()};
                List list2 = CollectionsKt.listOf((Object[])objectArray);
                object = list2;
                if (list2 != null) break block11;
            }
            object = CollectionsKt.emptyList();
        }
        Object defaultCompilerOptions = object;
        Intrinsics.checkNotNull((Object)gradleExeSettings);
        ScriptingHostConfiguration hostConfiguration2 = this.createHostConfiguration(projectPath2, gradleHome2, javaHome, gradleExeSettings);
        Iterable iterable = ScriptDefinitionLoadingKt.loadDefinitionsFromTemplatesByPaths(CollectionsKt.listOf((Object)templateClass2), templateClasspath2, hostConfiguration2, additionalClassPath, (Iterable)defaultCompilerOptions);
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ScriptDefinition scriptDefinition;
            KotlinScriptDefinition kotlinScriptDefinition;
            void it2;
            ScriptDefinition scriptDefinition2 = (ScriptDefinition)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void this_$iv = it2;
            boolean $i$f$asLegacyOrNull = false;
            if (this_$iv instanceof ScriptDefinition.FromLegacy) {
                KotlinScriptDefinition kotlinScriptDefinition2 = this_$iv.getLegacyDefinition();
                if (!(kotlinScriptDefinition2 instanceof KotlinScriptDefinitionFromAnnotatedTemplate)) {
                    kotlinScriptDefinition2 = null;
                }
                kotlinScriptDefinition = (KotlinScriptDefinitionFromAnnotatedTemplate)kotlinScriptDefinition2;
            } else {
                kotlinScriptDefinition = null;
            }
            if ((KotlinScriptDefinitionFromAnnotatedTemplate)kotlinScriptDefinition != null) {
                KotlinScriptDefinitionFromAnnotatedTemplate legacyDef;
                boolean bl2 = false;
                String string = GradleInstallationManager.getGradleVersion((String)gradleHome2);
                if (string == null) {
                    string = GradleVersion.current().getVersion();
                }
                String version2 = string;
                ScriptingHostConfiguration scriptingHostConfiguration2 = it2.getHostConfiguration();
                Intrinsics.checkNotNull((Object)version2);
                scriptDefinition = new GradleKotlinScriptDefinitionWrapper(scriptingHostConfiguration2, legacyDef, version2, (Iterable)defaultCompilerOptions);
            } else {
                scriptDefinition = it2;
            }
            collection.add(scriptDefinition);
        }
        return (List)destination$iv$iv;
    }

    private final ScriptingHostConfiguration createHostConfiguration(String projectPath2, String gradleHome2, String javaHome, GradleExecutionSettings gradleExeSettings) {
        Map map2;
        File file2;
        File file3;
        String p0;
        Pair[] pairArray;
        int n;
        String string;
        Object[] objectArray;
        List list2 = gradleExeSettings.getJvmArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getJvmArguments(...)");
        List gradleJvmOptions = list2;
        Pair[] pairArray2 = objectArray = new Pair[6];
        int n2 = 0;
        String string2 = "gradleHome";
        String string3 = gradleHome2;
        if (string3 != null) {
            String string4 = string3;
            string = string2;
            n = n2;
            pairArray = pairArray2;
            boolean bl = false;
            file3 = new File(p0);
            pairArray2 = pairArray;
            n2 = n;
            string2 = string;
            file2 = file3;
        } else {
            file2 = null;
        }
        pairArray2[n2] = TuplesKt.to((Object)string2, file2);
        objectArray[1] = TuplesKt.to((Object)"gradleJavaHome", (Object)javaHome);
        p0 = projectPath2;
        string = "projectRoot";
        n = 2;
        pairArray = objectArray;
        boolean bl = false;
        file3 = new File(p0);
        pairArray[n] = TuplesKt.to((Object)string, (Object)file3);
        objectArray[3] = TuplesKt.to((Object)"gradleOptions", (Object)CollectionsKt.emptyList());
        objectArray[4] = TuplesKt.to((Object)"gradleJvmOptions", (Object)gradleJvmOptions);
        if (gradleExeSettings.isPassParentEnvs()) {
            Map map3 = EnvironmentUtil.getEnvironmentMap();
            map2 = map3;
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getEnvironmentMap(...)");
        } else {
            map2 = MapsKt.emptyMap();
        }
        objectArray[5] = TuplesKt.to((Object)"gradleEnvironmentVariables", (Object)map2);
        Map environment = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new ScriptingHostConfiguration[]{JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration()};
        return new ScriptingHostConfiguration((ScriptingHostConfiguration[])objectArray, (Function1<? super ScriptingHostConfiguration.Builder, Unit>)((Function1)new Function1<ScriptingHostConfiguration.Builder, Unit>((Map<String, ? extends Object>)environment){
            final /* synthetic */ Map<String, Object> $environment;
            {
                this.$environment = $environment;
                super(1);
            }

            public final void invoke(@NotNull ScriptingHostConfiguration.Builder $this$$receiver) {
                Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                $this$$receiver.invoke(ScriptCompilationConfigurationFromDefinitionKt.getGetEnvironment($this$$receiver), new Function0<Map<String, ? extends Object>>(this.$environment){
                    final /* synthetic */ Map<String, Object> $environment;
                    {
                        this.$environment = $environment;
                        super(0);
                    }

                    @NotNull
                    public final Map<String, Object> invoke() {
                        return this.$environment;
                    }
                });
            }
        }));
    }

    private final void subscribeToGradleSettingChanges() {
        GradleSettingsListener listener2 = new GradleSettingsListener(this){
            final /* synthetic */ GradleScriptDefinitionsContributor this$0;
            {
                this.this$0 = $receiver;
            }

            public void onGradleVmOptionsChange(@Nullable String oldOptions, @Nullable String newOptions) {
                GradleScriptDefinitionsContributor.access$forceReload(this.this$0);
            }

            public void onGradleHomeChange(@Nullable String oldPath, @Nullable String newPath, @NotNull String linkedProjectPath) {
                Intrinsics.checkNotNullParameter((Object)linkedProjectPath, (String)"linkedProjectPath");
                GradleScriptDefinitionsContributor.access$forceReload(this.this$0);
            }

            public void onServiceDirectoryPathChange(@Nullable String oldPath, @Nullable String newPath) {
                GradleScriptDefinitionsContributor.access$forceReload(this.this$0);
            }

            public void onGradleDistributionTypeChange(@Nullable DistributionType currentValue, @NotNull String linkedProjectPath) {
                Intrinsics.checkNotNullParameter((Object)linkedProjectPath, (String)"linkedProjectPath");
                GradleScriptDefinitionsContributor.access$forceReload(this.this$0);
            }
        };
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = GradleSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)listener2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Sequence<ScriptDefinition> getDefinitions() {
        Object $this$forEach$iv;
        Enumeration<LightGradleBuildRoot> enumeration = this.definitionsByRoots.keys();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"keys(...)");
        CollectionsKt.iterator(enumeration).forEachRemaining(arg_0 -> GradleScriptDefinitionsContributor._get_definitions_$lambda$10((Function1)new Function1<LightGradleBuildRoot, Unit>(this){
            final /* synthetic */ GradleScriptDefinitionsContributor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(LightGradleBuildRoot root) {
                Intrinsics.checkNotNull((Object)root);
                if (GradleScriptDefinitionsContributor.access$isError(this.this$0, root)) {
                    ((Map)GradleScriptDefinitionsContributor.access$getDefinitionsByRoots$p(this.this$0)).put(root, GradleScriptDefinitionsContributor.access$loadGradleDefinitions(this.this$0, root));
                }
            }
        }, arg_0));
        if (this.definitionsByRoots.isEmpty()) {
            Object object = GradleBuildRootsManager.Companion.getInstance(this.project);
            if (object != null && (object = ((GradleBuildRootsLocator)object).getAllRoots()) != null) {
                $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Pair pair;
                    Object element$iv = iterator2.next();
                    GradleBuildRoot it = (GradleBuildRoot)element$iv;
                    boolean bl = false;
                    String workingDir = it.getPathPrefix();
                    GradleBuildRoot gradleBuildRoot = it;
                    if (gradleBuildRoot instanceof Imported) {
                        pair = TuplesKt.to((Object)((Imported)it).getData().getGradleHome(), (Object)((Imported)it).getData().getJavaHome());
                    } else if (gradleBuildRoot instanceof WithoutScriptModels) {
                        GradleExecutionSettings settings2 = (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)this.project, (String)workingDir, (ProjectSystemId)GradleConstants.SYSTEM_ID);
                        pair = TuplesKt.to((Object)settings2.getGradleHome(), (Object)settings2.getJavaHome());
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    Pair pair2 = pair;
                    String gradleHome2 = (String)pair2.component1();
                    String javaHome = (String)pair2.component2();
                    LightGradleBuildRoot root = new LightGradleBuildRoot(workingDir, gradleHome2, javaHome);
                    ((Map)this.definitionsByRoots).put(root, this.loadGradleDefinitions(root));
                }
            }
        }
        if (!((Map)this.definitionsByRoots).isEmpty()) {
            void $this$flatMapTo$iv$iv;
            Map $this$flatMap$iv = this.definitionsByRoots;
            boolean $i$f$flatMap = false;
            $this$forEach$iv = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator3 = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator3.next();
                boolean bl = false;
                Iterable list$iv$iv = (List)it.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
        }
        ErrorGradleScriptDefinition[] errorGradleScriptDefinitionArray = new ErrorGradleScriptDefinition[]{new ErrorGradleScriptDefinition(this.project, null, 2, null)};
        return SequencesKt.sequenceOf((Object[])errorGradleScriptDefinitionArray);
    }

    private static final void _get_definitions_$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Regex access$getKotlinDslDependencySelector$cp() {
        return kotlinDslDependencySelector;
    }

    public static final /* synthetic */ void access$forceReload(GradleScriptDefinitionsContributor $this) {
        $this.forceReload();
    }

    public static final /* synthetic */ List access$loadGradleDefinitions(GradleScriptDefinitionsContributor $this, LightGradleBuildRoot root) {
        return $this.loadGradleDefinitions(root);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ2\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J*\u0010\u0014\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0017\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor$Companion;", "", "()V", "kotlinDslDependencySelector", "Lkotlin/text/Regex;", "kotlinStdLibSelector", "findStdLibLanguageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "classpath", "", "Ljava/nio/file/Path;", "getDefinitions", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "project", "Lcom/intellij/openapi/project/Project;", "workingDir", "", "gradleHome", "javaHome", "getDefinitionsTemplateClasspath", "getFullDefinitionsClasspath", "Lkotlin/Pair;", "kotlinStdlibAndCompiler", "gradleLibDir", "kotlin.gradle.gradle-java"})
    @SourceDebugExtension(value={"SMAP\nGradleScriptDefinitionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleScriptDefinitionsProvider.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,406:1\n800#2,11:407\n1549#2:418\n1620#2,3:419\n1549#2:423\n1620#2,3:424\n1603#2,9:427\n1855#2:436\n1856#2:438\n1612#2:439\n1#3:422\n1#3:437\n*S KotlinDebug\n*F\n+ 1 GradleScriptDefinitionsProvider.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor$Companion\n*L\n49#1:407,11\n82#1:418\n82#1:419,3\n124#1:423\n124#1:424,3\n124#1:427,9\n124#1:436\n124#1:438\n124#1:439\n124#1:437\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<ScriptDefinition> getDefinitions(@NotNull Project project2, @NotNull String workingDir, @Nullable String gradleHome2, @Nullable String javaHome) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            Iterable iterable = ScriptDefinitionContributor.Companion.getEP_NAME().getExtensions((AreaInstance)project2);
            boolean $i$f$filterIsInstance = false;
            void var8_8 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof GradleScriptDefinitionsContributor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            GradleScriptDefinitionsContributor contributor = (GradleScriptDefinitionsContributor)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
            if (contributor == null) {
                ScriptUtilsKt.scriptingInfoLog("cannot find gradle script definitions contributor in ScriptDefinitionContributor.EP_NAME list: workingDir=" + workingDir + " gradleHome=" + gradleHome2);
                return null;
            }
            if (gradleHome2 == null) {
                ScriptUtilsKt.scriptingInfoLog(KotlinIdeaGradleBundle.message("error.text.unable.to.get.gradle.home.directory", new Object[0]) + ": workingDir=" + workingDir);
                return null;
            }
            LightGradleBuildRoot root = new LightGradleBuildRoot(workingDir, gradleHome2, javaHome);
            GradleScriptDefinitionsContributor $this$getDefinitions_u24lambda_u240 = contributor;
            boolean bl = false;
            if ($this$getDefinitions_u24lambda_u240.isError(root)) {
                return null;
            }
            List definitions2 = (List)contributor.definitionsByRoots.get(root);
            if (definitions2 == null) {
                ScriptUtilsKt.scriptingInfoLog("script definitions aren't loaded yet. They should be loaded by invoking GradleScriptDefinitionsContributor.reloadIfNeeded from KotlinDslSyncListener: workingDir=" + workingDir + " gradleHome=" + gradleHome2);
                return null;
            }
            return definitions2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getDefinitionsTemplateClasspath(@Nullable String gradleHome2) {
            List list2;
            try {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)this.getFullDefinitionsClasspath(gradleHome2).getFirst();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    Path path2 = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(PathKt.getSystemIndependentPath((Path)p0));
                }
                list2 = (List)destination$iv$iv;
            }
            catch (Throwable e) {
                ScriptUtilsKt.scriptingInfoLog("cannot get gradle classpath for Gradle Kotlin DSL scripts: " + e.getMessage());
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final Pair<List<Path>, List<Path>> getFullDefinitionsClasspath(String gradleHome) {
            if (gradleHome == null) {
                throw new IllegalStateException(KotlinIdeaGradleBundle.message("error.text.unable.to.get.gradle.home.directory", new Object[0]).toString());
            }
            var3_2 = new String[]{"lib"};
            v0 = Paths.get(gradleHome, Arrays.copyOf(var3_2, var3_2.length));
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"get(base, *subpaths)");
            it = v0;
            $i$a$-let-GradleScriptDefinitionsContributor$Companion$getFullDefinitionsClasspath$gradleLibDir$1 = false;
            var6_7 = it;
            it = var6_7;
            $i$a$-takeIf-GradleScriptDefinitionsContributor$Companion$getFullDefinitionsClasspath$gradleLibDir$1$1 = false;
            v1 = new LinkOption[]{};
            if (!Files.exists((Path)it, Arrays.copyOf(v1, v1.length))) ** GOTO lbl-1000
            v2 = new LinkOption[]{};
            if (Files.isDirectory((Path)it, Arrays.copyOf(v2, v2.length))) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            v4 /* !! */  = v3 != false ? var6_7 : null;
            if (v4 /* !! */  == null) {
                var6_7 = new Object[]{it};
                var6_7 = KotlinIdeaGradleBundle.message("error.text.invalid.gradle.libraries.directory", (Object[])var6_7);
                throw new IllegalStateException(var6_7.toString());
            }
            gradleLibDir = v4 /* !! */ ;
            it = Files.newDirectoryStream((Path)gradleLibDir, (DirectoryStream.Filter<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, getFullDefinitionsClasspath$lambda$3(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)getFullDefinitionsClasspath.templateClasspath.1.INSTANCE));
            $i$a$-let-GradleScriptDefinitionsContributor$Companion$getFullDefinitionsClasspath$gradleLibDir$1 = null;
            try {
                p0 = (DirectoryStream)it;
                $i$a$-use-GradleScriptDefinitionsContributor$Companion$getFullDefinitionsClasspath$templateClasspath$2 = false;
                var6_7 = CollectionsKt.toList((Iterable)p0);
            }
            catch (Throwable var6_8) {
                $i$a$-let-GradleScriptDefinitionsContributor$Companion$getFullDefinitionsClasspath$gradleLibDir$1 = var6_8;
                throw var6_8;
            }
            finally {
                CloseableKt.closeFinally((Closeable)it, (Throwable)$i$a$-let-GradleScriptDefinitionsContributor$Companion$getFullDefinitionsClasspath$gradleLibDir$1);
            }
            it = (Collection)var6_7;
            if (it.isEmpty()) {
                $i$a$-ifEmpty-GradleScriptDefinitionsContributor$Companion$getFullDefinitionsClasspath$templateClasspath$3 = false;
                throw new IllegalStateException(KotlinIdeaGradleBundle.message("error.text.missing.jars.in.gradle.directory", new Object[0]).toString());
            }
            templateClasspath = (List)it;
            ScriptUtilsKt.scriptingDebugLog$default(null, (Function0)new Function0<String>((List<? extends Path>)templateClasspath){
                final /* synthetic */ List<Path> $templateClasspath;
                {
                    this.$templateClasspath = $templateClasspath;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Gradle definitions classpath: " + this.$templateClasspath;
                }
            }, 1, null);
            additionalClassPath = this.kotlinStdlibAndCompiler((Path)gradleLibDir);
            ScriptUtilsKt.scriptingDebugLog$default(null, (Function0)new Function0<String>((List<? extends Path>)templateClasspath){
                final /* synthetic */ List<Path> $templateClasspath;
                {
                    this.$templateClasspath = $templateClasspath;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Gradle definitions additional classpath: " + this.$templateClasspath;
                }
            }, 1, null);
            return TuplesKt.to((Object)templateClasspath, additionalClassPath);
        }

        private final List<Path> kotlinStdlibAndCompiler(Path gradleLibDir) {
            Path stdlibPath = (Path)CollectionsKt.firstOrNull((List)PathsKt.listDirectoryEntries((Path)gradleLibDir, (String)"kotlin-stdlib-[1-9]*"));
            Path compilerPath = (Path)CollectionsKt.firstOrNull((List)PathsKt.listDirectoryEntries((Path)gradleLibDir, (String)"kotlin-compiler-embeddable*"));
            Object[] objectArray = new Path[]{stdlibPath, compilerPath};
            return CollectionsKt.listOfNotNull((Object[])objectArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Nullable
        public final LanguageVersion findStdLibLanguageVersion(@NotNull List<? extends Path> classpath2) {
            void $this$mapNotNullTo$iv$iv;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(classpath2, (String)"classpath");
            Iterable $this$map$iv = classpath2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getParent());
            }
            Iterable $this$mapNotNull$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                LanguageVersion it$iv$iv;
                LanguageVersion languageVersion;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                Path path2 = (Path)element$iv$iv;
                boolean bl2 = false;
                Closeable closeable = Files.newDirectoryStream(path2, arg_0 -> Companion.findStdLibLanguageVersion$lambda$9$lambda$7(findStdLibLanguageVersion.2.1.INSTANCE, arg_0));
                Throwable throwable = null;
                try {
                    MatchResult matchResult2;
                    Path resultPath;
                    DirectoryStream it = (DirectoryStream)closeable;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    languageVersion = (Path)CollectionsKt.firstOrNull((Iterable)it) == null ? null : (Regex.find$default((Regex)kotlinStdLibSelector, (CharSequence)PathsKt.getName((Path)resultPath), (int)0, (int)2, null) == null ? null : LanguageVersion.Companion.fromVersionString((String)matchResult2.getGroupValues().get(2)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                if (languageVersion == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (LanguageVersion)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        }

        private static final boolean getFullDefinitionsClasspath$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean findStdLibLanguageVersion$lambda$9$lambda$7(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/GradleScriptDefinitionsContributor$LightGradleBuildRoot;", "", "workingDir", "", "gradleHome", "javaHome", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getGradleHome", "()Ljava/lang/String;", "getJavaHome", "getWorkingDir", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.gradle.gradle-java"})
    private static final class LightGradleBuildRoot {
        @NotNull
        private final String workingDir;
        @Nullable
        private final String gradleHome;
        @Nullable
        private final String javaHome;

        public LightGradleBuildRoot(@NotNull String workingDir, @Nullable String gradleHome2, @Nullable String javaHome) {
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            this.workingDir = workingDir;
            this.gradleHome = gradleHome2;
            this.javaHome = javaHome;
        }

        @NotNull
        public final String getWorkingDir() {
            return this.workingDir;
        }

        @Nullable
        public final String getGradleHome() {
            return this.gradleHome;
        }

        @Nullable
        public final String getJavaHome() {
            return this.javaHome;
        }

        @NotNull
        public final String component1() {
            return this.workingDir;
        }

        @Nullable
        public final String component2() {
            return this.gradleHome;
        }

        @Nullable
        public final String component3() {
            return this.javaHome;
        }

        @NotNull
        public final LightGradleBuildRoot copy(@NotNull String workingDir, @Nullable String gradleHome2, @Nullable String javaHome) {
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            return new LightGradleBuildRoot(workingDir, gradleHome2, javaHome);
        }

        public static /* synthetic */ LightGradleBuildRoot copy$default(LightGradleBuildRoot lightGradleBuildRoot, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = lightGradleBuildRoot.workingDir;
            }
            if ((n & 2) != 0) {
                string2 = lightGradleBuildRoot.gradleHome;
            }
            if ((n & 4) != 0) {
                string3 = lightGradleBuildRoot.javaHome;
            }
            return lightGradleBuildRoot.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "LightGradleBuildRoot(workingDir=" + this.workingDir + ", gradleHome=" + this.gradleHome + ", javaHome=" + this.javaHome + ")";
        }

        public int hashCode() {
            int result2 = this.workingDir.hashCode();
            result2 = result2 * 31 + (this.gradleHome == null ? 0 : this.gradleHome.hashCode());
            result2 = result2 * 31 + (this.javaHome == null ? 0 : this.javaHome.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof LightGradleBuildRoot)) {
                return false;
            }
            LightGradleBuildRoot lightGradleBuildRoot = (LightGradleBuildRoot)other2;
            if (!Intrinsics.areEqual((Object)this.workingDir, (Object)lightGradleBuildRoot.workingDir)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.gradleHome, (Object)lightGradleBuildRoot.gradleHome)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.javaHome, (Object)lightGradleBuildRoot.javaHome);
        }
    }
}

