/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootIndex;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleScriptInfo;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.Imported;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.Legacy;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.New;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0002&'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0006J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0006J\u0014\u0010\u0015\u001a\b\u0018\u00010\u0016R\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000eJ\u001e\u0010\u0015\u001a\b\u0018\u00010\u0016R\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u0006J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H&J\u0010\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u000eJ\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u000b\u001a\u00020\u0006H&J\u000e\u0010$\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010%\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\f0\u0006\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "gradleWrapperEnding", "", "roots", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex;", "getRoots", "()Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex;", "localPath", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLocalPath", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "findAffectedFileRoot", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;", "filePath", "findGradleWrapperPropertiesBuildDir", "findScriptBuildRoot", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator$ScriptUnderRoot;", "gradleKtsFile", "searchNearestLegacy", "", "getAllRoots", "", "getBuildRootByWorkingDir", "gradleWorkingDir", "getScriptFirstSeenTs", "", "path", "getScriptInfo", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleScriptInfo;", "file", "isAffectedGradleProjectFile", "maybeAffectedGradleProjectFile", "NotificationKind", "ScriptUnderRoot", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nGradleBuildRootsLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBuildRootsLocator.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
public abstract class GradleBuildRootsLocator {
    @NotNull
    private final Project project;
    @NotNull
    private final GradleBuildRootIndex roots;
    @NotNull
    private final String gradleWrapperEnding;

    public GradleBuildRootsLocator(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.roots = new GradleBuildRootIndex(this.project);
        this.gradleWrapperEnding = "/gradle/wrapper/gradle-wrapper.properties";
    }

    @NotNull
    protected final GradleBuildRootIndex getRoots() {
        return this.roots;
    }

    @Nullable
    public abstract GradleScriptInfo getScriptInfo(@NotNull String var1);

    @NotNull
    public final Collection<GradleBuildRoot> getAllRoots() {
        return this.roots.getList();
    }

    @Nullable
    public final GradleBuildRoot getBuildRootByWorkingDir(@NotNull String gradleWorkingDir) {
        Intrinsics.checkNotNullParameter((Object)gradleWorkingDir, (String)"gradleWorkingDir");
        return this.roots.getBuildByRootDir(gradleWorkingDir);
    }

    @Nullable
    public final GradleScriptInfo getScriptInfo(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getScriptInfo(this.getLocalPath(file2));
    }

    private final String getLocalPath(VirtualFile $this$localPath) {
        String string = $this$localPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    public final boolean maybeAffectedGradleProjectFile(@NotNull String filePath2) {
        Intrinsics.checkNotNullParameter((Object)filePath2, (String)"filePath");
        return StringsKt.endsWith$default((String)filePath2, (String)"/gradle.properties", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath2, (String)"/gradle.local", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath2, (String)this.gradleWrapperEnding, (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath2, (String)".gradle.kts", (boolean)false, (int)2, null);
    }

    public final boolean isAffectedGradleProjectFile(@NotNull String filePath2) {
        Intrinsics.checkNotNullParameter((Object)filePath2, (String)"filePath");
        return this.findAffectedFileRoot(filePath2) != null || this.roots.isStandaloneScript(filePath2);
    }

    @Nullable
    public final GradleBuildRoot findAffectedFileRoot(@NotNull String filePath2) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)filePath2, (String)"filePath");
                if (StringsKt.endsWith$default((String)filePath2, (String)"/gradle.properties", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath2, (String)"/gradle.local", (boolean)false, (int)2, null)) {
                    return this.roots.getBuildByProjectDir(StringsKt.substringBeforeLast$default((String)filePath2, (String)"/", null, (int)2, null));
                }
                object = this.findGradleWrapperPropertiesBuildDir(filePath2);
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                GradleBuildRoot gradleBuildRoot = this.roots.getBuildByRootDir(it);
                object = gradleBuildRoot;
                if (gradleBuildRoot != null) break block5;
            }
            ScriptUnderRoot scriptUnderRoot = this.findScriptBuildRoot(filePath2, false);
            object = scriptUnderRoot != null ? scriptUnderRoot.getRoot() : null;
        }
        return object;
    }

    @Nullable
    public final String findGradleWrapperPropertiesBuildDir(@NotNull String filePath2) {
        Intrinsics.checkNotNullParameter((Object)filePath2, (String)"filePath");
        if (StringsKt.endsWith$default((String)filePath2, (String)this.gradleWrapperEnding, (boolean)false, (int)2, null)) {
            String string = filePath2.substring(0, filePath2.length() - this.gradleWrapperEnding.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }
        return null;
    }

    public abstract long getScriptFirstSeenTs(@NotNull String var1);

    @Nullable
    public final ScriptUnderRoot findScriptBuildRoot(@NotNull VirtualFile gradleKtsFile) {
        Intrinsics.checkNotNullParameter((Object)gradleKtsFile, (String)"gradleKtsFile");
        String string = gradleKtsFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return GradleBuildRootsLocator.findScriptBuildRoot$default(this, string, false, 2, null);
    }

    @Nullable
    public final ScriptUnderRoot findScriptBuildRoot(@NotNull String filePath2, boolean searchNearestLegacy) {
        GradleBuildRoot gradleBuildRoot;
        Intrinsics.checkNotNullParameter((Object)filePath2, (String)"filePath");
        if (this.project.isDisposed()) {
            return null;
        }
        if (!StringsKt.endsWith$default((String)filePath2, (String)".gradle.kts", (boolean)false, (int)2, null)) {
            return null;
        }
        GradleScriptInfo scriptInfo = this.getScriptInfo(filePath2);
        if (scriptInfo != null && (gradleBuildRoot = scriptInfo.getBuildRoot()) != null) {
            GradleBuildRoot it = gradleBuildRoot;
            boolean bl = false;
            return new ScriptUnderRoot(this, filePath2, it, scriptInfo, false, null, 24, null);
        }
        gradleBuildRoot = this.roots.getStandaloneScriptRoot(filePath2);
        if (gradleBuildRoot != null) {
            GradleBuildRoot it = gradleBuildRoot;
            boolean bl = false;
            return new ScriptUnderRoot(this, filePath2, it, null, true, null, 20, null);
        }
        if ((StringsKt.endsWith$default((String)filePath2, (String)"/build.gradle.kts", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath2, (String)"/settings.gradle.kts", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath2, (String)"/init.gradle.kts", (boolean)false, (int)2, null)) && (gradleBuildRoot = this.roots.getBuildByProjectDir(StringsKt.substringBeforeLast$default((String)filePath2, (String)"/", null, (int)2, null))) != null) {
            GradleBuildRoot it = gradleBuildRoot;
            boolean bl = false;
            return new ScriptUnderRoot(this, filePath2, it, null, false, null, 28, null);
        }
        GradleBuildRoot nearest = searchNearestLegacy ? this.roots.findNearestRoot(filePath2) : null;
        return new ScriptUnderRoot(this, filePath2, null, null, false, nearest, 12, null);
    }

    public static /* synthetic */ ScriptUnderRoot findScriptBuildRoot$default(GradleBuildRootsLocator gradleBuildRootsLocator, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findScriptBuildRoot");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return gradleBuildRootsLocator.findScriptBuildRoot(string, bl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator$NotificationKind;", "", "(Ljava/lang/String;I)V", "dontCare", "legacy", "legacyOutside", "outsideAnything", "wasNotImportedAfterCreation", "notEvaluatedInLastImport", "standalone", "standaloneLegacy", "kotlin.gradle.gradle-java"})
    public static final class NotificationKind
    extends Enum<NotificationKind> {
        public static final /* enum */ NotificationKind dontCare = new NotificationKind();
        public static final /* enum */ NotificationKind legacy = new NotificationKind();
        public static final /* enum */ NotificationKind legacyOutside = new NotificationKind();
        public static final /* enum */ NotificationKind outsideAnything = new NotificationKind();
        public static final /* enum */ NotificationKind wasNotImportedAfterCreation = new NotificationKind();
        public static final /* enum */ NotificationKind notEvaluatedInLastImport = new NotificationKind();
        public static final /* enum */ NotificationKind standalone = new NotificationKind();
        public static final /* enum */ NotificationKind standaloneLegacy = new NotificationKind();
        private static final /* synthetic */ NotificationKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NotificationKind[] values() {
            return (NotificationKind[])$VALUES.clone();
        }

        public static NotificationKind valueOf(String value2) {
            return Enum.valueOf(NotificationKind.class, value2);
        }

        @NotNull
        public static EnumEntries<NotificationKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = notificationKindArray = new NotificationKind[]{NotificationKind.dontCare, NotificationKind.legacy, NotificationKind.legacyOutside, NotificationKind.outsideAnything, NotificationKind.wasNotImportedAfterCreation, NotificationKind.notEvaluatedInLastImport, NotificationKind.standalone, NotificationKind.standaloneLegacy};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0004\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0010R\u0014\u0010\u001c\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator$ScriptUnderRoot;", "", "filePath", "", "root", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;", "script", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleScriptInfo;", "standalone", "", "nearest", "(Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleScriptInfo;ZLorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;)V", "getFilePath", "()Ljava/lang/String;", "importing", "getImporting", "()Z", "isImported", "getNearest", "()Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;", "notificationKind", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator$NotificationKind;", "getNotificationKind", "()Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator$NotificationKind;", "getRoot", "getScript", "()Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleScriptInfo;", "getStandalone", "wasImportedAndNotEvaluated", "getWasImportedAndNotEvaluated", "toString", "kotlin.gradle.gradle-java"})
    public final class ScriptUnderRoot {
        @NotNull
        private final String filePath;
        @Nullable
        private final GradleBuildRoot root;
        @Nullable
        private final GradleScriptInfo script;
        private final boolean standalone;
        @Nullable
        private final GradleBuildRoot nearest;
        final /* synthetic */ GradleBuildRootsLocator this$0;

        public ScriptUnderRoot(@NotNull GradleBuildRootsLocator this$0, @Nullable String filePath2, @Nullable GradleBuildRoot root, GradleScriptInfo script, @Nullable boolean standalone, GradleBuildRoot nearest) {
            Intrinsics.checkNotNullParameter((Object)filePath2, (String)"filePath");
            this.this$0 = this$0;
            this.filePath = filePath2;
            this.root = root;
            this.script = script;
            this.standalone = standalone;
            this.nearest = nearest;
        }

        public /* synthetic */ ScriptUnderRoot(GradleBuildRootsLocator gradleBuildRootsLocator, String string, GradleBuildRoot gradleBuildRoot, GradleScriptInfo gradleScriptInfo, boolean bl, GradleBuildRoot gradleBuildRoot2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                gradleScriptInfo = null;
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                gradleBuildRoot2 = gradleBuildRoot;
            }
            this(gradleBuildRootsLocator, string, gradleBuildRoot, gradleScriptInfo, bl, gradleBuildRoot2);
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        @Nullable
        public final GradleBuildRoot getRoot() {
            return this.root;
        }

        @Nullable
        public final GradleScriptInfo getScript() {
            return this.script;
        }

        public final boolean getStandalone() {
            return this.standalone;
        }

        @Nullable
        public final GradleBuildRoot getNearest() {
            return this.nearest;
        }

        @NotNull
        public final NotificationKind getNotificationKind() {
            NotificationKind notificationKind;
            if (this.isImported()) {
                notificationKind = NotificationKind.dontCare;
            } else if (this.standalone) {
                notificationKind = this.nearest instanceof Legacy ? NotificationKind.standaloneLegacy : NotificationKind.standalone;
            } else if (this.nearest == null) {
                notificationKind = NotificationKind.outsideAnything;
            } else if (this.getImporting()) {
                notificationKind = NotificationKind.dontCare;
            } else {
                GradleBuildRoot gradleBuildRoot = this.nearest;
                if (gradleBuildRoot instanceof Legacy) {
                    notificationKind = this.root == null ? NotificationKind.legacyOutside : NotificationKind.legacy;
                } else if (gradleBuildRoot instanceof New) {
                    notificationKind = NotificationKind.wasNotImportedAfterCreation;
                } else if (gradleBuildRoot instanceof Imported) {
                    notificationKind = this.getWasImportedAndNotEvaluated() ? NotificationKind.notEvaluatedInLastImport : NotificationKind.wasNotImportedAfterCreation;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return notificationKind;
        }

        private final boolean getImporting() {
            return this.nearest != null && this.nearest.isImportingInProgress();
        }

        private final boolean isImported() {
            return this.script != null;
        }

        private final boolean getWasImportedAndNotEvaluated() {
            return this.nearest instanceof Imported && this.this$0.getScriptFirstSeenTs(this.filePath) < ((Imported)this.nearest).getData().getImportTs();
        }

        @NotNull
        public String toString() {
            return "ScriptUnderRoot(root=" + this.root + ", script=" + this.script + ", standalone=" + this.standalone + ", nearest=" + this.nearest + ")";
        }
    }
}

