/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.UtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.ReceiverInfo;
import org.jetbrains.kotlin.idea.highlighter.ReceiverUsageCollector;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0013\u0014\u0015B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH$J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H$R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo;", "", "()V", "psi", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getPsi", "()Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "collectReceiverUsages", "", "consumer", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/TextRange;", "elementsToProcess", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "Function", "Lambda", "Property", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo$Function;", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo$Lambda;", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo$Property;", "kotlin.highlighting.k1"})
public abstract class ReceiverInfo {
    private ReceiverInfo() {
    }

    @NotNull
    public abstract KtCallableDeclaration getPsi();

    @Nullable
    protected abstract CallableDescriptor getDescriptor(@NotNull BindingContext var1);

    @NotNull
    protected abstract Sequence<KtElement> elementsToProcess();

    public void collectReceiverUsages(@NotNull Function1<? super TextRange, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        BindingContext bindingContext2 = ResolutionUtils.safeAnalyze((KtElement)this.getPsi(), BodyResolveMode.PARTIAL);
        CallableDescriptor callableDescriptor = this.getDescriptor(bindingContext2);
        if (callableDescriptor == null) {
            return;
        }
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        ReceiverUsageCollector visitor2 = new ReceiverUsageCollector(callableDescriptor2, consumer);
        for (KtElement element3 : this.elementsToProcess()) {
            element3.accept((KtVisitor)visitor2, (Object)Unit.INSTANCE);
        }
    }

    public /* synthetic */ ReceiverInfo(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo$Function;", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo;", "psi", "Lorg/jetbrains/kotlin/psi/KtFunction;", "(Lorg/jetbrains/kotlin/psi/KtFunction;)V", "getPsi", "()Lorg/jetbrains/kotlin/psi/KtFunction;", "collectReceiverUsages", "", "consumer", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/TextRange;", "elementsToProcess", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin.highlighting.k1"})
    public static final class Function
    extends ReceiverInfo {
        @NotNull
        private final KtFunction psi;

        public Function(@NotNull KtFunction psi2) {
            Intrinsics.checkNotNullParameter((Object)psi2, (String)"psi");
            super(null);
            this.psi = psi2;
        }

        @NotNull
        public KtFunction getPsi() {
            return this.psi;
        }

        @Override
        @Nullable
        protected CallableDescriptor getDescriptor(@NotNull BindingContext bindingContext2) {
            Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
            Object object = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)this.getPsi());
            return object instanceof CallableDescriptor ? (CallableDescriptor)object : null;
        }

        @Override
        public void collectReceiverUsages(@NotNull Function1<? super TextRange, Unit> consumer) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            KtTypeReference ktTypeReference = this.getPsi().getReceiverTypeReference();
            if (ktTypeReference != null && (ktTypeReference = ktTypeReference.getTextRange()) != null) {
                consumer.invoke((Object)ktTypeReference);
            }
            super.collectReceiverUsages(consumer);
        }

        @Override
        @NotNull
        protected Sequence<KtElement> elementsToProcess() {
            Sequence sequence2 = UtilKt.sequenceOfNotNull((Object)this.getPsi().getBodyExpression());
            List list2 = this.getPsi().getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
            return SequencesKt.plus((Sequence)sequence2, (Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)elementsToProcess.1.INSTANCE));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo$Lambda;", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo;", "psi", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "(Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;)V", "getPsi", "()Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "elementsToProcess", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin.highlighting.k1"})
    public static final class Lambda
    extends ReceiverInfo {
        @NotNull
        private final KtFunctionLiteral psi;

        public Lambda(@NotNull KtFunctionLiteral psi2) {
            Intrinsics.checkNotNullParameter((Object)psi2, (String)"psi");
            super(null);
            this.psi = psi2;
        }

        @NotNull
        public KtFunctionLiteral getPsi() {
            return this.psi;
        }

        @Override
        @Nullable
        protected CallableDescriptor getDescriptor(@NotNull BindingContext bindingContext2) {
            Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
            return (CallableDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)this.getPsi());
        }

        @Override
        @NotNull
        protected Sequence<KtElement> elementsToProcess() {
            Sequence sequence2 = UtilKt.sequenceOfNotNull((Object)this.getPsi().getBodyExpression());
            List list2 = this.getPsi().getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
            return SequencesKt.plus((Sequence)sequence2, (Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)elementsToProcess.1.INSTANCE));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo$Property;", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo;", "psi", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;)V", "getPsi", "()Lorg/jetbrains/kotlin/psi/KtProperty;", "collectReceiverUsages", "", "consumer", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/TextRange;", "elementsToProcess", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlin.highlighting.k1"})
    public static final class Property
    extends ReceiverInfo {
        @NotNull
        private final KtProperty psi;

        public Property(@NotNull KtProperty psi2) {
            Intrinsics.checkNotNullParameter((Object)psi2, (String)"psi");
            super(null);
            this.psi = psi2;
        }

        @NotNull
        public KtProperty getPsi() {
            return this.psi;
        }

        @Override
        @Nullable
        protected CallableDescriptor getDescriptor(@NotNull BindingContext bindingContext2) {
            Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
            Object object = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)this.getPsi());
            return object instanceof CallableDescriptor ? (CallableDescriptor)object : null;
        }

        @Override
        public void collectReceiverUsages(@NotNull Function1<? super TextRange, Unit> consumer) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            KtTypeReference ktTypeReference = this.getPsi().getReceiverTypeReference();
            if (ktTypeReference != null && (ktTypeReference = ktTypeReference.getTextRange()) != null) {
                consumer.invoke((Object)ktTypeReference);
            }
            super.collectReceiverUsages(consumer);
        }

        @Override
        @NotNull
        protected Sequence<KtElement> elementsToProcess() {
            List list2 = this.getPsi().getAccessors();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAccessors(...)");
            return CollectionsKt.asSequence((Iterable)list2);
        }
    }
}

