/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.util.ExtensionUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002J\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J,\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 H\u0002J\u001f\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010%R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ReceiverUsageCollector;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitor;", "", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "consumer", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/TextRange;", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lkotlin/jvm/functions/Function1;)V", "getCallableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getConsumer", "()Lkotlin/jvm/functions/Function1;", "checkIfTheSame", "", "one", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "two", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "processExplicitThis", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "receiverDescriptor", "processImplicitThis", "callElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "implicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "processThisCall", "expressionBindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "extensionReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "dispatchReceiver", "visitSimpleNameExpression", "Ljava/lang/Void;", "data", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lkotlin/Unit;)Ljava/lang/Void;", "kotlin.highlighting.k1"})
final class ReceiverUsageCollector
extends KtTreeVisitor<Unit> {
    @NotNull
    private final CallableDescriptor callableDescriptor;
    @NotNull
    private final Function1<TextRange, Unit> consumer;

    public ReceiverUsageCollector(@NotNull CallableDescriptor callableDescriptor, @NotNull Function1<? super TextRange, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"callableDescriptor");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.callableDescriptor = callableDescriptor;
        this.consumer = consumer;
    }

    @NotNull
    public final CallableDescriptor getCallableDescriptor() {
        return this.callableDescriptor;
    }

    @NotNull
    public final Function1<TextRange, Unit> getConsumer() {
        return this.consumer;
    }

    private final void processExplicitThis(KtSimpleNameExpression expression2, ReceiverParameterDescriptor receiverDescriptor) {
        if (!(expression2.getParent() instanceof KtThisExpression)) {
            return;
        }
        if (this.checkIfTheSame(receiverDescriptor, this.callableDescriptor.getExtensionReceiverParameter())) {
            TextRange textRange = expression2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            this.consumer.invoke((Object)textRange);
        }
    }

    private final void processImplicitThis(KtElement callElement2, ImplicitReceiver implicitReceiver) {
        TextRange textRange;
        DeclarationDescriptor targetDescriptor = implicitReceiver.getDeclarationDescriptor();
        if (!this.checkIfTheSame(targetDescriptor, (DeclarationDescriptor)this.callableDescriptor)) {
            return;
        }
        if (callElement2 instanceof KtCallExpression) {
            KtExpression ktExpression = ((KtCallExpression)callElement2).getCalleeExpression();
            if (ktExpression == null) {
                ktExpression = (KtExpression)callElement2;
            }
            textRange = ktExpression.getTextRange();
        } else {
            textRange = callElement2.getTextRange();
        }
        TextRange textRange2 = textRange;
        Intrinsics.checkNotNull((Object)textRange2);
        this.consumer.invoke((Object)textRange2);
    }

    private final void processThisCall(KtSimpleNameExpression expression2, BindingContext expressionBindingContext, ReceiverValue extensionReceiver, ReceiverValue dispatchReceiver) {
        PsiElement psiElement2 = expression2.getParent();
        KtThisExpression ktThisExpression = psiElement2 instanceof KtThisExpression ? (KtThisExpression)psiElement2 : null;
        if (!((ktThisExpression != null ? ktThisExpression.getParent() : null) instanceof KtCallExpression)) {
            return;
        }
        if (this.checkIfTheSame((DeclarationDescriptor)this.callableDescriptor, ExtensionUtils.getReceiverTargetDescriptor(extensionReceiver, expressionBindingContext)) || this.checkIfTheSame((DeclarationDescriptor)this.callableDescriptor, ExtensionUtils.getReceiverTargetDescriptor(dispatchReceiver, expressionBindingContext))) {
            TextRange textRange = expression2.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            this.consumer.invoke((Object)textRange);
        }
    }

    @Nullable
    public Void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @NotNull Unit data2) {
        ReceiverValue receiverValue;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        BindingContext bindingContext2 = ResolutionUtils.safeAnalyze((KtElement)expression2, BodyResolveMode.PARTIAL);
        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression2), (BindingContext)bindingContext2);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        CallableDescriptor resultingDescriptor = resolvedCall3.getResultingDescriptor();
        if (resultingDescriptor instanceof ReceiverParameterDescriptor) {
            this.processExplicitThis(expression2, (ReceiverParameterDescriptor)resultingDescriptor);
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> call = ResolutionUtils.variableCallOrThis((ResolvedCall<? extends CallableDescriptor>)resolvedCall3);
        ReceiverValue extensionReceiver = call.getExtensionReceiver();
        ReceiverValue dispatchReceiver = call.getDispatchReceiver();
        if (extensionReceiver == null && dispatchReceiver == null) {
            return null;
        }
        ReceiverValue receiverValue2 = extensionReceiver;
        if (receiverValue2 == null) {
            receiverValue2 = dispatchReceiver;
        }
        if ((receiverValue = receiverValue2) instanceof ImplicitReceiver) {
            KtElement ktElement = resolvedCall3.getCall().getCallElement();
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"getCallElement(...)");
            this.processImplicitThis(ktElement, (ImplicitReceiver)receiverValue);
        } else {
            this.processThisCall(expression2, bindingContext2, extensionReceiver, dispatchReceiver);
        }
        return null;
    }

    private final boolean checkIfTheSame(ReceiverParameterDescriptor one, ReceiverParameterDescriptor two) {
        if (one == two) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        return this.checkIfTheSame(one.getContainingDeclaration(), two.getContainingDeclaration());
    }

    private final boolean checkIfTheSame(DeclarationDescriptor one, DeclarationDescriptor two) {
        if (one == two) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (!(one instanceof CallableDescriptor)) {
            return false;
        }
        if (!(two instanceof CallableDescriptor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((CallableDescriptor)one).getName(), (Object)((CallableDescriptor)two).getName())) {
            return false;
        }
        if (!Intrinsics.areEqual(one.getClass(), two.getClass())) {
            return false;
        }
        return Intrinsics.areEqual((Object)JvmIrUtilsKt.getPsiElement((DeclarationDescriptorWithSource)((DeclarationDescriptorWithSource)one)), (Object)JvmIrUtilsKt.getPsiElement((DeclarationDescriptorWithSource)((DeclarationDescriptorWithSource)two)));
    }
}

