/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.asJava.elements.KtLightMethodImplKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinGutterTooltipHelper;
import org.jetbrains.kotlin.idea.presentation.DeclarationByModuleRenderer;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a6\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00060\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0000\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\r\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"getModuleSpecificSubclassedClassTooltip", "", "klass", "Lcom/intellij/psi/PsiClass;", "getOverriddenDeclarations", "", "T", "mappingToJava", "", "Lcom/intellij/psi/PsiElement;", "classes", "getOverriddenMethodTooltip", "method", "Lcom/intellij/psi/PsiMethod;", "isMethodWithDeclarationInOtherClass", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nOverridenFunctionMarker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverridenFunctionMarker.kt\norg/jetbrains/kotlin/idea/highlighter/markers/OverridenFunctionMarkerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n766#2:103\n857#2,2:104\n*S KotlinDebug\n*F\n+ 1 OverridenFunctionMarker.kt\norg/jetbrains/kotlin/idea/highlighter/markers/OverridenFunctionMarkerKt\n*L\n93#1:103\n93#1:104,2\n*E\n"})
public final class OverridenFunctionMarkerKt {
    private static final boolean isMethodWithDeclarationInOtherClass(PsiMethod $this$isMethodWithDeclarationInOtherClass) {
        return $this$isMethodWithDeclarationInOtherClass instanceof KtLightMethod && KtLightMethodImplKt.isTraitFakeOverride((KtLightMethod)((KtLightMethod)$this$isMethodWithDeclarationInOtherClass));
    }

    @NotNull
    public static final <T> Set<T> getOverriddenDeclarations(@NotNull Map<PsiElement, T> mappingToJava, @NotNull Set<? extends PsiClass> classes2) {
        Intrinsics.checkNotNullParameter(mappingToJava, (String)"mappingToJava");
        Intrinsics.checkNotNullParameter(classes2, (String)"classes");
        HashSet overridden = new HashSet();
        for (PsiClass psiClass2 : classes2) {
            OverridersSearchKt.forEachDeclaredMemberOverride(psiClass2, (Function2<? super PsiElement, ? super PsiElement, Boolean>)((Function2)new Function2<PsiElement, PsiElement, Boolean>(mappingToJava, overridden){
                final /* synthetic */ Map<PsiElement, T> $mappingToJava;
                final /* synthetic */ HashSet<T> $overridden;
                {
                    this.$mappingToJava = $mappingToJava;
                    this.$overridden = $overridden;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiElement superMember, @NotNull PsiElement overridingMember) {
                    block4: {
                        Object v0;
                        Object object;
                        Object object2;
                        block3: {
                            Intrinsics.checkNotNullParameter((Object)superMember, (String)"superMember");
                            Intrinsics.checkNotNullParameter((Object)overridingMember, (String)"overridingMember");
                            ProgressManager.checkCanceled();
                            List<PsiMethod> possiblyFakeLightMethods = OverridersSearchKt.toPossiblyFakeLightMethods(overridingMember);
                            object2 = possiblyFakeLightMethods;
                            object = object2.iterator();
                            while (object.hasNext()) {
                                T t = object.next();
                                PsiMethod it = (PsiMethod)t;
                                boolean bl = false;
                                if (!(!OverridenFunctionMarkerKt.access$isMethodWithDeclarationInOtherClass(it))) continue;
                                v0 = t;
                                break block3;
                            }
                            v0 = null;
                        }
                        PsiMethod psiMethod = v0;
                        if (psiMethod == null) break block4;
                        PsiMethod psiMethod2 = psiMethod;
                        object2 = this.$mappingToJava;
                        object = this.$overridden;
                        PsiMethod it = psiMethod2;
                        boolean bl = false;
                        V v = object2.remove(superMember);
                        if (v != null) {
                            V declaration2 = v;
                            boolean bl2 = false;
                            if (object2.remove(it) == null) {
                                object2.values().removeIf(superMember::equals);
                            }
                            ((HashSet)object).add(declaration2);
                        }
                    }
                    return !this.$mappingToJava.isEmpty();
                }
            }));
        }
        return overridden;
    }

    @Nullable
    public static final String getModuleSpecificSubclassedClassTooltip(@NotNull PsiClass klass2) {
        Intrinsics.checkNotNullParameter((Object)klass2, (String)"klass");
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(5, (Collection)new HashSet());
        ClassInheritorsSearch.search((PsiClass)klass2).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor2));
        if (processor2.isOverflow()) {
            return klass2.isInterface() ? DaemonBundle.message((String)"method.is.implemented.too.many", (Object[])new Object[0]) : DaemonBundle.message((String)"class.is.subclassed.too.many", (Object[])new Object[0]);
        }
        PsiElement[] psiElementArray = processor2.toArray((PsiElement[])PsiClass.EMPTY_ARRAY);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"toArray(...)");
        Object[] subclasses = (PsiClass[])psiElementArray;
        if (subclasses.length == 0) {
            PsiElementProcessor.CollectElementsWithLimit functionalImplementations = new PsiElementProcessor.CollectElementsWithLimit(2, (Collection)new HashSet());
            FunctionalExpressionSearch.search((PsiClass)klass2).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)functionalImplementations));
            Collection collection = functionalImplementations.getCollection();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getCollection(...)");
            return !collection.isEmpty() ? KotlinBundle.message("highlighter.text.has.functional.implementations", new Object[0]) : null;
        }
        Comparator comparator2 = new DeclarationByModuleRenderer().getComparator();
        String start2 = KotlinBundle.message(klass2.isInterface() ? "tooltip.is.implemented.by" : "tooltip.is.subclassed.by", new Object[0]);
        Intrinsics.checkNotNull((Object)comparator2);
        return KotlinGutterTooltipHelper.INSTANCE.buildTooltipText(ArraysKt.sortedWith((Object[])subclasses, (Comparator)comparator2), start2, true, "GotoImplementation");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getOverriddenMethodTooltip(@NotNull PsiMethod method) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiElementProcessor.CollectElementsWithLimit processor2 = new PsiElementProcessor.CollectElementsWithLimit(5);
        OverridersSearchUtilsKt.forEachOverridingMethod$default(method, null, (Function1)new Function1<PsiMethod, Boolean>((Object)new PsiElementProcessorAdapter((PsiElementProcessor)processor2)){

            @NotNull
            public final Boolean invoke(PsiMethod p0) {
                return ((PsiElementProcessorAdapter)this.receiver).process((Object)p0);
            }
        }, 1, null);
        boolean isAbstract = method.hasModifierProperty("abstract");
        if (processor2.isOverflow()) {
            return DaemonBundle.message((String)(isAbstract ? "method.is.implemented.too.many" : "method.is.overridden.too.many"), (Object[])new Object[0]);
        }
        Comparator comparator2 = new MethodCellRenderer(false).getComparator();
        Collection collection = processor2.getCollection();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getCollection(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiMethod it = (PsiMethod)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(!OverridenFunctionMarkerKt.isMethodWithDeclarationInOtherClass(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        Intrinsics.checkNotNull((Object)comparator2);
        List overridingJavaMethods = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator2);
        if (overridingJavaMethods.isEmpty()) {
            return null;
        }
        String start2 = KotlinBundle.message(isAbstract ? "overridden.marker.implementation" : "overridden.marker.overrides", new Object[0]);
        return KotlinGutterTooltipHelper.INSTANCE.buildTooltipText(overridingJavaMethods, start2, true, "GotoImplementation");
    }

    public static final /* synthetic */ boolean access$isMethodWithDeclarationInOtherClass(PsiMethod $receiver) {
        return OverridenFunctionMarkerKt.isMethodWithDeclarationInOtherClass($receiver);
    }
}

