/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u0001*\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u0006"}, d2={"hasRedundantType", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isCompanionObject", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin.idea"})
public final class RedundantExplicitTypeInspectionKt {
    private static final boolean hasRedundantType(KtProperty property2) {
        if (!property2.isLocal()) {
            return false;
        }
        KtTypeReference ktTypeReference = property2.getTypeReference();
        if (ktTypeReference == null) {
            return false;
        }
        KtTypeReference typeReference2 = ktTypeReference;
        if (!((Collection)typeReference2.getAnnotationEntries()).isEmpty()) {
            return false;
        }
        KtExpression ktExpression = property2.getInitializer();
        if (ktExpression == null) {
            return false;
        }
        KtExpression initializer2 = ktExpression;
        VariableDescriptor variableDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(property2, null, 1, null);
        if (variableDescriptor == null || (variableDescriptor = variableDescriptor.getType()) == null) {
            return false;
        }
        VariableDescriptor type2 = variableDescriptor;
        if (type2 instanceof AbbreviatedType) {
            return false;
        }
        KtExpression ktExpression2 = initializer2;
        if (ktExpression2 instanceof KtConstantExpression) {
            ClassId classId = KotlinPsiUtilsKt.getClassId((KtConstantExpression)initializer2);
            if (classId == null || (classId = classId.asSingleFqName()) == null) {
                return false;
            }
            ClassId fqName2 = classId;
            if (!KotlinBuiltIns.isConstructedFromGivenClass((KotlinType)type2, (FqName)fqName2) || type2.isMarkedNullable()) {
                return false;
            }
        } else if (ktExpression2 instanceof KtStringTemplateExpression) {
            if (!KotlinBuiltIns.isString((KotlinType)type2)) {
                return false;
            }
        } else if (ktExpression2 instanceof KtNameReferenceExpression) {
            if (!Intrinsics.areEqual((Object)typeReference2.getText(), (Object)((KtNameReferenceExpression)initializer2).getReferencedName())) {
                return false;
            }
            KotlinType initializerType = CallUtilKt.getType((KtExpression)initializer2, (BindingContext)ResolutionUtils.analyze((KtElement)property2, BodyResolveMode.PARTIAL));
            if (!Intrinsics.areEqual((Object)initializerType, (Object)type2) && RedundantExplicitTypeInspectionKt.isCompanionObject(initializerType)) {
                return false;
            }
        } else if (ktExpression2 instanceof KtCallExpression) {
            KtExpression ktExpression3 = ((KtCallExpression)initializer2).getCalleeExpression();
            if (!Intrinsics.areEqual((Object)typeReference2.getText(), (Object)(ktExpression3 != null ? ktExpression3.getText() : null))) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static final boolean isCompanionObject(KotlinType $this$isCompanionObject) {
        KotlinType kotlinType = $this$isCompanionObject;
        return kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null && (kotlinType = kotlinType.getDeclarationDescriptor()) != null ? DescriptorUtilsKt.isCompanionObject((DeclarationDescriptor)((DeclarationDescriptor)kotlinType)) : false;
    }

    public static final /* synthetic */ boolean access$hasRedundantType(KtProperty property2) {
        return RedundantExplicitTypeInspectionKt.hasRedundantType(property2);
    }
}

